package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// BackupPolicy 备份策略对象，包括备份保留的天数和备份开始时间。
type BackupPolicy struct {

	// 指定已生成的备份文件可以保存的天数。 取值范围：0～35。取0值，表示关闭自动备份策略。
	KeepDays int32 `json:"keep_days"`

	// 备份时间段。自动备份将在该时间段内触发。开启自动备份策略时，该参数必选；关闭自动备份策略时，不传该参数。 取值范围：格式必须为hh:mm-HH:MM，且有效，当前时间指UTC时间。 - HH取值必须比hh大1。 - mm和MM取值必须相同，且取值必须为00、30。 - 不传该参数，默认的备份时间段为00:00-01:00。 - 取值示例：23:00-00:00。
	StartTime *string `json:"start_time,omitempty"`

	// 备份周期配置。自动备份将在每星期指定的天进行。 取值范围：格式为半角逗号隔开的数字，数字代表星期。保留天数取值不同，备份周期约束如下： - 0天，不传该参数。 - 1～6天，备份周期全选，取值为：1,2,3,4,5,6,7。 - 7～732天，备份周期至少选择一周中的一天。示例：1,2,3,4。
	Period *string `json:"period,omitempty"`
}

func (o BackupPolicy) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "BackupPolicy struct{}"
	}

	return strings.Join([]string{"BackupPolicy", string(data)}, " ")
}
