//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Gripper actions.
type GRIPPER_ACTIONS uint64

const (
	// Gripper commence open. Often used to release cargo.
	GRIPPER_ACTION_OPEN GRIPPER_ACTIONS = 0
	// Gripper commence close. Often used to grab onto cargo.
	GRIPPER_ACTION_CLOSE GRIPPER_ACTIONS = 1
	// Gripper stop (maintain current grip position).
	GRIPPER_ACTION_STOP GRIPPER_ACTIONS = 2
)

var value_to_label_GRIPPER_ACTIONS = map[GRIPPER_ACTIONS]string{
	GRIPPER_ACTION_OPEN:  "GRIPPER_ACTION_OPEN",
	GRIPPER_ACTION_CLOSE: "GRIPPER_ACTION_CLOSE",
	GRIPPER_ACTION_STOP:  "GRIPPER_ACTION_STOP",
}

var label_to_value_GRIPPER_ACTIONS = map[string]GRIPPER_ACTIONS{
	"GRIPPER_ACTION_OPEN":  GRIPPER_ACTION_OPEN,
	"GRIPPER_ACTION_CLOSE": GRIPPER_ACTION_CLOSE,
	"GRIPPER_ACTION_STOP":  GRIPPER_ACTION_STOP,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GRIPPER_ACTIONS) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_GRIPPER_ACTIONS[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GRIPPER_ACTIONS) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_GRIPPER_ACTIONS[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GRIPPER_ACTIONS(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GRIPPER_ACTIONS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
