//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package development

import (
	"fmt"
	"strconv"
)

// Source for GLOBAL_POSITION measurement or estimate.
type GLOBAL_POSITION_SRC uint64

const (
	// Source is unknown or not one of the listed types.
	GLOBAL_POSITION_UNKNOWN GLOBAL_POSITION_SRC = 0
	// Global Navigation Satellite System (e.g.: GPS, Galileo, Glonass, BeiDou).
	GLOBAL_POSITION_GNSS GLOBAL_POSITION_SRC = 1
	// Vision system (e.g.: map matching).
	GLOBAL_POSITION_VISION GLOBAL_POSITION_SRC = 2
	// Pseudo-satellite system (performs GNSS-like function, but usually with transceiver beacons).
	GLOBAL_POSITION_PSEUDOLITES GLOBAL_POSITION_SRC = 3
	// Terrain referenced navigation.
	GLOBAL_POSITION_TRN GLOBAL_POSITION_SRC = 4
	// Magnetic positioning.
	GLOBAL_POSITION_MAGNETIC GLOBAL_POSITION_SRC = 5
	// Estimated position based on various sensors (eg. a Kalman Filter).
	GLOBAL_POSITION_ESTIMATOR GLOBAL_POSITION_SRC = 6
)

var value_to_label_GLOBAL_POSITION_SRC = map[GLOBAL_POSITION_SRC]string{
	GLOBAL_POSITION_UNKNOWN:     "GLOBAL_POSITION_UNKNOWN",
	GLOBAL_POSITION_GNSS:        "GLOBAL_POSITION_GNSS",
	GLOBAL_POSITION_VISION:      "GLOBAL_POSITION_VISION",
	GLOBAL_POSITION_PSEUDOLITES: "GLOBAL_POSITION_PSEUDOLITES",
	GLOBAL_POSITION_TRN:         "GLOBAL_POSITION_TRN",
	GLOBAL_POSITION_MAGNETIC:    "GLOBAL_POSITION_MAGNETIC",
	GLOBAL_POSITION_ESTIMATOR:   "GLOBAL_POSITION_ESTIMATOR",
}

var label_to_value_GLOBAL_POSITION_SRC = map[string]GLOBAL_POSITION_SRC{
	"GLOBAL_POSITION_UNKNOWN":     GLOBAL_POSITION_UNKNOWN,
	"GLOBAL_POSITION_GNSS":        GLOBAL_POSITION_GNSS,
	"GLOBAL_POSITION_VISION":      GLOBAL_POSITION_VISION,
	"GLOBAL_POSITION_PSEUDOLITES": GLOBAL_POSITION_PSEUDOLITES,
	"GLOBAL_POSITION_TRN":         GLOBAL_POSITION_TRN,
	"GLOBAL_POSITION_MAGNETIC":    GLOBAL_POSITION_MAGNETIC,
	"GLOBAL_POSITION_ESTIMATOR":   GLOBAL_POSITION_ESTIMATOR,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GLOBAL_POSITION_SRC) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_GLOBAL_POSITION_SRC[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GLOBAL_POSITION_SRC) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_GLOBAL_POSITION_SRC[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GLOBAL_POSITION_SRC(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GLOBAL_POSITION_SRC) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
