//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package marsh

import (
	"fmt"
	"strconv"
)

// These values are MARSH-specific modes intended to be sent in custom_mode field of HEARTBEAT message.
// Prefer defining values in the most significant byte (between 2^24 and 2^31) to leave the lower three bytes to contain a message id
type MARSH_MODE_FLAGS uint64

const (
	// Request Manager to only send one specific message, advised for very resource limited nodes or with control flow limitations like Simulink.
	// That message id should be in the lower three bytes of the mode, which can be done by adding it to the flags.
	MARSH_MODE_SINGLE_MESSAGE MARSH_MODE_FLAGS = 16777216
	// Request Manager to send every message going out to any of the clients.
	MARSH_MODE_ALL_MESSAGES MARSH_MODE_FLAGS = 33554432
)

var value_to_label_MARSH_MODE_FLAGS = map[MARSH_MODE_FLAGS]string{
	MARSH_MODE_SINGLE_MESSAGE: "MARSH_MODE_SINGLE_MESSAGE",
	MARSH_MODE_ALL_MESSAGES:   "MARSH_MODE_ALL_MESSAGES",
}

var label_to_value_MARSH_MODE_FLAGS = map[string]MARSH_MODE_FLAGS{
	"MARSH_MODE_SINGLE_MESSAGE": MARSH_MODE_SINGLE_MESSAGE,
	"MARSH_MODE_ALL_MESSAGES":   MARSH_MODE_ALL_MESSAGES,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MARSH_MODE_FLAGS) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MARSH_MODE_FLAGS[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MARSH_MODE_FLAGS) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MARSH_MODE_FLAGS[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MARSH_MODE_FLAGS(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MARSH_MODE_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
