//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package avssuas

import (
	"fmt"
	"strconv"
)

type AVSS_M300_OPERATION_MODE uint64

const (
	// In manual control mode
	MODE_M300_MANUAL_CTRL AVSS_M300_OPERATION_MODE = 0
	// In attitude mode
	MODE_M300_ATTITUDE AVSS_M300_OPERATION_MODE = 1
	// In GPS mode
	MODE_M300_P_GPS AVSS_M300_OPERATION_MODE = 6
	// In hotpoint mode
	MODE_M300_HOTPOINT_MODE AVSS_M300_OPERATION_MODE = 9
	// In assisted takeoff mode
	MODE_M300_ASSISTED_TAKEOFF AVSS_M300_OPERATION_MODE = 10
	// In auto takeoff mode
	MODE_M300_AUTO_TAKEOFF AVSS_M300_OPERATION_MODE = 11
	// In auto landing mode
	MODE_M300_AUTO_LANDING AVSS_M300_OPERATION_MODE = 12
	// In go home mode
	MODE_M300_NAVI_GO_HOME AVSS_M300_OPERATION_MODE = 15
	// In sdk control mode
	MODE_M300_NAVI_SDK_CTRL AVSS_M300_OPERATION_MODE = 17
	// In sport mode
	MODE_M300_S_SPORT AVSS_M300_OPERATION_MODE = 31
	// In force auto landing mode
	MODE_M300_FORCE_AUTO_LANDING AVSS_M300_OPERATION_MODE = 33
	// In tripod mode
	MODE_M300_T_TRIPOD AVSS_M300_OPERATION_MODE = 38
	// In search mode
	MODE_M300_SEARCH_MODE AVSS_M300_OPERATION_MODE = 40
	// In engine mode
	MODE_M300_ENGINE_START AVSS_M300_OPERATION_MODE = 41
)

var value_to_label_AVSS_M300_OPERATION_MODE = map[AVSS_M300_OPERATION_MODE]string{
	MODE_M300_MANUAL_CTRL:        "MODE_M300_MANUAL_CTRL",
	MODE_M300_ATTITUDE:           "MODE_M300_ATTITUDE",
	MODE_M300_P_GPS:              "MODE_M300_P_GPS",
	MODE_M300_HOTPOINT_MODE:      "MODE_M300_HOTPOINT_MODE",
	MODE_M300_ASSISTED_TAKEOFF:   "MODE_M300_ASSISTED_TAKEOFF",
	MODE_M300_AUTO_TAKEOFF:       "MODE_M300_AUTO_TAKEOFF",
	MODE_M300_AUTO_LANDING:       "MODE_M300_AUTO_LANDING",
	MODE_M300_NAVI_GO_HOME:       "MODE_M300_NAVI_GO_HOME",
	MODE_M300_NAVI_SDK_CTRL:      "MODE_M300_NAVI_SDK_CTRL",
	MODE_M300_S_SPORT:            "MODE_M300_S_SPORT",
	MODE_M300_FORCE_AUTO_LANDING: "MODE_M300_FORCE_AUTO_LANDING",
	MODE_M300_T_TRIPOD:           "MODE_M300_T_TRIPOD",
	MODE_M300_SEARCH_MODE:        "MODE_M300_SEARCH_MODE",
	MODE_M300_ENGINE_START:       "MODE_M300_ENGINE_START",
}

var label_to_value_AVSS_M300_OPERATION_MODE = map[string]AVSS_M300_OPERATION_MODE{
	"MODE_M300_MANUAL_CTRL":        MODE_M300_MANUAL_CTRL,
	"MODE_M300_ATTITUDE":           MODE_M300_ATTITUDE,
	"MODE_M300_P_GPS":              MODE_M300_P_GPS,
	"MODE_M300_HOTPOINT_MODE":      MODE_M300_HOTPOINT_MODE,
	"MODE_M300_ASSISTED_TAKEOFF":   MODE_M300_ASSISTED_TAKEOFF,
	"MODE_M300_AUTO_TAKEOFF":       MODE_M300_AUTO_TAKEOFF,
	"MODE_M300_AUTO_LANDING":       MODE_M300_AUTO_LANDING,
	"MODE_M300_NAVI_GO_HOME":       MODE_M300_NAVI_GO_HOME,
	"MODE_M300_NAVI_SDK_CTRL":      MODE_M300_NAVI_SDK_CTRL,
	"MODE_M300_S_SPORT":            MODE_M300_S_SPORT,
	"MODE_M300_FORCE_AUTO_LANDING": MODE_M300_FORCE_AUTO_LANDING,
	"MODE_M300_T_TRIPOD":           MODE_M300_T_TRIPOD,
	"MODE_M300_SEARCH_MODE":        MODE_M300_SEARCH_MODE,
	"MODE_M300_ENGINE_START":       MODE_M300_ENGINE_START,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e AVSS_M300_OPERATION_MODE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_AVSS_M300_OPERATION_MODE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *AVSS_M300_OPERATION_MODE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_AVSS_M300_OPERATION_MODE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = AVSS_M300_OPERATION_MODE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e AVSS_M300_OPERATION_MODE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
