//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Cellular network radio type
type CELLULAR_NETWORK_RADIO_TYPE uint64

const (
	CELLULAR_NETWORK_RADIO_TYPE_NONE  CELLULAR_NETWORK_RADIO_TYPE = 0
	CELLULAR_NETWORK_RADIO_TYPE_GSM   CELLULAR_NETWORK_RADIO_TYPE = 1
	CELLULAR_NETWORK_RADIO_TYPE_CDMA  CELLULAR_NETWORK_RADIO_TYPE = 2
	CELLULAR_NETWORK_RADIO_TYPE_WCDMA CELLULAR_NETWORK_RADIO_TYPE = 3
	CELLULAR_NETWORK_RADIO_TYPE_LTE   CELLULAR_NETWORK_RADIO_TYPE = 4
)

var value_to_label_CELLULAR_NETWORK_RADIO_TYPE = map[CELLULAR_NETWORK_RADIO_TYPE]string{
	CELLULAR_NETWORK_RADIO_TYPE_NONE:  "CELLULAR_NETWORK_RADIO_TYPE_NONE",
	CELLULAR_NETWORK_RADIO_TYPE_GSM:   "CELLULAR_NETWORK_RADIO_TYPE_GSM",
	CELLULAR_NETWORK_RADIO_TYPE_CDMA:  "CELLULAR_NETWORK_RADIO_TYPE_CDMA",
	CELLULAR_NETWORK_RADIO_TYPE_WCDMA: "CELLULAR_NETWORK_RADIO_TYPE_WCDMA",
	CELLULAR_NETWORK_RADIO_TYPE_LTE:   "CELLULAR_NETWORK_RADIO_TYPE_LTE",
}

var label_to_value_CELLULAR_NETWORK_RADIO_TYPE = map[string]CELLULAR_NETWORK_RADIO_TYPE{
	"CELLULAR_NETWORK_RADIO_TYPE_NONE":  CELLULAR_NETWORK_RADIO_TYPE_NONE,
	"CELLULAR_NETWORK_RADIO_TYPE_GSM":   CELLULAR_NETWORK_RADIO_TYPE_GSM,
	"CELLULAR_NETWORK_RADIO_TYPE_CDMA":  CELLULAR_NETWORK_RADIO_TYPE_CDMA,
	"CELLULAR_NETWORK_RADIO_TYPE_WCDMA": CELLULAR_NETWORK_RADIO_TYPE_WCDMA,
	"CELLULAR_NETWORK_RADIO_TYPE_LTE":   CELLULAR_NETWORK_RADIO_TYPE_LTE,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e CELLULAR_NETWORK_RADIO_TYPE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_CELLULAR_NETWORK_RADIO_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *CELLULAR_NETWORK_RADIO_TYPE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_CELLULAR_NETWORK_RADIO_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = CELLULAR_NETWORK_RADIO_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e CELLULAR_NETWORK_RADIO_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
