//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package marsh

import (
	"fmt"
	"strconv"
)

// General error state of a motion platform system.
type MOTION_PLATFORM_HEALTH uint64

const (
	// System is operating correctly.
	MOTION_PLATFORM_HEALTH_OK MOTION_PLATFORM_HEALTH = 0
	// There is at least one warning present, but operation can be continued.
	MOTION_PLATFORM_HEALTH_WARNING MOTION_PLATFORM_HEALTH = 1
	// There is a failure or misconfiguration that requires operator's attention for correct operation.
	MOTION_PLATFORM_HEALTH_ERROR MOTION_PLATFORM_HEALTH = 2
	// There is a major failure that requires immediate operator action to maintain safety.
	MOTION_PLATFORM_HEALTH_CRITICAL MOTION_PLATFORM_HEALTH = 3
)

var value_to_label_MOTION_PLATFORM_HEALTH = map[MOTION_PLATFORM_HEALTH]string{
	MOTION_PLATFORM_HEALTH_OK:       "MOTION_PLATFORM_HEALTH_OK",
	MOTION_PLATFORM_HEALTH_WARNING:  "MOTION_PLATFORM_HEALTH_WARNING",
	MOTION_PLATFORM_HEALTH_ERROR:    "MOTION_PLATFORM_HEALTH_ERROR",
	MOTION_PLATFORM_HEALTH_CRITICAL: "MOTION_PLATFORM_HEALTH_CRITICAL",
}

var label_to_value_MOTION_PLATFORM_HEALTH = map[string]MOTION_PLATFORM_HEALTH{
	"MOTION_PLATFORM_HEALTH_OK":       MOTION_PLATFORM_HEALTH_OK,
	"MOTION_PLATFORM_HEALTH_WARNING":  MOTION_PLATFORM_HEALTH_WARNING,
	"MOTION_PLATFORM_HEALTH_ERROR":    MOTION_PLATFORM_HEALTH_ERROR,
	"MOTION_PLATFORM_HEALTH_CRITICAL": MOTION_PLATFORM_HEALTH_CRITICAL,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MOTION_PLATFORM_HEALTH) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MOTION_PLATFORM_HEALTH[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MOTION_PLATFORM_HEALTH) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MOTION_PLATFORM_HEALTH[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MOTION_PLATFORM_HEALTH(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MOTION_PLATFORM_HEALTH) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
