package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// CreateCommandResponse Response Object
type CreateCommandResponse struct {

	// 命令所属服务id
	ServiceId *int32 `json:"service_id,omitempty"`

	// 命令id
	CommandId *int32 `json:"command_id,omitempty"`

	// 命令名称
	CommandName *string `json:"command_name,omitempty"`

	// 命令描述
	Description    *string `json:"description,omitempty"`
	HttpStatusCode int     `json:"-"`
}

func (o CreateCommandResponse) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "CreateCommandResponse struct{}"
	}

	return strings.Join([]string{"CreateCommandResponse", string(data)}, " ")
}
