// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dataproc/v1/sessions.proto

package dataprocpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	SessionController_CreateSession_FullMethodName    = "/google.cloud.dataproc.v1.SessionController/CreateSession"
	SessionController_GetSession_FullMethodName       = "/google.cloud.dataproc.v1.SessionController/GetSession"
	SessionController_ListSessions_FullMethodName     = "/google.cloud.dataproc.v1.SessionController/ListSessions"
	SessionController_TerminateSession_FullMethodName = "/google.cloud.dataproc.v1.SessionController/TerminateSession"
	SessionController_DeleteSession_FullMethodName    = "/google.cloud.dataproc.v1.SessionController/DeleteSession"
)

// SessionControllerClient is the client API for SessionController service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SessionControllerClient interface {
	// Create an interactive session asynchronously.
	CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the resource representation for an interactive session.
	GetSession(ctx context.Context, in *GetSessionRequest, opts ...grpc.CallOption) (*Session, error)
	// Lists interactive sessions.
	ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error)
	// Terminates the interactive session.
	TerminateSession(ctx context.Context, in *TerminateSessionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the interactive session resource. If the session is not in terminal
	// state, it is terminated, and then deleted.
	DeleteSession(ctx context.Context, in *DeleteSessionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type sessionControllerClient struct {
	cc grpc.ClientConnInterface
}

func NewSessionControllerClient(cc grpc.ClientConnInterface) SessionControllerClient {
	return &sessionControllerClient{cc}
}

func (c *sessionControllerClient) CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, SessionController_CreateSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionControllerClient) GetSession(ctx context.Context, in *GetSessionRequest, opts ...grpc.CallOption) (*Session, error) {
	out := new(Session)
	err := c.cc.Invoke(ctx, SessionController_GetSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionControllerClient) ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error) {
	out := new(ListSessionsResponse)
	err := c.cc.Invoke(ctx, SessionController_ListSessions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionControllerClient) TerminateSession(ctx context.Context, in *TerminateSessionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, SessionController_TerminateSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionControllerClient) DeleteSession(ctx context.Context, in *DeleteSessionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, SessionController_DeleteSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SessionControllerServer is the server API for SessionController service.
// All implementations should embed UnimplementedSessionControllerServer
// for forward compatibility
type SessionControllerServer interface {
	// Create an interactive session asynchronously.
	CreateSession(context.Context, *CreateSessionRequest) (*longrunningpb.Operation, error)
	// Gets the resource representation for an interactive session.
	GetSession(context.Context, *GetSessionRequest) (*Session, error)
	// Lists interactive sessions.
	ListSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error)
	// Terminates the interactive session.
	TerminateSession(context.Context, *TerminateSessionRequest) (*longrunningpb.Operation, error)
	// Deletes the interactive session resource. If the session is not in terminal
	// state, it is terminated, and then deleted.
	DeleteSession(context.Context, *DeleteSessionRequest) (*longrunningpb.Operation, error)
}

// UnimplementedSessionControllerServer should be embedded to have forward compatible implementations.
type UnimplementedSessionControllerServer struct {
}

func (UnimplementedSessionControllerServer) CreateSession(context.Context, *CreateSessionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSession not implemented")
}
func (UnimplementedSessionControllerServer) GetSession(context.Context, *GetSessionRequest) (*Session, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSession not implemented")
}
func (UnimplementedSessionControllerServer) ListSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSessions not implemented")
}
func (UnimplementedSessionControllerServer) TerminateSession(context.Context, *TerminateSessionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TerminateSession not implemented")
}
func (UnimplementedSessionControllerServer) DeleteSession(context.Context, *DeleteSessionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSession not implemented")
}

// UnsafeSessionControllerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SessionControllerServer will
// result in compilation errors.
type UnsafeSessionControllerServer interface {
	mustEmbedUnimplementedSessionControllerServer()
}

func RegisterSessionControllerServer(s grpc.ServiceRegistrar, srv SessionControllerServer) {
	s.RegisterService(&SessionController_ServiceDesc, srv)
}

func _SessionController_CreateSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionControllerServer).CreateSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SessionController_CreateSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionControllerServer).CreateSession(ctx, req.(*CreateSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionController_GetSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionControllerServer).GetSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SessionController_GetSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionControllerServer).GetSession(ctx, req.(*GetSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionController_ListSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionControllerServer).ListSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SessionController_ListSessions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionControllerServer).ListSessions(ctx, req.(*ListSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionController_TerminateSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TerminateSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionControllerServer).TerminateSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SessionController_TerminateSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionControllerServer).TerminateSession(ctx, req.(*TerminateSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionController_DeleteSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionControllerServer).DeleteSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SessionController_DeleteSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionControllerServer).DeleteSession(ctx, req.(*DeleteSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SessionController_ServiceDesc is the grpc.ServiceDesc for SessionController service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SessionController_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.SessionController",
	HandlerType: (*SessionControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSession",
			Handler:    _SessionController_CreateSession_Handler,
		},
		{
			MethodName: "GetSession",
			Handler:    _SessionController_GetSession_Handler,
		},
		{
			MethodName: "ListSessions",
			Handler:    _SessionController_ListSessions_Handler,
		},
		{
			MethodName: "TerminateSession",
			Handler:    _SessionController_TerminateSession_Handler,
		},
		{
			MethodName: "DeleteSession",
			Handler:    _SessionController_DeleteSession_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/sessions.proto",
}
