//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappcontainers

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AvailableWorkloadProfilesClient contains the methods for the AvailableWorkloadProfiles group.
// Don't use this type directly, use NewAvailableWorkloadProfilesClient() instead.
type AvailableWorkloadProfilesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewAvailableWorkloadProfilesClient creates a new instance of AvailableWorkloadProfilesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAvailableWorkloadProfilesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*AvailableWorkloadProfilesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &AvailableWorkloadProfilesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewGetPager - Get all available workload profiles for a location.
//
// Generated from API version 2024-03-01
//   - location - The name of Azure region.
//   - options - AvailableWorkloadProfilesClientGetOptions contains the optional parameters for the AvailableWorkloadProfilesClient.NewGetPager
//     method.
func (client *AvailableWorkloadProfilesClient) NewGetPager(location string, options *AvailableWorkloadProfilesClientGetOptions) *runtime.Pager[AvailableWorkloadProfilesClientGetResponse] {
	return runtime.NewPager(runtime.PagingHandler[AvailableWorkloadProfilesClientGetResponse]{
		More: func(page AvailableWorkloadProfilesClientGetResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AvailableWorkloadProfilesClientGetResponse) (AvailableWorkloadProfilesClientGetResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AvailableWorkloadProfilesClient.NewGetPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getCreateRequest(ctx, location, options)
			}, nil)
			if err != nil {
				return AvailableWorkloadProfilesClientGetResponse{}, err
			}
			return client.getHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getCreateRequest creates the Get request.
func (client *AvailableWorkloadProfilesClient) getCreateRequest(ctx context.Context, location string, options *AvailableWorkloadProfilesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.App/locations/{location}/availableManagedEnvironmentsWorkloadProfileTypes"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AvailableWorkloadProfilesClient) getHandleResponse(resp *http.Response) (AvailableWorkloadProfilesClientGetResponse, error) {
	result := AvailableWorkloadProfilesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AvailableWorkloadProfilesCollection); err != nil {
		return AvailableWorkloadProfilesClientGetResponse{}, err
	}
	return result, nil
}
