// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package appsmarket provides access to the Google Workspace Marketplace API.
//
// For product documentation, see: https://developers.google.com/workspace/marketplace
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/appsmarket/v2"
//	...
//	ctx := context.Background()
//	appsmarketService, err := appsmarket.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	appsmarketService, err := appsmarket.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	appsmarketService, err := appsmarket.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package appsmarket // import "google.golang.org/api/appsmarket/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "appsmarket:v2"
const apiName = "appsmarket"
const apiVersion = "v2"
const basePath = "https://appsmarket.googleapis.com/"
const basePathTemplate = "https://appsmarket.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://appsmarket.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// View your installed application's licensing information
	AppsmarketplaceLicenseScope = "https://www.googleapis.com/auth/appsmarketplace.license"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/appsmarketplace.license",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.CustomerLicense = NewCustomerLicenseService(s)
	s.UserLicense = NewUserLicenseService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	CustomerLicense *CustomerLicenseService

	UserLicense *UserLicenseService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewCustomerLicenseService(s *Service) *CustomerLicenseService {
	rs := &CustomerLicenseService{s: s}
	return rs
}

type CustomerLicenseService struct {
	s *Service
}

func NewUserLicenseService(s *Service) *UserLicenseService {
	rs := &UserLicenseService{s: s}
	return rs
}

type UserLicenseService struct {
	s *Service
}

type CustomerLicense struct {
	// ApplicationId: The ID of the application corresponding to this license
	// query.
	ApplicationId string `json:"applicationId,omitempty"`
	// CustomerId: The domain name of the customer.
	CustomerId string `json:"customerId,omitempty"`
	// Editions: (Deprecated)
	Editions []*Editions `json:"editions,omitempty"`
	// Id: The ID of the customer license.
	Id string `json:"id,omitempty"`
	// Kind: The type of API resource. This is always `appsmarket#customerLicense`.
	Kind string `json:"kind,omitempty"`
	// State: The customer's license status. One of: - `ACTIVE`: The customer has a
	// valid license. - `UNLICENSED`: There is no license. Either this customer has
	// never installed your application or has deleted it.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApplicationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerLicense) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerLicense
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Editions struct {
	// AssignedSeats: (Deprecated)
	AssignedSeats int64 `json:"assignedSeats,omitempty"`
	// EditionId: (Deprecated)
	EditionId string `json:"editionId,omitempty"`
	// SeatCount: (Deprecated)
	SeatCount int64 `json:"seatCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssignedSeats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssignedSeats") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Editions) MarshalJSON() ([]byte, error) {
	type NoMethod Editions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type UserLicense struct {
	// ApplicationId: The ID of the application corresponding to the license query.
	ApplicationId string `json:"applicationId,omitempty"`
	// CustomerId: The domain name of the user.
	CustomerId string `json:"customerId,omitempty"`
	// EditionId: (Deprecated)
	EditionId string `json:"editionId,omitempty"`
	// Enabled: The domain administrator has activated the application for this
	// domain.
	Enabled bool `json:"enabled,omitempty"`
	// Id: The ID of the user license.
	Id string `json:"id,omitempty"`
	// Kind: The type of API resource. This is always `appsmarket#userLicense`.
	Kind string `json:"kind,omitempty"`
	// State: The user's licensing status. One of: - `ACTIVE`: The user has a valid
	// license and should be permitted to use the application. - `UNLICENSED`: The
	// administrator of this user's domain never assigned a seat for the
	// application to this user. - `EXPIRED`: The administrator assigned a seat to
	// this user, but the license is expired.
	State string `json:"state,omitempty"`
	// UserId: The email address of the user.
	UserId string `json:"userId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApplicationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserLicense) MarshalJSON() ([]byte, error) {
	type NoMethod UserLicense
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CustomerLicenseGetCall struct {
	s             *Service
	applicationId string
	customerId    string
	urlParams_    gensupport.URLParams
	ifNoneMatch_  string
	ctx_          context.Context
	header_       http.Header
}

// Get: Gets the customer's licensing status to determine if they have access
// to a given app. For more information, see Getting app installation and
// licensing details
// (https://developers.google.com/workspace/marketplace/example-calls-marketplace-api).
//
// - applicationId: The ID of the application.
// - customerId: The ID of the customer.
func (r *CustomerLicenseService) Get(applicationId string, customerId string) *CustomerLicenseGetCall {
	c := &CustomerLicenseGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.applicationId = applicationId
	c.customerId = customerId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomerLicenseGetCall) Fields(s ...googleapi.Field) *CustomerLicenseGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomerLicenseGetCall) IfNoneMatch(entityTag string) *CustomerLicenseGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomerLicenseGetCall) Context(ctx context.Context) *CustomerLicenseGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomerLicenseGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomerLicenseGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "appsmarket/v2/customerLicense/{applicationId}/{customerId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"applicationId": c.applicationId,
		"customerId":    c.customerId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "appsmarket.customerLicense.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "appsmarket.customerLicense.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *CustomerLicense.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomerLicenseGetCall) Do(opts ...googleapi.CallOption) (*CustomerLicense, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CustomerLicense{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "appsmarket.customerLicense.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type UserLicenseGetCall struct {
	s             *Service
	applicationId string
	userId        string
	urlParams_    gensupport.URLParams
	ifNoneMatch_  string
	ctx_          context.Context
	header_       http.Header
}

// Get: Gets the user's licensing status to determine if they have permission
// to use a given app. For more information, see Getting app installation and
// licensing details
// (https://developers.google.com/workspace/marketplace/example-calls-marketplace-api).
//
// - applicationId: The ID of the application.
// - userId: The ID of the user.
func (r *UserLicenseService) Get(applicationId string, userId string) *UserLicenseGetCall {
	c := &UserLicenseGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.applicationId = applicationId
	c.userId = userId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UserLicenseGetCall) Fields(s ...googleapi.Field) *UserLicenseGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *UserLicenseGetCall) IfNoneMatch(entityTag string) *UserLicenseGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UserLicenseGetCall) Context(ctx context.Context) *UserLicenseGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UserLicenseGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UserLicenseGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "appsmarket/v2/userLicense/{applicationId}/{userId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"applicationId": c.applicationId,
		"userId":        c.userId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "appsmarket.userLicense.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "appsmarket.userLicense.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserLicense.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UserLicenseGetCall) Do(opts ...googleapi.CallOption) (*UserLicense, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserLicense{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "appsmarket.userLicense.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
