// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package dialogflow provides access to the Dialogflow API.
//
// This package is DEPRECATED. Use package cloud.google.com/go/dialogflow/apiv2 instead.
//
// For product documentation, see: https://cloud.google.com/dialogflow/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/dialogflow/v2"
//	...
//	ctx := context.Background()
//	dialogflowService, err := dialogflow.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	dialogflowService, err := dialogflow.NewService(ctx, option.WithScopes(dialogflow.DialogflowScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	dialogflowService, err := dialogflow.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	dialogflowService, err := dialogflow.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package dialogflow // import "google.golang.org/api/dialogflow/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "dialogflow:v2"
const apiName = "dialogflow"
const apiVersion = "v2"
const basePath = "https://dialogflow.googleapis.com/"
const basePathTemplate = "https://dialogflow.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://dialogflow.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View, manage and query your Dialogflow agents
	DialogflowScope = "https://www.googleapis.com/auth/dialogflow"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/dialogflow",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Agent = NewProjectsAgentService(s)
	rs.AnswerRecords = NewProjectsAnswerRecordsService(s)
	rs.ConversationDatasets = NewProjectsConversationDatasetsService(s)
	rs.ConversationModels = NewProjectsConversationModelsService(s)
	rs.ConversationProfiles = NewProjectsConversationProfilesService(s)
	rs.Conversations = NewProjectsConversationsService(s)
	rs.Generators = NewProjectsGeneratorsService(s)
	rs.KnowledgeBases = NewProjectsKnowledgeBasesService(s)
	rs.Locations = NewProjectsLocationsService(s)
	rs.Operations = NewProjectsOperationsService(s)
	rs.Suggestions = NewProjectsSuggestionsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Agent *ProjectsAgentService

	AnswerRecords *ProjectsAnswerRecordsService

	ConversationDatasets *ProjectsConversationDatasetsService

	ConversationModels *ProjectsConversationModelsService

	ConversationProfiles *ProjectsConversationProfilesService

	Conversations *ProjectsConversationsService

	Generators *ProjectsGeneratorsService

	KnowledgeBases *ProjectsKnowledgeBasesService

	Locations *ProjectsLocationsService

	Operations *ProjectsOperationsService

	Suggestions *ProjectsSuggestionsService
}

func NewProjectsAgentService(s *Service) *ProjectsAgentService {
	rs := &ProjectsAgentService{s: s}
	rs.EntityTypes = NewProjectsAgentEntityTypesService(s)
	rs.Environments = NewProjectsAgentEnvironmentsService(s)
	rs.Intents = NewProjectsAgentIntentsService(s)
	rs.KnowledgeBases = NewProjectsAgentKnowledgeBasesService(s)
	rs.Sessions = NewProjectsAgentSessionsService(s)
	rs.Versions = NewProjectsAgentVersionsService(s)
	return rs
}

type ProjectsAgentService struct {
	s *Service

	EntityTypes *ProjectsAgentEntityTypesService

	Environments *ProjectsAgentEnvironmentsService

	Intents *ProjectsAgentIntentsService

	KnowledgeBases *ProjectsAgentKnowledgeBasesService

	Sessions *ProjectsAgentSessionsService

	Versions *ProjectsAgentVersionsService
}

func NewProjectsAgentEntityTypesService(s *Service) *ProjectsAgentEntityTypesService {
	rs := &ProjectsAgentEntityTypesService{s: s}
	rs.Entities = NewProjectsAgentEntityTypesEntitiesService(s)
	return rs
}

type ProjectsAgentEntityTypesService struct {
	s *Service

	Entities *ProjectsAgentEntityTypesEntitiesService
}

func NewProjectsAgentEntityTypesEntitiesService(s *Service) *ProjectsAgentEntityTypesEntitiesService {
	rs := &ProjectsAgentEntityTypesEntitiesService{s: s}
	return rs
}

type ProjectsAgentEntityTypesEntitiesService struct {
	s *Service
}

func NewProjectsAgentEnvironmentsService(s *Service) *ProjectsAgentEnvironmentsService {
	rs := &ProjectsAgentEnvironmentsService{s: s}
	rs.Intents = NewProjectsAgentEnvironmentsIntentsService(s)
	rs.Users = NewProjectsAgentEnvironmentsUsersService(s)
	return rs
}

type ProjectsAgentEnvironmentsService struct {
	s *Service

	Intents *ProjectsAgentEnvironmentsIntentsService

	Users *ProjectsAgentEnvironmentsUsersService
}

func NewProjectsAgentEnvironmentsIntentsService(s *Service) *ProjectsAgentEnvironmentsIntentsService {
	rs := &ProjectsAgentEnvironmentsIntentsService{s: s}
	return rs
}

type ProjectsAgentEnvironmentsIntentsService struct {
	s *Service
}

func NewProjectsAgentEnvironmentsUsersService(s *Service) *ProjectsAgentEnvironmentsUsersService {
	rs := &ProjectsAgentEnvironmentsUsersService{s: s}
	rs.Sessions = NewProjectsAgentEnvironmentsUsersSessionsService(s)
	return rs
}

type ProjectsAgentEnvironmentsUsersService struct {
	s *Service

	Sessions *ProjectsAgentEnvironmentsUsersSessionsService
}

func NewProjectsAgentEnvironmentsUsersSessionsService(s *Service) *ProjectsAgentEnvironmentsUsersSessionsService {
	rs := &ProjectsAgentEnvironmentsUsersSessionsService{s: s}
	rs.Contexts = NewProjectsAgentEnvironmentsUsersSessionsContextsService(s)
	rs.EntityTypes = NewProjectsAgentEnvironmentsUsersSessionsEntityTypesService(s)
	return rs
}

type ProjectsAgentEnvironmentsUsersSessionsService struct {
	s *Service

	Contexts *ProjectsAgentEnvironmentsUsersSessionsContextsService

	EntityTypes *ProjectsAgentEnvironmentsUsersSessionsEntityTypesService
}

func NewProjectsAgentEnvironmentsUsersSessionsContextsService(s *Service) *ProjectsAgentEnvironmentsUsersSessionsContextsService {
	rs := &ProjectsAgentEnvironmentsUsersSessionsContextsService{s: s}
	return rs
}

type ProjectsAgentEnvironmentsUsersSessionsContextsService struct {
	s *Service
}

func NewProjectsAgentEnvironmentsUsersSessionsEntityTypesService(s *Service) *ProjectsAgentEnvironmentsUsersSessionsEntityTypesService {
	rs := &ProjectsAgentEnvironmentsUsersSessionsEntityTypesService{s: s}
	return rs
}

type ProjectsAgentEnvironmentsUsersSessionsEntityTypesService struct {
	s *Service
}

func NewProjectsAgentIntentsService(s *Service) *ProjectsAgentIntentsService {
	rs := &ProjectsAgentIntentsService{s: s}
	return rs
}

type ProjectsAgentIntentsService struct {
	s *Service
}

func NewProjectsAgentKnowledgeBasesService(s *Service) *ProjectsAgentKnowledgeBasesService {
	rs := &ProjectsAgentKnowledgeBasesService{s: s}
	rs.Documents = NewProjectsAgentKnowledgeBasesDocumentsService(s)
	return rs
}

type ProjectsAgentKnowledgeBasesService struct {
	s *Service

	Documents *ProjectsAgentKnowledgeBasesDocumentsService
}

func NewProjectsAgentKnowledgeBasesDocumentsService(s *Service) *ProjectsAgentKnowledgeBasesDocumentsService {
	rs := &ProjectsAgentKnowledgeBasesDocumentsService{s: s}
	return rs
}

type ProjectsAgentKnowledgeBasesDocumentsService struct {
	s *Service
}

func NewProjectsAgentSessionsService(s *Service) *ProjectsAgentSessionsService {
	rs := &ProjectsAgentSessionsService{s: s}
	rs.Contexts = NewProjectsAgentSessionsContextsService(s)
	rs.EntityTypes = NewProjectsAgentSessionsEntityTypesService(s)
	return rs
}

type ProjectsAgentSessionsService struct {
	s *Service

	Contexts *ProjectsAgentSessionsContextsService

	EntityTypes *ProjectsAgentSessionsEntityTypesService
}

func NewProjectsAgentSessionsContextsService(s *Service) *ProjectsAgentSessionsContextsService {
	rs := &ProjectsAgentSessionsContextsService{s: s}
	return rs
}

type ProjectsAgentSessionsContextsService struct {
	s *Service
}

func NewProjectsAgentSessionsEntityTypesService(s *Service) *ProjectsAgentSessionsEntityTypesService {
	rs := &ProjectsAgentSessionsEntityTypesService{s: s}
	return rs
}

type ProjectsAgentSessionsEntityTypesService struct {
	s *Service
}

func NewProjectsAgentVersionsService(s *Service) *ProjectsAgentVersionsService {
	rs := &ProjectsAgentVersionsService{s: s}
	return rs
}

type ProjectsAgentVersionsService struct {
	s *Service
}

func NewProjectsAnswerRecordsService(s *Service) *ProjectsAnswerRecordsService {
	rs := &ProjectsAnswerRecordsService{s: s}
	return rs
}

type ProjectsAnswerRecordsService struct {
	s *Service
}

func NewProjectsConversationDatasetsService(s *Service) *ProjectsConversationDatasetsService {
	rs := &ProjectsConversationDatasetsService{s: s}
	return rs
}

type ProjectsConversationDatasetsService struct {
	s *Service
}

func NewProjectsConversationModelsService(s *Service) *ProjectsConversationModelsService {
	rs := &ProjectsConversationModelsService{s: s}
	rs.Evaluations = NewProjectsConversationModelsEvaluationsService(s)
	return rs
}

type ProjectsConversationModelsService struct {
	s *Service

	Evaluations *ProjectsConversationModelsEvaluationsService
}

func NewProjectsConversationModelsEvaluationsService(s *Service) *ProjectsConversationModelsEvaluationsService {
	rs := &ProjectsConversationModelsEvaluationsService{s: s}
	return rs
}

type ProjectsConversationModelsEvaluationsService struct {
	s *Service
}

func NewProjectsConversationProfilesService(s *Service) *ProjectsConversationProfilesService {
	rs := &ProjectsConversationProfilesService{s: s}
	return rs
}

type ProjectsConversationProfilesService struct {
	s *Service
}

func NewProjectsConversationsService(s *Service) *ProjectsConversationsService {
	rs := &ProjectsConversationsService{s: s}
	rs.Messages = NewProjectsConversationsMessagesService(s)
	rs.Participants = NewProjectsConversationsParticipantsService(s)
	rs.Suggestions = NewProjectsConversationsSuggestionsService(s)
	return rs
}

type ProjectsConversationsService struct {
	s *Service

	Messages *ProjectsConversationsMessagesService

	Participants *ProjectsConversationsParticipantsService

	Suggestions *ProjectsConversationsSuggestionsService
}

func NewProjectsConversationsMessagesService(s *Service) *ProjectsConversationsMessagesService {
	rs := &ProjectsConversationsMessagesService{s: s}
	return rs
}

type ProjectsConversationsMessagesService struct {
	s *Service
}

func NewProjectsConversationsParticipantsService(s *Service) *ProjectsConversationsParticipantsService {
	rs := &ProjectsConversationsParticipantsService{s: s}
	rs.Suggestions = NewProjectsConversationsParticipantsSuggestionsService(s)
	return rs
}

type ProjectsConversationsParticipantsService struct {
	s *Service

	Suggestions *ProjectsConversationsParticipantsSuggestionsService
}

func NewProjectsConversationsParticipantsSuggestionsService(s *Service) *ProjectsConversationsParticipantsSuggestionsService {
	rs := &ProjectsConversationsParticipantsSuggestionsService{s: s}
	return rs
}

type ProjectsConversationsParticipantsSuggestionsService struct {
	s *Service
}

func NewProjectsConversationsSuggestionsService(s *Service) *ProjectsConversationsSuggestionsService {
	rs := &ProjectsConversationsSuggestionsService{s: s}
	return rs
}

type ProjectsConversationsSuggestionsService struct {
	s *Service
}

func NewProjectsGeneratorsService(s *Service) *ProjectsGeneratorsService {
	rs := &ProjectsGeneratorsService{s: s}
	return rs
}

type ProjectsGeneratorsService struct {
	s *Service
}

func NewProjectsKnowledgeBasesService(s *Service) *ProjectsKnowledgeBasesService {
	rs := &ProjectsKnowledgeBasesService{s: s}
	rs.Documents = NewProjectsKnowledgeBasesDocumentsService(s)
	return rs
}

type ProjectsKnowledgeBasesService struct {
	s *Service

	Documents *ProjectsKnowledgeBasesDocumentsService
}

func NewProjectsKnowledgeBasesDocumentsService(s *Service) *ProjectsKnowledgeBasesDocumentsService {
	rs := &ProjectsKnowledgeBasesDocumentsService{s: s}
	return rs
}

type ProjectsKnowledgeBasesDocumentsService struct {
	s *Service
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Agent = NewProjectsLocationsAgentService(s)
	rs.AnswerRecords = NewProjectsLocationsAnswerRecordsService(s)
	rs.ConversationDatasets = NewProjectsLocationsConversationDatasetsService(s)
	rs.ConversationModels = NewProjectsLocationsConversationModelsService(s)
	rs.ConversationProfiles = NewProjectsLocationsConversationProfilesService(s)
	rs.Conversations = NewProjectsLocationsConversationsService(s)
	rs.EncryptionSpec = NewProjectsLocationsEncryptionSpecService(s)
	rs.Generators = NewProjectsLocationsGeneratorsService(s)
	rs.KnowledgeBases = NewProjectsLocationsKnowledgeBasesService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.SipTrunks = NewProjectsLocationsSipTrunksService(s)
	rs.StatelessSuggestion = NewProjectsLocationsStatelessSuggestionService(s)
	rs.Suggestions = NewProjectsLocationsSuggestionsService(s)
	rs.Tools = NewProjectsLocationsToolsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Agent *ProjectsLocationsAgentService

	AnswerRecords *ProjectsLocationsAnswerRecordsService

	ConversationDatasets *ProjectsLocationsConversationDatasetsService

	ConversationModels *ProjectsLocationsConversationModelsService

	ConversationProfiles *ProjectsLocationsConversationProfilesService

	Conversations *ProjectsLocationsConversationsService

	EncryptionSpec *ProjectsLocationsEncryptionSpecService

	Generators *ProjectsLocationsGeneratorsService

	KnowledgeBases *ProjectsLocationsKnowledgeBasesService

	Operations *ProjectsLocationsOperationsService

	SipTrunks *ProjectsLocationsSipTrunksService

	StatelessSuggestion *ProjectsLocationsStatelessSuggestionService

	Suggestions *ProjectsLocationsSuggestionsService

	Tools *ProjectsLocationsToolsService
}

func NewProjectsLocationsAgentService(s *Service) *ProjectsLocationsAgentService {
	rs := &ProjectsLocationsAgentService{s: s}
	rs.EntityTypes = NewProjectsLocationsAgentEntityTypesService(s)
	rs.Environments = NewProjectsLocationsAgentEnvironmentsService(s)
	rs.Intents = NewProjectsLocationsAgentIntentsService(s)
	rs.Sessions = NewProjectsLocationsAgentSessionsService(s)
	rs.Versions = NewProjectsLocationsAgentVersionsService(s)
	return rs
}

type ProjectsLocationsAgentService struct {
	s *Service

	EntityTypes *ProjectsLocationsAgentEntityTypesService

	Environments *ProjectsLocationsAgentEnvironmentsService

	Intents *ProjectsLocationsAgentIntentsService

	Sessions *ProjectsLocationsAgentSessionsService

	Versions *ProjectsLocationsAgentVersionsService
}

func NewProjectsLocationsAgentEntityTypesService(s *Service) *ProjectsLocationsAgentEntityTypesService {
	rs := &ProjectsLocationsAgentEntityTypesService{s: s}
	rs.Entities = NewProjectsLocationsAgentEntityTypesEntitiesService(s)
	return rs
}

type ProjectsLocationsAgentEntityTypesService struct {
	s *Service

	Entities *ProjectsLocationsAgentEntityTypesEntitiesService
}

func NewProjectsLocationsAgentEntityTypesEntitiesService(s *Service) *ProjectsLocationsAgentEntityTypesEntitiesService {
	rs := &ProjectsLocationsAgentEntityTypesEntitiesService{s: s}
	return rs
}

type ProjectsLocationsAgentEntityTypesEntitiesService struct {
	s *Service
}

func NewProjectsLocationsAgentEnvironmentsService(s *Service) *ProjectsLocationsAgentEnvironmentsService {
	rs := &ProjectsLocationsAgentEnvironmentsService{s: s}
	rs.Intents = NewProjectsLocationsAgentEnvironmentsIntentsService(s)
	rs.Users = NewProjectsLocationsAgentEnvironmentsUsersService(s)
	return rs
}

type ProjectsLocationsAgentEnvironmentsService struct {
	s *Service

	Intents *ProjectsLocationsAgentEnvironmentsIntentsService

	Users *ProjectsLocationsAgentEnvironmentsUsersService
}

func NewProjectsLocationsAgentEnvironmentsIntentsService(s *Service) *ProjectsLocationsAgentEnvironmentsIntentsService {
	rs := &ProjectsLocationsAgentEnvironmentsIntentsService{s: s}
	return rs
}

type ProjectsLocationsAgentEnvironmentsIntentsService struct {
	s *Service
}

func NewProjectsLocationsAgentEnvironmentsUsersService(s *Service) *ProjectsLocationsAgentEnvironmentsUsersService {
	rs := &ProjectsLocationsAgentEnvironmentsUsersService{s: s}
	rs.Sessions = NewProjectsLocationsAgentEnvironmentsUsersSessionsService(s)
	return rs
}

type ProjectsLocationsAgentEnvironmentsUsersService struct {
	s *Service

	Sessions *ProjectsLocationsAgentEnvironmentsUsersSessionsService
}

func NewProjectsLocationsAgentEnvironmentsUsersSessionsService(s *Service) *ProjectsLocationsAgentEnvironmentsUsersSessionsService {
	rs := &ProjectsLocationsAgentEnvironmentsUsersSessionsService{s: s}
	rs.Contexts = NewProjectsLocationsAgentEnvironmentsUsersSessionsContextsService(s)
	rs.EntityTypes = NewProjectsLocationsAgentEnvironmentsUsersSessionsEntityTypesService(s)
	return rs
}

type ProjectsLocationsAgentEnvironmentsUsersSessionsService struct {
	s *Service

	Contexts *ProjectsLocationsAgentEnvironmentsUsersSessionsContextsService

	EntityTypes *ProjectsLocationsAgentEnvironmentsUsersSessionsEntityTypesService
}

func NewProjectsLocationsAgentEnvironmentsUsersSessionsContextsService(s *Service) *ProjectsLocationsAgentEnvironmentsUsersSessionsContextsService {
	rs := &ProjectsLocationsAgentEnvironmentsUsersSessionsContextsService{s: s}
	return rs
}

type ProjectsLocationsAgentEnvironmentsUsersSessionsContextsService struct {
	s *Service
}

func NewProjectsLocationsAgentEnvironmentsUsersSessionsEntityTypesService(s *Service) *ProjectsLocationsAgentEnvironmentsUsersSessionsEntityTypesService {
	rs := &ProjectsLocationsAgentEnvironmentsUsersSessionsEntityTypesService{s: s}
	return rs
}

type ProjectsLocationsAgentEnvironmentsUsersSessionsEntityTypesService struct {
	s *Service
}

func NewProjectsLocationsAgentIntentsService(s *Service) *ProjectsLocationsAgentIntentsService {
	rs := &ProjectsLocationsAgentIntentsService{s: s}
	return rs
}

type ProjectsLocationsAgentIntentsService struct {
	s *Service
}

func NewProjectsLocationsAgentSessionsService(s *Service) *ProjectsLocationsAgentSessionsService {
	rs := &ProjectsLocationsAgentSessionsService{s: s}
	rs.Contexts = NewProjectsLocationsAgentSessionsContextsService(s)
	rs.EntityTypes = NewProjectsLocationsAgentSessionsEntityTypesService(s)
	return rs
}

type ProjectsLocationsAgentSessionsService struct {
	s *Service

	Contexts *ProjectsLocationsAgentSessionsContextsService

	EntityTypes *ProjectsLocationsAgentSessionsEntityTypesService
}

func NewProjectsLocationsAgentSessionsContextsService(s *Service) *ProjectsLocationsAgentSessionsContextsService {
	rs := &ProjectsLocationsAgentSessionsContextsService{s: s}
	return rs
}

type ProjectsLocationsAgentSessionsContextsService struct {
	s *Service
}

func NewProjectsLocationsAgentSessionsEntityTypesService(s *Service) *ProjectsLocationsAgentSessionsEntityTypesService {
	rs := &ProjectsLocationsAgentSessionsEntityTypesService{s: s}
	return rs
}

type ProjectsLocationsAgentSessionsEntityTypesService struct {
	s *Service
}

func NewProjectsLocationsAgentVersionsService(s *Service) *ProjectsLocationsAgentVersionsService {
	rs := &ProjectsLocationsAgentVersionsService{s: s}
	return rs
}

type ProjectsLocationsAgentVersionsService struct {
	s *Service
}

func NewProjectsLocationsAnswerRecordsService(s *Service) *ProjectsLocationsAnswerRecordsService {
	rs := &ProjectsLocationsAnswerRecordsService{s: s}
	return rs
}

type ProjectsLocationsAnswerRecordsService struct {
	s *Service
}

func NewProjectsLocationsConversationDatasetsService(s *Service) *ProjectsLocationsConversationDatasetsService {
	rs := &ProjectsLocationsConversationDatasetsService{s: s}
	return rs
}

type ProjectsLocationsConversationDatasetsService struct {
	s *Service
}

func NewProjectsLocationsConversationModelsService(s *Service) *ProjectsLocationsConversationModelsService {
	rs := &ProjectsLocationsConversationModelsService{s: s}
	rs.Evaluations = NewProjectsLocationsConversationModelsEvaluationsService(s)
	return rs
}

type ProjectsLocationsConversationModelsService struct {
	s *Service

	Evaluations *ProjectsLocationsConversationModelsEvaluationsService
}

func NewProjectsLocationsConversationModelsEvaluationsService(s *Service) *ProjectsLocationsConversationModelsEvaluationsService {
	rs := &ProjectsLocationsConversationModelsEvaluationsService{s: s}
	return rs
}

type ProjectsLocationsConversationModelsEvaluationsService struct {
	s *Service
}

func NewProjectsLocationsConversationProfilesService(s *Service) *ProjectsLocationsConversationProfilesService {
	rs := &ProjectsLocationsConversationProfilesService{s: s}
	return rs
}

type ProjectsLocationsConversationProfilesService struct {
	s *Service
}

func NewProjectsLocationsConversationsService(s *Service) *ProjectsLocationsConversationsService {
	rs := &ProjectsLocationsConversationsService{s: s}
	rs.Messages = NewProjectsLocationsConversationsMessagesService(s)
	rs.Participants = NewProjectsLocationsConversationsParticipantsService(s)
	rs.Suggestions = NewProjectsLocationsConversationsSuggestionsService(s)
	return rs
}

type ProjectsLocationsConversationsService struct {
	s *Service

	Messages *ProjectsLocationsConversationsMessagesService

	Participants *ProjectsLocationsConversationsParticipantsService

	Suggestions *ProjectsLocationsConversationsSuggestionsService
}

func NewProjectsLocationsConversationsMessagesService(s *Service) *ProjectsLocationsConversationsMessagesService {
	rs := &ProjectsLocationsConversationsMessagesService{s: s}
	return rs
}

type ProjectsLocationsConversationsMessagesService struct {
	s *Service
}

func NewProjectsLocationsConversationsParticipantsService(s *Service) *ProjectsLocationsConversationsParticipantsService {
	rs := &ProjectsLocationsConversationsParticipantsService{s: s}
	rs.Suggestions = NewProjectsLocationsConversationsParticipantsSuggestionsService(s)
	return rs
}

type ProjectsLocationsConversationsParticipantsService struct {
	s *Service

	Suggestions *ProjectsLocationsConversationsParticipantsSuggestionsService
}

func NewProjectsLocationsConversationsParticipantsSuggestionsService(s *Service) *ProjectsLocationsConversationsParticipantsSuggestionsService {
	rs := &ProjectsLocationsConversationsParticipantsSuggestionsService{s: s}
	return rs
}

type ProjectsLocationsConversationsParticipantsSuggestionsService struct {
	s *Service
}

func NewProjectsLocationsConversationsSuggestionsService(s *Service) *ProjectsLocationsConversationsSuggestionsService {
	rs := &ProjectsLocationsConversationsSuggestionsService{s: s}
	return rs
}

type ProjectsLocationsConversationsSuggestionsService struct {
	s *Service
}

func NewProjectsLocationsEncryptionSpecService(s *Service) *ProjectsLocationsEncryptionSpecService {
	rs := &ProjectsLocationsEncryptionSpecService{s: s}
	return rs
}

type ProjectsLocationsEncryptionSpecService struct {
	s *Service
}

func NewProjectsLocationsGeneratorsService(s *Service) *ProjectsLocationsGeneratorsService {
	rs := &ProjectsLocationsGeneratorsService{s: s}
	rs.Evaluations = NewProjectsLocationsGeneratorsEvaluationsService(s)
	return rs
}

type ProjectsLocationsGeneratorsService struct {
	s *Service

	Evaluations *ProjectsLocationsGeneratorsEvaluationsService
}

func NewProjectsLocationsGeneratorsEvaluationsService(s *Service) *ProjectsLocationsGeneratorsEvaluationsService {
	rs := &ProjectsLocationsGeneratorsEvaluationsService{s: s}
	return rs
}

type ProjectsLocationsGeneratorsEvaluationsService struct {
	s *Service
}

func NewProjectsLocationsKnowledgeBasesService(s *Service) *ProjectsLocationsKnowledgeBasesService {
	rs := &ProjectsLocationsKnowledgeBasesService{s: s}
	rs.Documents = NewProjectsLocationsKnowledgeBasesDocumentsService(s)
	return rs
}

type ProjectsLocationsKnowledgeBasesService struct {
	s *Service

	Documents *ProjectsLocationsKnowledgeBasesDocumentsService
}

func NewProjectsLocationsKnowledgeBasesDocumentsService(s *Service) *ProjectsLocationsKnowledgeBasesDocumentsService {
	rs := &ProjectsLocationsKnowledgeBasesDocumentsService{s: s}
	return rs
}

type ProjectsLocationsKnowledgeBasesDocumentsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsSipTrunksService(s *Service) *ProjectsLocationsSipTrunksService {
	rs := &ProjectsLocationsSipTrunksService{s: s}
	return rs
}

type ProjectsLocationsSipTrunksService struct {
	s *Service
}

func NewProjectsLocationsStatelessSuggestionService(s *Service) *ProjectsLocationsStatelessSuggestionService {
	rs := &ProjectsLocationsStatelessSuggestionService{s: s}
	return rs
}

type ProjectsLocationsStatelessSuggestionService struct {
	s *Service
}

func NewProjectsLocationsSuggestionsService(s *Service) *ProjectsLocationsSuggestionsService {
	rs := &ProjectsLocationsSuggestionsService{s: s}
	return rs
}

type ProjectsLocationsSuggestionsService struct {
	s *Service
}

func NewProjectsLocationsToolsService(s *Service) *ProjectsLocationsToolsService {
	rs := &ProjectsLocationsToolsService{s: s}
	return rs
}

type ProjectsLocationsToolsService struct {
	s *Service
}

func NewProjectsOperationsService(s *Service) *ProjectsOperationsService {
	rs := &ProjectsOperationsService{s: s}
	return rs
}

type ProjectsOperationsService struct {
	s *Service
}

func NewProjectsSuggestionsService(s *Service) *ProjectsSuggestionsService {
	rs := &ProjectsSuggestionsService{s: s}
	return rs
}

type ProjectsSuggestionsService struct {
	s *Service
}

type GoogleCloudDialogflowCxV3AdvancedSettings struct {
	AudioExportGcsDestination *GoogleCloudDialogflowCxV3GcsDestination                  `json:"audioExportGcsDestination,omitempty"`
	DtmfSettings              *GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings    `json:"dtmfSettings,omitempty"`
	LoggingSettings           *GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings `json:"loggingSettings,omitempty"`
	SpeechSettings            *GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings  `json:"speechSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioExportGcsDestination")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioExportGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings struct {
	Enabled                    bool   `json:"enabled,omitempty"`
	EndpointingTimeoutDuration string `json:"endpointingTimeoutDuration,omitempty"`
	FinishDigit                string `json:"finishDigit,omitempty"`
	InterdigitTimeoutDuration  string `json:"interdigitTimeoutDuration,omitempty"`
	MaxDigits                  int64  `json:"maxDigits,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings struct {
	EnableConsentBasedRedaction bool `json:"enableConsentBasedRedaction,omitempty"`
	EnableInteractionLogging    bool `json:"enableInteractionLogging,omitempty"`
	EnableStackdriverLogging    bool `json:"enableStackdriverLogging,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableConsentBasedRedaction") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableConsentBasedRedaction") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings struct {
	EndpointerSensitivity      int64             `json:"endpointerSensitivity,omitempty"`
	Models                     map[string]string `json:"models,omitempty"`
	NoSpeechTimeout            string            `json:"noSpeechTimeout,omitempty"`
	UseTimeoutBasedEndpointing bool              `json:"useTimeoutBasedEndpointing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndpointerSensitivity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndpointerSensitivity") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AudioInput struct {
	Audio  string                                     `json:"audio,omitempty"`
	Config *GoogleCloudDialogflowCxV3InputAudioConfig `json:"config,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AudioInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AudioInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3BargeInConfig struct {
	NoBargeInDuration string `json:"noBargeInDuration,omitempty"`
	TotalDuration     string `json:"totalDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NoBargeInDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoBargeInDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BargeInConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BargeInConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata struct {
	Errors []*GoogleCloudDialogflowCxV3TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3BatchRunTestCasesResponse struct {
	Results []*GoogleCloudDialogflowCxV3TestCaseResult `json:"results,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Results") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Results") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BatchRunTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BatchRunTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ContinuousTestResult struct {
	Name string `json:"name,omitempty"`
	// Possible values:
	//   "AGGREGATED_TEST_RESULT_UNSPECIFIED"
	//   "PASSED"
	//   "FAILED"
	Result          string   `json:"result,omitempty"`
	RunTime         string   `json:"runTime,omitempty"`
	TestCaseResults []string `json:"testCaseResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ContinuousTestResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ContinuousTestResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ConversationSignals struct {
	TurnSignals *GoogleCloudDialogflowCxV3TurnSignals `json:"turnSignals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TurnSignals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TurnSignals") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ConversationTurn struct {
	UserInput          *GoogleCloudDialogflowCxV3ConversationTurnUserInput          `json:"userInput,omitempty"`
	VirtualAgentOutput *GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput `json:"virtualAgentOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserInput") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationTurn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ConversationTurnUserInput struct {
	EnableSentimentAnalysis bool                                 `json:"enableSentimentAnalysis,omitempty"`
	InjectedParameters      googleapi.RawMessage                 `json:"injectedParameters,omitempty"`
	Input                   *GoogleCloudDialogflowCxV3QueryInput `json:"input,omitempty"`
	IsWebhookEnabled        bool                                 `json:"isWebhookEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationTurnUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurnUserInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput struct {
	CurrentPage       *GoogleCloudDialogflowCxV3Page                  `json:"currentPage,omitempty"`
	DiagnosticInfo    googleapi.RawMessage                            `json:"diagnosticInfo,omitempty"`
	Differences       []*GoogleCloudDialogflowCxV3TestRunDifference   `json:"differences,omitempty"`
	SessionParameters googleapi.RawMessage                            `json:"sessionParameters,omitempty"`
	Status            *GoogleRpcStatus                                `json:"status,omitempty"`
	TextResponses     []*GoogleCloudDialogflowCxV3ResponseMessageText `json:"textResponses,omitempty"`
	TriggeredIntent   *GoogleCloudDialogflowCxV3Intent                `json:"triggeredIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3CreateVersionOperationMetadata struct {
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3CreateVersionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3CreateVersionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DataStoreConnection struct {
	DataStore string `json:"dataStore,omitempty"`
	// Possible values:
	//   "DATA_STORE_TYPE_UNSPECIFIED"
	//   "PUBLIC_WEB"
	//   "UNSTRUCTURED"
	//   "STRUCTURED"
	DataStoreType string `json:"dataStoreType,omitempty"`
	// Possible values:
	//   "DOCUMENT_PROCESSING_MODE_UNSPECIFIED"
	//   "DOCUMENTS"
	//   "CHUNKS"
	DocumentProcessingMode string `json:"documentProcessingMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DataStoreConnection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DataStoreConnection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DeployFlowMetadata struct {
	TestErrors []*GoogleCloudDialogflowCxV3TestError `json:"testErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DeployFlowMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DeployFlowMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DeployFlowResponse struct {
	Deployment  string                                `json:"deployment,omitempty"`
	Environment *GoogleCloudDialogflowCxV3Environment `json:"environment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deployment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DeployFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DeployFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DtmfInput struct {
	Digits      string `json:"digits,omitempty"`
	FinishDigit string `json:"finishDigit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Digits") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Digits") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DtmfInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DtmfInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Environment struct {
	Description     string                                               `json:"description,omitempty"`
	DisplayName     string                                               `json:"displayName,omitempty"`
	Name            string                                               `json:"name,omitempty"`
	TestCasesConfig *GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig `json:"testCasesConfig,omitempty"`
	UpdateTime      string                                               `json:"updateTime,omitempty"`
	VersionConfigs  []*GoogleCloudDialogflowCxV3EnvironmentVersionConfig `json:"versionConfigs,omitempty"`
	WebhookConfig   *GoogleCloudDialogflowCxV3EnvironmentWebhookConfig   `json:"webhookConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Environment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Environment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig struct {
	EnableContinuousRun    bool     `json:"enableContinuousRun,omitempty"`
	EnablePredeploymentRun bool     `json:"enablePredeploymentRun,omitempty"`
	TestCases              []string `json:"testCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableContinuousRun") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableContinuousRun") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3EnvironmentVersionConfig struct {
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EnvironmentVersionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EnvironmentVersionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3EnvironmentWebhookConfig struct {
	WebhookOverrides []*GoogleCloudDialogflowCxV3Webhook `json:"webhookOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WebhookOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WebhookOverrides") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EnvironmentWebhookConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EnvironmentWebhookConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3EventHandler struct {
	Event              string                                `json:"event,omitempty"`
	Name               string                                `json:"name,omitempty"`
	TargetFlow         string                                `json:"targetFlow,omitempty"`
	TargetPage         string                                `json:"targetPage,omitempty"`
	TargetPlaybook     string                                `json:"targetPlaybook,omitempty"`
	TriggerFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EventHandler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EventHandler
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3EventInput struct {
	Event string `json:"event,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportAgentResponse struct {
	AgentContent string `json:"agentContent,omitempty"`
	AgentUri     string `json:"agentUri,omitempty"`
	CommitSha    string `json:"commitSha,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportEntityTypesMetadata struct {
}

type GoogleCloudDialogflowCxV3ExportEntityTypesResponse struct {
	EntityTypesContent *GoogleCloudDialogflowCxV3InlineDestination `json:"entityTypesContent,omitempty"`
	EntityTypesUri     string                                      `json:"entityTypesUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypesContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypesContent") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportFlowResponse struct {
	FlowContent string `json:"flowContent,omitempty"`
	FlowUri     string `json:"flowUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlowContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportIntentsMetadata struct {
}

type GoogleCloudDialogflowCxV3ExportIntentsResponse struct {
	IntentsContent *GoogleCloudDialogflowCxV3InlineDestination `json:"intentsContent,omitempty"`
	IntentsUri     string                                      `json:"intentsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentsContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentsContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportTestCasesMetadata struct {
}

type GoogleCloudDialogflowCxV3ExportTestCasesResponse struct {
	Content string `json:"content,omitempty"`
	GcsUri  string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Form struct {
	Parameters []*GoogleCloudDialogflowCxV3FormParameter `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Form) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Form
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FormParameter struct {
	AdvancedSettings *GoogleCloudDialogflowCxV3AdvancedSettings          `json:"advancedSettings,omitempty"`
	DefaultValue     interface{}                                         `json:"defaultValue,omitempty"`
	DisplayName      string                                              `json:"displayName,omitempty"`
	EntityType       string                                              `json:"entityType,omitempty"`
	FillBehavior     *GoogleCloudDialogflowCxV3FormParameterFillBehavior `json:"fillBehavior,omitempty"`
	IsList           bool                                                `json:"isList,omitempty"`
	Redact           bool                                                `json:"redact,omitempty"`
	Required         bool                                                `json:"required,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FormParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FormParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FormParameterFillBehavior struct {
	InitialPromptFulfillment *GoogleCloudDialogflowCxV3Fulfillment    `json:"initialPromptFulfillment,omitempty"`
	RepromptEventHandlers    []*GoogleCloudDialogflowCxV3EventHandler `json:"repromptEventHandlers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InitialPromptFulfillment")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InitialPromptFulfillment") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FormParameterFillBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FormParameterFillBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Fulfillment struct {
	AdvancedSettings         *GoogleCloudDialogflowCxV3AdvancedSettings                `json:"advancedSettings,omitempty"`
	ConditionalCases         []*GoogleCloudDialogflowCxV3FulfillmentConditionalCases   `json:"conditionalCases,omitempty"`
	EnableGenerativeFallback bool                                                      `json:"enableGenerativeFallback,omitempty"`
	Generators               []*GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings  `json:"generators,omitempty"`
	Messages                 []*GoogleCloudDialogflowCxV3ResponseMessage               `json:"messages,omitempty"`
	ReturnPartialResponses   bool                                                      `json:"returnPartialResponses,omitempty"`
	SetParameterActions      []*GoogleCloudDialogflowCxV3FulfillmentSetParameterAction `json:"setParameterActions,omitempty"`
	Tag                      string                                                    `json:"tag,omitempty"`
	Webhook                  string                                                    `json:"webhook,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Fulfillment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Fulfillment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FulfillmentConditionalCases struct {
	Cases []*GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase `json:"cases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cases") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentConditionalCases) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCases
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase struct {
	CaseContent []*GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent `json:"caseContent,omitempty"`
	Condition   string                                                                 `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent struct {
	AdditionalCases *GoogleCloudDialogflowCxV3FulfillmentConditionalCases `json:"additionalCases,omitempty"`
	Message         *GoogleCloudDialogflowCxV3ResponseMessage             `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalCases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalCases") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings struct {
	Generator       string            `json:"generator,omitempty"`
	InputParameters map[string]string `json:"inputParameters,omitempty"`
	OutputParameter string            `json:"outputParameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Generator") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Generator") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FulfillmentSetParameterAction struct {
	Parameter string      `json:"parameter,omitempty"`
	Value     interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentSetParameterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentSetParameterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3GcsDestination struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportEntityTypesMetadata struct {
}

type GoogleCloudDialogflowCxV3ImportEntityTypesResponse struct {
	ConflictingResources *GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources `json:"conflictingResources,omitempty"`
	EntityTypes          []string                                                                `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources struct {
	EntityDisplayNames     []string `json:"entityDisplayNames,omitempty"`
	EntityTypeDisplayNames []string `json:"entityTypeDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportFlowResponse struct {
	Flow string `json:"flow,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportIntentsMetadata struct {
}

type GoogleCloudDialogflowCxV3ImportIntentsResponse struct {
	ConflictingResources *GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources `json:"conflictingResources,omitempty"`
	Intents              []string                                                            `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources struct {
	EntityDisplayNames []string `json:"entityDisplayNames,omitempty"`
	IntentDisplayNames []string `json:"intentDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportTestCasesMetadata struct {
	Errors []*GoogleCloudDialogflowCxV3TestCaseError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportTestCasesResponse struct {
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3InlineDestination struct {
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3InlineDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3InlineDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3InputAudioConfig struct {
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED"
	//   "AUDIO_ENCODING_LINEAR_16"
	//   "AUDIO_ENCODING_FLAC"
	//   "AUDIO_ENCODING_MULAW"
	//   "AUDIO_ENCODING_AMR"
	//   "AUDIO_ENCODING_AMR_WB"
	//   "AUDIO_ENCODING_OGG_OPUS"
	//   "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE"
	//   "AUDIO_ENCODING_ALAW"
	AudioEncoding  string                                  `json:"audioEncoding,omitempty"`
	BargeInConfig  *GoogleCloudDialogflowCxV3BargeInConfig `json:"bargeInConfig,omitempty"`
	EnableWordInfo bool                                    `json:"enableWordInfo,omitempty"`
	Model          string                                  `json:"model,omitempty"`
	// Possible values:
	//   "SPEECH_MODEL_VARIANT_UNSPECIFIED"
	//   "USE_BEST_AVAILABLE"
	//   "USE_STANDARD"
	//   "USE_ENHANCED"
	ModelVariant                  string   `json:"modelVariant,omitempty"`
	OptOutConformerModelMigration bool     `json:"optOutConformerModelMigration,omitempty"`
	PhraseHints                   []string `json:"phraseHints,omitempty"`
	SampleRateHertz               int64    `json:"sampleRateHertz,omitempty"`
	SingleUtterance               bool     `json:"singleUtterance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3InputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3InputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Intent struct {
	Description     string                                           `json:"description,omitempty"`
	DisplayName     string                                           `json:"displayName,omitempty"`
	IsFallback      bool                                             `json:"isFallback,omitempty"`
	Labels          map[string]string                                `json:"labels,omitempty"`
	Name            string                                           `json:"name,omitempty"`
	Parameters      []*GoogleCloudDialogflowCxV3IntentParameter      `json:"parameters,omitempty"`
	Priority        int64                                            `json:"priority,omitempty"`
	TrainingPhrases []*GoogleCloudDialogflowCxV3IntentTrainingPhrase `json:"trainingPhrases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3IntentInput struct {
	Intent string `json:"intent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3IntentParameter struct {
	EntityType string `json:"entityType,omitempty"`
	Id         string `json:"id,omitempty"`
	IsList     bool   `json:"isList,omitempty"`
	Redact     bool   `json:"redact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3IntentTrainingPhrase struct {
	Id          string                                               `json:"id,omitempty"`
	Parts       []*GoogleCloudDialogflowCxV3IntentTrainingPhrasePart `json:"parts,omitempty"`
	RepeatCount int64                                                `json:"repeatCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3IntentTrainingPhrasePart struct {
	ParameterId string `json:"parameterId,omitempty"`
	Text        string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3KnowledgeConnectorSettings struct {
	DataStoreConnections []*GoogleCloudDialogflowCxV3DataStoreConnection `json:"dataStoreConnections,omitempty"`
	Enabled              bool                                            `json:"enabled,omitempty"`
	TargetFlow           string                                          `json:"targetFlow,omitempty"`
	TargetPage           string                                          `json:"targetPage,omitempty"`
	TriggerFulfillment   *GoogleCloudDialogflowCxV3Fulfillment           `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStoreConnections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreConnections") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3KnowledgeConnectorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3KnowledgeConnectorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3LanguageInfo struct {
	ConfidenceScore      float64 `json:"confidenceScore,omitempty"`
	InputLanguageCode    string  `json:"inputLanguageCode,omitempty"`
	ResolvedLanguageCode string  `json:"resolvedLanguageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3LanguageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3LanguageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3LanguageInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3LanguageInfo
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

type GoogleCloudDialogflowCxV3Page struct {
	AdvancedSettings           *GoogleCloudDialogflowCxV3AdvancedSettings           `json:"advancedSettings,omitempty"`
	Description                string                                               `json:"description,omitempty"`
	DisplayName                string                                               `json:"displayName,omitempty"`
	EntryFulfillment           *GoogleCloudDialogflowCxV3Fulfillment                `json:"entryFulfillment,omitempty"`
	EventHandlers              []*GoogleCloudDialogflowCxV3EventHandler             `json:"eventHandlers,omitempty"`
	Form                       *GoogleCloudDialogflowCxV3Form                       `json:"form,omitempty"`
	KnowledgeConnectorSettings *GoogleCloudDialogflowCxV3KnowledgeConnectorSettings `json:"knowledgeConnectorSettings,omitempty"`
	Name                       string                                               `json:"name,omitempty"`
	TransitionRouteGroups      []string                                             `json:"transitionRouteGroups,omitempty"`
	TransitionRoutes           []*GoogleCloudDialogflowCxV3TransitionRoute          `json:"transitionRoutes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Page) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Page
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3PageInfo struct {
	CurrentPage string                                     `json:"currentPage,omitempty"`
	DisplayName string                                     `json:"displayName,omitempty"`
	FormInfo    *GoogleCloudDialogflowCxV3PageInfoFormInfo `json:"formInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3PageInfoFormInfo struct {
	ParameterInfo []*GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo `json:"parameterInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PageInfoFormInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfoFormInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo struct {
	DisplayName   string `json:"displayName,omitempty"`
	JustCollected bool   `json:"justCollected,omitempty"`
	Required      bool   `json:"required,omitempty"`
	// Possible values:
	//   "PARAMETER_STATE_UNSPECIFIED"
	//   "EMPTY"
	//   "INVALID"
	//   "FILLED"
	State string      `json:"state,omitempty"`
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3QueryInput struct {
	Audio          *GoogleCloudDialogflowCxV3AudioInput     `json:"audio,omitempty"`
	Dtmf           *GoogleCloudDialogflowCxV3DtmfInput      `json:"dtmf,omitempty"`
	Event          *GoogleCloudDialogflowCxV3EventInput     `json:"event,omitempty"`
	Intent         *GoogleCloudDialogflowCxV3IntentInput    `json:"intent,omitempty"`
	LanguageCode   string                                   `json:"languageCode,omitempty"`
	Text           *GoogleCloudDialogflowCxV3TextInput      `json:"text,omitempty"`
	ToolCallResult *GoogleCloudDialogflowCxV3ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3QueryInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3QueryInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessage struct {
	Channel             string                                                       `json:"channel,omitempty"`
	ConversationSuccess *GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess `json:"conversationSuccess,omitempty"`
	EndInteraction      *GoogleCloudDialogflowCxV3ResponseMessageEndInteraction      `json:"endInteraction,omitempty"`
	KnowledgeInfoCard   *GoogleCloudDialogflowCxV3ResponseMessageKnowledgeInfoCard   `json:"knowledgeInfoCard,omitempty"`
	LiveAgentHandoff    *GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff    `json:"liveAgentHandoff,omitempty"`
	MixedAudio          *GoogleCloudDialogflowCxV3ResponseMessageMixedAudio          `json:"mixedAudio,omitempty"`
	OutputAudioText     *GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText     `json:"outputAudioText,omitempty"`
	Payload             googleapi.RawMessage                                         `json:"payload,omitempty"`
	PlayAudio           *GoogleCloudDialogflowCxV3ResponseMessagePlayAudio           `json:"playAudio,omitempty"`
	// Possible values:
	//   "RESPONSE_TYPE_UNSPECIFIED"
	//   "ENTRY_PROMPT"
	//   "PARAMETER_PROMPT"
	//   "HANDLER_PROMPT"
	ResponseType          string                                                         `json:"responseType,omitempty"`
	TelephonyTransferCall *GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall `json:"telephonyTransferCall,omitempty"`
	Text                  *GoogleCloudDialogflowCxV3ResponseMessageText                  `json:"text,omitempty"`
	ToolCall              *GoogleCloudDialogflowCxV3ToolCall                             `json:"toolCall,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channel") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessageEndInteraction struct {
}

type GoogleCloudDialogflowCxV3ResponseMessageKnowledgeInfoCard struct {
}

type GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessageMixedAudio struct {
	Segments []*GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment `json:"segments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Segments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Segments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageMixedAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageMixedAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment struct {
	AllowPlaybackInterruption bool   `json:"allowPlaybackInterruption,omitempty"`
	Audio                     string `json:"audio,omitempty"`
	Uri                       string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText struct {
	AllowPlaybackInterruption bool   `json:"allowPlaybackInterruption,omitempty"`
	Ssml                      string `json:"ssml,omitempty"`
	Text                      string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessagePlayAudio struct {
	AllowPlaybackInterruption bool   `json:"allowPlaybackInterruption,omitempty"`
	AudioUri                  string `json:"audioUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessagePlayAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessagePlayAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall struct {
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessageText struct {
	AllowPlaybackInterruption bool     `json:"allowPlaybackInterruption,omitempty"`
	Text                      []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3RunContinuousTestMetadata struct {
	Errors []*GoogleCloudDialogflowCxV3TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RunContinuousTestMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunContinuousTestMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3RunContinuousTestResponse struct {
	ContinuousTestResult *GoogleCloudDialogflowCxV3ContinuousTestResult `json:"continuousTestResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContinuousTestResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContinuousTestResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RunContinuousTestResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunContinuousTestResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3RunTestCaseMetadata struct {
}

type GoogleCloudDialogflowCxV3RunTestCaseResponse struct {
	Result *GoogleCloudDialogflowCxV3TestCaseResult `json:"result,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Result") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RunTestCaseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunTestCaseResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3SessionInfo struct {
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	Session    string               `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SessionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TestCase struct {
	CreationTime              string                                       `json:"creationTime,omitempty"`
	DisplayName               string                                       `json:"displayName,omitempty"`
	LastTestResult            *GoogleCloudDialogflowCxV3TestCaseResult     `json:"lastTestResult,omitempty"`
	Name                      string                                       `json:"name,omitempty"`
	Notes                     string                                       `json:"notes,omitempty"`
	Tags                      []string                                     `json:"tags,omitempty"`
	TestCaseConversationTurns []*GoogleCloudDialogflowCxV3ConversationTurn `json:"testCaseConversationTurns,omitempty"`
	TestConfig                *GoogleCloudDialogflowCxV3TestConfig         `json:"testConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TestCaseError struct {
	Status   *GoogleRpcStatus                   `json:"status,omitempty"`
	TestCase *GoogleCloudDialogflowCxV3TestCase `json:"testCase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestCaseError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCaseError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TestCaseResult struct {
	ConversationTurns []*GoogleCloudDialogflowCxV3ConversationTurn `json:"conversationTurns,omitempty"`
	Environment       string                                       `json:"environment,omitempty"`
	Name              string                                       `json:"name,omitempty"`
	// Possible values:
	//   "TEST_RESULT_UNSPECIFIED"
	//   "PASSED"
	//   "FAILED"
	TestResult string `json:"testResult,omitempty"`
	TestTime   string `json:"testTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationTurns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationTurns") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestCaseResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCaseResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TestConfig struct {
	Flow               string   `json:"flow,omitempty"`
	Page               string   `json:"page,omitempty"`
	TrackingParameters []string `json:"trackingParameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TestError struct {
	Status   *GoogleRpcStatus `json:"status,omitempty"`
	TestCase string           `json:"testCase,omitempty"`
	TestTime string           `json:"testTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TestRunDifference struct {
	Description string `json:"description,omitempty"`
	// Possible values:
	//   "DIFF_TYPE_UNSPECIFIED"
	//   "INTENT"
	//   "PAGE"
	//   "PARAMETERS"
	//   "UTTERANCE"
	//   "FLOW"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestRunDifference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestRunDifference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TextInput struct {
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TextInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TextInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolCall struct {
	Action          string               `json:"action,omitempty"`
	InputParameters googleapi.RawMessage `json:"inputParameters,omitempty"`
	Tool            string               `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolCallResult struct {
	Action           string                                        `json:"action,omitempty"`
	Error            *GoogleCloudDialogflowCxV3ToolCallResultError `json:"error,omitempty"`
	OutputParameters googleapi.RawMessage                          `json:"outputParameters,omitempty"`
	Tool             string                                        `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolCallResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolCallResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolCallResultError struct {
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolCallResultError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolCallResultError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TransitionRoute struct {
	Condition          string                                `json:"condition,omitempty"`
	Description        string                                `json:"description,omitempty"`
	Intent             string                                `json:"intent,omitempty"`
	Name               string                                `json:"name,omitempty"`
	TargetFlow         string                                `json:"targetFlow,omitempty"`
	TargetPage         string                                `json:"targetPage,omitempty"`
	TriggerFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TransitionRoute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TransitionRoute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TurnSignals struct {
	AgentEscalated bool `json:"agentEscalated,omitempty"`
	DtmfUsed       bool `json:"dtmfUsed,omitempty"`
	// Possible values:
	//   "FAILURE_REASON_UNSPECIFIED"
	//   "FAILED_INTENT"
	//   "FAILED_WEBHOOK"
	FailureReasons     []string `json:"failureReasons,omitempty"`
	NoMatch            bool     `json:"noMatch,omitempty"`
	NoUserInput        bool     `json:"noUserInput,omitempty"`
	ReachedEndPage     bool     `json:"reachedEndPage,omitempty"`
	SentimentMagnitude float64  `json:"sentimentMagnitude,omitempty"`
	SentimentScore     float64  `json:"sentimentScore,omitempty"`
	UserEscalated      bool     `json:"userEscalated,omitempty"`
	WebhookStatuses    []string `json:"webhookStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentEscalated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentEscalated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TurnSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TurnSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3TurnSignals) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3TurnSignals
	var s1 struct {
		SentimentMagnitude gensupport.JSONFloat64 `json:"sentimentMagnitude"`
		SentimentScore     gensupport.JSONFloat64 `json:"sentimentScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SentimentMagnitude = float64(s1.SentimentMagnitude)
	s.SentimentScore = float64(s1.SentimentScore)
	return nil
}

type GoogleCloudDialogflowCxV3Webhook struct {
	Disabled          bool                                                    `json:"disabled,omitempty"`
	DisplayName       string                                                  `json:"displayName,omitempty"`
	GenericWebService *GoogleCloudDialogflowCxV3WebhookGenericWebService      `json:"genericWebService,omitempty"`
	Name              string                                                  `json:"name,omitempty"`
	ServiceDirectory  *GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig `json:"serviceDirectory,omitempty"`
	Timeout           string                                                  `json:"timeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Webhook) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Webhook
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookGenericWebService struct {
	AllowedCaCerts []string `json:"allowedCaCerts,omitempty"`
	// Possible values:
	//   "HTTP_METHOD_UNSPECIFIED"
	//   "POST"
	//   "GET"
	//   "HEAD"
	//   "PUT"
	//   "DELETE"
	//   "PATCH"
	//   "OPTIONS"
	HttpMethod                       string                                                                               `json:"httpMethod,omitempty"`
	OauthConfig                      *GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig                        `json:"oauthConfig,omitempty"`
	ParameterMapping                 map[string]string                                                                    `json:"parameterMapping,omitempty"`
	Password                         string                                                                               `json:"password,omitempty"`
	RequestBody                      string                                                                               `json:"requestBody,omitempty"`
	RequestHeaders                   map[string]string                                                                    `json:"requestHeaders,omitempty"`
	SecretVersionForUsernamePassword string                                                                               `json:"secretVersionForUsernamePassword,omitempty"`
	SecretVersionsForRequestHeaders  map[string]GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue `json:"secretVersionsForRequestHeaders,omitempty"`
	ServiceAccountAuthConfig         *GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig           `json:"serviceAccountAuthConfig,omitempty"`
	// Possible values:
	//   "SERVICE_AGENT_AUTH_UNSPECIFIED"
	//   "NONE"
	//   "ID_TOKEN"
	//   "ACCESS_TOKEN"
	ServiceAgentAuth string `json:"serviceAgentAuth,omitempty"`
	Uri              string `json:"uri,omitempty"`
	Username         string `json:"username,omitempty"`
	// Possible values:
	//   "WEBHOOK_TYPE_UNSPECIFIED"
	//   "STANDARD"
	//   "FLEXIBLE"
	WebhookType string `json:"webhookType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedCaCerts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedCaCerts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig struct {
	ClientId                     string   `json:"clientId,omitempty"`
	ClientSecret                 string   `json:"clientSecret,omitempty"`
	Scopes                       []string `json:"scopes,omitempty"`
	SecretVersionForClientSecret string   `json:"secretVersionForClientSecret,omitempty"`
	TokenEndpoint                string   `json:"tokenEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue struct {
	SecretVersion string `json:"secretVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecretVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecretVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig struct {
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAccount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookRequest struct {
	DetectIntentResponseId  string                                                          `json:"detectIntentResponseId,omitempty"`
	DtmfDigits              string                                                          `json:"dtmfDigits,omitempty"`
	FulfillmentInfo         *GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo         `json:"fulfillmentInfo,omitempty"`
	IntentInfo              *GoogleCloudDialogflowCxV3WebhookRequestIntentInfo              `json:"intentInfo,omitempty"`
	LanguageCode            string                                                          `json:"languageCode,omitempty"`
	LanguageInfo            *GoogleCloudDialogflowCxV3LanguageInfo                          `json:"languageInfo,omitempty"`
	Messages                []*GoogleCloudDialogflowCxV3ResponseMessage                     `json:"messages,omitempty"`
	PageInfo                *GoogleCloudDialogflowCxV3PageInfo                              `json:"pageInfo,omitempty"`
	Payload                 googleapi.RawMessage                                            `json:"payload,omitempty"`
	SentimentAnalysisResult *GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	SessionInfo             *GoogleCloudDialogflowCxV3SessionInfo                           `json:"sessionInfo,omitempty"`
	Text                    string                                                          `json:"text,omitempty"`
	Transcript              string                                                          `json:"transcript,omitempty"`
	TriggerEvent            string                                                          `json:"triggerEvent,omitempty"`
	TriggerIntent           string                                                          `json:"triggerIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectIntentResponseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectIntentResponseId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo struct {
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookRequestIntentInfo struct {
	Confidence        float64                                                                          `json:"confidence,omitempty"`
	DisplayName       string                                                                           `json:"displayName,omitempty"`
	LastMatchedIntent string                                                                           `json:"lastMatchedIntent,omitempty"`
	Parameters        map[string]GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3WebhookRequestIntentInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue struct {
	OriginalValue string      `json:"originalValue,omitempty"`
	ResolvedValue interface{} `json:"resolvedValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OriginalValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OriginalValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult struct {
	Magnitude float64 `json:"magnitude,omitempty"`
	Score     float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

type GoogleCloudDialogflowCxV3WebhookResponse struct {
	FulfillmentResponse *GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse `json:"fulfillmentResponse,omitempty"`
	PageInfo            *GoogleCloudDialogflowCxV3PageInfo                           `json:"pageInfo,omitempty"`
	Payload             googleapi.RawMessage                                         `json:"payload,omitempty"`
	SessionInfo         *GoogleCloudDialogflowCxV3SessionInfo                        `json:"sessionInfo,omitempty"`
	TargetFlow          string                                                       `json:"targetFlow,omitempty"`
	TargetPage          string                                                       `json:"targetPage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FulfillmentResponse") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FulfillmentResponse") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse struct {
	// Possible values:
	//   "MERGE_BEHAVIOR_UNSPECIFIED"
	//   "APPEND"
	//   "REPLACE"
	MergeBehavior string                                      `json:"mergeBehavior,omitempty"`
	Messages      []*GoogleCloudDialogflowCxV3ResponseMessage `json:"messages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MergeBehavior") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MergeBehavior") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig struct {
	GenericWebService *GoogleCloudDialogflowCxV3WebhookGenericWebService `json:"genericWebService,omitempty"`
	Service           string                                             `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericWebService") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericWebService") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1AdvancedSettings struct {
	AudioExportGcsDestination *GoogleCloudDialogflowCxV3beta1GcsDestination                  `json:"audioExportGcsDestination,omitempty"`
	DtmfSettings              *GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings    `json:"dtmfSettings,omitempty"`
	LoggingSettings           *GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings `json:"loggingSettings,omitempty"`
	SpeechSettings            *GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings  `json:"speechSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioExportGcsDestination")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioExportGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings struct {
	Enabled                    bool   `json:"enabled,omitempty"`
	EndpointingTimeoutDuration string `json:"endpointingTimeoutDuration,omitempty"`
	FinishDigit                string `json:"finishDigit,omitempty"`
	InterdigitTimeoutDuration  string `json:"interdigitTimeoutDuration,omitempty"`
	MaxDigits                  int64  `json:"maxDigits,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings struct {
	EnableConsentBasedRedaction bool `json:"enableConsentBasedRedaction,omitempty"`
	EnableInteractionLogging    bool `json:"enableInteractionLogging,omitempty"`
	EnableStackdriverLogging    bool `json:"enableStackdriverLogging,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableConsentBasedRedaction") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableConsentBasedRedaction") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings struct {
	EndpointerSensitivity      int64             `json:"endpointerSensitivity,omitempty"`
	Models                     map[string]string `json:"models,omitempty"`
	NoSpeechTimeout            string            `json:"noSpeechTimeout,omitempty"`
	UseTimeoutBasedEndpointing bool              `json:"useTimeoutBasedEndpointing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndpointerSensitivity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndpointerSensitivity") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1AudioInput struct {
	Audio  string                                          `json:"audio,omitempty"`
	Config *GoogleCloudDialogflowCxV3beta1InputAudioConfig `json:"config,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AudioInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AudioInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1BargeInConfig struct {
	NoBargeInDuration string `json:"noBargeInDuration,omitempty"`
	TotalDuration     string `json:"totalDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NoBargeInDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoBargeInDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BargeInConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BargeInConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata struct {
	Errors []*GoogleCloudDialogflowCxV3beta1TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse struct {
	Results []*GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"results,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Results") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Results") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ContinuousTestResult struct {
	Name string `json:"name,omitempty"`
	// Possible values:
	//   "AGGREGATED_TEST_RESULT_UNSPECIFIED"
	//   "PASSED"
	//   "FAILED"
	Result          string   `json:"result,omitempty"`
	RunTime         string   `json:"runTime,omitempty"`
	TestCaseResults []string `json:"testCaseResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ContinuousTestResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ContinuousTestResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ConversationSignals struct {
	TurnSignals *GoogleCloudDialogflowCxV3beta1TurnSignals `json:"turnSignals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TurnSignals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TurnSignals") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ConversationTurn struct {
	UserInput          *GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput          `json:"userInput,omitempty"`
	VirtualAgentOutput *GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput `json:"virtualAgentOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserInput") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationTurn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput struct {
	EnableSentimentAnalysis bool                                      `json:"enableSentimentAnalysis,omitempty"`
	InjectedParameters      googleapi.RawMessage                      `json:"injectedParameters,omitempty"`
	Input                   *GoogleCloudDialogflowCxV3beta1QueryInput `json:"input,omitempty"`
	IsWebhookEnabled        bool                                      `json:"isWebhookEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput struct {
	CurrentPage       *GoogleCloudDialogflowCxV3beta1Page                  `json:"currentPage,omitempty"`
	DiagnosticInfo    googleapi.RawMessage                                 `json:"diagnosticInfo,omitempty"`
	Differences       []*GoogleCloudDialogflowCxV3beta1TestRunDifference   `json:"differences,omitempty"`
	SessionParameters googleapi.RawMessage                                 `json:"sessionParameters,omitempty"`
	Status            *GoogleRpcStatus                                     `json:"status,omitempty"`
	TextResponses     []*GoogleCloudDialogflowCxV3beta1ResponseMessageText `json:"textResponses,omitempty"`
	TriggeredIntent   *GoogleCloudDialogflowCxV3beta1Intent                `json:"triggeredIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata struct {
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1DataStoreConnection struct {
	DataStore string `json:"dataStore,omitempty"`
	// Possible values:
	//   "DATA_STORE_TYPE_UNSPECIFIED"
	//   "PUBLIC_WEB"
	//   "UNSTRUCTURED"
	//   "STRUCTURED"
	DataStoreType string `json:"dataStoreType,omitempty"`
	// Possible values:
	//   "DOCUMENT_PROCESSING_MODE_UNSPECIFIED"
	//   "DOCUMENTS"
	//   "CHUNKS"
	DocumentProcessingMode string `json:"documentProcessingMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DataStoreConnection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DataStoreConnection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1DeployFlowMetadata struct {
	TestErrors []*GoogleCloudDialogflowCxV3beta1TestError `json:"testErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DeployFlowMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeployFlowMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1DeployFlowResponse struct {
	Deployment  string                                     `json:"deployment,omitempty"`
	Environment *GoogleCloudDialogflowCxV3beta1Environment `json:"environment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deployment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DeployFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeployFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1DtmfInput struct {
	Digits      string `json:"digits,omitempty"`
	FinishDigit string `json:"finishDigit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Digits") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Digits") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DtmfInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DtmfInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1Environment struct {
	Description     string                                                    `json:"description,omitempty"`
	DisplayName     string                                                    `json:"displayName,omitempty"`
	Name            string                                                    `json:"name,omitempty"`
	TestCasesConfig *GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig `json:"testCasesConfig,omitempty"`
	UpdateTime      string                                                    `json:"updateTime,omitempty"`
	VersionConfigs  []*GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig `json:"versionConfigs,omitempty"`
	WebhookConfig   *GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig   `json:"webhookConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Environment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Environment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig struct {
	EnableContinuousRun    bool     `json:"enableContinuousRun,omitempty"`
	EnablePredeploymentRun bool     `json:"enablePredeploymentRun,omitempty"`
	TestCases              []string `json:"testCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableContinuousRun") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableContinuousRun") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig struct {
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig struct {
	WebhookOverrides []*GoogleCloudDialogflowCxV3beta1Webhook `json:"webhookOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WebhookOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WebhookOverrides") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1EventHandler struct {
	Event              string                                     `json:"event,omitempty"`
	Name               string                                     `json:"name,omitempty"`
	TargetFlow         string                                     `json:"targetFlow,omitempty"`
	TargetPage         string                                     `json:"targetPage,omitempty"`
	TargetPlaybook     string                                     `json:"targetPlaybook,omitempty"`
	TriggerFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EventHandler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EventHandler
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1EventInput struct {
	Event string `json:"event,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ExportAgentResponse struct {
	AgentContent string `json:"agentContent,omitempty"`
	AgentUri     string `json:"agentUri,omitempty"`
	CommitSha    string `json:"commitSha,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ExportEntityTypesMetadata struct {
}

type GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse struct {
	EntityTypesContent *GoogleCloudDialogflowCxV3beta1InlineDestination `json:"entityTypesContent,omitempty"`
	EntityTypesUri     string                                           `json:"entityTypesUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypesContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypesContent") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ExportFlowResponse struct {
	FlowContent string `json:"flowContent,omitempty"`
	FlowUri     string `json:"flowUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlowContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ExportIntentsMetadata struct {
}

type GoogleCloudDialogflowCxV3beta1ExportIntentsResponse struct {
	IntentsContent *GoogleCloudDialogflowCxV3beta1InlineDestination `json:"intentsContent,omitempty"`
	IntentsUri     string                                           `json:"intentsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentsContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentsContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ExportTestCasesMetadata struct {
}

type GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse struct {
	Content string `json:"content,omitempty"`
	GcsUri  string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1Form struct {
	Parameters []*GoogleCloudDialogflowCxV3beta1FormParameter `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Form) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Form
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1FormParameter struct {
	AdvancedSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettings          `json:"advancedSettings,omitempty"`
	DefaultValue     interface{}                                              `json:"defaultValue,omitempty"`
	DisplayName      string                                                   `json:"displayName,omitempty"`
	EntityType       string                                                   `json:"entityType,omitempty"`
	FillBehavior     *GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior `json:"fillBehavior,omitempty"`
	IsList           bool                                                     `json:"isList,omitempty"`
	Redact           bool                                                     `json:"redact,omitempty"`
	Required         bool                                                     `json:"required,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FormParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FormParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior struct {
	InitialPromptFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment    `json:"initialPromptFulfillment,omitempty"`
	RepromptEventHandlers    []*GoogleCloudDialogflowCxV3beta1EventHandler `json:"repromptEventHandlers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InitialPromptFulfillment")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InitialPromptFulfillment") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1Fulfillment struct {
	AdvancedSettings         *GoogleCloudDialogflowCxV3beta1AdvancedSettings                `json:"advancedSettings,omitempty"`
	ConditionalCases         []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases   `json:"conditionalCases,omitempty"`
	EnableGenerativeFallback bool                                                           `json:"enableGenerativeFallback,omitempty"`
	Generators               []*GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings  `json:"generators,omitempty"`
	Messages                 []*GoogleCloudDialogflowCxV3beta1ResponseMessage               `json:"messages,omitempty"`
	ReturnPartialResponses   bool                                                           `json:"returnPartialResponses,omitempty"`
	SetParameterActions      []*GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction `json:"setParameterActions,omitempty"`
	Tag                      string                                                         `json:"tag,omitempty"`
	Webhook                  string                                                         `json:"webhook,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Fulfillment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Fulfillment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases struct {
	Cases []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase `json:"cases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cases") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase struct {
	CaseContent []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent `json:"caseContent,omitempty"`
	Condition   string                                                                      `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent struct {
	AdditionalCases *GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases `json:"additionalCases,omitempty"`
	Message         *GoogleCloudDialogflowCxV3beta1ResponseMessage             `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalCases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalCases") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings struct {
	Generator       string            `json:"generator,omitempty"`
	InputParameters map[string]string `json:"inputParameters,omitempty"`
	OutputParameter string            `json:"outputParameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Generator") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Generator") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction struct {
	Parameter string      `json:"parameter,omitempty"`
	Value     interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1GcsDestination struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ImportEntityTypesMetadata struct {
}

type GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse struct {
	ConflictingResources *GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources `json:"conflictingResources,omitempty"`
	EntityTypes          []string                                                                     `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources struct {
	EntityDisplayNames     []string `json:"entityDisplayNames,omitempty"`
	EntityTypeDisplayNames []string `json:"entityTypeDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ImportFlowResponse struct {
	Flow string `json:"flow,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ImportIntentsMetadata struct {
}

type GoogleCloudDialogflowCxV3beta1ImportIntentsResponse struct {
	ConflictingResources *GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources `json:"conflictingResources,omitempty"`
	Intents              []string                                                                 `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources struct {
	EntityDisplayNames []string `json:"entityDisplayNames,omitempty"`
	IntentDisplayNames []string `json:"intentDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata struct {
	Errors []*GoogleCloudDialogflowCxV3beta1TestCaseError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse struct {
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1InlineDestination struct {
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1InlineDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1InlineDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1InputAudioConfig struct {
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED"
	//   "AUDIO_ENCODING_LINEAR_16"
	//   "AUDIO_ENCODING_FLAC"
	//   "AUDIO_ENCODING_MULAW"
	//   "AUDIO_ENCODING_AMR"
	//   "AUDIO_ENCODING_AMR_WB"
	//   "AUDIO_ENCODING_OGG_OPUS"
	//   "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE"
	//   "AUDIO_ENCODING_ALAW"
	AudioEncoding  string                                       `json:"audioEncoding,omitempty"`
	BargeInConfig  *GoogleCloudDialogflowCxV3beta1BargeInConfig `json:"bargeInConfig,omitempty"`
	EnableWordInfo bool                                         `json:"enableWordInfo,omitempty"`
	Model          string                                       `json:"model,omitempty"`
	// Possible values:
	//   "SPEECH_MODEL_VARIANT_UNSPECIFIED"
	//   "USE_BEST_AVAILABLE"
	//   "USE_STANDARD"
	//   "USE_ENHANCED"
	ModelVariant                  string   `json:"modelVariant,omitempty"`
	OptOutConformerModelMigration bool     `json:"optOutConformerModelMigration,omitempty"`
	PhraseHints                   []string `json:"phraseHints,omitempty"`
	SampleRateHertz               int64    `json:"sampleRateHertz,omitempty"`
	SingleUtterance               bool     `json:"singleUtterance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1InputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1InputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1Intent struct {
	Description     string                                                `json:"description,omitempty"`
	DisplayName     string                                                `json:"displayName,omitempty"`
	IsFallback      bool                                                  `json:"isFallback,omitempty"`
	Labels          map[string]string                                     `json:"labels,omitempty"`
	Name            string                                                `json:"name,omitempty"`
	Parameters      []*GoogleCloudDialogflowCxV3beta1IntentParameter      `json:"parameters,omitempty"`
	Priority        int64                                                 `json:"priority,omitempty"`
	TrainingPhrases []*GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase `json:"trainingPhrases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1IntentInput struct {
	Intent string `json:"intent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1IntentParameter struct {
	EntityType string `json:"entityType,omitempty"`
	Id         string `json:"id,omitempty"`
	IsList     bool   `json:"isList,omitempty"`
	Redact     bool   `json:"redact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase struct {
	Id          string                                                    `json:"id,omitempty"`
	Parts       []*GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart `json:"parts,omitempty"`
	RepeatCount int64                                                     `json:"repeatCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart struct {
	ParameterId string `json:"parameterId,omitempty"`
	Text        string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings struct {
	DataStoreConnections []*GoogleCloudDialogflowCxV3beta1DataStoreConnection `json:"dataStoreConnections,omitempty"`
	Enabled              bool                                                 `json:"enabled,omitempty"`
	TargetFlow           string                                               `json:"targetFlow,omitempty"`
	TargetPage           string                                               `json:"targetPage,omitempty"`
	TriggerFulfillment   *GoogleCloudDialogflowCxV3beta1Fulfillment           `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStoreConnections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreConnections") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1LanguageInfo struct {
	ConfidenceScore      float64 `json:"confidenceScore,omitempty"`
	InputLanguageCode    string  `json:"inputLanguageCode,omitempty"`
	ResolvedLanguageCode string  `json:"resolvedLanguageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1LanguageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1LanguageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1LanguageInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1LanguageInfo
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

type GoogleCloudDialogflowCxV3beta1Page struct {
	AdvancedSettings           *GoogleCloudDialogflowCxV3beta1AdvancedSettings           `json:"advancedSettings,omitempty"`
	Description                string                                                    `json:"description,omitempty"`
	DisplayName                string                                                    `json:"displayName,omitempty"`
	EntryFulfillment           *GoogleCloudDialogflowCxV3beta1Fulfillment                `json:"entryFulfillment,omitempty"`
	EventHandlers              []*GoogleCloudDialogflowCxV3beta1EventHandler             `json:"eventHandlers,omitempty"`
	Form                       *GoogleCloudDialogflowCxV3beta1Form                       `json:"form,omitempty"`
	KnowledgeConnectorSettings *GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings `json:"knowledgeConnectorSettings,omitempty"`
	Name                       string                                                    `json:"name,omitempty"`
	TransitionRouteGroups      []string                                                  `json:"transitionRouteGroups,omitempty"`
	TransitionRoutes           []*GoogleCloudDialogflowCxV3beta1TransitionRoute          `json:"transitionRoutes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Page) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Page
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1PageInfo struct {
	CurrentPage string                                          `json:"currentPage,omitempty"`
	DisplayName string                                          `json:"displayName,omitempty"`
	FormInfo    *GoogleCloudDialogflowCxV3beta1PageInfoFormInfo `json:"formInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1PageInfoFormInfo struct {
	ParameterInfo []*GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo `json:"parameterInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PageInfoFormInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfoFormInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo struct {
	DisplayName   string `json:"displayName,omitempty"`
	JustCollected bool   `json:"justCollected,omitempty"`
	Required      bool   `json:"required,omitempty"`
	// Possible values:
	//   "PARAMETER_STATE_UNSPECIFIED"
	//   "EMPTY"
	//   "INVALID"
	//   "FILLED"
	State string      `json:"state,omitempty"`
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1QueryInput struct {
	Audio          *GoogleCloudDialogflowCxV3beta1AudioInput     `json:"audio,omitempty"`
	Dtmf           *GoogleCloudDialogflowCxV3beta1DtmfInput      `json:"dtmf,omitempty"`
	Event          *GoogleCloudDialogflowCxV3beta1EventInput     `json:"event,omitempty"`
	Intent         *GoogleCloudDialogflowCxV3beta1IntentInput    `json:"intent,omitempty"`
	LanguageCode   string                                        `json:"languageCode,omitempty"`
	Text           *GoogleCloudDialogflowCxV3beta1TextInput      `json:"text,omitempty"`
	ToolCallResult *GoogleCloudDialogflowCxV3beta1ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1QueryInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1QueryInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessage struct {
	Channel               string                                                              `json:"channel,omitempty"`
	ConversationSuccess   *GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess   `json:"conversationSuccess,omitempty"`
	EndInteraction        *GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction        `json:"endInteraction,omitempty"`
	KnowledgeInfoCard     *GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard     `json:"knowledgeInfoCard,omitempty"`
	LiveAgentHandoff      *GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff      `json:"liveAgentHandoff,omitempty"`
	MixedAudio            *GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio            `json:"mixedAudio,omitempty"`
	OutputAudioText       *GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText       `json:"outputAudioText,omitempty"`
	Payload               googleapi.RawMessage                                                `json:"payload,omitempty"`
	PlayAudio             *GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio             `json:"playAudio,omitempty"`
	TelephonyTransferCall *GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall `json:"telephonyTransferCall,omitempty"`
	Text                  *GoogleCloudDialogflowCxV3beta1ResponseMessageText                  `json:"text,omitempty"`
	ToolCall              *GoogleCloudDialogflowCxV3beta1ToolCall                             `json:"toolCall,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channel") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction struct {
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard struct {
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio struct {
	Segments []*GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment `json:"segments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Segments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Segments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment struct {
	AllowPlaybackInterruption bool   `json:"allowPlaybackInterruption,omitempty"`
	Audio                     string `json:"audio,omitempty"`
	Uri                       string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText struct {
	AllowPlaybackInterruption bool   `json:"allowPlaybackInterruption,omitempty"`
	Ssml                      string `json:"ssml,omitempty"`
	Text                      string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio struct {
	AllowPlaybackInterruption bool   `json:"allowPlaybackInterruption,omitempty"`
	AudioUri                  string `json:"audioUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall struct {
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageText struct {
	AllowPlaybackInterruption bool     `json:"allowPlaybackInterruption,omitempty"`
	Text                      []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata struct {
	Errors []*GoogleCloudDialogflowCxV3beta1TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse struct {
	ContinuousTestResult *GoogleCloudDialogflowCxV3beta1ContinuousTestResult `json:"continuousTestResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContinuousTestResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContinuousTestResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1RunTestCaseMetadata struct {
}

type GoogleCloudDialogflowCxV3beta1RunTestCaseResponse struct {
	Result *GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"result,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Result") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RunTestCaseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunTestCaseResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1SessionInfo struct {
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	Session    string               `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SessionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TestCase struct {
	CreationTime              string                                            `json:"creationTime,omitempty"`
	DisplayName               string                                            `json:"displayName,omitempty"`
	LastTestResult            *GoogleCloudDialogflowCxV3beta1TestCaseResult     `json:"lastTestResult,omitempty"`
	Name                      string                                            `json:"name,omitempty"`
	Notes                     string                                            `json:"notes,omitempty"`
	Tags                      []string                                          `json:"tags,omitempty"`
	TestCaseConversationTurns []*GoogleCloudDialogflowCxV3beta1ConversationTurn `json:"testCaseConversationTurns,omitempty"`
	TestConfig                *GoogleCloudDialogflowCxV3beta1TestConfig         `json:"testConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TestCaseError struct {
	Status   *GoogleRpcStatus                        `json:"status,omitempty"`
	TestCase *GoogleCloudDialogflowCxV3beta1TestCase `json:"testCase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestCaseError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCaseError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TestCaseResult struct {
	ConversationTurns []*GoogleCloudDialogflowCxV3beta1ConversationTurn `json:"conversationTurns,omitempty"`
	Environment       string                                            `json:"environment,omitempty"`
	Name              string                                            `json:"name,omitempty"`
	// Possible values:
	//   "TEST_RESULT_UNSPECIFIED"
	//   "PASSED"
	//   "FAILED"
	TestResult string `json:"testResult,omitempty"`
	TestTime   string `json:"testTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationTurns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationTurns") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestCaseResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCaseResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TestConfig struct {
	Flow               string   `json:"flow,omitempty"`
	Page               string   `json:"page,omitempty"`
	TrackingParameters []string `json:"trackingParameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TestError struct {
	Status   *GoogleRpcStatus `json:"status,omitempty"`
	TestCase string           `json:"testCase,omitempty"`
	TestTime string           `json:"testTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TestRunDifference struct {
	Description string `json:"description,omitempty"`
	// Possible values:
	//   "DIFF_TYPE_UNSPECIFIED"
	//   "INTENT"
	//   "PAGE"
	//   "PARAMETERS"
	//   "UTTERANCE"
	//   "FLOW"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestRunDifference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestRunDifference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TextInput struct {
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TextInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TextInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ToolCall struct {
	Action          string               `json:"action,omitempty"`
	InputParameters googleapi.RawMessage `json:"inputParameters,omitempty"`
	Tool            string               `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ToolCallResult struct {
	Action           string                                             `json:"action,omitempty"`
	Error            *GoogleCloudDialogflowCxV3beta1ToolCallResultError `json:"error,omitempty"`
	OutputParameters googleapi.RawMessage                               `json:"outputParameters,omitempty"`
	Tool             string                                             `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolCallResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolCallResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ToolCallResultError struct {
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolCallResultError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolCallResultError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TransitionRoute struct {
	Condition          string                                     `json:"condition,omitempty"`
	Description        string                                     `json:"description,omitempty"`
	Intent             string                                     `json:"intent,omitempty"`
	Name               string                                     `json:"name,omitempty"`
	TargetFlow         string                                     `json:"targetFlow,omitempty"`
	TargetPage         string                                     `json:"targetPage,omitempty"`
	TriggerFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TransitionRoute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRoute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TurnSignals struct {
	AgentEscalated bool `json:"agentEscalated,omitempty"`
	DtmfUsed       bool `json:"dtmfUsed,omitempty"`
	// Possible values:
	//   "FAILURE_REASON_UNSPECIFIED"
	//   "FAILED_INTENT"
	//   "FAILED_WEBHOOK"
	FailureReasons     []string `json:"failureReasons,omitempty"`
	NoMatch            bool     `json:"noMatch,omitempty"`
	NoUserInput        bool     `json:"noUserInput,omitempty"`
	ReachedEndPage     bool     `json:"reachedEndPage,omitempty"`
	SentimentMagnitude float64  `json:"sentimentMagnitude,omitempty"`
	SentimentScore     float64  `json:"sentimentScore,omitempty"`
	UserEscalated      bool     `json:"userEscalated,omitempty"`
	WebhookStatuses    []string `json:"webhookStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentEscalated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentEscalated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TurnSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TurnSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1TurnSignals) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1TurnSignals
	var s1 struct {
		SentimentMagnitude gensupport.JSONFloat64 `json:"sentimentMagnitude"`
		SentimentScore     gensupport.JSONFloat64 `json:"sentimentScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SentimentMagnitude = float64(s1.SentimentMagnitude)
	s.SentimentScore = float64(s1.SentimentScore)
	return nil
}

type GoogleCloudDialogflowCxV3beta1Webhook struct {
	Disabled          bool                                                         `json:"disabled,omitempty"`
	DisplayName       string                                                       `json:"displayName,omitempty"`
	GenericWebService *GoogleCloudDialogflowCxV3beta1WebhookGenericWebService      `json:"genericWebService,omitempty"`
	Name              string                                                       `json:"name,omitempty"`
	ServiceDirectory  *GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig `json:"serviceDirectory,omitempty"`
	Timeout           string                                                       `json:"timeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Webhook) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Webhook
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookGenericWebService struct {
	AllowedCaCerts []string `json:"allowedCaCerts,omitempty"`
	// Possible values:
	//   "HTTP_METHOD_UNSPECIFIED"
	//   "POST"
	//   "GET"
	//   "HEAD"
	//   "PUT"
	//   "DELETE"
	//   "PATCH"
	//   "OPTIONS"
	HttpMethod                       string                                                                                    `json:"httpMethod,omitempty"`
	OauthConfig                      *GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig                        `json:"oauthConfig,omitempty"`
	ParameterMapping                 map[string]string                                                                         `json:"parameterMapping,omitempty"`
	Password                         string                                                                                    `json:"password,omitempty"`
	RequestBody                      string                                                                                    `json:"requestBody,omitempty"`
	RequestHeaders                   map[string]string                                                                         `json:"requestHeaders,omitempty"`
	SecretVersionForUsernamePassword string                                                                                    `json:"secretVersionForUsernamePassword,omitempty"`
	SecretVersionsForRequestHeaders  map[string]GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue `json:"secretVersionsForRequestHeaders,omitempty"`
	ServiceAccountAuthConfig         *GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfig           `json:"serviceAccountAuthConfig,omitempty"`
	// Possible values:
	//   "SERVICE_AGENT_AUTH_UNSPECIFIED"
	//   "NONE"
	//   "ID_TOKEN"
	//   "ACCESS_TOKEN"
	ServiceAgentAuth string `json:"serviceAgentAuth,omitempty"`
	Uri              string `json:"uri,omitempty"`
	Username         string `json:"username,omitempty"`
	// Possible values:
	//   "WEBHOOK_TYPE_UNSPECIFIED"
	//   "STANDARD"
	//   "FLEXIBLE"
	WebhookType string `json:"webhookType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedCaCerts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedCaCerts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig struct {
	ClientId                     string   `json:"clientId,omitempty"`
	ClientSecret                 string   `json:"clientSecret,omitempty"`
	Scopes                       []string `json:"scopes,omitempty"`
	SecretVersionForClientSecret string   `json:"secretVersionForClientSecret,omitempty"`
	TokenEndpoint                string   `json:"tokenEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue struct {
	SecretVersion string `json:"secretVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecretVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecretVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfig struct {
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAccount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookRequest struct {
	DetectIntentResponseId  string                                                               `json:"detectIntentResponseId,omitempty"`
	DtmfDigits              string                                                               `json:"dtmfDigits,omitempty"`
	FulfillmentInfo         *GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo         `json:"fulfillmentInfo,omitempty"`
	IntentInfo              *GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo              `json:"intentInfo,omitempty"`
	LanguageCode            string                                                               `json:"languageCode,omitempty"`
	LanguageInfo            *GoogleCloudDialogflowCxV3beta1LanguageInfo                          `json:"languageInfo,omitempty"`
	Messages                []*GoogleCloudDialogflowCxV3beta1ResponseMessage                     `json:"messages,omitempty"`
	PageInfo                *GoogleCloudDialogflowCxV3beta1PageInfo                              `json:"pageInfo,omitempty"`
	Payload                 googleapi.RawMessage                                                 `json:"payload,omitempty"`
	SentimentAnalysisResult *GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	SessionInfo             *GoogleCloudDialogflowCxV3beta1SessionInfo                           `json:"sessionInfo,omitempty"`
	Text                    string                                                               `json:"text,omitempty"`
	Transcript              string                                                               `json:"transcript,omitempty"`
	TriggerEvent            string                                                               `json:"triggerEvent,omitempty"`
	TriggerIntent           string                                                               `json:"triggerIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectIntentResponseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectIntentResponseId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo struct {
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo struct {
	Confidence        float64                                                                               `json:"confidence,omitempty"`
	DisplayName       string                                                                                `json:"displayName,omitempty"`
	LastMatchedIntent string                                                                                `json:"lastMatchedIntent,omitempty"`
	Parameters        map[string]GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue struct {
	OriginalValue string      `json:"originalValue,omitempty"`
	ResolvedValue interface{} `json:"resolvedValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OriginalValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OriginalValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult struct {
	Magnitude float64 `json:"magnitude,omitempty"`
	Score     float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

type GoogleCloudDialogflowCxV3beta1WebhookResponse struct {
	FulfillmentResponse *GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse `json:"fulfillmentResponse,omitempty"`
	PageInfo            *GoogleCloudDialogflowCxV3beta1PageInfo                           `json:"pageInfo,omitempty"`
	Payload             googleapi.RawMessage                                              `json:"payload,omitempty"`
	SessionInfo         *GoogleCloudDialogflowCxV3beta1SessionInfo                        `json:"sessionInfo,omitempty"`
	TargetFlow          string                                                            `json:"targetFlow,omitempty"`
	TargetPage          string                                                            `json:"targetPage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FulfillmentResponse") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FulfillmentResponse") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse struct {
	// Possible values:
	//   "MERGE_BEHAVIOR_UNSPECIFIED"
	//   "APPEND"
	//   "REPLACE"
	MergeBehavior string                                           `json:"mergeBehavior,omitempty"`
	Messages      []*GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"messages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MergeBehavior") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MergeBehavior") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig struct {
	GenericWebService *GoogleCloudDialogflowCxV3beta1WebhookGenericWebService `json:"genericWebService,omitempty"`
	Service           string                                                  `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericWebService") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericWebService") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Agent struct {
	// Possible values:
	//   "API_VERSION_UNSPECIFIED"
	//   "API_VERSION_V1"
	//   "API_VERSION_V2"
	//   "API_VERSION_V2_BETA_1"
	ApiVersion              string  `json:"apiVersion,omitempty"`
	AvatarUri               string  `json:"avatarUri,omitempty"`
	ClassificationThreshold float64 `json:"classificationThreshold,omitempty"`
	DefaultLanguageCode     string  `json:"defaultLanguageCode,omitempty"`
	Description             string  `json:"description,omitempty"`
	DisplayName             string  `json:"displayName,omitempty"`
	EnableLogging           bool    `json:"enableLogging,omitempty"`
	// Possible values:
	//   "MATCH_MODE_UNSPECIFIED"
	//   "MATCH_MODE_HYBRID"
	//   "MATCH_MODE_ML_ONLY"
	MatchMode              string   `json:"matchMode,omitempty"`
	Parent                 string   `json:"parent,omitempty"`
	SupportedLanguageCodes []string `json:"supportedLanguageCodes,omitempty"`
	// Possible values:
	//   "TIER_UNSPECIFIED"
	//   "TIER_STANDARD"
	//   "TIER_ENTERPRISE"
	//   "TIER_ENTERPRISE_PLUS"
	Tier     string `json:"tier,omitempty"`
	TimeZone string `json:"timeZone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Agent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Agent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2Agent) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2Agent
	var s1 struct {
		ClassificationThreshold gensupport.JSONFloat64 `json:"classificationThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ClassificationThreshold = float64(s1.ClassificationThreshold)
	return nil
}

type GoogleCloudDialogflowV2AgentAssistantFeedback struct {
	// Possible values:
	//   "ANSWER_RELEVANCE_UNSPECIFIED"
	//   "IRRELEVANT"
	//   "RELEVANT"
	AnswerRelevance string `json:"answerRelevance,omitempty"`
	// Possible values:
	//   "DOCUMENT_CORRECTNESS_UNSPECIFIED"
	//   "INCORRECT"
	//   "CORRECT"
	DocumentCorrectness string `json:"documentCorrectness,omitempty"`
	// Possible values:
	//   "DOCUMENT_EFFICIENCY_UNSPECIFIED"
	//   "INEFFICIENT"
	//   "EFFICIENT"
	DocumentEfficiency      string                                                                `json:"documentEfficiency,omitempty"`
	KnowledgeAssistFeedback *GoogleCloudDialogflowV2AgentAssistantFeedbackKnowledgeAssistFeedback `json:"knowledgeAssistFeedback,omitempty"`
	KnowledgeSearchFeedback *GoogleCloudDialogflowV2AgentAssistantFeedbackKnowledgeSearchFeedback `json:"knowledgeSearchFeedback,omitempty"`
	SummarizationFeedback   *GoogleCloudDialogflowV2AgentAssistantFeedbackSummarizationFeedback   `json:"summarizationFeedback,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRelevance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRelevance") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentAssistantFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentAssistantFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentAssistantFeedbackKnowledgeAssistFeedback struct {
	AnswerCopied bool     `json:"answerCopied,omitempty"`
	ClickedUris  []string `json:"clickedUris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerCopied") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerCopied") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentAssistantFeedbackKnowledgeAssistFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentAssistantFeedbackKnowledgeAssistFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentAssistantFeedbackKnowledgeSearchFeedback struct {
	AnswerCopied bool     `json:"answerCopied,omitempty"`
	ClickedUris  []string `json:"clickedUris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerCopied") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerCopied") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentAssistantFeedbackKnowledgeSearchFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentAssistantFeedbackKnowledgeSearchFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentAssistantFeedbackSummarizationFeedback struct {
	StartTime    string            `json:"startTime,omitempty"`
	SubmitTime   string            `json:"submitTime,omitempty"`
	SummaryText  string            `json:"summaryText,omitempty"`
	TextSections map[string]string `json:"textSections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StartTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StartTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentAssistantFeedbackSummarizationFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentAssistantFeedbackSummarizationFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentAssistantRecord struct {
	ArticleSuggestionAnswer *GoogleCloudDialogflowV2ArticleAnswer          `json:"articleSuggestionAnswer,omitempty"`
	DialogflowAssistAnswer  *GoogleCloudDialogflowV2DialogflowAssistAnswer `json:"dialogflowAssistAnswer,omitempty"`
	FaqAnswer               *GoogleCloudDialogflowV2FaqAnswer              `json:"faqAnswer,omitempty"`
	GeneratorSuggestion     *GoogleCloudDialogflowV2GeneratorSuggestion    `json:"generatorSuggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArticleSuggestionAnswer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArticleSuggestionAnswer") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentAssistantRecord) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentAssistantRecord
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingContext struct {
	Instructions        []*GoogleCloudDialogflowV2AgentCoachingInstruction `json:"instructions,omitempty"`
	OutputLanguageCode  string                                             `json:"outputLanguageCode,omitempty"`
	OverarchingGuidance string                                             `json:"overarchingGuidance,omitempty"`
	Version             string                                             `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instructions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instructions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingInstruction struct {
	AgentAction          string                                                               `json:"agentAction,omitempty"`
	Condition            string                                                               `json:"condition,omitempty"`
	DisplayDetails       string                                                               `json:"displayDetails,omitempty"`
	DisplayName          string                                                               `json:"displayName,omitempty"`
	DuplicateCheckResult *GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	SystemAction         string                                                               `json:"systemAction,omitempty"`
	// Possible values:
	//   "TRIGGER_EVENT_UNSPECIFIED"
	//   "END_OF_UTTERANCE"
	//   "MANUAL_CALL"
	//   "CUSTOMER_MESSAGE"
	//   "AGENT_MESSAGE"
	//   "TOOL_CALL_COMPLETION"
	TriggeringEvent string `json:"triggeringEvent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingInstruction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingInstruction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult struct {
	DuplicateSuggestions []*GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion `json:"duplicateSuggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateSuggestions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion struct {
	AnswerRecord    string  `json:"answerRecord,omitempty"`
	SimilarityScore float64 `json:"similarityScore,omitempty"`
	SuggestionIndex int64   `json:"suggestionIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion
	var s1 struct {
		SimilarityScore gensupport.JSONFloat64 `json:"similarityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SimilarityScore = float64(s1.SimilarityScore)
	return nil
}

type GoogleCloudDialogflowV2AgentCoachingSuggestion struct {
	AgentActionSuggestions []*GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion `json:"agentActionSuggestions,omitempty"`
	ApplicableInstructions []*GoogleCloudDialogflowV2AgentCoachingInstruction                     `json:"applicableInstructions,omitempty"`
	SampleResponses        []*GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse        `json:"sampleResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentActionSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentActionSuggestions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion struct {
	AgentAction          string                                                              `json:"agentAction,omitempty"`
	DuplicateCheckResult *GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	Sources              *GoogleCloudDialogflowV2AgentCoachingSuggestionSources              `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult struct {
	DuplicateSuggestions []*GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion `json:"duplicateSuggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateSuggestions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion struct {
	AnswerRecord    string                                                 `json:"answerRecord,omitempty"`
	SimilarityScore float64                                                `json:"similarityScore,omitempty"`
	Sources         *GoogleCloudDialogflowV2AgentCoachingSuggestionSources `json:"sources,omitempty"`
	SuggestionIndex int64                                                  `json:"suggestionIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion
	var s1 struct {
		SimilarityScore gensupport.JSONFloat64 `json:"similarityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SimilarityScore = float64(s1.SimilarityScore)
	return nil
}

type GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse struct {
	DuplicateCheckResult *GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	ResponseText         string                                                              `json:"responseText,omitempty"`
	Sources              *GoogleCloudDialogflowV2AgentCoachingSuggestionSources              `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateCheckResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateCheckResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingSuggestionSources struct {
	InstructionIndexes []int64 `json:"instructionIndexes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstructionIndexes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstructionIndexes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionSources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionSources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AnalyzeContentRequest struct {
	AssistQueryParams *GoogleCloudDialogflowV2AssistQueryParameters `json:"assistQueryParams,omitempty"`
	AudioInput        *GoogleCloudDialogflowV2AudioInput            `json:"audioInput,omitempty"`
	CxParameters      googleapi.RawMessage                          `json:"cxParameters,omitempty"`
	EventInput        *GoogleCloudDialogflowV2EventInput            `json:"eventInput,omitempty"`
	QueryParams       *GoogleCloudDialogflowV2QueryParameters       `json:"queryParams,omitempty"`
	ReplyAudioConfig  *GoogleCloudDialogflowV2OutputAudioConfig     `json:"replyAudioConfig,omitempty"`
	RequestId         string                                        `json:"requestId,omitempty"`
	SuggestionInput   *GoogleCloudDialogflowV2SuggestionInput       `json:"suggestionInput,omitempty"`
	TextInput         *GoogleCloudDialogflowV2TextInput             `json:"textInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssistQueryParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssistQueryParams") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AnalyzeContentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AnalyzeContentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AnalyzeContentResponse struct {
	AutomatedAgentReply         *GoogleCloudDialogflowV2AutomatedAgentReply `json:"automatedAgentReply,omitempty"`
	DtmfParameters              *GoogleCloudDialogflowV2DtmfParameters      `json:"dtmfParameters,omitempty"`
	EndUserSuggestionResults    []*GoogleCloudDialogflowV2SuggestionResult  `json:"endUserSuggestionResults,omitempty"`
	HumanAgentSuggestionResults []*GoogleCloudDialogflowV2SuggestionResult  `json:"humanAgentSuggestionResults,omitempty"`
	Message                     *GoogleCloudDialogflowV2Message             `json:"message,omitempty"`
	ReplyAudio                  *GoogleCloudDialogflowV2OutputAudio         `json:"replyAudio,omitempty"`
	ReplyText                   string                                      `json:"replyText,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutomatedAgentReply") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutomatedAgentReply") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AnalyzeContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AnalyzeContentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AnnotatedMessagePart struct {
	EntityType     string      `json:"entityType,omitempty"`
	FormattedValue interface{} `json:"formattedValue,omitempty"`
	Text           string      `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AnnotatedMessagePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AnnotatedMessagePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AnswerFeedback struct {
	AgentAssistantDetailFeedback *GoogleCloudDialogflowV2AgentAssistantFeedback `json:"agentAssistantDetailFeedback,omitempty"`
	ClickTime                    string                                         `json:"clickTime,omitempty"`
	Clicked                      bool                                           `json:"clicked,omitempty"`
	// Possible values:
	//   "CORRECTNESS_LEVEL_UNSPECIFIED"
	//   "NOT_CORRECT"
	//   "PARTIALLY_CORRECT"
	//   "FULLY_CORRECT"
	CorrectnessLevel string `json:"correctnessLevel,omitempty"`
	DisplayTime      string `json:"displayTime,omitempty"`
	Displayed        bool   `json:"displayed,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AgentAssistantDetailFeedback") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAssistantDetailFeedback") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AnswerFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AnswerFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AnswerRecord struct {
	AgentAssistantRecord *GoogleCloudDialogflowV2AgentAssistantRecord `json:"agentAssistantRecord,omitempty"`
	AnswerFeedback       *GoogleCloudDialogflowV2AnswerFeedback       `json:"answerFeedback,omitempty"`
	Name                 string                                       `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AgentAssistantRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAssistantRecord") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AnswerRecord) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AnswerRecord
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ArticleAnswer struct {
	AnswerRecord string            `json:"answerRecord,omitempty"`
	Confidence   float64           `json:"confidence,omitempty"`
	Metadata     map[string]string `json:"metadata,omitempty"`
	Snippets     []string          `json:"snippets,omitempty"`
	Title        string            `json:"title,omitempty"`
	Uri          string            `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ArticleAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ArticleAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2ArticleAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2ArticleAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2ArticleSuggestionModelMetadata struct {
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED"
	//   "SMART_REPLY_DUAL_ENCODER_MODEL"
	//   "SMART_REPLY_BERT_MODEL"
	TrainingModelType string `json:"trainingModelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TrainingModelType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrainingModelType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ArticleSuggestionModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ArticleSuggestionModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AssistQueryParameters struct {
	DocumentsMetadataFilters map[string]string `json:"documentsMetadataFilters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentsMetadataFilters")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentsMetadataFilters") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AssistQueryParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AssistQueryParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AudioInput struct {
	Audio  string                                   `json:"audio,omitempty"`
	Config *GoogleCloudDialogflowV2InputAudioConfig `json:"config,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AudioInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AudioInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AutomatedAgentConfig struct {
	Agent      string `json:"agent,omitempty"`
	SessionTtl string `json:"sessionTtl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AutomatedAgentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AutomatedAgentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AutomatedAgentReply struct {
	AllowCancellation bool `json:"allowCancellation,omitempty"`
	// Possible values:
	//   "AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED"
	//   "PARTIAL"
	//   "FINAL"
	AutomatedAgentReplyType string                                       `json:"automatedAgentReplyType,omitempty"`
	CxCurrentPage           string                                       `json:"cxCurrentPage,omitempty"`
	DetectIntentResponse    *GoogleCloudDialogflowV2DetectIntentResponse `json:"detectIntentResponse,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowCancellation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowCancellation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AutomatedAgentReply) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AutomatedAgentReply
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2BatchCreateEntitiesRequest struct {
	Entities     []*GoogleCloudDialogflowV2EntityTypeEntity `json:"entities,omitempty"`
	LanguageCode string                                     `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchCreateEntitiesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchCreateEntitiesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2BatchDeleteEntitiesRequest struct {
	EntityValues []string `json:"entityValues,omitempty"`
	LanguageCode string   `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityValues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchDeleteEntitiesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchDeleteEntitiesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2BatchDeleteEntityTypesRequest struct {
	EntityTypeNames []string `json:"entityTypeNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypeNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypeNames") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchDeleteEntityTypesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchDeleteEntityTypesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2BatchDeleteIntentsRequest struct {
	Intents []*GoogleCloudDialogflowV2Intent `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchDeleteIntentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchDeleteIntentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2BatchUpdateEntitiesRequest struct {
	Entities     []*GoogleCloudDialogflowV2EntityTypeEntity `json:"entities,omitempty"`
	LanguageCode string                                     `json:"languageCode,omitempty"`
	UpdateMask   string                                     `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchUpdateEntitiesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchUpdateEntitiesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2BatchUpdateEntityTypesRequest struct {
	EntityTypeBatchInline *GoogleCloudDialogflowV2EntityTypeBatch `json:"entityTypeBatchInline,omitempty"`
	EntityTypeBatchUri    string                                  `json:"entityTypeBatchUri,omitempty"`
	LanguageCode          string                                  `json:"languageCode,omitempty"`
	UpdateMask            string                                  `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypeBatchInline") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypeBatchInline") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchUpdateEntityTypesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchUpdateEntityTypesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse struct {
	EntityTypes []*GoogleCloudDialogflowV2EntityType `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2BatchUpdateIntentsRequest struct {
	IntentBatchInline *GoogleCloudDialogflowV2IntentBatch `json:"intentBatchInline,omitempty"`
	IntentBatchUri    string                              `json:"intentBatchUri,omitempty"`
	// Possible values:
	//   "INTENT_VIEW_UNSPECIFIED"
	//   "INTENT_VIEW_FULL"
	IntentView   string `json:"intentView,omitempty"`
	LanguageCode string `json:"languageCode,omitempty"`
	UpdateMask   string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentBatchInline") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentBatchInline") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchUpdateIntentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchUpdateIntentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2BatchUpdateIntentsResponse struct {
	Intents []*GoogleCloudDialogflowV2Intent `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchUpdateIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchUpdateIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata struct {
	ConversationProfile string `json:"conversationProfile,omitempty"`
	CreateTime          string `json:"createTime,omitempty"`
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	ParticipantRole string `json:"participantRole,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "ARTICLE_SUGGESTION"
	//   "FAQ"
	//   "SMART_REPLY"
	//   "CONVERSATION_SUMMARIZATION"
	//   "KNOWLEDGE_SEARCH"
	//   "KNOWLEDGE_ASSIST"
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ClearSuggestionFeatureConfigRequest struct {
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	ParticipantRole string `json:"participantRole,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "ARTICLE_SUGGESTION"
	//   "FAQ"
	//   "SMART_REPLY"
	//   "CONVERSATION_SUMMARIZATION"
	//   "KNOWLEDGE_SEARCH"
	//   "KNOWLEDGE_ASSIST"
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParticipantRole") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParticipantRole") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ClearSuggestionFeatureConfigRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ClearSuggestionFeatureConfigRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2CompleteConversationRequest struct {
}

type GoogleCloudDialogflowV2Connection struct {
	ConnectionId string                                         `json:"connectionId,omitempty"`
	ErrorDetails *GoogleCloudDialogflowV2ConnectionErrorDetails `json:"errorDetails,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "CONNECTED"
	//   "DISCONNECTED"
	//   "AUTHENTICATION_FAILED"
	//   "KEEPALIVE"
	State      string `json:"state,omitempty"`
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Connection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Connection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConnectionErrorDetails struct {
	// Possible values:
	//   "CERTIFICATE_STATE_UNSPECIFIED"
	//   "CERTIFICATE_VALID"
	//   "CERTIFICATE_INVALID"
	//   "CERTIFICATE_EXPIRED"
	//   "CERTIFICATE_HOSTNAME_NOT_FOUND"
	//   "CERTIFICATE_UNAUTHENTICATED"
	//   "CERTIFICATE_TRUST_STORE_NOT_FOUND"
	//   "CERTIFICATE_HOSTNAME_INVALID_FORMAT"
	//   "CERTIFICATE_QUOTA_EXCEEDED"
	CertificateState string `json:"certificateState,omitempty"`
	ErrorMessage     string `json:"errorMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertificateState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificateState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConnectionErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConnectionErrorDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Context struct {
	LifespanCount int64                `json:"lifespanCount,omitempty"`
	Name          string               `json:"name,omitempty"`
	Parameters    googleapi.RawMessage `json:"parameters,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "LifespanCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LifespanCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Context) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Context
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Conversation struct {
	ConversationProfile string `json:"conversationProfile,omitempty"`
	// Possible values:
	//   "CONVERSATION_STAGE_UNSPECIFIED"
	//   "VIRTUAL_AGENT_STAGE"
	//   "HUMAN_ASSIST_STAGE"
	ConversationStage         string                                                         `json:"conversationStage,omitempty"`
	EndTime                   string                                                         `json:"endTime,omitempty"`
	IngestedContextReferences map[string]GoogleCloudDialogflowV2ConversationContextReference `json:"ingestedContextReferences,omitempty"`
	// Possible values:
	//   "LIFECYCLE_STATE_UNSPECIFIED"
	//   "IN_PROGRESS"
	//   "COMPLETED"
	LifecycleState          string                                                      `json:"lifecycleState,omitempty"`
	Name                    string                                                      `json:"name,omitempty"`
	PhoneNumber             *GoogleCloudDialogflowV2ConversationPhoneNumber             `json:"phoneNumber,omitempty"`
	StartTime               string                                                      `json:"startTime,omitempty"`
	TelephonyConnectionInfo *GoogleCloudDialogflowV2ConversationTelephonyConnectionInfo `json:"telephonyConnectionInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Conversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Conversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationContext struct {
	MessageEntries []*GoogleCloudDialogflowV2MessageEntry `json:"messageEntries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MessageEntries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MessageEntries") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationContextReference struct {
	ContextContents []*GoogleCloudDialogflowV2ConversationContextReferenceContextContent `json:"contextContents,omitempty"`
	CreateTime      string                                                               `json:"createTime,omitempty"`
	LanguageCode    string                                                               `json:"languageCode,omitempty"`
	// Possible values:
	//   "UPDATE_MODE_UNSPECIFIED"
	//   "APPEND"
	//   "OVERWRITE"
	UpdateMode string `json:"updateMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextContents") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationContextReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationContextReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationContextReferenceContextContent struct {
	AnswerRecord string `json:"answerRecord,omitempty"`
	Content      string `json:"content,omitempty"`
	// Possible values:
	//   "CONTENT_FORMAT_UNSPECIFIED"
	//   "JSON"
	//   "PLAIN_TEXT"
	ContentFormat string `json:"contentFormat,omitempty"`
	IngestionTime string `json:"ingestionTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationContextReferenceContextContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationContextReferenceContextContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationDataset struct {
	ConversationCount int64                                    `json:"conversationCount,omitempty,string"`
	ConversationInfo  *GoogleCloudDialogflowV2ConversationInfo `json:"conversationInfo,omitempty"`
	CreateTime        string                                   `json:"createTime,omitempty"`
	Description       string                                   `json:"description,omitempty"`
	DisplayName       string                                   `json:"displayName,omitempty"`
	InputConfig       *GoogleCloudDialogflowV2InputConfig      `json:"inputConfig,omitempty"`
	Name              string                                   `json:"name,omitempty"`
	SatisfiesPzi      bool                                     `json:"satisfiesPzi,omitempty"`
	SatisfiesPzs      bool                                     `json:"satisfiesPzs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConversationCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationDataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationDataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationEvent struct {
	Conversation                string                                             `json:"conversation,omitempty"`
	ErrorStatus                 *GoogleRpcStatus                                   `json:"errorStatus,omitempty"`
	NewMessagePayload           *GoogleCloudDialogflowV2Message                    `json:"newMessagePayload,omitempty"`
	NewRecognitionResultPayload *GoogleCloudDialogflowV2StreamingRecognitionResult `json:"newRecognitionResultPayload,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "CONVERSATION_STARTED"
	//   "CONVERSATION_FINISHED"
	//   "HUMAN_INTERVENTION_NEEDED"
	//   "NEW_MESSAGE"
	//   "NEW_RECOGNITION_RESULT"
	//   "UNRECOVERABLE_ERROR"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationInfo struct {
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationModel struct {
	ArticleSuggestionModelMetadata *GoogleCloudDialogflowV2ArticleSuggestionModelMetadata `json:"articleSuggestionModelMetadata,omitempty"`
	CreateTime                     string                                                 `json:"createTime,omitempty"`
	Datasets                       []*GoogleCloudDialogflowV2InputDataset                 `json:"datasets,omitempty"`
	DisplayName                    string                                                 `json:"displayName,omitempty"`
	LanguageCode                   string                                                 `json:"languageCode,omitempty"`
	Name                           string                                                 `json:"name,omitempty"`
	SatisfiesPzi                   bool                                                   `json:"satisfiesPzi,omitempty"`
	SatisfiesPzs                   bool                                                   `json:"satisfiesPzs,omitempty"`
	SmartReplyModelMetadata        *GoogleCloudDialogflowV2SmartReplyModelMetadata        `json:"smartReplyModelMetadata,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "CREATING"
	//   "UNDEPLOYED"
	//   "DEPLOYING"
	//   "DEPLOYED"
	//   "UNDEPLOYING"
	//   "DELETING"
	//   "FAILED"
	//   "PENDING"
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "ArticleSuggestionModelMetadata") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArticleSuggestionModelMetadata")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationModelEvaluation struct {
	CreateTime              string                                    `json:"createTime,omitempty"`
	DisplayName             string                                    `json:"displayName,omitempty"`
	EvaluationConfig        *GoogleCloudDialogflowV2EvaluationConfig  `json:"evaluationConfig,omitempty"`
	Name                    string                                    `json:"name,omitempty"`
	RawHumanEvalTemplateCsv string                                    `json:"rawHumanEvalTemplateCsv,omitempty"`
	SmartReplyMetrics       *GoogleCloudDialogflowV2SmartReplyMetrics `json:"smartReplyMetrics,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationModelEvaluation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationModelEvaluation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationPhoneNumber struct {
	CountryCode int64  `json:"countryCode,omitempty"`
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CountryCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CountryCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationPhoneNumber) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationPhoneNumber
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationProfile struct {
	AutomatedAgentConfig                   *GoogleCloudDialogflowV2AutomatedAgentConfig      `json:"automatedAgentConfig,omitempty"`
	CreateTime                             string                                            `json:"createTime,omitempty"`
	DisplayName                            string                                            `json:"displayName,omitempty"`
	HumanAgentAssistantConfig              *GoogleCloudDialogflowV2HumanAgentAssistantConfig `json:"humanAgentAssistantConfig,omitempty"`
	HumanAgentHandoffConfig                *GoogleCloudDialogflowV2HumanAgentHandoffConfig   `json:"humanAgentHandoffConfig,omitempty"`
	LanguageCode                           string                                            `json:"languageCode,omitempty"`
	LoggingConfig                          *GoogleCloudDialogflowV2LoggingConfig             `json:"loggingConfig,omitempty"`
	Name                                   string                                            `json:"name,omitempty"`
	NewMessageEventNotificationConfig      *GoogleCloudDialogflowV2NotificationConfig        `json:"newMessageEventNotificationConfig,omitempty"`
	NewRecognitionResultNotificationConfig *GoogleCloudDialogflowV2NotificationConfig        `json:"newRecognitionResultNotificationConfig,omitempty"`
	NotificationConfig                     *GoogleCloudDialogflowV2NotificationConfig        `json:"notificationConfig,omitempty"`
	SecuritySettings                       string                                            `json:"securitySettings,omitempty"`
	SttConfig                              *GoogleCloudDialogflowV2SpeechToTextConfig        `json:"sttConfig,omitempty"`
	TimeZone                               string                                            `json:"timeZone,omitempty"`
	TtsConfig                              *GoogleCloudDialogflowV2SynthesizeSpeechConfig    `json:"ttsConfig,omitempty"`
	UpdateTime                             string                                            `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutomatedAgentConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutomatedAgentConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationProfile) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationTelephonyConnectionInfo struct {
	DialedNumber      string                                                                   `json:"dialedNumber,omitempty"`
	ExtraMimeContents []*GoogleCloudDialogflowV2ConversationTelephonyConnectionInfoMimeContent `json:"extraMimeContents,omitempty"`
	Sdp               string                                                                   `json:"sdp,omitempty"`
	SipHeaders        []*GoogleCloudDialogflowV2ConversationTelephonyConnectionInfoSipHeader   `json:"sipHeaders,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialedNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialedNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationTelephonyConnectionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationTelephonyConnectionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationTelephonyConnectionInfoMimeContent struct {
	Content  string `json:"content,omitempty"`
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationTelephonyConnectionInfoMimeContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationTelephonyConnectionInfoMimeContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationTelephonyConnectionInfoSipHeader struct {
	Name  string `json:"name,omitempty"`
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationTelephonyConnectionInfoSipHeader) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationTelephonyConnectionInfoSipHeader
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata struct {
	ConversationDataset string `json:"conversationDataset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata struct {
	ConversationModel           string `json:"conversationModel,omitempty"`
	ConversationModelEvaluation string `json:"conversationModelEvaluation,omitempty"`
	CreateTime                  string `json:"createTime,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "INITIALIZING"
	//   "RUNNING"
	//   "CANCELLED"
	//   "SUCCEEDED"
	//   "FAILED"
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2CreateConversationModelEvaluationRequest struct {
	ConversationModelEvaluation *GoogleCloudDialogflowV2ConversationModelEvaluation `json:"conversationModelEvaluation,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ConversationModelEvaluation") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModelEvaluation") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2CreateConversationModelEvaluationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2CreateConversationModelEvaluationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2CreateConversationModelOperationMetadata struct {
	ConversationModel string `json:"conversationModel,omitempty"`
	CreateTime        string `json:"createTime,omitempty"`
	DoneTime          string `json:"doneTime,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "PENDING"
	//   "SUCCEEDED"
	//   "FAILED"
	//   "CANCELLED"
	//   "CANCELLING"
	//   "TRAINING"
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2CreateConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2CreateConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2CustomPronunciationParams struct {
	// Possible values:
	//   "PHONETIC_ENCODING_UNSPECIFIED"
	//   "PHONETIC_ENCODING_IPA"
	//   "PHONETIC_ENCODING_X_SAMPA"
	PhoneticEncoding string `json:"phoneticEncoding,omitempty"`
	Phrase           string `json:"phrase,omitempty"`
	Pronunciation    string `json:"pronunciation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneticEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneticEncoding") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2CustomPronunciationParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2CustomPronunciationParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2DeleteConversationDatasetOperationMetadata struct {
}

type GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata struct {
	ConversationModel string `json:"conversationModel,omitempty"`
	CreateTime        string `json:"createTime,omitempty"`
	DoneTime          string `json:"doneTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2DeployConversationModelOperationMetadata struct {
	ConversationModel string `json:"conversationModel,omitempty"`
	CreateTime        string `json:"createTime,omitempty"`
	DoneTime          string `json:"doneTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2DeployConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2DeployConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2DeployConversationModelRequest struct {
}

type GoogleCloudDialogflowV2DetectIntentRequest struct {
	InputAudio            string                                    `json:"inputAudio,omitempty"`
	OutputAudioConfig     *GoogleCloudDialogflowV2OutputAudioConfig `json:"outputAudioConfig,omitempty"`
	OutputAudioConfigMask string                                    `json:"outputAudioConfigMask,omitempty"`
	QueryInput            *GoogleCloudDialogflowV2QueryInput        `json:"queryInput,omitempty"`
	QueryParams           *GoogleCloudDialogflowV2QueryParameters   `json:"queryParams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputAudio") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputAudio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2DetectIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2DetectIntentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2DetectIntentResponse struct {
	OutputAudio       string                                    `json:"outputAudio,omitempty"`
	OutputAudioConfig *GoogleCloudDialogflowV2OutputAudioConfig `json:"outputAudioConfig,omitempty"`
	QueryResult       *GoogleCloudDialogflowV2QueryResult       `json:"queryResult,omitempty"`
	ResponseId        string                                    `json:"responseId,omitempty"`
	WebhookStatus     *GoogleRpcStatus                          `json:"webhookStatus,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "OutputAudio") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputAudio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2DetectIntentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2DetectIntentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2DialogflowAssistAnswer struct {
	AnswerRecord     string                                   `json:"answerRecord,omitempty"`
	IntentSuggestion *GoogleCloudDialogflowV2IntentSuggestion `json:"intentSuggestion,omitempty"`
	QueryResult      *GoogleCloudDialogflowV2QueryResult      `json:"queryResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2DialogflowAssistAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2DialogflowAssistAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Document struct {
	ContentUri       string `json:"contentUri,omitempty"`
	DisplayName      string `json:"displayName,omitempty"`
	EnableAutoReload bool   `json:"enableAutoReload,omitempty"`
	// Possible values:
	//   "KNOWLEDGE_TYPE_UNSPECIFIED"
	//   "FAQ"
	//   "EXTRACTIVE_QA"
	//   "ARTICLE_SUGGESTION"
	//   "AGENT_FACING_SMART_REPLY"
	KnowledgeTypes     []string                                     `json:"knowledgeTypes,omitempty"`
	LatestReloadStatus *GoogleCloudDialogflowV2DocumentReloadStatus `json:"latestReloadStatus,omitempty"`
	Metadata           map[string]string                            `json:"metadata,omitempty"`
	MimeType           string                                       `json:"mimeType,omitempty"`
	Name               string                                       `json:"name,omitempty"`
	RawContent         string                                       `json:"rawContent,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "CREATING"
	//   "ACTIVE"
	//   "UPDATING"
	//   "RELOADING"
	//   "DELETING"
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContentUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Document) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Document
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2DocumentReloadStatus struct {
	Status *GoogleRpcStatus `json:"status,omitempty"`
	Time   string           `json:"time,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2DocumentReloadStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2DocumentReloadStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2DtmfParameters struct {
	AcceptsDtmfInput bool `json:"acceptsDtmfInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptsDtmfInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptsDtmfInput") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2DtmfParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2DtmfParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EncryptionSpec struct {
	KmsKey string `json:"kmsKey,omitempty"`
	Name   string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EntityType struct {
	// Possible values:
	//   "AUTO_EXPANSION_MODE_UNSPECIFIED"
	//   "AUTO_EXPANSION_MODE_DEFAULT"
	AutoExpansionMode     string                                     `json:"autoExpansionMode,omitempty"`
	DisplayName           string                                     `json:"displayName,omitempty"`
	EnableFuzzyExtraction bool                                       `json:"enableFuzzyExtraction,omitempty"`
	Entities              []*GoogleCloudDialogflowV2EntityTypeEntity `json:"entities,omitempty"`
	// Possible values:
	//   "KIND_UNSPECIFIED"
	//   "KIND_MAP"
	//   "KIND_LIST"
	//   "KIND_REGEXP"
	Kind string `json:"kind,omitempty"`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutoExpansionMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoExpansionMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EntityTypeBatch struct {
	EntityTypes []*GoogleCloudDialogflowV2EntityType `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EntityTypeBatch) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EntityTypeBatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EntityTypeEntity struct {
	Synonyms []string `json:"synonyms,omitempty"`
	Value    string   `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EntityTypeEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EntityTypeEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Environment struct {
	AgentVersion string                              `json:"agentVersion,omitempty"`
	Description  string                              `json:"description,omitempty"`
	Fulfillment  *GoogleCloudDialogflowV2Fulfillment `json:"fulfillment,omitempty"`
	Name         string                              `json:"name,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "STOPPED"
	//   "LOADING"
	//   "RUNNING"
	State                string                                       `json:"state,omitempty"`
	TextToSpeechSettings *GoogleCloudDialogflowV2TextToSpeechSettings `json:"textToSpeechSettings,omitempty"`
	UpdateTime           string                                       `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AgentVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Environment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Environment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EnvironmentHistory struct {
	Entries       []*GoogleCloudDialogflowV2EnvironmentHistoryEntry `json:"entries,omitempty"`
	NextPageToken string                                            `json:"nextPageToken,omitempty"`
	Parent        string                                            `json:"parent,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EnvironmentHistory) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EnvironmentHistory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EnvironmentHistoryEntry struct {
	AgentVersion string `json:"agentVersion,omitempty"`
	CreateTime   string `json:"createTime,omitempty"`
	Description  string `json:"description,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EnvironmentHistoryEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EnvironmentHistoryEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EvaluationConfig struct {
	Datasets           []*GoogleCloudDialogflowV2InputDataset                     `json:"datasets,omitempty"`
	SmartComposeConfig *GoogleCloudDialogflowV2EvaluationConfigSmartComposeConfig `json:"smartComposeConfig,omitempty"`
	SmartReplyConfig   *GoogleCloudDialogflowV2EvaluationConfigSmartReplyConfig   `json:"smartReplyConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Datasets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Datasets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EvaluationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EvaluationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EvaluationConfigSmartComposeConfig struct {
	AllowlistDocument string `json:"allowlistDocument,omitempty"`
	MaxResultCount    int64  `json:"maxResultCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowlistDocument") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowlistDocument") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EvaluationConfigSmartComposeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EvaluationConfigSmartComposeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EvaluationConfigSmartReplyConfig struct {
	AllowlistDocument string `json:"allowlistDocument,omitempty"`
	MaxResultCount    int64  `json:"maxResultCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowlistDocument") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowlistDocument") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EvaluationConfigSmartReplyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EvaluationConfigSmartReplyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EvaluationStatus struct {
	Done           bool             `json:"done,omitempty"`
	PipelineStatus *GoogleRpcStatus `json:"pipelineStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EvaluationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EvaluationStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EventInput struct {
	LanguageCode string               `json:"languageCode,omitempty"`
	Name         string               `json:"name,omitempty"`
	Parameters   googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ExportAgentRequest struct {
	AgentUri string `json:"agentUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ExportAgentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ExportAgentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ExportAgentResponse struct {
	AgentContent string `json:"agentContent,omitempty"`
	AgentUri     string `json:"agentUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ExportDocumentRequest struct {
	ExportFullContent           bool                                   `json:"exportFullContent,omitempty"`
	GcsDestination              *GoogleCloudDialogflowV2GcsDestination `json:"gcsDestination,omitempty"`
	SmartMessagingPartialUpdate bool                                   `json:"smartMessagingPartialUpdate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportFullContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportFullContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ExportDocumentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ExportDocumentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ExportOperationMetadata struct {
	ExportedGcsDestination *GoogleCloudDialogflowV2GcsDestination `json:"exportedGcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportedGcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportedGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ExportOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ExportOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2FaqAnswer struct {
	Answer       string            `json:"answer,omitempty"`
	AnswerRecord string            `json:"answerRecord,omitempty"`
	Confidence   float64           `json:"confidence,omitempty"`
	Metadata     map[string]string `json:"metadata,omitempty"`
	Question     string            `json:"question,omitempty"`
	Source       string            `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2FaqAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2FaqAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2FaqAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2FaqAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2FewShotExample struct {
	ConversationContext      *GoogleCloudDialogflowV2ConversationContext      `json:"conversationContext,omitempty"`
	ExtraInfo                map[string]string                                `json:"extraInfo,omitempty"`
	Output                   *GoogleCloudDialogflowV2GeneratorSuggestion      `json:"output,omitempty"`
	SummarizationSectionList *GoogleCloudDialogflowV2SummarizationSectionList `json:"summarizationSectionList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationContext") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2FewShotExample) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2FewShotExample
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2FreeFormContext struct {
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2FreeFormContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2FreeFormContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2FreeFormSuggestion struct {
	Response string `json:"response,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Response") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Response") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2FreeFormSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2FreeFormSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Fulfillment struct {
	DisplayName       string                                               `json:"displayName,omitempty"`
	Enabled           bool                                                 `json:"enabled,omitempty"`
	Features          []*GoogleCloudDialogflowV2FulfillmentFeature         `json:"features,omitempty"`
	GenericWebService *GoogleCloudDialogflowV2FulfillmentGenericWebService `json:"genericWebService,omitempty"`
	Name              string                                               `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Fulfillment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Fulfillment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2FulfillmentFeature struct {
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "SMALLTALK"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2FulfillmentFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2FulfillmentFeature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2FulfillmentGenericWebService struct {
	IsCloudFunction bool              `json:"isCloudFunction,omitempty"`
	Password        string            `json:"password,omitempty"`
	RequestHeaders  map[string]string `json:"requestHeaders,omitempty"`
	Uri             string            `json:"uri,omitempty"`
	Username        string            `json:"username,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsCloudFunction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsCloudFunction") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2FulfillmentGenericWebService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2FulfillmentGenericWebService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GcsDestination struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GcsSources struct {
	Uris []string `json:"uris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uris") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uris") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GcsSources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GcsSources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GenerateStatelessSuggestionRequest struct {
	ContextReferences   map[string]GoogleCloudDialogflowV2ConversationContextReference `json:"contextReferences,omitempty"`
	ConversationContext *GoogleCloudDialogflowV2ConversationContext                    `json:"conversationContext,omitempty"`
	Generator           *GoogleCloudDialogflowV2Generator                              `json:"generator,omitempty"`
	GeneratorName       string                                                         `json:"generatorName,omitempty"`
	SecuritySettings    string                                                         `json:"securitySettings,omitempty"`
	// Possible values:
	//   "TRIGGER_EVENT_UNSPECIFIED"
	//   "END_OF_UTTERANCE"
	//   "MANUAL_CALL"
	//   "CUSTOMER_MESSAGE"
	//   "AGENT_MESSAGE"
	TriggerEvents []string `json:"triggerEvents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextReferences") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextReferences") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateStatelessSuggestionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateStatelessSuggestionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GenerateStatelessSuggestionResponse struct {
	GeneratorSuggestion *GoogleCloudDialogflowV2GeneratorSuggestion `json:"generatorSuggestion,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GeneratorSuggestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorSuggestion") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateStatelessSuggestionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateStatelessSuggestionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GenerateStatelessSummaryRequest struct {
	ConversationProfile   *GoogleCloudDialogflowV2ConversationProfile                                `json:"conversationProfile,omitempty"`
	LatestMessage         string                                                                     `json:"latestMessage,omitempty"`
	MaxContextSize        int64                                                                      `json:"maxContextSize,omitempty"`
	StatelessConversation *GoogleCloudDialogflowV2GenerateStatelessSummaryRequestMinimalConversation `json:"statelessConversation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateStatelessSummaryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateStatelessSummaryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GenerateStatelessSummaryRequestMinimalConversation struct {
	Messages []*GoogleCloudDialogflowV2Message `json:"messages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Messages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Messages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateStatelessSummaryRequestMinimalConversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateStatelessSummaryRequestMinimalConversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GenerateStatelessSummaryResponse struct {
	ContextSize   int64                                                           `json:"contextSize,omitempty"`
	LatestMessage string                                                          `json:"latestMessage,omitempty"`
	Summary       *GoogleCloudDialogflowV2GenerateStatelessSummaryResponseSummary `json:"summary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateStatelessSummaryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateStatelessSummaryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GenerateStatelessSummaryResponseSummary struct {
	BaselineModelVersion string            `json:"baselineModelVersion,omitempty"`
	Text                 string            `json:"text,omitempty"`
	TextSections         map[string]string `json:"textSections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaselineModelVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaselineModelVersion") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateStatelessSummaryResponseSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateStatelessSummaryResponseSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GenerateSuggestionsRequest struct {
	LatestMessage string `json:"latestMessage,omitempty"`
	// Possible values:
	//   "TRIGGER_EVENT_UNSPECIFIED"
	//   "END_OF_UTTERANCE"
	//   "MANUAL_CALL"
	//   "CUSTOMER_MESSAGE"
	//   "AGENT_MESSAGE"
	TriggerEvents []string `json:"triggerEvents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LatestMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LatestMessage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateSuggestionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateSuggestionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GenerateSuggestionsResponse struct {
	GeneratorSuggestionAnswers []*GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer `json:"generatorSuggestionAnswers,omitempty"`
	LatestMessage              string                                                                         `json:"latestMessage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GeneratorSuggestionAnswers")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorSuggestionAnswers") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer struct {
	AnswerRecord        string                                      `json:"answerRecord,omitempty"`
	GeneratorSuggestion *GoogleCloudDialogflowV2GeneratorSuggestion `json:"generatorSuggestion,omitempty"`
	SourceGenerator     string                                      `json:"sourceGenerator,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Generator struct {
	AgentCoachingContext     *GoogleCloudDialogflowV2AgentCoachingContext     `json:"agentCoachingContext,omitempty"`
	CreateTime               string                                           `json:"createTime,omitempty"`
	Description              string                                           `json:"description,omitempty"`
	FreeFormContext          *GoogleCloudDialogflowV2FreeFormContext          `json:"freeFormContext,omitempty"`
	InferenceParameter       *GoogleCloudDialogflowV2InferenceParameter       `json:"inferenceParameter,omitempty"`
	Name                     string                                           `json:"name,omitempty"`
	PublishedModel           string                                           `json:"publishedModel,omitempty"`
	SuggestionDedupingConfig *GoogleCloudDialogflowV2SuggestionDedupingConfig `json:"suggestionDedupingConfig,omitempty"`
	SummarizationContext     *GoogleCloudDialogflowV2SummarizationContext     `json:"summarizationContext,omitempty"`
	Tools                    []string                                         `json:"tools,omitempty"`
	// Possible values:
	//   "TRIGGER_EVENT_UNSPECIFIED"
	//   "END_OF_UTTERANCE"
	//   "MANUAL_CALL"
	//   "CUSTOMER_MESSAGE"
	//   "AGENT_MESSAGE"
	TriggerEvent string `json:"triggerEvent,omitempty"`
	UpdateTime   string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AgentCoachingContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCoachingContext") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Generator) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Generator
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GeneratorEvaluation struct {
	CompleteTime              string                                                 `json:"completeTime,omitempty"`
	CreateTime                string                                                 `json:"createTime,omitempty"`
	DisplayName               string                                                 `json:"displayName,omitempty"`
	EvaluationStatus          *GoogleCloudDialogflowV2EvaluationStatus               `json:"evaluationStatus,omitempty"`
	GeneratorEvaluationConfig *GoogleCloudDialogflowV2GeneratorEvaluationConfig      `json:"generatorEvaluationConfig,omitempty"`
	InitialGenerator          *GoogleCloudDialogflowV2Generator                      `json:"initialGenerator,omitempty"`
	Name                      string                                                 `json:"name,omitempty"`
	SatisfiesPzi              bool                                                   `json:"satisfiesPzi,omitempty"`
	SatisfiesPzs              bool                                                   `json:"satisfiesPzs,omitempty"`
	SummarizationMetrics      *GoogleCloudDialogflowV2SummarizationEvaluationMetrics `json:"summarizationMetrics,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CompleteTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompleteTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GeneratorEvaluation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GeneratorEvaluation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GeneratorEvaluationConfig struct {
	InputDataConfig     *GoogleCloudDialogflowV2GeneratorEvaluationConfigInputDataConfig     `json:"inputDataConfig,omitempty"`
	OutputGcsBucketPath string                                                               `json:"outputGcsBucketPath,omitempty"`
	SummarizationConfig *GoogleCloudDialogflowV2GeneratorEvaluationConfigSummarizationConfig `json:"summarizationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputDataConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputDataConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GeneratorEvaluationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GeneratorEvaluationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GeneratorEvaluationConfigAgentAssistInputDataConfig struct {
	EndTime   string `json:"endTime,omitempty"`
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GeneratorEvaluationConfigAgentAssistInputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GeneratorEvaluationConfigAgentAssistInputDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GeneratorEvaluationConfigDatasetInputDataConfig struct {
	Dataset string `json:"dataset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GeneratorEvaluationConfigDatasetInputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GeneratorEvaluationConfigDatasetInputDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GeneratorEvaluationConfigInputDataConfig struct {
	AgentAssistInputDataConfig *GoogleCloudDialogflowV2GeneratorEvaluationConfigAgentAssistInputDataConfig `json:"agentAssistInputDataConfig,omitempty"`
	DatasetInputDataConfig     *GoogleCloudDialogflowV2GeneratorEvaluationConfigDatasetInputDataConfig     `json:"datasetInputDataConfig,omitempty"`
	EndTime                    string                                                                      `json:"endTime,omitempty"`
	// Possible values:
	//   "INPUT_DATA_SOURCE_TYPE_UNSPECIFIED"
	//   "AGENT_ASSIST_CONVERSATIONS"
	//   "INSIGHTS_CONVERSATIONS"
	InputDataSourceType        string `json:"inputDataSourceType,omitempty"`
	IsSummaryGenerationAllowed bool   `json:"isSummaryGenerationAllowed,omitempty"`
	SampleSize                 int64  `json:"sampleSize,omitempty"`
	StartTime                  string `json:"startTime,omitempty"`
	// Possible values:
	//   "SUMMARY_GENERATION_OPTION_UNSPECIFIED"
	//   "ALWAYS_GENERATE"
	//   "GENERATE_IF_MISSING"
	//   "DO_NOT_GENERATE"
	SummaryGenerationOption string `json:"summaryGenerationOption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentAssistInputDataConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAssistInputDataConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GeneratorEvaluationConfigInputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GeneratorEvaluationConfigInputDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GeneratorEvaluationConfigSummarizationConfig struct {
	AccuracyEvaluationVersion     string `json:"accuracyEvaluationVersion,omitempty"`
	CompletenessEvaluationVersion string `json:"completenessEvaluationVersion,omitempty"`
	EnableAccuracyEvaluation      bool   `json:"enableAccuracyEvaluation,omitempty"`
	EnableCompletenessEvaluation  bool   `json:"enableCompletenessEvaluation,omitempty"`
	EvaluatorVersion              string `json:"evaluatorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccuracyEvaluationVersion")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccuracyEvaluationVersion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GeneratorEvaluationConfigSummarizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GeneratorEvaluationConfigSummarizationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GeneratorSuggestion struct {
	AgentCoachingSuggestion *GoogleCloudDialogflowV2AgentCoachingSuggestion           `json:"agentCoachingSuggestion,omitempty"`
	FreeFormSuggestion      *GoogleCloudDialogflowV2FreeFormSuggestion                `json:"freeFormSuggestion,omitempty"`
	SummarySuggestion       *GoogleCloudDialogflowV2SummarySuggestion                 `json:"summarySuggestion,omitempty"`
	ToolCallInfo            []*GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo `json:"toolCallInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentCoachingSuggestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCoachingSuggestion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GeneratorSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GeneratorSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo struct {
	ToolCall       *GoogleCloudDialogflowV2ToolCall       `json:"toolCall,omitempty"`
	ToolCallResult *GoogleCloudDialogflowV2ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolCall") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolCall") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantConfig struct {
	EndUserSuggestionConfig    *GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfig      `json:"endUserSuggestionConfig,omitempty"`
	HumanAgentSuggestionConfig *GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfig      `json:"humanAgentSuggestionConfig,omitempty"`
	MessageAnalysisConfig      *GoogleCloudDialogflowV2HumanAgentAssistantConfigMessageAnalysisConfig `json:"messageAnalysisConfig,omitempty"`
	NotificationConfig         *GoogleCloudDialogflowV2NotificationConfig                             `json:"notificationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndUserSuggestionConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndUserSuggestionConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantConfigConversationModelConfig struct {
	BaselineModelVersion string `json:"baselineModelVersion,omitempty"`
	Model                string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaselineModelVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaselineModelVersion") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantConfigConversationModelConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfigConversationModelConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantConfigConversationProcessConfig struct {
	RecentSentencesCount int64 `json:"recentSentencesCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RecentSentencesCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RecentSentencesCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantConfigConversationProcessConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfigConversationProcessConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantConfigMessageAnalysisConfig struct {
	EnableEntityExtraction    bool `json:"enableEntityExtraction,omitempty"`
	EnableSentimentAnalysis   bool `json:"enableSentimentAnalysis,omitempty"`
	EnableSentimentAnalysisV3 bool `json:"enableSentimentAnalysisV3,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableEntityExtraction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableEntityExtraction") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantConfigMessageAnalysisConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfigMessageAnalysisConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfig struct {
	DisableHighLatencyFeaturesSyncDelivery bool                                                                       `json:"disableHighLatencyFeaturesSyncDelivery,omitempty"`
	EnableAsyncToolCall                    bool                                                                       `json:"enableAsyncToolCall,omitempty"`
	FeatureConfigs                         []*GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionFeatureConfig `json:"featureConfigs,omitempty"`
	Generators                             []string                                                                   `json:"generators,omitempty"`
	GroupSuggestionResponses               bool                                                                       `json:"groupSuggestionResponses,omitempty"`
	SkipEmptyEventBasedSuggestion          bool                                                                       `json:"skipEmptyEventBasedSuggestion,omitempty"`
	UseUnredactedConversationData          bool                                                                       `json:"useUnredactedConversationData,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "DisableHighLatencyFeaturesSyncDelivery") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "DisableHighLatencyFeaturesSyncDelivery") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted from
	// API requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields
	// for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionFeatureConfig struct {
	ConversationModelConfig           *GoogleCloudDialogflowV2HumanAgentAssistantConfigConversationModelConfig   `json:"conversationModelConfig,omitempty"`
	ConversationProcessConfig         *GoogleCloudDialogflowV2HumanAgentAssistantConfigConversationProcessConfig `json:"conversationProcessConfig,omitempty"`
	DisableAgentQueryLogging          bool                                                                       `json:"disableAgentQueryLogging,omitempty"`
	EnableConversationAugmentedQuery  bool                                                                       `json:"enableConversationAugmentedQuery,omitempty"`
	EnableEventBasedSuggestion        bool                                                                       `json:"enableEventBasedSuggestion,omitempty"`
	EnableQuerySuggestionOnly         bool                                                                       `json:"enableQuerySuggestionOnly,omitempty"`
	EnableQuerySuggestionWhenNoAnswer bool                                                                       `json:"enableQuerySuggestionWhenNoAnswer,omitempty"`
	EnableResponseDebugInfo           bool                                                                       `json:"enableResponseDebugInfo,omitempty"`
	QueryConfig                       *GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfig     `json:"queryConfig,omitempty"`
	RaiSettings                       *GoogleCloudDialogflowV2RaiSettings                                        `json:"raiSettings,omitempty"`
	SuggestionFeature                 *GoogleCloudDialogflowV2SuggestionFeature                                  `json:"suggestionFeature,omitempty"`
	SuggestionTriggerSettings         *GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionTriggerSettings `json:"suggestionTriggerSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModelConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModelConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionFeatureConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionFeatureConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfig struct {
	ConfidenceThreshold      float64                                                                                        `json:"confidenceThreshold,omitempty"`
	ContextFilterSettings    *GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettings    `json:"contextFilterSettings,omitempty"`
	ContextSize              int64                                                                                          `json:"contextSize,omitempty"`
	DialogflowQuerySource    *GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySource    `json:"dialogflowQuerySource,omitempty"`
	DocumentQuerySource      *GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySource      `json:"documentQuerySource,omitempty"`
	KnowledgeBaseQuerySource *GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySource `json:"knowledgeBaseQuerySource,omitempty"`
	MaxResults               int64                                                                                          `json:"maxResults,omitempty"`
	Sections                 *GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigSections                 `json:"sections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceThreshold") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfig
	var s1 struct {
		ConfidenceThreshold gensupport.JSONFloat64 `json:"confidenceThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceThreshold = float64(s1.ConfidenceThreshold)
	return nil
}

type GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettings struct {
	DropHandoffMessages      bool `json:"dropHandoffMessages,omitempty"`
	DropIvrMessages          bool `json:"dropIvrMessages,omitempty"`
	DropVirtualAgentMessages bool `json:"dropVirtualAgentMessages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DropHandoffMessages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DropHandoffMessages") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySource struct {
	Agent                string                                                                                                          `json:"agent,omitempty"`
	HumanAgentSideConfig *GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceHumanAgentSideConfig `json:"humanAgentSideConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceHumanAgentSideConfig struct {
	Agent string `json:"agent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceHumanAgentSideConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceHumanAgentSideConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySource struct {
	Documents []string `json:"documents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySource struct {
	KnowledgeBases []string `json:"knowledgeBases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KnowledgeBases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KnowledgeBases") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigSections struct {
	// Possible values:
	//   "SECTION_TYPE_UNSPECIFIED"
	//   "SITUATION"
	//   "ACTION"
	//   "RESOLUTION"
	//   "REASON_FOR_CANCELLATION"
	//   "CUSTOMER_SATISFACTION"
	//   "ENTITIES"
	SectionTypes []string `json:"sectionTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SectionTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SectionTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigSections) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigSections
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionTriggerSettings struct {
	NoSmalltalk bool `json:"noSmalltalk,omitempty"`
	OnlyEndUser bool `json:"onlyEndUser,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NoSmalltalk") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoSmalltalk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionTriggerSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionTriggerSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantEvent struct {
	Conversation      string                                     `json:"conversation,omitempty"`
	Participant       string                                     `json:"participant,omitempty"`
	SuggestionResults []*GoogleCloudDialogflowV2SuggestionResult `json:"suggestionResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentHandoffConfig struct {
	LivePersonConfig          *GoogleCloudDialogflowV2HumanAgentHandoffConfigLivePersonConfig          `json:"livePersonConfig,omitempty"`
	SalesforceLiveAgentConfig *GoogleCloudDialogflowV2HumanAgentHandoffConfigSalesforceLiveAgentConfig `json:"salesforceLiveAgentConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LivePersonConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LivePersonConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentHandoffConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentHandoffConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentHandoffConfigLivePersonConfig struct {
	AccountNumber string `json:"accountNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentHandoffConfigLivePersonConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentHandoffConfigLivePersonConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentHandoffConfigSalesforceLiveAgentConfig struct {
	ButtonId       string `json:"buttonId,omitempty"`
	DeploymentId   string `json:"deploymentId,omitempty"`
	EndpointDomain string `json:"endpointDomain,omitempty"`
	OrganizationId string `json:"organizationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ButtonId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ButtonId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentHandoffConfigSalesforceLiveAgentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentHandoffConfigSalesforceLiveAgentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ImportAgentRequest struct {
	AgentContent string `json:"agentContent,omitempty"`
	AgentUri     string `json:"agentUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportAgentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportAgentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ImportConversationDataOperationMetadata struct {
	ConversationDataset string             `json:"conversationDataset,omitempty"`
	CreateTime          string             `json:"createTime,omitempty"`
	PartialFailures     []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportConversationDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportConversationDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ImportConversationDataOperationResponse struct {
	ConversationDataset string `json:"conversationDataset,omitempty"`
	ImportCount         int64  `json:"importCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportConversationDataOperationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportConversationDataOperationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ImportConversationDataRequest struct {
	InputConfig *GoogleCloudDialogflowV2InputConfig `json:"inputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportConversationDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportConversationDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ImportDocumentTemplate struct {
	// Possible values:
	//   "KNOWLEDGE_TYPE_UNSPECIFIED"
	//   "FAQ"
	//   "EXTRACTIVE_QA"
	//   "ARTICLE_SUGGESTION"
	//   "AGENT_FACING_SMART_REPLY"
	KnowledgeTypes []string          `json:"knowledgeTypes,omitempty"`
	Metadata       map[string]string `json:"metadata,omitempty"`
	MimeType       string            `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KnowledgeTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KnowledgeTypes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportDocumentTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportDocumentTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ImportDocumentsRequest struct {
	DocumentTemplate        *GoogleCloudDialogflowV2ImportDocumentTemplate `json:"documentTemplate,omitempty"`
	GcsSource               *GoogleCloudDialogflowV2GcsSources             `json:"gcsSource,omitempty"`
	ImportGcsCustomMetadata bool                                           `json:"importGcsCustomMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentTemplate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportDocumentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ImportDocumentsResponse struct {
	Warnings []*GoogleRpcStatus `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Warnings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Warnings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2InferenceParameter struct {
	MaxOutputTokens int64   `json:"maxOutputTokens,omitempty"`
	Temperature     float64 `json:"temperature,omitempty"`
	TopK            int64   `json:"topK,omitempty"`
	TopP            float64 `json:"topP,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxOutputTokens") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxOutputTokens") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InferenceParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InferenceParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2InferenceParameter) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2InferenceParameter
	var s1 struct {
		Temperature gensupport.JSONFloat64 `json:"temperature"`
		TopP        gensupport.JSONFloat64 `json:"topP"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Temperature = float64(s1.Temperature)
	s.TopP = float64(s1.TopP)
	return nil
}

type GoogleCloudDialogflowV2IngestContextReferencesRequest struct {
	ContextReferences map[string]GoogleCloudDialogflowV2ConversationContextReference `json:"contextReferences,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextReferences") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextReferences") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IngestContextReferencesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IngestContextReferencesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IngestContextReferencesResponse struct {
	IngestedContextReferences map[string]GoogleCloudDialogflowV2ConversationContextReference `json:"ingestedContextReferences,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IngestedContextReferences")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IngestedContextReferences") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IngestContextReferencesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IngestContextReferencesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IngestedContextReferenceDebugInfo struct {
	ContextReferenceRetrieved   bool                                                                                  `json:"contextReferenceRetrieved,omitempty"`
	IngestedParametersDebugInfo []*GoogleCloudDialogflowV2IngestedContextReferenceDebugInfoIngestedParameterDebugInfo `json:"ingestedParametersDebugInfo,omitempty"`
	ProjectNotAllowlisted       bool                                                                                  `json:"projectNotAllowlisted,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextReferenceRetrieved")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextReferenceRetrieved") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IngestedContextReferenceDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IngestedContextReferenceDebugInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IngestedContextReferenceDebugInfoIngestedParameterDebugInfo struct {
	// Possible values:
	//   "INGESTION_STATUS_UNSPECIFIED"
	//   "INGESTION_STATUS_SUCCEEDED"
	//   "INGESTION_STATUS_CONTEXT_NOT_AVAILABLE"
	//   "INGESTION_STATUS_PARSE_FAILED"
	//   "INGESTION_STATUS_INVALID_ENTRY"
	//   "INGESTION_STATUS_INVALID_FORMAT"
	//   "INGESTION_STATUS_LANGUAGE_MISMATCH"
	IngestionStatus string `json:"ingestionStatus,omitempty"`
	Parameter       string `json:"parameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IngestionStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IngestionStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IngestedContextReferenceDebugInfoIngestedParameterDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IngestedContextReferenceDebugInfoIngestedParameterDebugInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata struct {
	Request *GoogleCloudDialogflowV2InitializeEncryptionSpecRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Request") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Request") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2InitializeEncryptionSpecRequest struct {
	EncryptionSpec *GoogleCloudDialogflowV2EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InitializeEncryptionSpecRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InitializeEncryptionSpecRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2InputAudioConfig struct {
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED"
	//   "AUDIO_ENCODING_LINEAR_16"
	//   "AUDIO_ENCODING_FLAC"
	//   "AUDIO_ENCODING_MULAW"
	//   "AUDIO_ENCODING_AMR"
	//   "AUDIO_ENCODING_AMR_WB"
	//   "AUDIO_ENCODING_OGG_OPUS"
	//   "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE"
	//   "AUDIO_ENCODING_ALAW"
	AudioEncoding                  string `json:"audioEncoding,omitempty"`
	DisableNoSpeechRecognizedEvent bool   `json:"disableNoSpeechRecognizedEvent,omitempty"`
	EnableAutomaticPunctuation     bool   `json:"enableAutomaticPunctuation,omitempty"`
	EnableWordInfo                 bool   `json:"enableWordInfo,omitempty"`
	LanguageCode                   string `json:"languageCode,omitempty"`
	Model                          string `json:"model,omitempty"`
	// Possible values:
	//   "SPEECH_MODEL_VARIANT_UNSPECIFIED"
	//   "USE_BEST_AVAILABLE"
	//   "USE_STANDARD"
	//   "USE_ENHANCED"
	ModelVariant                  string                                  `json:"modelVariant,omitempty"`
	OptOutConformerModelMigration bool                                    `json:"optOutConformerModelMigration,omitempty"`
	PhraseHints                   []string                                `json:"phraseHints,omitempty"`
	PhraseSets                    []string                                `json:"phraseSets,omitempty"`
	SampleRateHertz               int64                                   `json:"sampleRateHertz,omitempty"`
	SingleUtterance               bool                                    `json:"singleUtterance,omitempty"`
	SpeechContexts                []*GoogleCloudDialogflowV2SpeechContext `json:"speechContexts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2InputConfig struct {
	GcsSource *GoogleCloudDialogflowV2GcsSources `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2InputDataset struct {
	Dataset string `json:"dataset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InputDataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InputDataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Intent struct {
	Action string `json:"action,omitempty"`
	// Possible values:
	//   "PLATFORM_UNSPECIFIED"
	//   "FACEBOOK"
	//   "SLACK"
	//   "TELEGRAM"
	//   "KIK"
	//   "SKYPE"
	//   "LINE"
	//   "VIBER"
	//   "ACTIONS_ON_GOOGLE"
	//   "GOOGLE_HANGOUTS"
	DefaultResponsePlatforms []string                                           `json:"defaultResponsePlatforms,omitempty"`
	DisplayName              string                                             `json:"displayName,omitempty"`
	EndInteraction           bool                                               `json:"endInteraction,omitempty"`
	Events                   []string                                           `json:"events,omitempty"`
	FollowupIntentInfo       []*GoogleCloudDialogflowV2IntentFollowupIntentInfo `json:"followupIntentInfo,omitempty"`
	InputContextNames        []string                                           `json:"inputContextNames,omitempty"`
	IsFallback               bool                                               `json:"isFallback,omitempty"`
	LiveAgentHandoff         bool                                               `json:"liveAgentHandoff,omitempty"`
	Messages                 []*GoogleCloudDialogflowV2IntentMessage            `json:"messages,omitempty"`
	MlDisabled               bool                                               `json:"mlDisabled,omitempty"`
	Name                     string                                             `json:"name,omitempty"`
	OutputContexts           []*GoogleCloudDialogflowV2Context                  `json:"outputContexts,omitempty"`
	Parameters               []*GoogleCloudDialogflowV2IntentParameter          `json:"parameters,omitempty"`
	ParentFollowupIntentName string                                             `json:"parentFollowupIntentName,omitempty"`
	Priority                 int64                                              `json:"priority,omitempty"`
	ResetContexts            bool                                               `json:"resetContexts,omitempty"`
	RootFollowupIntentName   string                                             `json:"rootFollowupIntentName,omitempty"`
	TrainingPhrases          []*GoogleCloudDialogflowV2IntentTrainingPhrase     `json:"trainingPhrases,omitempty"`
	// Possible values:
	//   "WEBHOOK_STATE_UNSPECIFIED"
	//   "WEBHOOK_STATE_ENABLED"
	//   "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING"
	WebhookState string `json:"webhookState,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentBatch struct {
	Intents []*GoogleCloudDialogflowV2Intent `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentBatch) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentBatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentFollowupIntentInfo struct {
	FollowupIntentName       string `json:"followupIntentName,omitempty"`
	ParentFollowupIntentName string `json:"parentFollowupIntentName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FollowupIntentName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FollowupIntentName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentFollowupIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentFollowupIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessage struct {
	BasicCard          *GoogleCloudDialogflowV2IntentMessageBasicCard          `json:"basicCard,omitempty"`
	BrowseCarouselCard *GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard `json:"browseCarouselCard,omitempty"`
	Card               *GoogleCloudDialogflowV2IntentMessageCard               `json:"card,omitempty"`
	CarouselSelect     *GoogleCloudDialogflowV2IntentMessageCarouselSelect     `json:"carouselSelect,omitempty"`
	Image              *GoogleCloudDialogflowV2IntentMessageImage              `json:"image,omitempty"`
	LinkOutSuggestion  *GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion  `json:"linkOutSuggestion,omitempty"`
	ListSelect         *GoogleCloudDialogflowV2IntentMessageListSelect         `json:"listSelect,omitempty"`
	MediaContent       *GoogleCloudDialogflowV2IntentMessageMediaContent       `json:"mediaContent,omitempty"`
	Payload            googleapi.RawMessage                                    `json:"payload,omitempty"`
	// Possible values:
	//   "PLATFORM_UNSPECIFIED"
	//   "FACEBOOK"
	//   "SLACK"
	//   "TELEGRAM"
	//   "KIK"
	//   "SKYPE"
	//   "LINE"
	//   "VIBER"
	//   "ACTIONS_ON_GOOGLE"
	//   "GOOGLE_HANGOUTS"
	Platform        string                                               `json:"platform,omitempty"`
	QuickReplies    *GoogleCloudDialogflowV2IntentMessageQuickReplies    `json:"quickReplies,omitempty"`
	SimpleResponses *GoogleCloudDialogflowV2IntentMessageSimpleResponses `json:"simpleResponses,omitempty"`
	Suggestions     *GoogleCloudDialogflowV2IntentMessageSuggestions     `json:"suggestions,omitempty"`
	TableCard       *GoogleCloudDialogflowV2IntentMessageTableCard       `json:"tableCard,omitempty"`
	Text            *GoogleCloudDialogflowV2IntentMessageText            `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicCard") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicCard") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageBasicCard struct {
	Buttons       []*GoogleCloudDialogflowV2IntentMessageBasicCardButton `json:"buttons,omitempty"`
	FormattedText string                                                 `json:"formattedText,omitempty"`
	Image         *GoogleCloudDialogflowV2IntentMessageImage             `json:"image,omitempty"`
	Subtitle      string                                                 `json:"subtitle,omitempty"`
	Title         string                                                 `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBasicCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageBasicCardButton struct {
	OpenUriAction *GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction `json:"openUriAction,omitempty"`
	Title         string                                                            `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OpenUriAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OpenUriAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBasicCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCardButton
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard struct {
	// Possible values:
	//   "IMAGE_DISPLAY_OPTIONS_UNSPECIFIED"
	//   "GRAY"
	//   "WHITE"
	//   "CROPPED"
	//   "BLURRED_BACKGROUND"
	ImageDisplayOptions string                                                                          `json:"imageDisplayOptions,omitempty"`
	Items               []*GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageDisplayOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageDisplayOptions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem struct {
	Description   string                                                                                     `json:"description,omitempty"`
	Footer        string                                                                                     `json:"footer,omitempty"`
	Image         *GoogleCloudDialogflowV2IntentMessageImage                                                 `json:"image,omitempty"`
	OpenUriAction *GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction `json:"openUriAction,omitempty"`
	Title         string                                                                                     `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction struct {
	Url string `json:"url,omitempty"`
	// Possible values:
	//   "URL_TYPE_HINT_UNSPECIFIED"
	//   "AMP_ACTION"
	//   "AMP_CONTENT"
	UrlTypeHint string `json:"urlTypeHint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Url") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Url") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageCard struct {
	Buttons  []*GoogleCloudDialogflowV2IntentMessageCardButton `json:"buttons,omitempty"`
	ImageUri string                                            `json:"imageUri,omitempty"`
	Subtitle string                                            `json:"subtitle,omitempty"`
	Title    string                                            `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageCardButton struct {
	Postback string `json:"postback,omitempty"`
	Text     string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Postback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Postback") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCardButton
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageCarouselSelect struct {
	Items []*GoogleCloudDialogflowV2IntentMessageCarouselSelectItem `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCarouselSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCarouselSelect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageCarouselSelectItem struct {
	Description string                                              `json:"description,omitempty"`
	Image       *GoogleCloudDialogflowV2IntentMessageImage          `json:"image,omitempty"`
	Info        *GoogleCloudDialogflowV2IntentMessageSelectItemInfo `json:"info,omitempty"`
	Title       string                                              `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCarouselSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCarouselSelectItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageColumnProperties struct {
	Header string `json:"header,omitempty"`
	// Possible values:
	//   "HORIZONTAL_ALIGNMENT_UNSPECIFIED"
	//   "LEADING"
	//   "CENTER"
	//   "TRAILING"
	HorizontalAlignment string `json:"horizontalAlignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Header") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Header") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageColumnProperties) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageColumnProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageImage struct {
	AccessibilityText string `json:"accessibilityText,omitempty"`
	ImageUri          string `json:"imageUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessibilityText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessibilityText") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion struct {
	DestinationName string `json:"destinationName,omitempty"`
	Uri             string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageListSelect struct {
	Items    []*GoogleCloudDialogflowV2IntentMessageListSelectItem `json:"items,omitempty"`
	Subtitle string                                                `json:"subtitle,omitempty"`
	Title    string                                                `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageListSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageListSelect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageListSelectItem struct {
	Description string                                              `json:"description,omitempty"`
	Image       *GoogleCloudDialogflowV2IntentMessageImage          `json:"image,omitempty"`
	Info        *GoogleCloudDialogflowV2IntentMessageSelectItemInfo `json:"info,omitempty"`
	Title       string                                              `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageListSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageListSelectItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageMediaContent struct {
	MediaObjects []*GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject `json:"mediaObjects,omitempty"`
	// Possible values:
	//   "RESPONSE_MEDIA_TYPE_UNSPECIFIED"
	//   "AUDIO"
	MediaType string `json:"mediaType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MediaObjects") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MediaObjects") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageMediaContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageMediaContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject struct {
	ContentUrl  string                                     `json:"contentUrl,omitempty"`
	Description string                                     `json:"description,omitempty"`
	Icon        *GoogleCloudDialogflowV2IntentMessageImage `json:"icon,omitempty"`
	LargeImage  *GoogleCloudDialogflowV2IntentMessageImage `json:"largeImage,omitempty"`
	Name        string                                     `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageQuickReplies struct {
	QuickReplies []string `json:"quickReplies,omitempty"`
	Title        string   `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuickReplies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuickReplies") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageQuickReplies) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageQuickReplies
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageSelectItemInfo struct {
	Key      string   `json:"key,omitempty"`
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSelectItemInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSelectItemInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageSimpleResponse struct {
	DisplayText  string `json:"displayText,omitempty"`
	Ssml         string `json:"ssml,omitempty"`
	TextToSpeech string `json:"textToSpeech,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSimpleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSimpleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageSimpleResponses struct {
	SimpleResponses []*GoogleCloudDialogflowV2IntentMessageSimpleResponse `json:"simpleResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SimpleResponses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SimpleResponses") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSimpleResponses) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSimpleResponses
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageSuggestion struct {
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Title") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Title") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageSuggestions struct {
	Suggestions []*GoogleCloudDialogflowV2IntentMessageSuggestion `json:"suggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Suggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Suggestions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSuggestions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSuggestions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageTableCard struct {
	Buttons          []*GoogleCloudDialogflowV2IntentMessageBasicCardButton  `json:"buttons,omitempty"`
	ColumnProperties []*GoogleCloudDialogflowV2IntentMessageColumnProperties `json:"columnProperties,omitempty"`
	Image            *GoogleCloudDialogflowV2IntentMessageImage              `json:"image,omitempty"`
	Rows             []*GoogleCloudDialogflowV2IntentMessageTableCardRow     `json:"rows,omitempty"`
	Subtitle         string                                                  `json:"subtitle,omitempty"`
	Title            string                                                  `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageTableCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageTableCardCell struct {
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageTableCardCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCardCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageTableCardRow struct {
	Cells        []*GoogleCloudDialogflowV2IntentMessageTableCardCell `json:"cells,omitempty"`
	DividerAfter bool                                                 `json:"dividerAfter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageTableCardRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCardRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageText struct {
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentParameter struct {
	DefaultValue          string   `json:"defaultValue,omitempty"`
	DisplayName           string   `json:"displayName,omitempty"`
	EntityTypeDisplayName string   `json:"entityTypeDisplayName,omitempty"`
	IsList                bool     `json:"isList,omitempty"`
	Mandatory             bool     `json:"mandatory,omitempty"`
	Name                  string   `json:"name,omitempty"`
	Prompts               []string `json:"prompts,omitempty"`
	Value                 string   `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentSuggestion struct {
	Description string `json:"description,omitempty"`
	DisplayName string `json:"displayName,omitempty"`
	IntentV2    string `json:"intentV2,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentTrainingPhrase struct {
	Name            string                                             `json:"name,omitempty"`
	Parts           []*GoogleCloudDialogflowV2IntentTrainingPhrasePart `json:"parts,omitempty"`
	TimesAddedCount int64                                              `json:"timesAddedCount,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "EXAMPLE"
	//   "TEMPLATE"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentTrainingPhrasePart struct {
	Alias       string `json:"alias,omitempty"`
	EntityType  string `json:"entityType,omitempty"`
	Text        string `json:"text,omitempty"`
	UserDefined bool   `json:"userDefined,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistAnswer struct {
	AnswerRecord             string                                                       `json:"answerRecord,omitempty"`
	KnowledgeAssistDebugInfo *GoogleCloudDialogflowV2KnowledgeAssistDebugInfo             `json:"knowledgeAssistDebugInfo,omitempty"`
	SuggestedQuery           *GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery  `json:"suggestedQuery,omitempty"`
	SuggestedQueryAnswer     *GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer `json:"suggestedQueryAnswer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer struct {
	AnswerText       string                                                                       `json:"answerText,omitempty"`
	FaqSource        *GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource        `json:"faqSource,omitempty"`
	GenerativeSource *GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource `json:"generativeSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource struct {
	Question string `json:"question,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Question") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Question") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource struct {
	Snippets []*GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet `json:"snippets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Snippets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Snippets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	Text     string               `json:"text,omitempty"`
	Title    string               `json:"title,omitempty"`
	Uri      string               `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery struct {
	QueryText string `json:"queryText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistDebugInfo struct {
	// Possible values:
	//   "DATASTORE_RESPONSE_REASON_UNSPECIFIED"
	//   "NONE"
	//   "SEARCH_OUT_OF_QUOTA"
	//   "SEARCH_EMPTY_RESULTS"
	//   "ANSWER_GENERATION_GEN_AI_DISABLED"
	//   "ANSWER_GENERATION_OUT_OF_QUOTA"
	//   "ANSWER_GENERATION_ERROR"
	//   "ANSWER_GENERATION_NOT_ENOUGH_INFO"
	//   "ANSWER_GENERATION_RAI_FAILED"
	//   "ANSWER_GENERATION_NOT_GROUNDED"
	DatastoreResponseReason           string                                                                  `json:"datastoreResponseReason,omitempty"`
	IngestedContextReferenceDebugInfo *GoogleCloudDialogflowV2IngestedContextReferenceDebugInfo               `json:"ingestedContextReferenceDebugInfo,omitempty"`
	KnowledgeAssistBehavior           *GoogleCloudDialogflowV2KnowledgeAssistDebugInfoKnowledgeAssistBehavior `json:"knowledgeAssistBehavior,omitempty"`
	// Possible values:
	//   "QUERY_CATEGORIZATION_FAILURE_REASON_UNSPECIFIED"
	//   "QUERY_CATEGORIZATION_INVALID_CONFIG"
	//   "QUERY_CATEGORIZATION_RESULT_NOT_FOUND"
	//   "QUERY_CATEGORIZATION_FAILED"
	QueryCategorizationFailureReason string `json:"queryCategorizationFailureReason,omitempty"`
	// Possible values:
	//   "QUERY_GENERATION_FAILURE_REASON_UNSPECIFIED"
	//   "QUERY_GENERATION_OUT_OF_QUOTA"
	//   "QUERY_GENERATION_FAILED"
	//   "QUERY_GENERATION_NO_QUERY_GENERATED"
	//   "QUERY_GENERATION_RAI_FAILED"
	//   "NOT_IN_ALLOWLIST"
	//   "QUERY_GENERATION_QUERY_REDACTED"
	//   "QUERY_GENERATION_LLM_RESPONSE_PARSE_FAILED"
	//   "QUERY_GENERATION_EMPTY_CONVERSATION"
	//   "QUERY_GENERATION_EMPTY_LAST_MESSAGE"
	//   "QUERY_GENERATION_TRIGGERING_EVENT_CONDITION_NOT_MET"
	QueryGenerationFailureReason string                                 `json:"queryGenerationFailureReason,omitempty"`
	ServiceLatency               *GoogleCloudDialogflowV2ServiceLatency `json:"serviceLatency,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatastoreResponseReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatastoreResponseReason") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistDebugInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistDebugInfoKnowledgeAssistBehavior struct {
	AnswerGenerationRewriterOn              bool  `json:"answerGenerationRewriterOn,omitempty"`
	AppendedSearchContextCount              int64 `json:"appendedSearchContextCount,omitempty"`
	ConversationTranscriptHasMixedLanguages bool  `json:"conversationTranscriptHasMixedLanguages,omitempty"`
	DisableSyncDelivery                     bool  `json:"disableSyncDelivery,omitempty"`
	EndUserMetadataIncluded                 bool  `json:"endUserMetadataIncluded,omitempty"`
	InvalidItemsQuerySuggestionSkipped      bool  `json:"invalidItemsQuerySuggestionSkipped,omitempty"`
	MultipleQueriesGenerated                bool  `json:"multipleQueriesGenerated,omitempty"`
	PreviousQueriesIncluded                 bool  `json:"previousQueriesIncluded,omitempty"`
	PrimaryQueryRedactedAndReplaced         bool  `json:"primaryQueryRedactedAndReplaced,omitempty"`
	QueryContainedSearchContext             bool  `json:"queryContainedSearchContext,omitempty"`
	QueryGenerationAgentLanguageMismatch    bool  `json:"queryGenerationAgentLanguageMismatch,omitempty"`
	QueryGenerationEndUserLanguageMismatch  bool  `json:"queryGenerationEndUserLanguageMismatch,omitempty"`
	ReturnQueryOnly                         bool  `json:"returnQueryOnly,omitempty"`
	ThirdPartyConnectorAllowed              bool  `json:"thirdPartyConnectorAllowed,omitempty"`
	UseCustomSafetyFilterLevel              bool  `json:"useCustomSafetyFilterLevel,omitempty"`
	UsePubsubDelivery                       bool  `json:"usePubsubDelivery,omitempty"`
	UseTranslatedMessage                    bool  `json:"useTranslatedMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerGenerationRewriterOn")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerGenerationRewriterOn") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistDebugInfoKnowledgeAssistBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistDebugInfoKnowledgeAssistBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeBase struct {
	DisplayName  string `json:"displayName,omitempty"`
	LanguageCode string `json:"languageCode,omitempty"`
	Name         string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeBase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeBase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeOperationMetadata struct {
	DoneTime                string                                          `json:"doneTime,omitempty"`
	ExportOperationMetadata *GoogleCloudDialogflowV2ExportOperationMetadata `json:"exportOperationMetadata,omitempty"`
	KnowledgeBase           string                                          `json:"knowledgeBase,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "PENDING"
	//   "RUNNING"
	//   "DONE"
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DoneTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DoneTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListAnswerRecordsResponse struct {
	AnswerRecords []*GoogleCloudDialogflowV2AnswerRecord `json:"answerRecords,omitempty"`
	NextPageToken string                                 `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecords") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecords") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListAnswerRecordsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListAnswerRecordsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListContextsResponse struct {
	Contexts      []*GoogleCloudDialogflowV2Context `json:"contexts,omitempty"`
	NextPageToken string                            `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Contexts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contexts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListContextsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListContextsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListConversationDatasetsResponse struct {
	ConversationDatasets []*GoogleCloudDialogflowV2ConversationDataset `json:"conversationDatasets,omitempty"`
	NextPageToken        string                                        `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConversationDatasets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDatasets") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListConversationDatasetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListConversationDatasetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListConversationModelEvaluationsResponse struct {
	ConversationModelEvaluations []*GoogleCloudDialogflowV2ConversationModelEvaluation `json:"conversationModelEvaluations,omitempty"`
	NextPageToken                string                                                `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "ConversationModelEvaluations") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModelEvaluations") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListConversationModelEvaluationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListConversationModelEvaluationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListConversationModelsResponse struct {
	ConversationModels []*GoogleCloudDialogflowV2ConversationModel `json:"conversationModels,omitempty"`
	NextPageToken      string                                      `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConversationModels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModels") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListConversationModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListConversationModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListConversationProfilesResponse struct {
	ConversationProfiles []*GoogleCloudDialogflowV2ConversationProfile `json:"conversationProfiles,omitempty"`
	NextPageToken        string                                        `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfiles") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfiles") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListConversationProfilesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListConversationProfilesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListConversationsResponse struct {
	Conversations []*GoogleCloudDialogflowV2Conversation `json:"conversations,omitempty"`
	NextPageToken string                                 `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Conversations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListDocumentsResponse struct {
	Documents     []*GoogleCloudDialogflowV2Document `json:"documents,omitempty"`
	NextPageToken string                             `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListEntityTypesResponse struct {
	EntityTypes   []*GoogleCloudDialogflowV2EntityType `json:"entityTypes,omitempty"`
	NextPageToken string                               `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListEnvironmentsResponse struct {
	Environments  []*GoogleCloudDialogflowV2Environment `json:"environments,omitempty"`
	NextPageToken string                                `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Environments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Environments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListEnvironmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListEnvironmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListGeneratorEvaluationsResponse struct {
	GeneratorEvaluations []*GoogleCloudDialogflowV2GeneratorEvaluation `json:"generatorEvaluations,omitempty"`
	NextPageToken        string                                        `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GeneratorEvaluations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorEvaluations") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListGeneratorEvaluationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListGeneratorEvaluationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListGeneratorsResponse struct {
	Generators    []*GoogleCloudDialogflowV2Generator `json:"generators,omitempty"`
	NextPageToken string                              `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Generators") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Generators") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListGeneratorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListGeneratorsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListIntentsResponse struct {
	Intents       []*GoogleCloudDialogflowV2Intent `json:"intents,omitempty"`
	NextPageToken string                           `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Intents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListKnowledgeBasesResponse struct {
	KnowledgeBases []*GoogleCloudDialogflowV2KnowledgeBase `json:"knowledgeBases,omitempty"`
	NextPageToken  string                                  `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "KnowledgeBases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KnowledgeBases") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListKnowledgeBasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListKnowledgeBasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListMessagesResponse struct {
	Messages      []*GoogleCloudDialogflowV2Message `json:"messages,omitempty"`
	NextPageToken string                            `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Messages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Messages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListMessagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListMessagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListParticipantsResponse struct {
	NextPageToken string                                `json:"nextPageToken,omitempty"`
	Participants  []*GoogleCloudDialogflowV2Participant `json:"participants,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListParticipantsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListParticipantsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListSessionEntityTypesResponse struct {
	NextPageToken      string                                      `json:"nextPageToken,omitempty"`
	SessionEntityTypes []*GoogleCloudDialogflowV2SessionEntityType `json:"sessionEntityTypes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListSessionEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListSessionEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListSipTrunksResponse struct {
	NextPageToken string                             `json:"nextPageToken,omitempty"`
	SipTrunks     []*GoogleCloudDialogflowV2SipTrunk `json:"sipTrunks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListSipTrunksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListSipTrunksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListToolsResponse struct {
	NextPageToken string                         `json:"nextPageToken,omitempty"`
	Tools         []*GoogleCloudDialogflowV2Tool `json:"tools,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListToolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListToolsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ListVersionsResponse struct {
	NextPageToken string                            `json:"nextPageToken,omitempty"`
	Versions      []*GoogleCloudDialogflowV2Version `json:"versions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ListVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ListVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2LoggingConfig struct {
	EnableStackdriverLogging bool `json:"enableStackdriverLogging,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableStackdriverLogging")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableStackdriverLogging") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2LoggingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2LoggingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Message struct {
	Content           string                                    `json:"content,omitempty"`
	CreateTime        string                                    `json:"createTime,omitempty"`
	LanguageCode      string                                    `json:"languageCode,omitempty"`
	MessageAnnotation *GoogleCloudDialogflowV2MessageAnnotation `json:"messageAnnotation,omitempty"`
	Name              string                                    `json:"name,omitempty"`
	Participant       string                                    `json:"participant,omitempty"`
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	ParticipantRole   string                                          `json:"participantRole,omitempty"`
	SendTime          string                                          `json:"sendTime,omitempty"`
	SentimentAnalysis *GoogleCloudDialogflowV2SentimentAnalysisResult `json:"sentimentAnalysis,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Message) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Message
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2MessageAnnotation struct {
	ContainEntities bool                                           `json:"containEntities,omitempty"`
	Parts           []*GoogleCloudDialogflowV2AnnotatedMessagePart `json:"parts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainEntities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainEntities") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2MessageAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2MessageAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2MessageEntry struct {
	CreateTime   string `json:"createTime,omitempty"`
	LanguageCode string `json:"languageCode,omitempty"`
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	Role string `json:"role,omitempty"`
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2MessageEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2MessageEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2NotificationConfig struct {
	// Possible values:
	//   "MESSAGE_FORMAT_UNSPECIFIED"
	//   "PROTO"
	//   "JSON"
	MessageFormat string `json:"messageFormat,omitempty"`
	Topic         string `json:"topic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MessageFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MessageFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2NotificationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2NotificationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2OriginalDetectIntentRequest struct {
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	Source  string               `json:"source,omitempty"`
	Version string               `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Payload") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Payload") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2OriginalDetectIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2OriginalDetectIntentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2OutputAudio struct {
	Audio  string                                    `json:"audio,omitempty"`
	Config *GoogleCloudDialogflowV2OutputAudioConfig `json:"config,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2OutputAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2OutputAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2OutputAudioConfig struct {
	// Possible values:
	//   "OUTPUT_AUDIO_ENCODING_UNSPECIFIED"
	//   "OUTPUT_AUDIO_ENCODING_LINEAR_16"
	//   "OUTPUT_AUDIO_ENCODING_MP3"
	//   "OUTPUT_AUDIO_ENCODING_MP3_64_KBPS"
	//   "OUTPUT_AUDIO_ENCODING_OGG_OPUS"
	//   "OUTPUT_AUDIO_ENCODING_MULAW"
	//   "OUTPUT_AUDIO_ENCODING_ALAW"
	AudioEncoding          string                                         `json:"audioEncoding,omitempty"`
	SampleRateHertz        int64                                          `json:"sampleRateHertz,omitempty"`
	SynthesizeSpeechConfig *GoogleCloudDialogflowV2SynthesizeSpeechConfig `json:"synthesizeSpeechConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2OutputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2OutputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Participant struct {
	// Possible values:
	//   "AGENT_DESKTOP_SOURCE_UNSPECIFIED"
	//   "LIVE_PERSON"
	//   "GENESYS_CLOUD"
	//   "TWILIO"
	//   "SALESFORCE"
	//   "OTHER"
	AgentDesktopSource       string            `json:"agentDesktopSource,omitempty"`
	DocumentsMetadataFilters map[string]string `json:"documentsMetadataFilters,omitempty"`
	Name                     string            `json:"name,omitempty"`
	ObfuscatedExternalUserId string            `json:"obfuscatedExternalUserId,omitempty"`
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	Role                   string `json:"role,omitempty"`
	SipRecordingMediaLabel string `json:"sipRecordingMediaLabel,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AgentDesktopSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDesktopSource") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Participant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Participant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2QueryInput struct {
	AudioConfig *GoogleCloudDialogflowV2InputAudioConfig `json:"audioConfig,omitempty"`
	Event       *GoogleCloudDialogflowV2EventInput       `json:"event,omitempty"`
	Text        *GoogleCloudDialogflowV2TextInput        `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2QueryInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2QueryInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2QueryParameters struct {
	Contexts                       []*GoogleCloudDialogflowV2Context                      `json:"contexts,omitempty"`
	GeoLocation                    *GoogleTypeLatLng                                      `json:"geoLocation,omitempty"`
	Payload                        googleapi.RawMessage                                   `json:"payload,omitempty"`
	Platform                       string                                                 `json:"platform,omitempty"`
	ResetContexts                  bool                                                   `json:"resetContexts,omitempty"`
	SentimentAnalysisRequestConfig *GoogleCloudDialogflowV2SentimentAnalysisRequestConfig `json:"sentimentAnalysisRequestConfig,omitempty"`
	SessionEntityTypes             []*GoogleCloudDialogflowV2SessionEntityType            `json:"sessionEntityTypes,omitempty"`
	TimeZone                       string                                                 `json:"timeZone,omitempty"`
	WebhookHeaders                 map[string]string                                      `json:"webhookHeaders,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contexts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contexts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2QueryParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2QueryParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2QueryResult struct {
	Action                      string                                          `json:"action,omitempty"`
	AllRequiredParamsPresent    bool                                            `json:"allRequiredParamsPresent,omitempty"`
	CancelsSlotFilling          bool                                            `json:"cancelsSlotFilling,omitempty"`
	DiagnosticInfo              googleapi.RawMessage                            `json:"diagnosticInfo,omitempty"`
	FulfillmentMessages         []*GoogleCloudDialogflowV2IntentMessage         `json:"fulfillmentMessages,omitempty"`
	FulfillmentText             string                                          `json:"fulfillmentText,omitempty"`
	Intent                      *GoogleCloudDialogflowV2Intent                  `json:"intent,omitempty"`
	IntentDetectionConfidence   float64                                         `json:"intentDetectionConfidence,omitempty"`
	LanguageCode                string                                          `json:"languageCode,omitempty"`
	OutputContexts              []*GoogleCloudDialogflowV2Context               `json:"outputContexts,omitempty"`
	Parameters                  googleapi.RawMessage                            `json:"parameters,omitempty"`
	QueryText                   string                                          `json:"queryText,omitempty"`
	SentimentAnalysisResult     *GoogleCloudDialogflowV2SentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	SpeechRecognitionConfidence float64                                         `json:"speechRecognitionConfidence,omitempty"`
	WebhookPayload              googleapi.RawMessage                            `json:"webhookPayload,omitempty"`
	WebhookSource               string                                          `json:"webhookSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2QueryResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2QueryResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2QueryResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2QueryResult
	var s1 struct {
		IntentDetectionConfidence   gensupport.JSONFloat64 `json:"intentDetectionConfidence"`
		SpeechRecognitionConfidence gensupport.JSONFloat64 `json:"speechRecognitionConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.IntentDetectionConfidence = float64(s1.IntentDetectionConfidence)
	s.SpeechRecognitionConfidence = float64(s1.SpeechRecognitionConfidence)
	return nil
}

type GoogleCloudDialogflowV2RaiSettings struct {
	RaiCategoryConfigs []*GoogleCloudDialogflowV2RaiSettingsRaiCategoryConfig `json:"raiCategoryConfigs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RaiCategoryConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RaiCategoryConfigs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2RaiSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2RaiSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2RaiSettingsRaiCategoryConfig struct {
	// Possible values:
	//   "RAI_CATEGORY_UNSPECIFIED"
	//   "DANGEROUS_CONTENT"
	//   "SEXUALLY_EXPLICIT"
	//   "HARASSMENT"
	//   "HATE_SPEECH"
	Category string `json:"category,omitempty"`
	// Possible values:
	//   "SENSITIVITY_LEVEL_UNSPECIFIED"
	//   "BLOCK_MOST"
	//   "BLOCK_SOME"
	//   "BLOCK_FEW"
	//   "BLOCK_NONE"
	SensitivityLevel string `json:"sensitivityLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Category") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2RaiSettingsRaiCategoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2RaiSettingsRaiCategoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ReloadDocumentRequest struct {
	ContentUri                  string `json:"contentUri,omitempty"`
	ImportGcsCustomMetadata     bool   `json:"importGcsCustomMetadata,omitempty"`
	SmartMessagingPartialUpdate bool   `json:"smartMessagingPartialUpdate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ReloadDocumentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ReloadDocumentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2RestoreAgentRequest struct {
	AgentContent string `json:"agentContent,omitempty"`
	AgentUri     string `json:"agentUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2RestoreAgentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2RestoreAgentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SearchAgentsResponse struct {
	Agents        []*GoogleCloudDialogflowV2Agent `json:"agents,omitempty"`
	NextPageToken string                          `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Agents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SearchAgentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SearchAgentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SearchKnowledgeAnswer struct {
	Answer        string                                                      `json:"answer,omitempty"`
	AnswerRecord  string                                                      `json:"answerRecord,omitempty"`
	AnswerSources []*GoogleCloudDialogflowV2SearchKnowledgeAnswerAnswerSource `json:"answerSources,omitempty"`
	// Possible values:
	//   "ANSWER_TYPE_UNSPECIFIED"
	//   "FAQ"
	//   "GENERATIVE"
	//   "INTENT"
	AnswerType string `json:"answerType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SearchKnowledgeAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SearchKnowledgeAnswerAnswerSource struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	Snippet  string               `json:"snippet,omitempty"`
	Title    string               `json:"title,omitempty"`
	Uri      string               `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SearchKnowledgeAnswerAnswerSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeAnswerAnswerSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SearchKnowledgeDebugInfo struct {
	// Possible values:
	//   "DATASTORE_RESPONSE_REASON_UNSPECIFIED"
	//   "NONE"
	//   "SEARCH_OUT_OF_QUOTA"
	//   "SEARCH_EMPTY_RESULTS"
	//   "ANSWER_GENERATION_GEN_AI_DISABLED"
	//   "ANSWER_GENERATION_OUT_OF_QUOTA"
	//   "ANSWER_GENERATION_ERROR"
	//   "ANSWER_GENERATION_NOT_ENOUGH_INFO"
	//   "ANSWER_GENERATION_RAI_FAILED"
	//   "ANSWER_GENERATION_NOT_GROUNDED"
	DatastoreResponseReason           string                                                                  `json:"datastoreResponseReason,omitempty"`
	IngestedContextReferenceDebugInfo *GoogleCloudDialogflowV2IngestedContextReferenceDebugInfo               `json:"ingestedContextReferenceDebugInfo,omitempty"`
	SearchKnowledgeBehavior           *GoogleCloudDialogflowV2SearchKnowledgeDebugInfoSearchKnowledgeBehavior `json:"searchKnowledgeBehavior,omitempty"`
	ServiceLatency                    *GoogleCloudDialogflowV2ServiceLatency                                  `json:"serviceLatency,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatastoreResponseReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatastoreResponseReason") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SearchKnowledgeDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeDebugInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SearchKnowledgeDebugInfoSearchKnowledgeBehavior struct {
	AnswerGenerationRewriterOn bool `json:"answerGenerationRewriterOn,omitempty"`
	EndUserMetadataIncluded    bool `json:"endUserMetadataIncluded,omitempty"`
	ThirdPartyConnectorAllowed bool `json:"thirdPartyConnectorAllowed,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerGenerationRewriterOn")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerGenerationRewriterOn") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SearchKnowledgeDebugInfoSearchKnowledgeBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeDebugInfoSearchKnowledgeBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SearchKnowledgeRequest struct {
	Conversation        string                            `json:"conversation,omitempty"`
	ConversationProfile string                            `json:"conversationProfile,omitempty"`
	EndUserMetadata     googleapi.RawMessage              `json:"endUserMetadata,omitempty"`
	ExactSearch         bool                              `json:"exactSearch,omitempty"`
	LatestMessage       string                            `json:"latestMessage,omitempty"`
	Parent              string                            `json:"parent,omitempty"`
	Query               *GoogleCloudDialogflowV2TextInput `json:"query,omitempty"`
	// Possible values:
	//   "QUERY_SOURCE_UNSPECIFIED"
	//   "AGENT_QUERY"
	//   "SUGGESTED_QUERY"
	QuerySource  string                                                     `json:"querySource,omitempty"`
	SearchConfig *GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfig `json:"searchConfig,omitempty"`
	SessionId    string                                                     `json:"sessionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SearchKnowledgeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfig struct {
	BoostSpecs  []*GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecs  `json:"boostSpecs,omitempty"`
	FilterSpecs []*GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigFilterSpecs `json:"filterSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpecs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecs struct {
	DataStores []string                                                                        `json:"dataStores,omitempty"`
	Spec       []*GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpec `json:"spec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecs) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecs
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpec struct {
	ConditionBoostSpecs []*GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpec `json:"conditionBoostSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConditionBoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConditionBoostSpecs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpec struct {
	Boost            float64                                                                                                         `json:"boost,omitempty"`
	BoostControlSpec *GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpecBoostControlSpec `json:"boostControlSpec,omitempty"`
	Condition        string                                                                                                          `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpec
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

type GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpecBoostControlSpec struct {
	// Possible values:
	//   "ATTRIBUTE_TYPE_UNSPECIFIED"
	//   "NUMERICAL"
	//   "FRESHNESS"
	AttributeType string                                                                                                                        `json:"attributeType,omitempty"`
	ControlPoints []*GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpecBoostControlSpecControlPoint `json:"controlPoints,omitempty"`
	FieldName     string                                                                                                                        `json:"fieldName,omitempty"`
	// Possible values:
	//   "INTERPOLATION_TYPE_UNSPECIFIED"
	//   "LINEAR"
	InterpolationType string `json:"interpolationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpecBoostControlSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpecBoostControlSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpecBoostControlSpecControlPoint struct {
	AttributeValue string  `json:"attributeValue,omitempty"`
	BoostAmount    float64 `json:"boostAmount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpecBoostControlSpecControlPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpecBoostControlSpecControlPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpecBoostControlSpecControlPoint) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpecBoostControlSpecControlPoint
	var s1 struct {
		BoostAmount gensupport.JSONFloat64 `json:"boostAmount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BoostAmount = float64(s1.BoostAmount)
	return nil
}

type GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigFilterSpecs struct {
	DataStores []string `json:"dataStores,omitempty"`
	Filter     string   `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigFilterSpecs) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeRequestSearchConfigFilterSpecs
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SearchKnowledgeResponse struct {
	Answers                  []*GoogleCloudDialogflowV2SearchKnowledgeAnswer  `json:"answers,omitempty"`
	RewrittenQuery           string                                           `json:"rewrittenQuery,omitempty"`
	SearchKnowledgeDebugInfo *GoogleCloudDialogflowV2SearchKnowledgeDebugInfo `json:"searchKnowledgeDebugInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Answers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SearchKnowledgeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SearchKnowledgeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Sentiment struct {
	Magnitude float64 `json:"magnitude,omitempty"`
	Score     float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Sentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Sentiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2Sentiment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2Sentiment
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

type GoogleCloudDialogflowV2SentimentAnalysisRequestConfig struct {
	AnalyzeQueryTextSentiment bool `json:"analyzeQueryTextSentiment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalyzeQueryTextSentiment")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyzeQueryTextSentiment") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SentimentAnalysisRequestConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SentimentAnalysisRequestConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SentimentAnalysisResult struct {
	QueryTextSentiment *GoogleCloudDialogflowV2Sentiment `json:"queryTextSentiment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryTextSentiment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryTextSentiment") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ServiceLatency struct {
	InternalServiceLatencies []*GoogleCloudDialogflowV2ServiceLatencyInternalServiceLatency `json:"internalServiceLatencies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InternalServiceLatencies")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InternalServiceLatencies") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ServiceLatency) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ServiceLatency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ServiceLatencyInternalServiceLatency struct {
	CompleteTime string  `json:"completeTime,omitempty"`
	LatencyMs    float64 `json:"latencyMs,omitempty"`
	StartTime    string  `json:"startTime,omitempty"`
	Step         string  `json:"step,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompleteTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompleteTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ServiceLatencyInternalServiceLatency) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ServiceLatencyInternalServiceLatency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2ServiceLatencyInternalServiceLatency) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2ServiceLatencyInternalServiceLatency
	var s1 struct {
		LatencyMs gensupport.JSONFloat64 `json:"latencyMs"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LatencyMs = float64(s1.LatencyMs)
	return nil
}

type GoogleCloudDialogflowV2SessionEntityType struct {
	Entities []*GoogleCloudDialogflowV2EntityTypeEntity `json:"entities,omitempty"`
	// Possible values:
	//   "ENTITY_OVERRIDE_MODE_UNSPECIFIED"
	//   "ENTITY_OVERRIDE_MODE_OVERRIDE"
	//   "ENTITY_OVERRIDE_MODE_SUPPLEMENT"
	EntityOverrideMode string `json:"entityOverrideMode,omitempty"`
	Name               string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SessionEntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SessionEntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata struct {
	ConversationProfile string `json:"conversationProfile,omitempty"`
	CreateTime          string `json:"createTime,omitempty"`
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	ParticipantRole string `json:"participantRole,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "ARTICLE_SUGGESTION"
	//   "FAQ"
	//   "SMART_REPLY"
	//   "CONVERSATION_SUMMARIZATION"
	//   "KNOWLEDGE_SEARCH"
	//   "KNOWLEDGE_ASSIST"
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SetSuggestionFeatureConfigRequest struct {
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	ParticipantRole         string                                                                   `json:"participantRole,omitempty"`
	SuggestionFeatureConfig *GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionFeatureConfig `json:"suggestionFeatureConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParticipantRole") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParticipantRole") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SetSuggestionFeatureConfigRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SetSuggestionFeatureConfigRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SipTrunk struct {
	Connections      []*GoogleCloudDialogflowV2Connection `json:"connections,omitempty"`
	DisplayName      string                               `json:"displayName,omitempty"`
	ExpectedHostname []string                             `json:"expectedHostname,omitempty"`
	Name             string                               `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Connections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Connections") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SipTrunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SipTrunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SmartReplyAnswer struct {
	AnswerRecord string  `json:"answerRecord,omitempty"`
	Confidence   float64 `json:"confidence,omitempty"`
	Reply        string  `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SmartReplyAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SmartReplyAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SmartReplyAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SmartReplyAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2SmartReplyMetrics struct {
	AllowlistCoverage float64                                                `json:"allowlistCoverage,omitempty"`
	ConversationCount int64                                                  `json:"conversationCount,omitempty,string"`
	TopNMetrics       []*GoogleCloudDialogflowV2SmartReplyMetricsTopNMetrics `json:"topNMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowlistCoverage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowlistCoverage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SmartReplyMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SmartReplyMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SmartReplyMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SmartReplyMetrics
	var s1 struct {
		AllowlistCoverage gensupport.JSONFloat64 `json:"allowlistCoverage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AllowlistCoverage = float64(s1.AllowlistCoverage)
	return nil
}

type GoogleCloudDialogflowV2SmartReplyMetricsTopNMetrics struct {
	N      int64   `json:"n,omitempty"`
	Recall float64 `json:"recall,omitempty"`
	// ForceSendFields is a list of field names (e.g. "N") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "N") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SmartReplyMetricsTopNMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SmartReplyMetricsTopNMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SmartReplyMetricsTopNMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SmartReplyMetricsTopNMetrics
	var s1 struct {
		Recall gensupport.JSONFloat64 `json:"recall"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Recall = float64(s1.Recall)
	return nil
}

type GoogleCloudDialogflowV2SmartReplyModelMetadata struct {
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED"
	//   "SMART_REPLY_DUAL_ENCODER_MODEL"
	//   "SMART_REPLY_BERT_MODEL"
	TrainingModelType string `json:"trainingModelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TrainingModelType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrainingModelType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SmartReplyModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SmartReplyModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SpeechContext struct {
	Boost   float64  `json:"boost,omitempty"`
	Phrases []string `json:"phrases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SpeechContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SpeechContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SpeechContext) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SpeechContext
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

type GoogleCloudDialogflowV2SpeechToTextConfig struct {
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED"
	//   "AUDIO_ENCODING_LINEAR_16"
	//   "AUDIO_ENCODING_FLAC"
	//   "AUDIO_ENCODING_MULAW"
	//   "AUDIO_ENCODING_AMR"
	//   "AUDIO_ENCODING_AMR_WB"
	//   "AUDIO_ENCODING_OGG_OPUS"
	//   "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE"
	//   "AUDIO_ENCODING_ALAW"
	AudioEncoding   string   `json:"audioEncoding,omitempty"`
	EnableWordInfo  bool     `json:"enableWordInfo,omitempty"`
	LanguageCode    string   `json:"languageCode,omitempty"`
	Model           string   `json:"model,omitempty"`
	PhraseSets      []string `json:"phraseSets,omitempty"`
	SampleRateHertz int64    `json:"sampleRateHertz,omitempty"`
	// Possible values:
	//   "SPEECH_MODEL_VARIANT_UNSPECIFIED"
	//   "USE_BEST_AVAILABLE"
	//   "USE_STANDARD"
	//   "USE_ENHANCED"
	SpeechModelVariant         string `json:"speechModelVariant,omitempty"`
	UseTimeoutBasedEndpointing bool   `json:"useTimeoutBasedEndpointing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SpeechToTextConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SpeechToTextConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SpeechWordInfo struct {
	Confidence  float64 `json:"confidence,omitempty"`
	EndOffset   string  `json:"endOffset,omitempty"`
	StartOffset string  `json:"startOffset,omitempty"`
	Word        string  `json:"word,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SpeechWordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SpeechWordInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SpeechWordInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SpeechWordInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2StreamingRecognitionResult struct {
	Confidence   float64 `json:"confidence,omitempty"`
	IsFinal      bool    `json:"isFinal,omitempty"`
	LanguageCode string  `json:"languageCode,omitempty"`
	// Possible values:
	//   "MESSAGE_TYPE_UNSPECIFIED"
	//   "TRANSCRIPT"
	//   "END_OF_SINGLE_UTTERANCE"
	MessageType     string                                   `json:"messageType,omitempty"`
	SpeechEndOffset string                                   `json:"speechEndOffset,omitempty"`
	SpeechWordInfo  []*GoogleCloudDialogflowV2SpeechWordInfo `json:"speechWordInfo,omitempty"`
	Transcript      string                                   `json:"transcript,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2StreamingRecognitionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2StreamingRecognitionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2StreamingRecognitionResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2StreamingRecognitionResult
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2SuggestArticlesRequest struct {
	AssistQueryParams *GoogleCloudDialogflowV2AssistQueryParameters `json:"assistQueryParams,omitempty"`
	ContextSize       int64                                         `json:"contextSize,omitempty"`
	LatestMessage     string                                        `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssistQueryParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssistQueryParams") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestArticlesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestArticlesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestArticlesResponse struct {
	ArticleAnswers []*GoogleCloudDialogflowV2ArticleAnswer `json:"articleAnswers,omitempty"`
	ContextSize    int64                                   `json:"contextSize,omitempty"`
	LatestMessage  string                                  `json:"latestMessage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ArticleAnswers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArticleAnswers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestArticlesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestArticlesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestConversationSummaryRequest struct {
	AssistQueryParams *GoogleCloudDialogflowV2AssistQueryParameters `json:"assistQueryParams,omitempty"`
	ContextSize       int64                                         `json:"contextSize,omitempty"`
	LatestMessage     string                                        `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssistQueryParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssistQueryParams") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestConversationSummaryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestConversationSummaryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestConversationSummaryResponse struct {
	ContextSize   int64                                                             `json:"contextSize,omitempty"`
	LatestMessage string                                                            `json:"latestMessage,omitempty"`
	Summary       *GoogleCloudDialogflowV2SuggestConversationSummaryResponseSummary `json:"summary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestConversationSummaryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestConversationSummaryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestConversationSummaryResponseSummary struct {
	AnswerRecord         string                                                                            `json:"answerRecord,omitempty"`
	BaselineModelVersion string                                                                            `json:"baselineModelVersion,omitempty"`
	SortedTextSections   []*GoogleCloudDialogflowV2SuggestConversationSummaryResponseSummarySummarySection `json:"sortedTextSections,omitempty"`
	Text                 string                                                                            `json:"text,omitempty"`
	TextSections         map[string]string                                                                 `json:"textSections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestConversationSummaryResponseSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestConversationSummaryResponseSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestConversationSummaryResponseSummarySummarySection struct {
	Section string `json:"section,omitempty"`
	Summary string `json:"summary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Section") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Section") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestConversationSummaryResponseSummarySummarySection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestConversationSummaryResponseSummarySummarySection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestFaqAnswersRequest struct {
	AssistQueryParams *GoogleCloudDialogflowV2AssistQueryParameters `json:"assistQueryParams,omitempty"`
	ContextSize       int64                                         `json:"contextSize,omitempty"`
	LatestMessage     string                                        `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssistQueryParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssistQueryParams") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestFaqAnswersRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestFaqAnswersRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestFaqAnswersResponse struct {
	ContextSize   int64                               `json:"contextSize,omitempty"`
	FaqAnswers    []*GoogleCloudDialogflowV2FaqAnswer `json:"faqAnswers,omitempty"`
	LatestMessage string                              `json:"latestMessage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestFaqAnswersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestFaqAnswersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestKnowledgeAssistRequest struct {
	ContextSize            int64  `json:"contextSize,omitempty"`
	LatestMessage          string `json:"latestMessage,omitempty"`
	PreviousSuggestedQuery string `json:"previousSuggestedQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestKnowledgeAssistRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestKnowledgeAssistRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse struct {
	ContextSize           int64                                         `json:"contextSize,omitempty"`
	KnowledgeAssistAnswer *GoogleCloudDialogflowV2KnowledgeAssistAnswer `json:"knowledgeAssistAnswer,omitempty"`
	LatestMessage         string                                        `json:"latestMessage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestSmartRepliesRequest struct {
	ContextSize      int64                             `json:"contextSize,omitempty"`
	CurrentTextInput *GoogleCloudDialogflowV2TextInput `json:"currentTextInput,omitempty"`
	LatestMessage    string                            `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestSmartRepliesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestSmartRepliesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestSmartRepliesResponse struct {
	ContextSize       int64                                      `json:"contextSize,omitempty"`
	LatestMessage     string                                     `json:"latestMessage,omitempty"`
	SmartReplyAnswers []*GoogleCloudDialogflowV2SmartReplyAnswer `json:"smartReplyAnswers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestSmartRepliesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestSmartRepliesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestionDedupingConfig struct {
	EnableDeduping      bool    `json:"enableDeduping,omitempty"`
	SimilarityThreshold float64 `json:"similarityThreshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableDeduping") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableDeduping") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestionDedupingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestionDedupingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SuggestionDedupingConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SuggestionDedupingConfig
	var s1 struct {
		SimilarityThreshold gensupport.JSONFloat64 `json:"similarityThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SimilarityThreshold = float64(s1.SimilarityThreshold)
	return nil
}

type GoogleCloudDialogflowV2SuggestionFeature struct {
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "ARTICLE_SUGGESTION"
	//   "FAQ"
	//   "SMART_REPLY"
	//   "CONVERSATION_SUMMARIZATION"
	//   "KNOWLEDGE_SEARCH"
	//   "KNOWLEDGE_ASSIST"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestionFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestionFeature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestionInput struct {
	// Possible values:
	//   "ACTION_UNSPECIFIED"
	//   "CANCEL"
	//   "REVISE"
	//   "CONFIRM"
	Action       string               `json:"action,omitempty"`
	AnswerRecord string               `json:"answerRecord,omitempty"`
	Parameters   googleapi.RawMessage `json:"parameters,omitempty"`
	SendTime     string               `json:"sendTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestionInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestionInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestionResult struct {
	Error                          *GoogleRpcStatus                                       `json:"error,omitempty"`
	GenerateSuggestionsResponse    *GoogleCloudDialogflowV2GenerateSuggestionsResponse    `json:"generateSuggestionsResponse,omitempty"`
	SuggestArticlesResponse        *GoogleCloudDialogflowV2SuggestArticlesResponse        `json:"suggestArticlesResponse,omitempty"`
	SuggestFaqAnswersResponse      *GoogleCloudDialogflowV2SuggestFaqAnswersResponse      `json:"suggestFaqAnswersResponse,omitempty"`
	SuggestKnowledgeAssistResponse *GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse `json:"suggestKnowledgeAssistResponse,omitempty"`
	SuggestSmartRepliesResponse    *GoogleCloudDialogflowV2SuggestSmartRepliesResponse    `json:"suggestSmartRepliesResponse,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarizationContext struct {
	FewShotExamples       []*GoogleCloudDialogflowV2FewShotExample       `json:"fewShotExamples,omitempty"`
	OutputLanguageCode    string                                         `json:"outputLanguageCode,omitempty"`
	SummarizationSections []*GoogleCloudDialogflowV2SummarizationSection `json:"summarizationSections,omitempty"`
	Version               string                                         `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FewShotExamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FewShotExamples") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarizationEvaluationMetrics struct {
	ConversationDetails                     []*GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetail            `json:"conversationDetails,omitempty"`
	OverallMetrics                          []*GoogleCloudDialogflowV2SummarizationEvaluationMetricsOverallScoresByMetric         `json:"overallMetrics,omitempty"`
	OverallSectionTokens                    []*GoogleCloudDialogflowV2SummarizationEvaluationMetricsSectionToken                  `json:"overallSectionTokens,omitempty"`
	SummarizationEvaluationMergedResultsUri string                                                                                `json:"summarizationEvaluationMergedResultsUri,omitempty"`
	SummarizationEvaluationResults          []*GoogleCloudDialogflowV2SummarizationEvaluationMetricsSummarizationEvaluationResult `json:"summarizationEvaluationResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDetails") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationEvaluationMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarizationEvaluationMetricsAccuracyDecomposition struct {
	AccuracyReasoning string `json:"accuracyReasoning,omitempty"`
	IsAccurate        bool   `json:"isAccurate,omitempty"`
	Point             string `json:"point,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccuracyReasoning") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccuracyReasoning") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationEvaluationMetricsAccuracyDecomposition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsAccuracyDecomposition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarizationEvaluationMetricsAdherenceDecomposition struct {
	AdherenceReasoning string `json:"adherenceReasoning,omitempty"`
	IsAdherent         bool   `json:"isAdherent,omitempty"`
	Point              string `json:"point,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdherenceReasoning") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdherenceReasoning") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationEvaluationMetricsAdherenceDecomposition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsAdherenceDecomposition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarizationEvaluationMetricsAdherenceRubric struct {
	IsAddressed bool   `json:"isAddressed,omitempty"`
	Question    string `json:"question,omitempty"`
	Reasoning   string `json:"reasoning,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsAddressed") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsAddressed") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationEvaluationMetricsAdherenceRubric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsAdherenceRubric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarizationEvaluationMetricsCompletenessRubric struct {
	IsAddressed bool   `json:"isAddressed,omitempty"`
	Question    string `json:"question,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsAddressed") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsAddressed") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationEvaluationMetricsCompletenessRubric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsCompletenessRubric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetail struct {
	MessageEntries  []*GoogleCloudDialogflowV2MessageEntry                                                 `json:"messageEntries,omitempty"`
	MetricDetails   []*GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetailMetricDetail `json:"metricDetails,omitempty"`
	SectionTokens   []*GoogleCloudDialogflowV2SummarizationEvaluationMetricsSectionToken                   `json:"sectionTokens,omitempty"`
	SummarySections []*GoogleCloudDialogflowV2SummarySuggestionSummarySection                              `json:"summarySections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MessageEntries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MessageEntries") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetailMetricDetail struct {
	Metric         string                                                                                              `json:"metric,omitempty"`
	Score          float64                                                                                             `json:"score,omitempty"`
	SectionDetails []*GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetailMetricDetailSectionDetail `json:"sectionDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metric") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metric") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetailMetricDetail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetailMetricDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetailMetricDetail) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetailMetricDetail
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

type GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetailMetricDetailSectionDetail struct {
	EvaluationResults []*GoogleCloudDialogflowV2SummarizationEvaluationMetricsEvaluationResult `json:"evaluationResults,omitempty"`
	Score             float64                                                                  `json:"score,omitempty"`
	Section           string                                                                   `json:"section,omitempty"`
	SectionSummary    string                                                                   `json:"sectionSummary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EvaluationResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluationResults") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetailMetricDetailSectionDetail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetailMetricDetailSectionDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetailMetricDetailSectionDetail) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsConversationDetailMetricDetailSectionDetail
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

type GoogleCloudDialogflowV2SummarizationEvaluationMetricsDecomposition struct {
	AccuracyDecomposition  *GoogleCloudDialogflowV2SummarizationEvaluationMetricsAccuracyDecomposition  `json:"accuracyDecomposition,omitempty"`
	AdherenceDecomposition *GoogleCloudDialogflowV2SummarizationEvaluationMetricsAdherenceDecomposition `json:"adherenceDecomposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccuracyDecomposition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccuracyDecomposition") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationEvaluationMetricsDecomposition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsDecomposition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarizationEvaluationMetricsEvaluationResult struct {
	AccuracyDecomposition *GoogleCloudDialogflowV2SummarizationEvaluationMetricsAccuracyDecomposition `json:"accuracyDecomposition,omitempty"`
	AdherenceRubric       *GoogleCloudDialogflowV2SummarizationEvaluationMetricsAdherenceRubric       `json:"adherenceRubric,omitempty"`
	CompletenessRubric    *GoogleCloudDialogflowV2SummarizationEvaluationMetricsCompletenessRubric    `json:"completenessRubric,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccuracyDecomposition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccuracyDecomposition") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationEvaluationMetricsEvaluationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsEvaluationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarizationEvaluationMetricsOverallScoresByMetric struct {
	Metric string `json:"metric,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metric") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metric") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationEvaluationMetricsOverallScoresByMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsOverallScoresByMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarizationEvaluationMetricsSectionToken struct {
	Section    string `json:"section,omitempty"`
	TokenCount int64  `json:"tokenCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Section") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Section") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationEvaluationMetricsSectionToken) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsSectionToken
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarizationEvaluationMetricsSummarizationEvaluationResult struct {
	Decompositions    []*GoogleCloudDialogflowV2SummarizationEvaluationMetricsDecomposition    `json:"decompositions,omitempty"`
	EvaluationResults []*GoogleCloudDialogflowV2SummarizationEvaluationMetricsEvaluationResult `json:"evaluationResults,omitempty"`
	Metric            string                                                                   `json:"metric,omitempty"`
	Score             float64                                                                  `json:"score,omitempty"`
	Section           string                                                                   `json:"section,omitempty"`
	SectionSummary    string                                                                   `json:"sectionSummary,omitempty"`
	SessionId         string                                                                   `json:"sessionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Decompositions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Decompositions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationEvaluationMetricsSummarizationEvaluationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsSummarizationEvaluationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SummarizationEvaluationMetricsSummarizationEvaluationResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SummarizationEvaluationMetricsSummarizationEvaluationResult
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

type GoogleCloudDialogflowV2SummarizationSection struct {
	Definition string `json:"definition,omitempty"`
	Key        string `json:"key,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "SITUATION"
	//   "ACTION"
	//   "RESOLUTION"
	//   "REASON_FOR_CANCELLATION"
	//   "CUSTOMER_SATISFACTION"
	//   "ENTITIES"
	//   "CUSTOMER_DEFINED"
	//   "SITUATION_CONCISE"
	//   "ACTION_CONCISE"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Definition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Definition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationSection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationSection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarizationSectionList struct {
	SummarizationSections []*GoogleCloudDialogflowV2SummarizationSection `json:"summarizationSections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SummarizationSections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SummarizationSections") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarizationSectionList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarizationSectionList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarySuggestion struct {
	SummarySections []*GoogleCloudDialogflowV2SummarySuggestionSummarySection `json:"summarySections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SummarySections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SummarySections") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarySuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarySuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarySuggestionSummarySection struct {
	Section string `json:"section,omitempty"`
	Summary string `json:"summary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Section") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Section") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarySuggestionSummarySection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarySuggestionSummarySection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SynthesizeSpeechConfig struct {
	EffectsProfileId []string                                            `json:"effectsProfileId,omitempty"`
	Pitch            float64                                             `json:"pitch,omitempty"`
	Pronunciations   []*GoogleCloudDialogflowV2CustomPronunciationParams `json:"pronunciations,omitempty"`
	SpeakingRate     float64                                             `json:"speakingRate,omitempty"`
	Voice            *GoogleCloudDialogflowV2VoiceSelectionParams        `json:"voice,omitempty"`
	VolumeGainDb     float64                                             `json:"volumeGainDb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EffectsProfileId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EffectsProfileId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SynthesizeSpeechConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SynthesizeSpeechConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SynthesizeSpeechConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SynthesizeSpeechConfig
	var s1 struct {
		Pitch        gensupport.JSONFloat64 `json:"pitch"`
		SpeakingRate gensupport.JSONFloat64 `json:"speakingRate"`
		VolumeGainDb gensupport.JSONFloat64 `json:"volumeGainDb"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Pitch = float64(s1.Pitch)
	s.SpeakingRate = float64(s1.SpeakingRate)
	s.VolumeGainDb = float64(s1.VolumeGainDb)
	return nil
}

type GoogleCloudDialogflowV2TextInput struct {
	LanguageCode string `json:"languageCode,omitempty"`
	Text         string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2TextInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2TextInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2TextToSpeechSettings struct {
	EnableTextToSpeech bool `json:"enableTextToSpeech,omitempty"`
	// Possible values:
	//   "OUTPUT_AUDIO_ENCODING_UNSPECIFIED"
	//   "OUTPUT_AUDIO_ENCODING_LINEAR_16"
	//   "OUTPUT_AUDIO_ENCODING_MP3"
	//   "OUTPUT_AUDIO_ENCODING_MP3_64_KBPS"
	//   "OUTPUT_AUDIO_ENCODING_OGG_OPUS"
	//   "OUTPUT_AUDIO_ENCODING_MULAW"
	//   "OUTPUT_AUDIO_ENCODING_ALAW"
	OutputAudioEncoding     string                                                   `json:"outputAudioEncoding,omitempty"`
	SampleRateHertz         int64                                                    `json:"sampleRateHertz,omitempty"`
	SynthesizeSpeechConfigs map[string]GoogleCloudDialogflowV2SynthesizeSpeechConfig `json:"synthesizeSpeechConfigs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableTextToSpeech") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableTextToSpeech") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2TextToSpeechSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2TextToSpeechSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Tool struct {
	ActionConfirmationRequirement map[string]string                         `json:"actionConfirmationRequirement,omitempty"`
	ConnectorSpec                 *GoogleCloudDialogflowV2ToolConnectorTool `json:"connectorSpec,omitempty"`
	CreateTime                    string                                    `json:"createTime,omitempty"`
	Description                   string                                    `json:"description,omitempty"`
	DisplayName                   string                                    `json:"displayName,omitempty"`
	ExtensionSpec                 *GoogleCloudDialogflowV2ToolExtensionTool `json:"extensionSpec,omitempty"`
	FunctionSpec                  *GoogleCloudDialogflowV2ToolFunctionTool  `json:"functionSpec,omitempty"`
	Name                          string                                    `json:"name,omitempty"`
	OpenApiSpec                   *GoogleCloudDialogflowV2ToolOpenApiTool   `json:"openApiSpec,omitempty"`
	SatisfiesPzi                  bool                                      `json:"satisfiesPzi,omitempty"`
	SatisfiesPzs                  bool                                      `json:"satisfiesPzs,omitempty"`
	ToolKey                       string                                    `json:"toolKey,omitempty"`
	UpdateTime                    string                                    `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "ActionConfirmationRequirement") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionConfirmationRequirement")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Tool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Tool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolAuthentication struct {
	ApiKeyConfig           *GoogleCloudDialogflowV2ToolAuthenticationApiKeyConfig           `json:"apiKeyConfig,omitempty"`
	BearerTokenConfig      *GoogleCloudDialogflowV2ToolAuthenticationBearerTokenConfig      `json:"bearerTokenConfig,omitempty"`
	OauthConfig            *GoogleCloudDialogflowV2ToolAuthenticationOAuthConfig            `json:"oauthConfig,omitempty"`
	ServiceAgentAuthConfig *GoogleCloudDialogflowV2ToolAuthenticationServiceAgentAuthConfig `json:"serviceAgentAuthConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolAuthentication) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolAuthentication
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolAuthenticationApiKeyConfig struct {
	ApiKey  string `json:"apiKey,omitempty"`
	KeyName string `json:"keyName,omitempty"`
	// Possible values:
	//   "REQUEST_LOCATION_UNSPECIFIED"
	//   "HEADER"
	//   "QUERY_STRING"
	RequestLocation        string `json:"requestLocation,omitempty"`
	SecretVersionForApiKey string `json:"secretVersionForApiKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolAuthenticationApiKeyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolAuthenticationApiKeyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolAuthenticationBearerTokenConfig struct {
	SecretVersionForToken string `json:"secretVersionForToken,omitempty"`
	Token                 string `json:"token,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecretVersionForToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecretVersionForToken") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolAuthenticationBearerTokenConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolAuthenticationBearerTokenConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolAuthenticationOAuthConfig struct {
	ClientId     string `json:"clientId,omitempty"`
	ClientSecret string `json:"clientSecret,omitempty"`
	// Possible values:
	//   "OAUTH_GRANT_TYPE_UNSPECIFIED"
	//   "CLIENT_CREDENTIAL"
	OauthGrantType               string   `json:"oauthGrantType,omitempty"`
	Scopes                       []string `json:"scopes,omitempty"`
	SecretVersionForClientSecret string   `json:"secretVersionForClientSecret,omitempty"`
	TokenEndpoint                string   `json:"tokenEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolAuthenticationOAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolAuthenticationOAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolAuthenticationServiceAgentAuthConfig struct {
	// Possible values:
	//   "SERVICE_AGENT_AUTH_UNSPECIFIED"
	//   "ID_TOKEN"
	//   "ACCESS_TOKEN"
	ServiceAgentAuth string `json:"serviceAgentAuth,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAgentAuth") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAgentAuth") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolAuthenticationServiceAgentAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolAuthenticationServiceAgentAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolCall struct {
	Action          string               `json:"action,omitempty"`
	AnswerRecord    string               `json:"answerRecord,omitempty"`
	CreateTime      string               `json:"createTime,omitempty"`
	InputParameters googleapi.RawMessage `json:"inputParameters,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "TRIGGERED"
	//   "NEEDS_CONFIRMATION"
	State              string `json:"state,omitempty"`
	Tool               string `json:"tool,omitempty"`
	ToolDisplayDetails string `json:"toolDisplayDetails,omitempty"`
	ToolDisplayName    string `json:"toolDisplayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolCallResult struct {
	Action       string                                      `json:"action,omitempty"`
	AnswerRecord string                                      `json:"answerRecord,omitempty"`
	Content      string                                      `json:"content,omitempty"`
	CreateTime   string                                      `json:"createTime,omitempty"`
	Error        *GoogleCloudDialogflowV2ToolCallResultError `json:"error,omitempty"`
	RawContent   string                                      `json:"rawContent,omitempty"`
	Tool         string                                      `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolCallResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolCallResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolCallResultError struct {
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolCallResultError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolCallResultError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolConnectorTool struct {
	Actions []*GoogleCloudDialogflowV2ToolConnectorToolAction `json:"actions,omitempty"`
	Name    string                                            `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolConnectorTool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolConnectorTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolConnectorToolAction struct {
	ConnectionActionId string                                                         `json:"connectionActionId,omitempty"`
	EntityOperation    *GoogleCloudDialogflowV2ToolConnectorToolActionEntityOperation `json:"entityOperation,omitempty"`
	InputFields        []string                                                       `json:"inputFields,omitempty"`
	OutputFields       []string                                                       `json:"outputFields,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectionActionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectionActionId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolConnectorToolAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolConnectorToolAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolConnectorToolActionEntityOperation struct {
	EntityId string `json:"entityId,omitempty"`
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED"
	//   "LIST"
	//   "GET"
	//   "CREATE"
	//   "UPDATE"
	//   "DELETE"
	Operation string `json:"operation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolConnectorToolActionEntityOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolConnectorToolActionEntityOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolExtensionTool struct {
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolExtensionTool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolExtensionTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolFunctionTool struct {
	InputSchema googleapi.RawMessage `json:"inputSchema,omitempty"`
	// Possible values:
	//   "METHOD_TYPE_UNSPECIFIED"
	//   "GET"
	//   "POST"
	//   "PUT"
	//   "DELETE"
	//   "PATCH"
	MethodType   string               `json:"methodType,omitempty"`
	OutputSchema googleapi.RawMessage `json:"outputSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolFunctionTool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolFunctionTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolOpenApiTool struct {
	Authentication         *GoogleCloudDialogflowV2ToolAuthentication         `json:"authentication,omitempty"`
	ServiceDirectoryConfig *GoogleCloudDialogflowV2ToolServiceDirectoryConfig `json:"serviceDirectoryConfig,omitempty"`
	TextSchema             string                                             `json:"textSchema,omitempty"`
	TlsConfig              *GoogleCloudDialogflowV2ToolTLSConfig              `json:"tlsConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Authentication") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Authentication") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolOpenApiTool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolOpenApiTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolServiceDirectoryConfig struct {
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Service") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Service") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolServiceDirectoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolServiceDirectoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolTLSConfig struct {
	CaCerts []*GoogleCloudDialogflowV2ToolTLSConfigCACert `json:"caCerts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaCerts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaCerts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolTLSConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolTLSConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolTLSConfigCACert struct {
	Cert        string `json:"cert,omitempty"`
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cert") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cert") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolTLSConfigCACert) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolTLSConfigCACert
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2TrainAgentRequest struct {
}

type GoogleCloudDialogflowV2UndeployConversationModelOperationMetadata struct {
	ConversationModel string `json:"conversationModel,omitempty"`
	CreateTime        string `json:"createTime,omitempty"`
	DoneTime          string `json:"doneTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2UndeployConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2UndeployConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2UndeployConversationModelRequest struct {
}

type GoogleCloudDialogflowV2ValidationError struct {
	Entries      []string `json:"entries,omitempty"`
	ErrorMessage string   `json:"errorMessage,omitempty"`
	// Possible values:
	//   "SEVERITY_UNSPECIFIED"
	//   "INFO"
	//   "WARNING"
	//   "ERROR"
	//   "CRITICAL"
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ValidationError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ValidationError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ValidationResult struct {
	ValidationErrors []*GoogleCloudDialogflowV2ValidationError `json:"validationErrors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ValidationErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ValidationErrors") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ValidationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ValidationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Version struct {
	CreateTime  string `json:"createTime,omitempty"`
	Description string `json:"description,omitempty"`
	Name        string `json:"name,omitempty"`
	// Possible values:
	//   "VERSION_STATUS_UNSPECIFIED"
	//   "IN_PROGRESS"
	//   "READY"
	//   "FAILED"
	Status        string `json:"status,omitempty"`
	VersionNumber int64  `json:"versionNumber,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Version) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Version
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2VoiceSelectionParams struct {
	Name string `json:"name,omitempty"`
	// Possible values:
	//   "SSML_VOICE_GENDER_UNSPECIFIED"
	//   "SSML_VOICE_GENDER_MALE"
	//   "SSML_VOICE_GENDER_FEMALE"
	//   "SSML_VOICE_GENDER_NEUTRAL"
	SsmlGender string `json:"ssmlGender,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2VoiceSelectionParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2VoiceSelectionParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2WebhookRequest struct {
	OriginalDetectIntentRequest *GoogleCloudDialogflowV2OriginalDetectIntentRequest `json:"originalDetectIntentRequest,omitempty"`
	QueryResult                 *GoogleCloudDialogflowV2QueryResult                 `json:"queryResult,omitempty"`
	ResponseId                  string                                              `json:"responseId,omitempty"`
	Session                     string                                              `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "OriginalDetectIntentRequest") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OriginalDetectIntentRequest") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2WebhookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2WebhookResponse struct {
	FollowupEventInput  *GoogleCloudDialogflowV2EventInput          `json:"followupEventInput,omitempty"`
	FulfillmentMessages []*GoogleCloudDialogflowV2IntentMessage     `json:"fulfillmentMessages,omitempty"`
	FulfillmentText     string                                      `json:"fulfillmentText,omitempty"`
	OutputContexts      []*GoogleCloudDialogflowV2Context           `json:"outputContexts,omitempty"`
	Payload             googleapi.RawMessage                        `json:"payload,omitempty"`
	SessionEntityTypes  []*GoogleCloudDialogflowV2SessionEntityType `json:"sessionEntityTypes,omitempty"`
	Source              string                                      `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FollowupEventInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FollowupEventInput") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2WebhookResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AgentCoachingInstruction struct {
	AgentAction          string                                                                    `json:"agentAction,omitempty"`
	Condition            string                                                                    `json:"condition,omitempty"`
	DisplayDetails       string                                                                    `json:"displayDetails,omitempty"`
	DisplayName          string                                                                    `json:"displayName,omitempty"`
	DuplicateCheckResult *GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	SystemAction         string                                                                    `json:"systemAction,omitempty"`
	// Possible values:
	//   "TRIGGER_EVENT_UNSPECIFIED"
	//   "END_OF_UTTERANCE"
	//   "MANUAL_CALL"
	//   "CUSTOMER_MESSAGE"
	//   "AGENT_MESSAGE"
	//   "TOOL_CALL_COMPLETION"
	TriggeringEvent string `json:"triggeringEvent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingInstruction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingInstruction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult struct {
	DuplicateSuggestions []*GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion `json:"duplicateSuggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateSuggestions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion struct {
	AnswerRecord    string  `json:"answerRecord,omitempty"`
	SimilarityScore float64 `json:"similarityScore,omitempty"`
	SuggestionIndex int64   `json:"suggestionIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion
	var s1 struct {
		SimilarityScore gensupport.JSONFloat64 `json:"similarityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SimilarityScore = float64(s1.SimilarityScore)
	return nil
}

type GoogleCloudDialogflowV2beta1AgentCoachingSuggestion struct {
	AgentActionSuggestions []*GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion `json:"agentActionSuggestions,omitempty"`
	ApplicableInstructions []*GoogleCloudDialogflowV2beta1AgentCoachingInstruction                     `json:"applicableInstructions,omitempty"`
	SampleResponses        []*GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse        `json:"sampleResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentActionSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentActionSuggestions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion struct {
	AgentAction          string                                                                   `json:"agentAction,omitempty"`
	DuplicateCheckResult *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	Sources              *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources              `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult struct {
	DuplicateSuggestions []*GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion `json:"duplicateSuggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateSuggestions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion struct {
	AnswerRecord    string                                                      `json:"answerRecord,omitempty"`
	SimilarityScore float64                                                     `json:"similarityScore,omitempty"`
	Sources         *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources `json:"sources,omitempty"`
	SuggestionIndex int64                                                       `json:"suggestionIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion
	var s1 struct {
		SimilarityScore gensupport.JSONFloat64 `json:"similarityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SimilarityScore = float64(s1.SimilarityScore)
	return nil
}

type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse struct {
	DuplicateCheckResult *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	ResponseText         string                                                                   `json:"responseText,omitempty"`
	Sources              *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources              `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateCheckResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateCheckResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources struct {
	InstructionIndexes []int64 `json:"instructionIndexes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstructionIndexes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstructionIndexes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AnnotatedMessagePart struct {
	EntityType     string      `json:"entityType,omitempty"`
	FormattedValue interface{} `json:"formattedValue,omitempty"`
	Text           string      `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AnnotatedMessagePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AnnotatedMessagePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ArticleAnswer struct {
	AnswerRecord string            `json:"answerRecord,omitempty"`
	Metadata     map[string]string `json:"metadata,omitempty"`
	Snippets     []string          `json:"snippets,omitempty"`
	Title        string            `json:"title,omitempty"`
	Uri          string            `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ArticleAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ArticleAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse struct {
	EntityTypes []*GoogleCloudDialogflowV2beta1EntityType `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse struct {
	Intents []*GoogleCloudDialogflowV2beta1Intent `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigOperationMetadata struct {
	ConversationProfile string `json:"conversationProfile,omitempty"`
	CreateTime          string `json:"createTime,omitempty"`
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	ParticipantRole string `json:"participantRole,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "ARTICLE_SUGGESTION"
	//   "FAQ"
	//   "SMART_REPLY"
	//   "DIALOGFLOW_ASSIST"
	//   "CONVERSATION_SUMMARIZATION"
	//   "KNOWLEDGE_SEARCH"
	//   "KNOWLEDGE_ASSIST"
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1Context struct {
	LifespanCount int64                `json:"lifespanCount,omitempty"`
	Name          string               `json:"name,omitempty"`
	Parameters    googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LifespanCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LifespanCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Context) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Context
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ConversationEvent struct {
	Conversation                string                                                  `json:"conversation,omitempty"`
	ErrorStatus                 *GoogleRpcStatus                                        `json:"errorStatus,omitempty"`
	NewMessagePayload           *GoogleCloudDialogflowV2beta1Message                    `json:"newMessagePayload,omitempty"`
	NewRecognitionResultPayload *GoogleCloudDialogflowV2beta1StreamingRecognitionResult `json:"newRecognitionResultPayload,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "CONVERSATION_STARTED"
	//   "CONVERSATION_FINISHED"
	//   "HUMAN_INTERVENTION_NEEDED"
	//   "NEW_MESSAGE"
	//   "NEW_RECOGNITION_RESULT"
	//   "UNRECOVERABLE_ERROR"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ConversationEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ConversationEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1DialogflowAssistAnswer struct {
	AnswerRecord     string                                        `json:"answerRecord,omitempty"`
	IntentSuggestion *GoogleCloudDialogflowV2beta1IntentSuggestion `json:"intentSuggestion,omitempty"`
	QueryResult      *GoogleCloudDialogflowV2beta1QueryResult      `json:"queryResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1DialogflowAssistAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1DialogflowAssistAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1EncryptionSpec struct {
	KmsKey string `json:"kmsKey,omitempty"`
	Name   string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1EntityType struct {
	// Possible values:
	//   "AUTO_EXPANSION_MODE_UNSPECIFIED"
	//   "AUTO_EXPANSION_MODE_DEFAULT"
	AutoExpansionMode     string                                          `json:"autoExpansionMode,omitempty"`
	DisplayName           string                                          `json:"displayName,omitempty"`
	EnableFuzzyExtraction bool                                            `json:"enableFuzzyExtraction,omitempty"`
	Entities              []*GoogleCloudDialogflowV2beta1EntityTypeEntity `json:"entities,omitempty"`
	// Possible values:
	//   "KIND_UNSPECIFIED"
	//   "KIND_MAP"
	//   "KIND_LIST"
	//   "KIND_REGEXP"
	Kind string `json:"kind,omitempty"`
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoExpansionMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoExpansionMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1EntityTypeEntity struct {
	Synonyms []string `json:"synonyms,omitempty"`
	Value    string   `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EntityTypeEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EntityTypeEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1EventInput struct {
	LanguageCode string               `json:"languageCode,omitempty"`
	Name         string               `json:"name,omitempty"`
	Parameters   googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ExportAgentResponse struct {
	AgentContent string `json:"agentContent,omitempty"`
	AgentUri     string `json:"agentUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ExportOperationMetadata struct {
	ExportedGcsDestination *GoogleCloudDialogflowV2beta1GcsDestination `json:"exportedGcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportedGcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportedGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ExportOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ExportOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1FaqAnswer struct {
	Answer       string            `json:"answer,omitempty"`
	AnswerRecord string            `json:"answerRecord,omitempty"`
	Confidence   float64           `json:"confidence,omitempty"`
	Metadata     map[string]string `json:"metadata,omitempty"`
	Question     string            `json:"question,omitempty"`
	Source       string            `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1FaqAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1FaqAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1FaqAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1FaqAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2beta1FreeFormSuggestion struct {
	Response string `json:"response,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Response") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Response") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1FreeFormSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1FreeFormSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1GcsDestination struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse struct {
	GeneratorSuggestionAnswers []*GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAnswer `json:"generatorSuggestionAnswers,omitempty"`
	LatestMessage              string                                                                              `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratorSuggestionAnswers")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorSuggestionAnswers") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAnswer struct {
	AnswerRecord        string                                           `json:"answerRecord,omitempty"`
	GeneratorSuggestion *GoogleCloudDialogflowV2beta1GeneratorSuggestion `json:"generatorSuggestion,omitempty"`
	SourceGenerator     string                                           `json:"sourceGenerator,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1GeneratorSuggestion struct {
	AgentCoachingSuggestion *GoogleCloudDialogflowV2beta1AgentCoachingSuggestion           `json:"agentCoachingSuggestion,omitempty"`
	FreeFormSuggestion      *GoogleCloudDialogflowV2beta1FreeFormSuggestion                `json:"freeFormSuggestion,omitempty"`
	SummarySuggestion       *GoogleCloudDialogflowV2beta1SummarySuggestion                 `json:"summarySuggestion,omitempty"`
	ToolCallInfo            []*GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo `json:"toolCallInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentCoachingSuggestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCoachingSuggestion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GeneratorSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GeneratorSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo struct {
	ToolCall       *GoogleCloudDialogflowV2beta1ToolCall       `json:"toolCall,omitempty"`
	ToolCallResult *GoogleCloudDialogflowV2beta1ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolCall") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolCall") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent struct {
	Conversation      string                                          `json:"conversation,omitempty"`
	Participant       string                                          `json:"participant,omitempty"`
	SuggestionResults []*GoogleCloudDialogflowV2beta1SuggestionResult `json:"suggestionResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ImportDocumentsResponse struct {
	Warnings []*GoogleRpcStatus `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Warnings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Warnings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ImportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfo struct {
	ContextReferenceRetrieved   bool                                                                                       `json:"contextReferenceRetrieved,omitempty"`
	IngestedParametersDebugInfo []*GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfoIngestedParameterDebugInfo `json:"ingestedParametersDebugInfo,omitempty"`
	ProjectNotAllowlisted       bool                                                                                       `json:"projectNotAllowlisted,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextReferenceRetrieved")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextReferenceRetrieved") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfoIngestedParameterDebugInfo struct {
	// Possible values:
	//   "INGESTION_STATUS_UNSPECIFIED"
	//   "INGESTION_STATUS_SUCCEEDED"
	//   "INGESTION_STATUS_CONTEXT_NOT_AVAILABLE"
	//   "INGESTION_STATUS_PARSE_FAILED"
	//   "INGESTION_STATUS_INVALID_ENTRY"
	//   "INGESTION_STATUS_INVALID_FORMAT"
	//   "INGESTION_STATUS_LANGUAGE_MISMATCH"
	IngestionStatus string `json:"ingestionStatus,omitempty"`
	Parameter       string `json:"parameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IngestionStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IngestionStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfoIngestedParameterDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfoIngestedParameterDebugInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1InitializeEncryptionSpecMetadata struct {
	Request *GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Request") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Request") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1InitializeEncryptionSpecMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1InitializeEncryptionSpecMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest struct {
	EncryptionSpec *GoogleCloudDialogflowV2beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1Intent struct {
	Action string `json:"action,omitempty"`
	// Possible values:
	//   "PLATFORM_UNSPECIFIED"
	//   "FACEBOOK"
	//   "SLACK"
	//   "TELEGRAM"
	//   "KIK"
	//   "SKYPE"
	//   "LINE"
	//   "VIBER"
	//   "ACTIONS_ON_GOOGLE"
	//   "TELEPHONY"
	//   "GOOGLE_HANGOUTS"
	DefaultResponsePlatforms []string                                                `json:"defaultResponsePlatforms,omitempty"`
	DisplayName              string                                                  `json:"displayName,omitempty"`
	EndInteraction           bool                                                    `json:"endInteraction,omitempty"`
	Events                   []string                                                `json:"events,omitempty"`
	FollowupIntentInfo       []*GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo `json:"followupIntentInfo,omitempty"`
	InputContextNames        []string                                                `json:"inputContextNames,omitempty"`
	IsFallback               bool                                                    `json:"isFallback,omitempty"`
	LiveAgentHandoff         bool                                                    `json:"liveAgentHandoff,omitempty"`
	Messages                 []*GoogleCloudDialogflowV2beta1IntentMessage            `json:"messages,omitempty"`
	MlDisabled               bool                                                    `json:"mlDisabled,omitempty"`
	MlEnabled                bool                                                    `json:"mlEnabled,omitempty"`
	Name                     string                                                  `json:"name,omitempty"`
	OutputContexts           []*GoogleCloudDialogflowV2beta1Context                  `json:"outputContexts,omitempty"`
	Parameters               []*GoogleCloudDialogflowV2beta1IntentParameter          `json:"parameters,omitempty"`
	ParentFollowupIntentName string                                                  `json:"parentFollowupIntentName,omitempty"`
	Priority                 int64                                                   `json:"priority,omitempty"`
	ResetContexts            bool                                                    `json:"resetContexts,omitempty"`
	RootFollowupIntentName   string                                                  `json:"rootFollowupIntentName,omitempty"`
	TrainingPhrases          []*GoogleCloudDialogflowV2beta1IntentTrainingPhrase     `json:"trainingPhrases,omitempty"`
	// Possible values:
	//   "WEBHOOK_STATE_UNSPECIFIED"
	//   "WEBHOOK_STATE_ENABLED"
	//   "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING"
	WebhookState string `json:"webhookState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo struct {
	FollowupIntentName       string `json:"followupIntentName,omitempty"`
	ParentFollowupIntentName string `json:"parentFollowupIntentName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FollowupIntentName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FollowupIntentName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessage struct {
	BasicCard          *GoogleCloudDialogflowV2beta1IntentMessageBasicCard          `json:"basicCard,omitempty"`
	BrowseCarouselCard *GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard `json:"browseCarouselCard,omitempty"`
	Card               *GoogleCloudDialogflowV2beta1IntentMessageCard               `json:"card,omitempty"`
	CarouselSelect     *GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect     `json:"carouselSelect,omitempty"`
	Image              *GoogleCloudDialogflowV2beta1IntentMessageImage              `json:"image,omitempty"`
	LinkOutSuggestion  *GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion  `json:"linkOutSuggestion,omitempty"`
	ListSelect         *GoogleCloudDialogflowV2beta1IntentMessageListSelect         `json:"listSelect,omitempty"`
	MediaContent       *GoogleCloudDialogflowV2beta1IntentMessageMediaContent       `json:"mediaContent,omitempty"`
	Payload            googleapi.RawMessage                                         `json:"payload,omitempty"`
	// Possible values:
	//   "PLATFORM_UNSPECIFIED"
	//   "FACEBOOK"
	//   "SLACK"
	//   "TELEGRAM"
	//   "KIK"
	//   "SKYPE"
	//   "LINE"
	//   "VIBER"
	//   "ACTIONS_ON_GOOGLE"
	//   "TELEPHONY"
	//   "GOOGLE_HANGOUTS"
	Platform                  string                                                              `json:"platform,omitempty"`
	QuickReplies              *GoogleCloudDialogflowV2beta1IntentMessageQuickReplies              `json:"quickReplies,omitempty"`
	RbmCarouselRichCard       *GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard           `json:"rbmCarouselRichCard,omitempty"`
	RbmStandaloneRichCard     *GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard         `json:"rbmStandaloneRichCard,omitempty"`
	RbmText                   *GoogleCloudDialogflowV2beta1IntentMessageRbmText                   `json:"rbmText,omitempty"`
	SimpleResponses           *GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses           `json:"simpleResponses,omitempty"`
	Suggestions               *GoogleCloudDialogflowV2beta1IntentMessageSuggestions               `json:"suggestions,omitempty"`
	TableCard                 *GoogleCloudDialogflowV2beta1IntentMessageTableCard                 `json:"tableCard,omitempty"`
	TelephonyPlayAudio        *GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio        `json:"telephonyPlayAudio,omitempty"`
	TelephonySynthesizeSpeech *GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech `json:"telephonySynthesizeSpeech,omitempty"`
	TelephonyTransferCall     *GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall     `json:"telephonyTransferCall,omitempty"`
	Text                      *GoogleCloudDialogflowV2beta1IntentMessageText                      `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicCard") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicCard") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageBasicCard struct {
	Buttons       []*GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton `json:"buttons,omitempty"`
	FormattedText string                                                      `json:"formattedText,omitempty"`
	Image         *GoogleCloudDialogflowV2beta1IntentMessageImage             `json:"image,omitempty"`
	Subtitle      string                                                      `json:"subtitle,omitempty"`
	Title         string                                                      `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBasicCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBasicCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton struct {
	OpenUriAction *GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction `json:"openUriAction,omitempty"`
	Title         string                                                                 `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OpenUriAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OpenUriAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard struct {
	// Possible values:
	//   "IMAGE_DISPLAY_OPTIONS_UNSPECIFIED"
	//   "GRAY"
	//   "WHITE"
	//   "CROPPED"
	//   "BLURRED_BACKGROUND"
	ImageDisplayOptions string                                                                               `json:"imageDisplayOptions,omitempty"`
	Items               []*GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageDisplayOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageDisplayOptions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem struct {
	Description   string                                                                                          `json:"description,omitempty"`
	Footer        string                                                                                          `json:"footer,omitempty"`
	Image         *GoogleCloudDialogflowV2beta1IntentMessageImage                                                 `json:"image,omitempty"`
	OpenUriAction *GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction `json:"openUriAction,omitempty"`
	Title         string                                                                                          `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction struct {
	Url string `json:"url,omitempty"`
	// Possible values:
	//   "URL_TYPE_HINT_UNSPECIFIED"
	//   "AMP_ACTION"
	//   "AMP_CONTENT"
	UrlTypeHint string `json:"urlTypeHint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Url") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Url") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageCard struct {
	Buttons  []*GoogleCloudDialogflowV2beta1IntentMessageCardButton `json:"buttons,omitempty"`
	ImageUri string                                                 `json:"imageUri,omitempty"`
	Subtitle string                                                 `json:"subtitle,omitempty"`
	Title    string                                                 `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageCardButton struct {
	Postback string `json:"postback,omitempty"`
	Text     string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Postback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Postback") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCardButton
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect struct {
	Items []*GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem struct {
	Description string                                                   `json:"description,omitempty"`
	Image       *GoogleCloudDialogflowV2beta1IntentMessageImage          `json:"image,omitempty"`
	Info        *GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo `json:"info,omitempty"`
	Title       string                                                   `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageColumnProperties struct {
	Header string `json:"header,omitempty"`
	// Possible values:
	//   "HORIZONTAL_ALIGNMENT_UNSPECIFIED"
	//   "LEADING"
	//   "CENTER"
	//   "TRAILING"
	HorizontalAlignment string `json:"horizontalAlignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Header") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Header") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageColumnProperties) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageColumnProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageImage struct {
	AccessibilityText string `json:"accessibilityText,omitempty"`
	ImageUri          string `json:"imageUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessibilityText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessibilityText") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion struct {
	DestinationName string `json:"destinationName,omitempty"`
	Uri             string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageListSelect struct {
	Items    []*GoogleCloudDialogflowV2beta1IntentMessageListSelectItem `json:"items,omitempty"`
	Subtitle string                                                     `json:"subtitle,omitempty"`
	Title    string                                                     `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageListSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageListSelect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageListSelectItem struct {
	Description string                                                   `json:"description,omitempty"`
	Image       *GoogleCloudDialogflowV2beta1IntentMessageImage          `json:"image,omitempty"`
	Info        *GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo `json:"info,omitempty"`
	Title       string                                                   `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageListSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageListSelectItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageMediaContent struct {
	MediaObjects []*GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject `json:"mediaObjects,omitempty"`
	// Possible values:
	//   "RESPONSE_MEDIA_TYPE_UNSPECIFIED"
	//   "AUDIO"
	MediaType string `json:"mediaType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MediaObjects") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MediaObjects") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageMediaContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageMediaContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject struct {
	ContentUrl  string                                          `json:"contentUrl,omitempty"`
	Description string                                          `json:"description,omitempty"`
	Icon        *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"icon,omitempty"`
	LargeImage  *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"largeImage,omitempty"`
	Name        string                                          `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageQuickReplies struct {
	QuickReplies []string `json:"quickReplies,omitempty"`
	Title        string   `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuickReplies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuickReplies") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageQuickReplies) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageQuickReplies
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent struct {
	Description string                                                           `json:"description,omitempty"`
	Media       *GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia `json:"media,omitempty"`
	Suggestions []*GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion        `json:"suggestions,omitempty"`
	Title       string                                                           `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia struct {
	FileUri string `json:"fileUri,omitempty"`
	// Possible values:
	//   "HEIGHT_UNSPECIFIED"
	//   "SHORT"
	//   "MEDIUM"
	//   "TALL"
	Height       string `json:"height,omitempty"`
	ThumbnailUri string `json:"thumbnailUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard struct {
	CardContents []*GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent `json:"cardContents,omitempty"`
	// Possible values:
	//   "CARD_WIDTH_UNSPECIFIED"
	//   "SMALL"
	//   "MEDIUM"
	CardWidth string `json:"cardWidth,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CardContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CardContents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard struct {
	CardContent *GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent `json:"cardContent,omitempty"`
	// Possible values:
	//   "CARD_ORIENTATION_UNSPECIFIED"
	//   "HORIZONTAL"
	//   "VERTICAL"
	CardOrientation string `json:"cardOrientation,omitempty"`
	// Possible values:
	//   "THUMBNAIL_IMAGE_ALIGNMENT_UNSPECIFIED"
	//   "LEFT"
	//   "RIGHT"
	ThumbnailImageAlignment string `json:"thumbnailImageAlignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CardContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CardContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction struct {
	Dial          *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial          `json:"dial,omitempty"`
	OpenUrl       *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri       `json:"openUrl,omitempty"`
	PostbackData  string                                                                                      `json:"postbackData,omitempty"`
	ShareLocation *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocation `json:"shareLocation,omitempty"`
	Text          string                                                                                      `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dial") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dial") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial struct {
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocation struct {
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply struct {
	PostbackData string `json:"postbackData,omitempty"`
	Text         string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PostbackData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PostbackData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion struct {
	Action *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction `json:"action,omitempty"`
	Reply  *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply  `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmText struct {
	RbmSuggestion []*GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion `json:"rbmSuggestion,omitempty"`
	Text          string                                                    `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RbmSuggestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RbmSuggestion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo struct {
	Key      string   `json:"key,omitempty"`
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse struct {
	DisplayText  string `json:"displayText,omitempty"`
	Ssml         string `json:"ssml,omitempty"`
	TextToSpeech string `json:"textToSpeech,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses struct {
	SimpleResponses []*GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse `json:"simpleResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SimpleResponses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SimpleResponses") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageSuggestion struct {
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Title") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Title") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageSuggestions struct {
	Suggestions []*GoogleCloudDialogflowV2beta1IntentMessageSuggestion `json:"suggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Suggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Suggestions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSuggestions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSuggestions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageTableCard struct {
	Buttons          []*GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton  `json:"buttons,omitempty"`
	ColumnProperties []*GoogleCloudDialogflowV2beta1IntentMessageColumnProperties `json:"columnProperties,omitempty"`
	Image            *GoogleCloudDialogflowV2beta1IntentMessageImage              `json:"image,omitempty"`
	Rows             []*GoogleCloudDialogflowV2beta1IntentMessageTableCardRow     `json:"rows,omitempty"`
	Subtitle         string                                                       `json:"subtitle,omitempty"`
	Title            string                                                       `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTableCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTableCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageTableCardCell struct {
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTableCardCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTableCardCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageTableCardRow struct {
	Cells        []*GoogleCloudDialogflowV2beta1IntentMessageTableCardCell `json:"cells,omitempty"`
	DividerAfter bool                                                      `json:"dividerAfter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTableCardRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTableCardRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio struct {
	AudioUri string `json:"audioUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech struct {
	Ssml string `json:"ssml,omitempty"`
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Ssml") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Ssml") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall struct {
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageText struct {
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentParameter struct {
	DefaultValue          string   `json:"defaultValue,omitempty"`
	DisplayName           string   `json:"displayName,omitempty"`
	EntityTypeDisplayName string   `json:"entityTypeDisplayName,omitempty"`
	IsList                bool     `json:"isList,omitempty"`
	Mandatory             bool     `json:"mandatory,omitempty"`
	Name                  string   `json:"name,omitempty"`
	Prompts               []string `json:"prompts,omitempty"`
	Value                 string   `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentSuggestion struct {
	Description string `json:"description,omitempty"`
	DisplayName string `json:"displayName,omitempty"`
	IntentV2    string `json:"intentV2,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentTrainingPhrase struct {
	Name            string                                                  `json:"name,omitempty"`
	Parts           []*GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart `json:"parts,omitempty"`
	TimesAddedCount int64                                                   `json:"timesAddedCount,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "EXAMPLE"
	//   "TEMPLATE"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart struct {
	Alias       string `json:"alias,omitempty"`
	EntityType  string `json:"entityType,omitempty"`
	Text        string `json:"text,omitempty"`
	UserDefined bool   `json:"userDefined,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAnswers struct {
	Answers []*GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer `json:"answers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAnswers) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAnswers
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer struct {
	Answer          string  `json:"answer,omitempty"`
	FaqQuestion     string  `json:"faqQuestion,omitempty"`
	MatchConfidence float64 `json:"matchConfidence,omitempty"`
	// Possible values:
	//   "MATCH_CONFIDENCE_LEVEL_UNSPECIFIED"
	//   "LOW"
	//   "MEDIUM"
	//   "HIGH"
	MatchConfidenceLevel string `json:"matchConfidenceLevel,omitempty"`
	Source               string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer
	var s1 struct {
		MatchConfidence gensupport.JSONFloat64 `json:"matchConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MatchConfidence = float64(s1.MatchConfidence)
	return nil
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswer struct {
	AnswerRecord             string                                                            `json:"answerRecord,omitempty"`
	KnowledgeAssistDebugInfo *GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfo             `json:"knowledgeAssistDebugInfo,omitempty"`
	SuggestedQuery           *GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery  `json:"suggestedQuery,omitempty"`
	SuggestedQueryAnswer     *GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer `json:"suggestedQueryAnswer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer struct {
	AnswerText       string                                                                            `json:"answerText,omitempty"`
	FaqSource        *GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource        `json:"faqSource,omitempty"`
	GenerativeSource *GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource `json:"generativeSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource struct {
	Question string `json:"question,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Question") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Question") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource struct {
	Snippets []*GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet `json:"snippets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Snippets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Snippets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	Text     string               `json:"text,omitempty"`
	Title    string               `json:"title,omitempty"`
	Uri      string               `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery struct {
	QueryText string `json:"queryText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfo struct {
	// Possible values:
	//   "DATASTORE_RESPONSE_REASON_UNSPECIFIED"
	//   "NONE"
	//   "SEARCH_OUT_OF_QUOTA"
	//   "SEARCH_EMPTY_RESULTS"
	//   "ANSWER_GENERATION_GEN_AI_DISABLED"
	//   "ANSWER_GENERATION_OUT_OF_QUOTA"
	//   "ANSWER_GENERATION_ERROR"
	//   "ANSWER_GENERATION_NOT_ENOUGH_INFO"
	//   "ANSWER_GENERATION_RAI_FAILED"
	//   "ANSWER_GENERATION_NOT_GROUNDED"
	DatastoreResponseReason           string                                                                       `json:"datastoreResponseReason,omitempty"`
	IngestedContextReferenceDebugInfo *GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfo               `json:"ingestedContextReferenceDebugInfo,omitempty"`
	KnowledgeAssistBehavior           *GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfoKnowledgeAssistBehavior `json:"knowledgeAssistBehavior,omitempty"`
	// Possible values:
	//   "QUERY_CATEGORIZATION_FAILURE_REASON_UNSPECIFIED"
	//   "QUERY_CATEGORIZATION_INVALID_CONFIG"
	//   "QUERY_CATEGORIZATION_RESULT_NOT_FOUND"
	//   "QUERY_CATEGORIZATION_FAILED"
	QueryCategorizationFailureReason string `json:"queryCategorizationFailureReason,omitempty"`
	// Possible values:
	//   "QUERY_GENERATION_FAILURE_REASON_UNSPECIFIED"
	//   "QUERY_GENERATION_OUT_OF_QUOTA"
	//   "QUERY_GENERATION_FAILED"
	//   "QUERY_GENERATION_NO_QUERY_GENERATED"
	//   "QUERY_GENERATION_RAI_FAILED"
	//   "NOT_IN_ALLOWLIST"
	//   "QUERY_GENERATION_QUERY_REDACTED"
	//   "QUERY_GENERATION_LLM_RESPONSE_PARSE_FAILED"
	//   "QUERY_GENERATION_EMPTY_CONVERSATION"
	//   "QUERY_GENERATION_EMPTY_LAST_MESSAGE"
	//   "QUERY_GENERATION_TRIGGERING_EVENT_CONDITION_NOT_MET"
	QueryGenerationFailureReason string                                      `json:"queryGenerationFailureReason,omitempty"`
	ServiceLatency               *GoogleCloudDialogflowV2beta1ServiceLatency `json:"serviceLatency,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatastoreResponseReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatastoreResponseReason") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfoKnowledgeAssistBehavior struct {
	AnswerGenerationRewriterOn              bool  `json:"answerGenerationRewriterOn,omitempty"`
	AppendedSearchContextCount              int64 `json:"appendedSearchContextCount,omitempty"`
	ConversationTranscriptHasMixedLanguages bool  `json:"conversationTranscriptHasMixedLanguages,omitempty"`
	DisableSyncDelivery                     bool  `json:"disableSyncDelivery,omitempty"`
	EndUserMetadataIncluded                 bool  `json:"endUserMetadataIncluded,omitempty"`
	InvalidItemsQuerySuggestionSkipped      bool  `json:"invalidItemsQuerySuggestionSkipped,omitempty"`
	MultipleQueriesGenerated                bool  `json:"multipleQueriesGenerated,omitempty"`
	PreviousQueriesIncluded                 bool  `json:"previousQueriesIncluded,omitempty"`
	PrimaryQueryRedactedAndReplaced         bool  `json:"primaryQueryRedactedAndReplaced,omitempty"`
	QueryContainedSearchContext             bool  `json:"queryContainedSearchContext,omitempty"`
	QueryGenerationAgentLanguageMismatch    bool  `json:"queryGenerationAgentLanguageMismatch,omitempty"`
	QueryGenerationEndUserLanguageMismatch  bool  `json:"queryGenerationEndUserLanguageMismatch,omitempty"`
	ReturnQueryOnly                         bool  `json:"returnQueryOnly,omitempty"`
	ThirdPartyConnectorAllowed              bool  `json:"thirdPartyConnectorAllowed,omitempty"`
	UseCustomSafetyFilterLevel              bool  `json:"useCustomSafetyFilterLevel,omitempty"`
	UsePubsubDelivery                       bool  `json:"usePubsubDelivery,omitempty"`
	UseTranslatedMessage                    bool  `json:"useTranslatedMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerGenerationRewriterOn")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerGenerationRewriterOn") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfoKnowledgeAssistBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfoKnowledgeAssistBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata struct {
	DoneTime                string                                               `json:"doneTime,omitempty"`
	ExportOperationMetadata *GoogleCloudDialogflowV2beta1ExportOperationMetadata `json:"exportOperationMetadata,omitempty"`
	KnowledgeBase           string                                               `json:"knowledgeBase,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "PENDING"
	//   "RUNNING"
	//   "DONE"
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DoneTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DoneTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1Message struct {
	Content           string                                         `json:"content,omitempty"`
	CreateTime        string                                         `json:"createTime,omitempty"`
	LanguageCode      string                                         `json:"languageCode,omitempty"`
	MessageAnnotation *GoogleCloudDialogflowV2beta1MessageAnnotation `json:"messageAnnotation,omitempty"`
	Name              string                                         `json:"name,omitempty"`
	Participant       string                                         `json:"participant,omitempty"`
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	ParticipantRole   string                                               `json:"participantRole,omitempty"`
	ResponseMessages  []*GoogleCloudDialogflowV2beta1ResponseMessage       `json:"responseMessages,omitempty"`
	SendTime          string                                               `json:"sendTime,omitempty"`
	SentimentAnalysis *GoogleCloudDialogflowV2beta1SentimentAnalysisResult `json:"sentimentAnalysis,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Message) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Message
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1MessageAnnotation struct {
	ContainEntities bool                                                `json:"containEntities,omitempty"`
	Parts           []*GoogleCloudDialogflowV2beta1AnnotatedMessagePart `json:"parts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainEntities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainEntities") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1MessageAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1MessageAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest struct {
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	Source  string               `json:"source,omitempty"`
	Version string               `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Payload") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Payload") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1QueryResult struct {
	Action                      string                                               `json:"action,omitempty"`
	AllRequiredParamsPresent    bool                                                 `json:"allRequiredParamsPresent,omitempty"`
	CancelsSlotFilling          bool                                                 `json:"cancelsSlotFilling,omitempty"`
	DiagnosticInfo              googleapi.RawMessage                                 `json:"diagnosticInfo,omitempty"`
	FulfillmentMessages         []*GoogleCloudDialogflowV2beta1IntentMessage         `json:"fulfillmentMessages,omitempty"`
	FulfillmentText             string                                               `json:"fulfillmentText,omitempty"`
	Intent                      *GoogleCloudDialogflowV2beta1Intent                  `json:"intent,omitempty"`
	IntentDetectionConfidence   float64                                              `json:"intentDetectionConfidence,omitempty"`
	KnowledgeAnswers            *GoogleCloudDialogflowV2beta1KnowledgeAnswers        `json:"knowledgeAnswers,omitempty"`
	LanguageCode                string                                               `json:"languageCode,omitempty"`
	OutputContexts              []*GoogleCloudDialogflowV2beta1Context               `json:"outputContexts,omitempty"`
	Parameters                  googleapi.RawMessage                                 `json:"parameters,omitempty"`
	QueryText                   string                                               `json:"queryText,omitempty"`
	SentimentAnalysisResult     *GoogleCloudDialogflowV2beta1SentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	SpeechRecognitionConfidence float64                                              `json:"speechRecognitionConfidence,omitempty"`
	WebhookPayload              googleapi.RawMessage                                 `json:"webhookPayload,omitempty"`
	WebhookSource               string                                               `json:"webhookSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1QueryResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1QueryResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1QueryResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1QueryResult
	var s1 struct {
		IntentDetectionConfidence   gensupport.JSONFloat64 `json:"intentDetectionConfidence"`
		SpeechRecognitionConfidence gensupport.JSONFloat64 `json:"speechRecognitionConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.IntentDetectionConfidence = float64(s1.IntentDetectionConfidence)
	s.SpeechRecognitionConfidence = float64(s1.SpeechRecognitionConfidence)
	return nil
}

type GoogleCloudDialogflowV2beta1ResponseMessage struct {
	EndInteraction        *GoogleCloudDialogflowV2beta1ResponseMessageEndInteraction        `json:"endInteraction,omitempty"`
	LiveAgentHandoff      *GoogleCloudDialogflowV2beta1ResponseMessageLiveAgentHandoff      `json:"liveAgentHandoff,omitempty"`
	MixedAudio            *GoogleCloudDialogflowV2beta1ResponseMessageMixedAudio            `json:"mixedAudio,omitempty"`
	Payload               googleapi.RawMessage                                              `json:"payload,omitempty"`
	TelephonyTransferCall *GoogleCloudDialogflowV2beta1ResponseMessageTelephonyTransferCall `json:"telephonyTransferCall,omitempty"`
	Text                  *GoogleCloudDialogflowV2beta1ResponseMessageText                  `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndInteraction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndInteraction") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ResponseMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ResponseMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ResponseMessageEndInteraction struct {
}

type GoogleCloudDialogflowV2beta1ResponseMessageLiveAgentHandoff struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ResponseMessageLiveAgentHandoff) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ResponseMessageLiveAgentHandoff
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ResponseMessageMixedAudio struct {
	Segments []*GoogleCloudDialogflowV2beta1ResponseMessageMixedAudioSegment `json:"segments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Segments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Segments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ResponseMessageMixedAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ResponseMessageMixedAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ResponseMessageMixedAudioSegment struct {
	AllowPlaybackInterruption bool   `json:"allowPlaybackInterruption,omitempty"`
	Audio                     string `json:"audio,omitempty"`
	Uri                       string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ResponseMessageMixedAudioSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ResponseMessageMixedAudioSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ResponseMessageTelephonyTransferCall struct {
	PhoneNumber string `json:"phoneNumber,omitempty"`
	SipUri      string `json:"sipUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ResponseMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ResponseMessageTelephonyTransferCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ResponseMessageText struct {
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ResponseMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ResponseMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1Sentiment struct {
	Magnitude float64 `json:"magnitude,omitempty"`
	Score     float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Sentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Sentiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1Sentiment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1Sentiment
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

type GoogleCloudDialogflowV2beta1SentimentAnalysisResult struct {
	QueryTextSentiment *GoogleCloudDialogflowV2beta1Sentiment `json:"queryTextSentiment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryTextSentiment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryTextSentiment") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ServiceLatency struct {
	InternalServiceLatencies []*GoogleCloudDialogflowV2beta1ServiceLatencyInternalServiceLatency `json:"internalServiceLatencies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InternalServiceLatencies")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InternalServiceLatencies") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ServiceLatency) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ServiceLatency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ServiceLatencyInternalServiceLatency struct {
	CompleteTime string  `json:"completeTime,omitempty"`
	LatencyMs    float64 `json:"latencyMs,omitempty"`
	StartTime    string  `json:"startTime,omitempty"`
	Step         string  `json:"step,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompleteTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompleteTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ServiceLatencyInternalServiceLatency) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ServiceLatencyInternalServiceLatency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1ServiceLatencyInternalServiceLatency) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1ServiceLatencyInternalServiceLatency
	var s1 struct {
		LatencyMs gensupport.JSONFloat64 `json:"latencyMs"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LatencyMs = float64(s1.LatencyMs)
	return nil
}

type GoogleCloudDialogflowV2beta1SessionEntityType struct {
	Entities []*GoogleCloudDialogflowV2beta1EntityTypeEntity `json:"entities,omitempty"`
	// Possible values:
	//   "ENTITY_OVERRIDE_MODE_UNSPECIFIED"
	//   "ENTITY_OVERRIDE_MODE_OVERRIDE"
	//   "ENTITY_OVERRIDE_MODE_SUPPLEMENT"
	EntityOverrideMode string `json:"entityOverrideMode,omitempty"`
	Name               string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SessionEntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SessionEntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SetSuggestionFeatureConfigOperationMetadata struct {
	ConversationProfile string `json:"conversationProfile,omitempty"`
	CreateTime          string `json:"createTime,omitempty"`
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	ParticipantRole string `json:"participantRole,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "ARTICLE_SUGGESTION"
	//   "FAQ"
	//   "SMART_REPLY"
	//   "DIALOGFLOW_ASSIST"
	//   "CONVERSATION_SUMMARIZATION"
	//   "KNOWLEDGE_SEARCH"
	//   "KNOWLEDGE_ASSIST"
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SetSuggestionFeatureConfigOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SetSuggestionFeatureConfigOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SmartReplyAnswer struct {
	AnswerRecord string  `json:"answerRecord,omitempty"`
	Confidence   float64 `json:"confidence,omitempty"`
	Reply        string  `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SmartReplyAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SmartReplyAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1SmartReplyAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1SmartReplyAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2beta1SpeechWordInfo struct {
	Confidence  float64 `json:"confidence,omitempty"`
	EndOffset   string  `json:"endOffset,omitempty"`
	StartOffset string  `json:"startOffset,omitempty"`
	Word        string  `json:"word,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SpeechWordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SpeechWordInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1SpeechWordInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1SpeechWordInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2beta1StreamingRecognitionResult struct {
	Confidence   float64                                          `json:"confidence,omitempty"`
	DtmfDigits   *GoogleCloudDialogflowV2beta1TelephonyDtmfEvents `json:"dtmfDigits,omitempty"`
	IsFinal      bool                                             `json:"isFinal,omitempty"`
	LanguageCode string                                           `json:"languageCode,omitempty"`
	// Possible values:
	//   "MESSAGE_TYPE_UNSPECIFIED"
	//   "TRANSCRIPT"
	//   "END_OF_SINGLE_UTTERANCE"
	//   "DTMF_DIGITS"
	//   "PARTIAL_DTMF_DIGITS"
	MessageType     string                                        `json:"messageType,omitempty"`
	SpeechEndOffset string                                        `json:"speechEndOffset,omitempty"`
	SpeechWordInfo  []*GoogleCloudDialogflowV2beta1SpeechWordInfo `json:"speechWordInfo,omitempty"`
	Stability       float64                                       `json:"stability,omitempty"`
	Transcript      string                                        `json:"transcript,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1StreamingRecognitionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1StreamingRecognitionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1StreamingRecognitionResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1StreamingRecognitionResult
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		Stability  gensupport.JSONFloat64 `json:"stability"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	s.Stability = float64(s1.Stability)
	return nil
}

type GoogleCloudDialogflowV2beta1SuggestArticlesResponse struct {
	ArticleAnswers []*GoogleCloudDialogflowV2beta1ArticleAnswer `json:"articleAnswers,omitempty"`
	ContextSize    int64                                        `json:"contextSize,omitempty"`
	LatestMessage  string                                       `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArticleAnswers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArticleAnswers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SuggestArticlesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestArticlesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SuggestDialogflowAssistsResponse struct {
	ContextSize             int64                                                 `json:"contextSize,omitempty"`
	DialogflowAssistAnswers []*GoogleCloudDialogflowV2beta1DialogflowAssistAnswer `json:"dialogflowAssistAnswers,omitempty"`
	LatestMessage           string                                                `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SuggestDialogflowAssistsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestDialogflowAssistsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse struct {
	ContextSize   int64                                    `json:"contextSize,omitempty"`
	FaqAnswers    []*GoogleCloudDialogflowV2beta1FaqAnswer `json:"faqAnswers,omitempty"`
	LatestMessage string                                   `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse struct {
	ContextSize           int64                                              `json:"contextSize,omitempty"`
	KnowledgeAssistAnswer *GoogleCloudDialogflowV2beta1KnowledgeAssistAnswer `json:"knowledgeAssistAnswer,omitempty"`
	LatestMessage         string                                             `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse struct {
	ContextSize       int64                                           `json:"contextSize,omitempty"`
	LatestMessage     string                                          `json:"latestMessage,omitempty"`
	SmartReplyAnswers []*GoogleCloudDialogflowV2beta1SmartReplyAnswer `json:"smartReplyAnswers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SuggestionResult struct {
	Error                            *GoogleRpcStatus                                              `json:"error,omitempty"`
	GenerateSuggestionsResponse      *GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse      `json:"generateSuggestionsResponse,omitempty"`
	SuggestArticlesResponse          *GoogleCloudDialogflowV2beta1SuggestArticlesResponse          `json:"suggestArticlesResponse,omitempty"`
	SuggestDialogflowAssistsResponse *GoogleCloudDialogflowV2beta1SuggestDialogflowAssistsResponse `json:"suggestDialogflowAssistsResponse,omitempty"`
	SuggestEntityExtractionResponse  *GoogleCloudDialogflowV2beta1SuggestDialogflowAssistsResponse `json:"suggestEntityExtractionResponse,omitempty"`
	SuggestFaqAnswersResponse        *GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse        `json:"suggestFaqAnswersResponse,omitempty"`
	SuggestKnowledgeAssistResponse   *GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse   `json:"suggestKnowledgeAssistResponse,omitempty"`
	SuggestSmartRepliesResponse      *GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse      `json:"suggestSmartRepliesResponse,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SuggestionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SummarySuggestion struct {
	SummarySections []*GoogleCloudDialogflowV2beta1SummarySuggestionSummarySection `json:"summarySections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SummarySections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SummarySections") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SummarySuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SummarySuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SummarySuggestionSummarySection struct {
	Section string `json:"section,omitempty"`
	Summary string `json:"summary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Section") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Section") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SummarySuggestionSummarySection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SummarySuggestionSummarySection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1TelephonyDtmfEvents struct {
	// Possible values:
	//   "TELEPHONY_DTMF_UNSPECIFIED"
	//   "DTMF_ONE"
	//   "DTMF_TWO"
	//   "DTMF_THREE"
	//   "DTMF_FOUR"
	//   "DTMF_FIVE"
	//   "DTMF_SIX"
	//   "DTMF_SEVEN"
	//   "DTMF_EIGHT"
	//   "DTMF_NINE"
	//   "DTMF_ZERO"
	//   "DTMF_A"
	//   "DTMF_B"
	//   "DTMF_C"
	//   "DTMF_D"
	//   "DTMF_STAR"
	//   "DTMF_POUND"
	DtmfEvents []string `json:"dtmfEvents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DtmfEvents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DtmfEvents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1TelephonyDtmfEvents) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1TelephonyDtmfEvents
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ToolCall struct {
	Action          string               `json:"action,omitempty"`
	AnswerRecord    string               `json:"answerRecord,omitempty"`
	CreateTime      string               `json:"createTime,omitempty"`
	InputParameters googleapi.RawMessage `json:"inputParameters,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "TRIGGERED"
	//   "NEEDS_CONFIRMATION"
	State              string `json:"state,omitempty"`
	Tool               string `json:"tool,omitempty"`
	ToolDisplayDetails string `json:"toolDisplayDetails,omitempty"`
	ToolDisplayName    string `json:"toolDisplayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ToolCallResult struct {
	Action       string                                           `json:"action,omitempty"`
	AnswerRecord string                                           `json:"answerRecord,omitempty"`
	Content      string                                           `json:"content,omitempty"`
	CreateTime   string                                           `json:"createTime,omitempty"`
	Error        *GoogleCloudDialogflowV2beta1ToolCallResultError `json:"error,omitempty"`
	RawContent   string                                           `json:"rawContent,omitempty"`
	Tool         string                                           `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ToolCallResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ToolCallResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ToolCallResultError struct {
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ToolCallResultError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ToolCallResultError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1WebhookRequest struct {
	AlternativeQueryResults     []*GoogleCloudDialogflowV2beta1QueryResult               `json:"alternativeQueryResults,omitempty"`
	OriginalDetectIntentRequest *GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest `json:"originalDetectIntentRequest,omitempty"`
	QueryResult                 *GoogleCloudDialogflowV2beta1QueryResult                 `json:"queryResult,omitempty"`
	ResponseId                  string                                                   `json:"responseId,omitempty"`
	Session                     string                                                   `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlternativeQueryResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternativeQueryResults") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1WebhookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1WebhookResponse struct {
	EndInteraction      bool                                             `json:"endInteraction,omitempty"`
	FollowupEventInput  *GoogleCloudDialogflowV2beta1EventInput          `json:"followupEventInput,omitempty"`
	FulfillmentMessages []*GoogleCloudDialogflowV2beta1IntentMessage     `json:"fulfillmentMessages,omitempty"`
	FulfillmentText     string                                           `json:"fulfillmentText,omitempty"`
	LiveAgentHandoff    bool                                             `json:"liveAgentHandoff,omitempty"`
	OutputContexts      []*GoogleCloudDialogflowV2beta1Context           `json:"outputContexts,omitempty"`
	Payload             googleapi.RawMessage                             `json:"payload,omitempty"`
	SessionEntityTypes  []*GoogleCloudDialogflowV2beta1SessionEntityType `json:"sessionEntityTypes,omitempty"`
	Source              string                                           `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndInteraction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndInteraction") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1WebhookResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV3alpha1ConversationSignals struct {
	TurnSignals *GoogleCloudDialogflowV3alpha1TurnSignals `json:"turnSignals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TurnSignals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TurnSignals") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV3alpha1ConversationSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV3alpha1ConversationSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV3alpha1TurnSignals struct {
	AgentEscalated bool `json:"agentEscalated,omitempty"`
	DtmfUsed       bool `json:"dtmfUsed,omitempty"`
	// Possible values:
	//   "FAILURE_REASON_UNSPECIFIED"
	//   "FAILED_INTENT"
	//   "FAILED_WEBHOOK"
	FailureReasons            []string `json:"failureReasons,omitempty"`
	NoMatch                   bool     `json:"noMatch,omitempty"`
	NoUserInput               bool     `json:"noUserInput,omitempty"`
	ReachedEndPage            bool     `json:"reachedEndPage,omitempty"`
	SentimentMagnitude        float64  `json:"sentimentMagnitude,omitempty"`
	SentimentScore            float64  `json:"sentimentScore,omitempty"`
	TriggeredAbandonmentEvent bool     `json:"triggeredAbandonmentEvent,omitempty"`
	UserEscalated             bool     `json:"userEscalated,omitempty"`
	WebhookStatuses           []string `json:"webhookStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentEscalated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentEscalated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV3alpha1TurnSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV3alpha1TurnSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV3alpha1TurnSignals) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV3alpha1TurnSignals
	var s1 struct {
		SentimentMagnitude gensupport.JSONFloat64 `json:"sentimentMagnitude"`
		SentimentScore     gensupport.JSONFloat64 `json:"sentimentScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SentimentMagnitude = float64(s1.SentimentMagnitude)
	s.SentimentScore = float64(s1.SentimentScore)
	return nil
}

type GoogleCloudLocationListLocationsResponse struct {
	Locations     []*GoogleCloudLocationLocation `json:"locations,omitempty"`
	NextPageToken string                         `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudLocationListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudLocationLocation struct {
	DisplayName string               `json:"displayName,omitempty"`
	Labels      map[string]string    `json:"labels,omitempty"`
	LocationId  string               `json:"locationId,omitempty"`
	Metadata    googleapi.RawMessage `json:"metadata,omitempty"`
	Name        string               `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudLocationLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleLongrunningListOperationsResponse struct {
	NextPageToken string                        `json:"nextPageToken,omitempty"`
	Operations    []*GoogleLongrunningOperation `json:"operations,omitempty"`
	Unreachable   []string                      `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleLongrunningOperation struct {
	Done     bool                 `json:"done,omitempty"`
	Error    *GoogleRpcStatus     `json:"error,omitempty"`
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	Name     string               `json:"name,omitempty"`
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

type GoogleRpcStatus struct {
	Code    int64                  `json:"code,omitempty"`
	Details []googleapi.RawMessage `json:"details,omitempty"`
	Message string                 `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleTypeLatLng struct {
	Latitude  float64 `json:"latitude,omitempty"`
	Longitude float64 `json:"longitude,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Latitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Latitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeLatLng) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeLatLng
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleTypeLatLng) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleTypeLatLng
	var s1 struct {
		Latitude  gensupport.JSONFloat64 `json:"latitude"`
		Longitude gensupport.JSONFloat64 `json:"longitude"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Latitude = float64(s1.Latitude)
	s.Longitude = float64(s1.Longitude)
	return nil
}

type ProjectsDeleteAgentCall struct {
	s          *Service
	parent     string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// DeleteAgent:
//
// - parent: .
func (r *ProjectsService) DeleteAgent(parent string) *ProjectsDeleteAgentCall {
	c := &ProjectsDeleteAgentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDeleteAgentCall) Fields(s ...googleapi.Field) *ProjectsDeleteAgentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDeleteAgentCall) Context(ctx context.Context) *ProjectsDeleteAgentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDeleteAgentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDeleteAgentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/agent")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.deleteAgent", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.deleteAgent" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsDeleteAgentCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.deleteAgent", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsGetAgentCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAgent:
//
// - parent: .
func (r *ProjectsService) GetAgent(parent string) *ProjectsGetAgentCall {
	c := &ProjectsGetAgentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGetAgentCall) Fields(s ...googleapi.Field) *ProjectsGetAgentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsGetAgentCall) IfNoneMatch(entityTag string) *ProjectsGetAgentCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGetAgentCall) Context(ctx context.Context) *ProjectsGetAgentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGetAgentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetAgentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/agent")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.getAgent", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.getAgent" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2Agent.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsGetAgentCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2Agent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowV2Agent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.getAgent", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsSetAgentCall struct {
	s                            *Service
	parent                       string
	googleclouddialogflowv2agent *GoogleCloudDialogflowV2Agent
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// SetAgent:
//
// - parent: .
func (r *ProjectsService) SetAgent(parent string, googleclouddialogflowv2agent *GoogleCloudDialogflowV2Agent) *ProjectsSetAgentCall {
	c := &ProjectsSetAgentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowv2agent = googleclouddialogflowv2agent
	return c
}

// UpdateMask sets the optional parameter "updateMask":
func (c *ProjectsSetAgentCall) UpdateMask(updateMask string) *ProjectsSetAgentCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsSetAgentCall) Fields(s ...googleapi.Field) *ProjectsSetAgentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsSetAgentCall) Context(ctx context.Context) *ProjectsSetAgentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsSetAgentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsSetAgentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2agent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/agent")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.setAgent", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.setAgent" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2Agent.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsSetAgentCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2Agent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowV2Agent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.setAgent", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentExportCall struct {
	s                                         *Service
	parent                                    string
	googleclouddialogflowv2exportagentrequest *GoogleCloudDialogflowV2ExportAgentRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Export:
//
// - parent: .
func (r *ProjectsAgentService) Export(parent string, googleclouddialogflowv2exportagentrequest *GoogleCloudDialogflowV2ExportAgentRequest) *ProjectsAgentExportCall {
	c := &ProjectsAgentExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowv2exportagentrequest = googleclouddialogflowv2exportagentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentExportCall) Fields(s ...googleapi.Field) *ProjectsAgentExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentExportCall) Context(ctx context.Context) *ProjectsAgentExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2exportagentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/agent:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.export", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.export" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentExportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.export", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentGetFulfillmentCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetFulfillment:
//
// - name: .
func (r *ProjectsAgentService) GetFulfillment(name string) *ProjectsAgentGetFulfillmentCall {
	c := &ProjectsAgentGetFulfillmentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentGetFulfillmentCall) Fields(s ...googleapi.Field) *ProjectsAgentGetFulfillmentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAgentGetFulfillmentCall) IfNoneMatch(entityTag string) *ProjectsAgentGetFulfillmentCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentGetFulfillmentCall) Context(ctx context.Context) *ProjectsAgentGetFulfillmentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentGetFulfillmentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentGetFulfillmentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.getFulfillment", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.getFulfillment" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2Fulfillment.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentGetFulfillmentCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2Fulfillment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowV2Fulfillment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.getFulfillment", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentGetValidationResultCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetValidationResult:
//
// - parent: .
func (r *ProjectsAgentService) GetValidationResult(parent string) *ProjectsAgentGetValidationResultCall {
	c := &ProjectsAgentGetValidationResultCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// LanguageCode sets the optional parameter "languageCode":
func (c *ProjectsAgentGetValidationResultCall) LanguageCode(languageCode string) *ProjectsAgentGetValidationResultCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentGetValidationResultCall) Fields(s ...googleapi.Field) *ProjectsAgentGetValidationResultCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAgentGetValidationResultCall) IfNoneMatch(entityTag string) *ProjectsAgentGetValidationResultCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentGetValidationResultCall) Context(ctx context.Context) *ProjectsAgentGetValidationResultCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentGetValidationResultCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentGetValidationResultCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/agent/validationResult")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.getValidationResult", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.getValidationResult" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2ValidationResult.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentGetValidationResultCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2ValidationResult, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowV2ValidationResult{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.getValidationResult", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentImportCall struct {
	s                                         *Service
	parent                                    string
	googleclouddialogflowv2importagentrequest *GoogleCloudDialogflowV2ImportAgentRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Import:
//
// - parent: .
func (r *ProjectsAgentService) Import(parent string, googleclouddialogflowv2importagentrequest *GoogleCloudDialogflowV2ImportAgentRequest) *ProjectsAgentImportCall {
	c := &ProjectsAgentImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowv2importagentrequest = googleclouddialogflowv2importagentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentImportCall) Fields(s ...googleapi.Field) *ProjectsAgentImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentImportCall) Context(ctx context.Context) *ProjectsAgentImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2importagentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/agent:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.import", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.import", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentRestoreCall struct {
	s                                          *Service
	parent                                     string
	googleclouddialogflowv2restoreagentrequest *GoogleCloudDialogflowV2RestoreAgentRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Restore:
//
// - parent: .
func (r *ProjectsAgentService) Restore(parent string, googleclouddialogflowv2restoreagentrequest *GoogleCloudDialogflowV2RestoreAgentRequest) *ProjectsAgentRestoreCall {
	c := &ProjectsAgentRestoreCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowv2restoreagentrequest = googleclouddialogflowv2restoreagentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentRestoreCall) Fields(s ...googleapi.Field) *ProjectsAgentRestoreCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentRestoreCall) Context(ctx context.Context) *ProjectsAgentRestoreCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentRestoreCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentRestoreCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2restoreagentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/agent:restore")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.restore", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.restore" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentRestoreCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.restore", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentSearchCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search:
//
// - parent: .
func (r *ProjectsAgentService) Search(parent string) *ProjectsAgentSearchCall {
	c := &ProjectsAgentSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsAgentSearchCall) PageSize(pageSize int64) *ProjectsAgentSearchCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken":
func (c *ProjectsAgentSearchCall) PageToken(pageToken string) *ProjectsAgentSearchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentSearchCall) Fields(s ...googleapi.Field) *ProjectsAgentSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAgentSearchCall) IfNoneMatch(entityTag string) *ProjectsAgentSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentSearchCall) Context(ctx context.Context) *ProjectsAgentSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/agent:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.search", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2SearchAgentsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentSearchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2SearchAgentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowV2SearchAgentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.search", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAgentSearchCall) Pages(ctx context.Context, f func(*GoogleCloudDialogflowV2SearchAgentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsAgentTrainCall struct {
	s                                        *Service
	parent                                   string
	googleclouddialogflowv2trainagentrequest *GoogleCloudDialogflowV2TrainAgentRequest
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Train:
//
// - parent: .
func (r *ProjectsAgentService) Train(parent string, googleclouddialogflowv2trainagentrequest *GoogleCloudDialogflowV2TrainAgentRequest) *ProjectsAgentTrainCall {
	c := &ProjectsAgentTrainCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowv2trainagentrequest = googleclouddialogflowv2trainagentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentTrainCall) Fields(s ...googleapi.Field) *ProjectsAgentTrainCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentTrainCall) Context(ctx context.Context) *ProjectsAgentTrainCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentTrainCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentTrainCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2trainagentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/agent:train")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.train", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.train" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentTrainCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.train", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentUpdateFulfillmentCall struct {
	s                                  *Service
	name                               string
	googleclouddialogflowv2fulfillment *GoogleCloudDialogflowV2Fulfillment
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// UpdateFulfillment:
//
// - name: .
func (r *ProjectsAgentService) UpdateFulfillment(name string, googleclouddialogflowv2fulfillment *GoogleCloudDialogflowV2Fulfillment) *ProjectsAgentUpdateFulfillmentCall {
	c := &ProjectsAgentUpdateFulfillmentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddialogflowv2fulfillment = googleclouddialogflowv2fulfillment
	return c
}

// UpdateMask sets the optional parameter "updateMask":
func (c *ProjectsAgentUpdateFulfillmentCall) UpdateMask(updateMask string) *ProjectsAgentUpdateFulfillmentCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentUpdateFulfillmentCall) Fields(s ...googleapi.Field) *ProjectsAgentUpdateFulfillmentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentUpdateFulfillmentCall) Context(ctx context.Context) *ProjectsAgentUpdateFulfillmentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentUpdateFulfillmentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentUpdateFulfillmentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2fulfillment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.updateFulfillment", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.updateFulfillment" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2Fulfillment.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentUpdateFulfillmentCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2Fulfillment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowV2Fulfillment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.updateFulfillment", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentEntityTypesBatchDeleteCall struct {
	s                                                    *Service
	parent                                               string
	googleclouddialogflowv2batchdeleteentitytypesrequest *GoogleCloudDialogflowV2BatchDeleteEntityTypesRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// BatchDelete:
//
// - parent: .
func (r *ProjectsAgentEntityTypesService) BatchDelete(parent string, googleclouddialogflowv2batchdeleteentitytypesrequest *GoogleCloudDialogflowV2BatchDeleteEntityTypesRequest) *ProjectsAgentEntityTypesBatchDeleteCall {
	c := &ProjectsAgentEntityTypesBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowv2batchdeleteentitytypesrequest = googleclouddialogflowv2batchdeleteentitytypesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEntityTypesBatchDeleteCall) Fields(s ...googleapi.Field) *ProjectsAgentEntityTypesBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEntityTypesBatchDeleteCall) Context(ctx context.Context) *ProjectsAgentEntityTypesBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEntityTypesBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEntityTypesBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2batchdeleteentitytypesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/entityTypes:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.batchDelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.entityTypes.batchDelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentEntityTypesBatchDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.batchDelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentEntityTypesBatchUpdateCall struct {
	s                                                    *Service
	parent                                               string
	googleclouddialogflowv2batchupdateentitytypesrequest *GoogleCloudDialogflowV2BatchUpdateEntityTypesRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// BatchUpdate:
//
// - parent: .
func (r *ProjectsAgentEntityTypesService) BatchUpdate(parent string, googleclouddialogflowv2batchupdateentitytypesrequest *GoogleCloudDialogflowV2BatchUpdateEntityTypesRequest) *ProjectsAgentEntityTypesBatchUpdateCall {
	c := &ProjectsAgentEntityTypesBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowv2batchupdateentitytypesrequest = googleclouddialogflowv2batchupdateentitytypesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEntityTypesBatchUpdateCall) Fields(s ...googleapi.Field) *ProjectsAgentEntityTypesBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEntityTypesBatchUpdateCall) Context(ctx context.Context) *ProjectsAgentEntityTypesBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEntityTypesBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEntityTypesBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2batchupdateentitytypesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/entityTypes:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.batchUpdate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.entityTypes.batchUpdate" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentEntityTypesBatchUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.batchUpdate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentEntityTypesCreateCall struct {
	s                                 *Service
	parent                            string
	googleclouddialogflowv2entitytype *GoogleCloudDialogflowV2EntityType
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Create:
//
// - parent: .
func (r *ProjectsAgentEntityTypesService) Create(parent string, googleclouddialogflowv2entitytype *GoogleCloudDialogflowV2EntityType) *ProjectsAgentEntityTypesCreateCall {
	c := &ProjectsAgentEntityTypesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowv2entitytype = googleclouddialogflowv2entitytype
	return c
}

// LanguageCode sets the optional parameter "languageCode":
func (c *ProjectsAgentEntityTypesCreateCall) LanguageCode(languageCode string) *ProjectsAgentEntityTypesCreateCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEntityTypesCreateCall) Fields(s ...googleapi.Field) *ProjectsAgentEntityTypesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEntityTypesCreateCall) Context(ctx context.Context) *ProjectsAgentEntityTypesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEntityTypesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEntityTypesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2entitytype)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/entityTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.entityTypes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2EntityType.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentEntityTypesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2EntityType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowV2EntityType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentEntityTypesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete:
//
// - name: .
func (r *ProjectsAgentEntityTypesService) Delete(name string) *ProjectsAgentEntityTypesDeleteCall {
	c := &ProjectsAgentEntityTypesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEntityTypesDeleteCall) Fields(s ...googleapi.Field) *ProjectsAgentEntityTypesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEntityTypesDeleteCall) Context(ctx context.Context) *ProjectsAgentEntityTypesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEntityTypesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEntityTypesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.entityTypes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAgentEntityTypesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentEntityTypesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get:
//
// - name: .
func (r *ProjectsAgentEntityTypesService) Get(name string) *ProjectsAgentEntityTypesGetCall {
	c := &ProjectsAgentEntityTypesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// LanguageCode sets the optional parameter "languageCode":
func (c *ProjectsAgentEntityTypesGetCall) LanguageCode(languageCode string) *ProjectsAgentEntityTypesGetCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEntityTypesGetCall) Fields(s ...googleapi.Field) *ProjectsAgentEntityTypesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAgentEntityTypesGetCall) IfNoneMatch(entityTag string) *ProjectsAgentEntityTypesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEntityTypesGetCall) Context(ctx context.Context) *ProjectsAgentEntityTypesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEntityTypesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEntityTypesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.entityTypes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2EntityType.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentEntityTypesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2EntityType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowV2EntityType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentEntityTypesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List:
//
// - parent: .
func (r *ProjectsAgentEntityTypesService) List(parent string) *ProjectsAgentEntityTypesListCall {
	c := &ProjectsAgentEntityTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// LanguageCode sets the optional parameter "languageCode":
func (c *ProjectsAgentEntityTypesListCall) LanguageCode(languageCode string) *ProjectsAgentEntityTypesListCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsAgentEntityTypesListCall) PageSize(pageSize int64) *ProjectsAgentEntityTypesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken":
func (c *ProjectsAgentEntityTypesListCall) PageToken(pageToken string) *ProjectsAgentEntityTypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEntityTypesListCall) Fields(s ...googleapi.Field) *ProjectsAgentEntityTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAgentEntityTypesListCall) IfNoneMatch(entityTag string) *ProjectsAgentEntityTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEntityTypesListCall) Context(ctx context.Context) *ProjectsAgentEntityTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEntityTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEntityTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/entityTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.entityTypes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2ListEntityTypesResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentEntityTypesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2ListEntityTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowV2ListEntityTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAgentEntityTypesListCall) Pages(ctx context.Context, f func(*GoogleCloudDialogflowV2ListEntityTypesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsAgentEntityTypesPatchCall struct {
	s                                 *Service
	name                              string
	googleclouddialogflowv2entitytype *GoogleCloudDialogflowV2EntityType
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Patch:
//
// - name: .
func (r *ProjectsAgentEntityTypesService) Patch(name string, googleclouddialogflowv2entitytype *GoogleCloudDialogflowV2EntityType) *ProjectsAgentEntityTypesPatchCall {
	c := &ProjectsAgentEntityTypesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddialogflowv2entitytype = googleclouddialogflowv2entitytype
	return c
}

// LanguageCode sets the optional parameter "languageCode":
func (c *ProjectsAgentEntityTypesPatchCall) LanguageCode(languageCode string) *ProjectsAgentEntityTypesPatchCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// UpdateMask sets the optional parameter "updateMask":
func (c *ProjectsAgentEntityTypesPatchCall) UpdateMask(updateMask string) *ProjectsAgentEntityTypesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEntityTypesPatchCall) Fields(s ...googleapi.Field) *ProjectsAgentEntityTypesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEntityTypesPatchCall) Context(ctx context.Context) *ProjectsAgentEntityTypesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEntityTypesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEntityTypesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2entitytype)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.entityTypes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2EntityType.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentEntityTypesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2EntityType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowV2EntityType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentEntityTypesEntitiesBatchCreateCall struct {
	s                                                 *Service
	parent                                            string
	googleclouddialogflowv2batchcreateentitiesrequest *GoogleCloudDialogflowV2BatchCreateEntitiesRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// BatchCreate:
//
// - parent: .
func (r *ProjectsAgentEntityTypesEntitiesService) BatchCreate(parent string, googleclouddialogflowv2batchcreateentitiesrequest *GoogleCloudDialogflowV2BatchCreateEntitiesRequest) *ProjectsAgentEntityTypesEntitiesBatchCreateCall {
	c := &ProjectsAgentEntityTypesEntitiesBatchCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowv2batchcreateentitiesrequest = googleclouddialogflowv2batchcreateentitiesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEntityTypesEntitiesBatchCreateCall) Fields(s ...googleapi.Field) *ProjectsAgentEntityTypesEntitiesBatchCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEntityTypesEntitiesBatchCreateCall) Context(ctx context.Context) *ProjectsAgentEntityTypesEntitiesBatchCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEntityTypesEntitiesBatchCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEntityTypesEntitiesBatchCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2batchcreateentitiesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/entities:batchCreate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.entities.batchCreate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.entityTypes.entities.batchCreate" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentEntityTypesEntitiesBatchCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.entities.batchCreate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentEntityTypesEntitiesBatchDeleteCall struct {
	s                                                 *Service
	parent                                            string
	googleclouddialogflowv2batchdeleteentitiesrequest *GoogleCloudDialogflowV2BatchDeleteEntitiesRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// BatchDelete:
//
// - parent: .
func (r *ProjectsAgentEntityTypesEntitiesService) BatchDelete(parent string, googleclouddialogflowv2batchdeleteentitiesrequest *GoogleCloudDialogflowV2BatchDeleteEntitiesRequest) *ProjectsAgentEntityTypesEntitiesBatchDeleteCall {
	c := &ProjectsAgentEntityTypesEntitiesBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowv2batchdeleteentitiesrequest = googleclouddialogflowv2batchdeleteentitiesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEntityTypesEntitiesBatchDeleteCall) Fields(s ...googleapi.Field) *ProjectsAgentEntityTypesEntitiesBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEntityTypesEntitiesBatchDeleteCall) Context(ctx context.Context) *ProjectsAgentEntityTypesEntitiesBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEntityTypesEntitiesBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEntityTypesEntitiesBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2batchdeleteentitiesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/entities:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.entities.batchDelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.entityTypes.entities.batchDelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentEntityTypesEntitiesBatchDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.entities.batchDelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentEntityTypesEntitiesBatchUpdateCall struct {
	s                                                 *Service
	parent                                            string
	googleclouddialogflowv2batchupdateentitiesrequest *GoogleCloudDialogflowV2BatchUpdateEntitiesRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// BatchUpdate:
//
// - parent: .
func (r *ProjectsAgentEntityTypesEntitiesService) BatchUpdate(parent string, googleclouddialogflowv2batchupdateentitiesrequest *GoogleCloudDialogflowV2BatchUpdateEntitiesRequest) *ProjectsAgentEntityTypesEntitiesBatchUpdateCall {
	c := &ProjectsAgentEntityTypesEntitiesBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowv2batchupdateentitiesrequest = googleclouddialogflowv2batchupdateentitiesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEntityTypesEntitiesBatchUpdateCall) Fields(s ...googleapi.Field) *ProjectsAgentEntityTypesEntitiesBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEntityTypesEntitiesBatchUpdateCall) Context(ctx context.Context) *ProjectsAgentEntityTypesEntitiesBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEntityTypesEntitiesBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEntityTypesEntitiesBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2batchupdateentitiesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/entities:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.entities.batchUpdate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.entityTypes.entities.batchUpdate" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentEntityTypesEntitiesBatchUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.entityTypes.entities.batchUpdate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentEnvironmentsCreateCall struct {
	s                                  *Service
	parent                             string
	googleclouddialogflowv2environment *GoogleCloudDialogflowV2Environment
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Create:
//
// - parent: .
func (r *ProjectsAgentEnvironmentsService) Create(parent string, googleclouddialogflowv2environment *GoogleCloudDialogflowV2Environment) *ProjectsAgentEnvironmentsCreateCall {
	c := &ProjectsAgentEnvironmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowv2environment = googleclouddialogflowv2environment
	return c
}

// EnvironmentId sets the optional parameter "environmentId":
func (c *ProjectsAgentEnvironmentsCreateCall) EnvironmentId(environmentId string) *ProjectsAgentEnvironmentsCreateCall {
	c.urlParams_.Set("environmentId", environmentId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEnvironmentsCreateCall) Fields(s ...googleapi.Field) *ProjectsAgentEnvironmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEnvironmentsCreateCall) Context(ctx context.Context) *ProjectsAgentEnvironmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEnvironmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEnvironmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2environment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/environments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.environments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.environments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2Environment.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentEnvironmentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2Environment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowV2Environment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.environments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentEnvironmentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete:
//
// - name: .
func (r *ProjectsAgentEnvironmentsService) Delete(name string) *ProjectsAgentEnvironmentsDeleteCall {
	c := &ProjectsAgentEnvironmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEnvironmentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsAgentEnvironmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEnvironmentsDeleteCall) Context(ctx context.Context) *ProjectsAgentEnvironmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEnvironmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEnvironmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.environments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.environments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAgentEnvironmentsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.environments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentEnvironmentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get:
//
// - name: .
func (r *ProjectsAgentEnvironmentsService) Get(name string) *ProjectsAgentEnvironmentsGetCall {
	c := &ProjectsAgentEnvironmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEnvironmentsGetCall) Fields(s ...googleapi.Field) *ProjectsAgentEnvironmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAgentEnvironmentsGetCall) IfNoneMatch(entityTag string) *ProjectsAgentEnvironmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEnvironmentsGetCall) Context(ctx context.Context) *ProjectsAgentEnvironmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEnvironmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEnvironmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.environments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.environments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2Environment.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentEnvironmentsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2Environment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowV2Environment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.environments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAgentEnvironmentsGetHistoryCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetHistory:
//
// - parent: .
func (r *ProjectsAgentEnvironmentsService) GetHistory(parent string) *ProjectsAgentEnvironmentsGetHistoryCall {
	c := &ProjectsAgentEnvironmentsGetHistoryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsAgentEnvironmentsGetHistoryCall) PageSize(pageSize int64) *ProjectsAgentEnvironmentsGetHistoryCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken":
func (c *ProjectsAgentEnvironmentsGetHistoryCall) PageToken(pageToken string) *ProjectsAgentEnvironmentsGetHistoryCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEnvironmentsGetHistoryCall) Fields(s ...googleapi.Field) *ProjectsAgentEnvironmentsGetHistoryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAgentEnvironmentsGetHistoryCall) IfNoneMatch(entityTag string) *ProjectsAgentEnvironmentsGetHistoryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEnvironmentsGetHistoryCall) Context(ctx context.Context) *ProjectsAgentEnvironmentsGetHistoryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEnvironmentsGetHistoryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEnvironmentsGetHistoryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/history")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.environments.getHistory", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.environments.getHistory" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2EnvironmentHistory.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentEnvironmentsGetHistoryCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2EnvironmentHistory, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowV2EnvironmentHistory{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.environments.getHistory", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAgentEnvironmentsGetHistoryCall) Pages(ctx context.Context, f func(*GoogleCloudDialogflowV2EnvironmentHistory) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsAgentEnvironmentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List:
//
// - parent: .
func (r *ProjectsAgentEnvironmentsService) List(parent string) *ProjectsAgentEnvironmentsListCall {
	c := &ProjectsAgentEnvironmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsAgentEnvironmentsListCall) PageSize(pageSize int64) *ProjectsAgentEnvironmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken":
func (c *ProjectsAgentEnvironmentsListCall) PageToken(pageToken string) *ProjectsAgentEnvironmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEnvironmentsListCall) Fields(s ...googleapi.Field) *ProjectsAgentEnvironmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAgentEnvironmentsListCall) IfNoneMatch(entityTag string) *ProjectsAgentEnvironmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEnvironmentsListCall) Context(ctx context.Context) *ProjectsAgentEnvironmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEnvironmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEnvironmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/environments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.environments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.environments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2ListEnvironmentsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentEnvironmentsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2ListEnvironmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowV2ListEnvironmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.environments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAgentEnvironmentsListCall) Pages(ctx context.Context, f func(*GoogleCloudDialogflowV2ListEnvironmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsAgentEnvironmentsPatchCall struct {
	s                                  *Service
	name                               string
	googleclouddialogflowv2environment *GoogleCloudDialogflowV2Environment
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Patch:
//
// - name: .
func (r *ProjectsAgentEnvironmentsService) Patch(name string, googleclouddialogflowv2environment *GoogleCloudDialogflowV2Environment) *ProjectsAgentEnvironmentsPatchCall {
	c := &ProjectsAgentEnvironmentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddialogflowv2environment = googleclouddialogflowv2environment
	return c
}

// AllowLoadToDraftAndDiscardChanges sets the optional parameter
// "allowLoadToDraftAndDiscardChanges":
func (c *ProjectsAgentEnvironmentsPatchCall) AllowLoadToDraftAndDiscardChanges(allowLoadToDraftAndDiscardChanges bool) *ProjectsAgentEnvironmentsPatchCall {
	c.urlParams_.Set("allowLoadToDraftAndDiscardChanges", fmt.Sprint(allowLoadToDraftAndDiscardChanges))
	return c
}

// UpdateMask sets the optional parameter "updateMask":
func (c *ProjectsAgentEnvironmentsPatchCall) UpdateMask(updateMask string) *ProjectsAgentEnvironmentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAgentEnvironmentsPatchCall) Fields(s ...googleapi.Field) *ProjectsAgentEnvironmentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAgentEnvironmentsPatchCall) Context(ctx context.Context) *ProjectsAgentEnvironmentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAgentEnvironmentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAgentEnvironmentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowv2environment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.agent.environments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.agent.environments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowV2Environment.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAgentEnvironmentsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowV2Environment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if e