// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectormetrics "go.opentelemetry.io/proto/slim/otlp/collector/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExportMetricsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExportMetricsServiceResponse()
				CopyExportMetricsServiceResponse(dest, src)
				assert.Equal(t, src, dest)
				CopyExportMetricsServiceResponse(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExportMetricsServiceResponseSlice(t *testing.T) {
	src := []ExportMetricsServiceResponse{}
	dest := []ExportMetricsServiceResponse{}
	// Test CopyTo empty
	dest = CopyExportMetricsServiceResponseSlice(dest, src)
	assert.Equal(t, []ExportMetricsServiceResponse{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportMetricsServiceResponseSlice()
	dest = CopyExportMetricsServiceResponseSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsServiceResponseSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportMetricsServiceResponseSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsServiceResponseSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportMetricsServiceResponseSlice(dest, []ExportMetricsServiceResponse{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportMetricsServiceResponseSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsServiceResponseSlice(), dest)
}

func TestCopyExportMetricsServiceResponsePtrSlice(t *testing.T) {
	src := []*ExportMetricsServiceResponse{}
	dest := []*ExportMetricsServiceResponse{}
	// Test CopyTo empty
	dest = CopyExportMetricsServiceResponsePtrSlice(dest, src)
	assert.Equal(t, []*ExportMetricsServiceResponse{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportMetricsServiceResponsePtrSlice()
	dest = CopyExportMetricsServiceResponsePtrSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsServiceResponsePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportMetricsServiceResponsePtrSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsServiceResponsePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportMetricsServiceResponsePtrSlice(dest, []*ExportMetricsServiceResponse{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportMetricsServiceResponsePtrSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsServiceResponsePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExportMetricsServiceResponseUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExportMetricsServiceResponse()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExportMetricsServiceResponse(), dest)
}

func TestMarshalAndUnmarshalJSONExportMetricsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExportMetricsServiceResponse()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExportMetricsServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExportMetricsServiceResponseFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportMetricsServiceResponse() {
		t.Run(name, func(t *testing.T) {
			dest := NewExportMetricsServiceResponse()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExportMetricsServiceResponseUnknown(t *testing.T) {
	dest := NewExportMetricsServiceResponse()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExportMetricsServiceResponse(), dest)
}

func TestMarshalAndUnmarshalProtoExportMetricsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExportMetricsServiceResponse()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExportMetricsServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportMetricsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceResponse() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectormetrics.ExportMetricsServiceResponse{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExportMetricsServiceResponse()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportMetricsServiceResponse() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                  {0x02},
		"PartialSuccess/wrong_wire_type": {0xc},
		"PartialSuccess/missing_value":   {0xa},
	}
}

func genTestEncodingValuesExportMetricsServiceResponse() map[string]*ExportMetricsServiceResponse {
	return map[string]*ExportMetricsServiceResponse{
		"empty":               NewExportMetricsServiceResponse(),
		"PartialSuccess/test": {PartialSuccess: *GenTestExportMetricsPartialSuccess()},
	}
}
