// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyMapping(t *testing.T) {
	for name, src := range genTestEncodingValuesMapping() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewMapping()
				CopyMapping(dest, src)
				assert.Equal(t, src, dest)
				CopyMapping(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyMappingSlice(t *testing.T) {
	src := []Mapping{}
	dest := []Mapping{}
	// Test CopyTo empty
	dest = CopyMappingSlice(dest, src)
	assert.Equal(t, []Mapping{}, dest)

	// Test CopyTo larger slice
	src = GenTestMappingSlice()
	dest = CopyMappingSlice(dest, src)
	assert.Equal(t, GenTestMappingSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyMappingSlice(dest, src)
	assert.Equal(t, GenTestMappingSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyMappingSlice(dest, []Mapping{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyMappingSlice(dest, src)
	assert.Equal(t, GenTestMappingSlice(), dest)
}

func TestCopyMappingPtrSlice(t *testing.T) {
	src := []*Mapping{}
	dest := []*Mapping{}
	// Test CopyTo empty
	dest = CopyMappingPtrSlice(dest, src)
	assert.Equal(t, []*Mapping{}, dest)

	// Test CopyTo larger slice
	src = GenTestMappingPtrSlice()
	dest = CopyMappingPtrSlice(dest, src)
	assert.Equal(t, GenTestMappingPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyMappingPtrSlice(dest, src)
	assert.Equal(t, GenTestMappingPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyMappingPtrSlice(dest, []*Mapping{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyMappingPtrSlice(dest, src)
	assert.Equal(t, GenTestMappingPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONMappingUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewMapping()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewMapping(), dest)
}

func TestMarshalAndUnmarshalJSONMapping(t *testing.T) {
	for name, src := range genTestEncodingValuesMapping() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewMapping()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteMapping(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoMappingFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesMapping() {
		t.Run(name, func(t *testing.T) {
			dest := NewMapping()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoMappingUnknown(t *testing.T) {
	dest := NewMapping()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewMapping(), dest)
}

func TestMarshalAndUnmarshalProtoMapping(t *testing.T) {
	for name, src := range genTestEncodingValuesMapping() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewMapping()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteMapping(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufMapping(t *testing.T) {
	for name, src := range genTestEncodingValuesMapping() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.Mapping{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewMapping()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesMapping() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                    {0x02},
		"MemoryStart/wrong_wire_type":      {0xc},
		"MemoryStart/missing_value":        {0x8},
		"MemoryLimit/wrong_wire_type":      {0x14},
		"MemoryLimit/missing_value":        {0x10},
		"FileOffset/wrong_wire_type":       {0x1c},
		"FileOffset/missing_value":         {0x18},
		"FilenameStrindex/wrong_wire_type": {0x24},
		"FilenameStrindex/missing_value":   {0x20},
		"AttributeIndices/wrong_wire_type": {0x2c},
		"AttributeIndices/missing_value":   {0x2a},
	}
}

func genTestEncodingValuesMapping() map[string]*Mapping {
	return map[string]*Mapping{
		"empty":                 NewMapping(),
		"MemoryStart/test":      {MemoryStart: uint64(13)},
		"MemoryLimit/test":      {MemoryLimit: uint64(13)},
		"FileOffset/test":       {FileOffset: uint64(13)},
		"FilenameStrindex/test": {FilenameStrindex: int32(13)},
		"AttributeIndices/test": {AttributeIndices: []int32{int32(0), int32(13)}},
	}
}
