// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	"google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/types/known/emptypb"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyTCPAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesTCPAddr() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewTCPAddr()
				CopyTCPAddr(dest, src)
				assert.Equal(t, src, dest)
				CopyTCPAddr(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyTCPAddrSlice(t *testing.T) {
	src := []TCPAddr{}
	dest := []TCPAddr{}
	// Test CopyTo empty
	dest = CopyTCPAddrSlice(dest, src)
	assert.Equal(t, []TCPAddr{}, dest)

	// Test CopyTo larger slice
	src = GenTestTCPAddrSlice()
	dest = CopyTCPAddrSlice(dest, src)
	assert.Equal(t, GenTestTCPAddrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyTCPAddrSlice(dest, src)
	assert.Equal(t, GenTestTCPAddrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyTCPAddrSlice(dest, []TCPAddr{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyTCPAddrSlice(dest, src)
	assert.Equal(t, GenTestTCPAddrSlice(), dest)
}

func TestCopyTCPAddrPtrSlice(t *testing.T) {
	src := []*TCPAddr{}
	dest := []*TCPAddr{}
	// Test CopyTo empty
	dest = CopyTCPAddrPtrSlice(dest, src)
	assert.Equal(t, []*TCPAddr{}, dest)

	// Test CopyTo larger slice
	src = GenTestTCPAddrPtrSlice()
	dest = CopyTCPAddrPtrSlice(dest, src)
	assert.Equal(t, GenTestTCPAddrPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyTCPAddrPtrSlice(dest, src)
	assert.Equal(t, GenTestTCPAddrPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyTCPAddrPtrSlice(dest, []*TCPAddr{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyTCPAddrPtrSlice(dest, src)
	assert.Equal(t, GenTestTCPAddrPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONTCPAddrUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewTCPAddr()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewTCPAddr(), dest)
}

func TestMarshalAndUnmarshalJSONTCPAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesTCPAddr() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewTCPAddr()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteTCPAddr(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoTCPAddrFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesTCPAddr() {
		t.Run(name, func(t *testing.T) {
			dest := NewTCPAddr()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoTCPAddrUnknown(t *testing.T) {
	dest := NewTCPAddr()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewTCPAddr(), dest)
}

func TestMarshalAndUnmarshalProtoTCPAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesTCPAddr() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewTCPAddr()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteTCPAddr(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufTCPAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesTCPAddr() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &emptypb.Empty{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewTCPAddr()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesTCPAddr() map[string][]byte {
	return map[string][]byte{
		"invalid_field":        {0x02},
		"IP/wrong_wire_type":   {0xc},
		"IP/missing_value":     {0xa},
		"Port/wrong_wire_type": {0x14},
		"Port/missing_value":   {0x10},
		"Zone/wrong_wire_type": {0x1c},
		"Zone/missing_value":   {0x1a},
	}
}

func genTestEncodingValuesTCPAddr() map[string]*TCPAddr {
	return map[string]*TCPAddr{
		"empty":     NewTCPAddr(),
		"IP/test":   {IP: []byte{1, 2, 3}},
		"Port/test": {Port: int64(13)},
		"Zone/test": {Zone: "test_zone"},
	}
}
