//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstorage_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storage/armstorage"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountCheckNameAvailability.json
func ExampleAccountsClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().CheckNameAvailability(ctx, armstorage.AccountCheckNameAvailabilityParameters{
		Name: to.Ptr("sto3363"),
		Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityResult = armstorage.CheckNameAvailabilityResult{
	// 	NameAvailable: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/NfsV3AccountCreate.json
func ExampleAccountsClient_BeginCreate_nfsV3AccountCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginCreate(ctx, "res9101", "sto4445", armstorage.AccountCreateParameters{
		Kind:     to.Ptr(armstorage.KindBlockBlobStorage),
		Location: to.Ptr("eastus"),
		Properties: &armstorage.AccountPropertiesCreateParameters{
			EnableExtendedGroups: to.Ptr(true),
			IsHnsEnabled:         to.Ptr(true),
			EnableNfsV3:          to.Ptr(true),
			NetworkRuleSet: &armstorage.NetworkRuleSet{
				Bypass:        to.Ptr(armstorage.BypassAzureServices),
				DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
				IPRules:       []*armstorage.IPRule{},
				VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
					{
						VirtualNetworkResourceID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Network/virtualNetworks/net123/subnets/subnet12"),
					}},
			},
			EnableHTTPSTrafficOnly: to.Ptr(false),
		},
		SKU: &armstorage.SKU{
			Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto4445"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Storage/storageAccounts/sto4445"),
	// 	Location: to.Ptr("eastus"),
	// 	Kind: to.Ptr(armstorage.KindBlockBlobStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		EnableExtendedGroups: to.Ptr(true),
	// 		IsHnsEnabled: to.Ptr(true),
	// 		EnableNfsV3: to.Ptr(true),
	// 		NetworkRuleSet: &armstorage.NetworkRuleSet{
	// 			Bypass: to.Ptr(armstorage.BypassAzureServices),
	// 			DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
	// 			IPRules: []*armstorage.IPRule{
	// 			},
	// 			VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
	// 				{
	// 					VirtualNetworkResourceID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Network/virtualNetworks/net123/subnets/subnet12"),
	// 			}},
	// 		},
	// 		EnableHTTPSTrafficOnly: to.Ptr(false),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNamePremiumLRS),
	// 		Tier: to.Ptr(armstorage.SKUTierPremium),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountCreate.json
func ExampleAccountsClient_BeginCreate_storageAccountCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginCreate(ctx, "res9101", "sto4445", armstorage.AccountCreateParameters{
		ExtendedLocation: &armstorage.ExtendedLocation{
			Name: to.Ptr("losangeles001"),
			Type: to.Ptr(armstorage.ExtendedLocationTypesEdgeZone),
		},
		Kind:     to.Ptr(armstorage.KindStorage),
		Location: to.Ptr("eastus"),
		Properties: &armstorage.AccountPropertiesCreateParameters{
			AllowBlobPublicAccess:        to.Ptr(false),
			AllowSharedKeyAccess:         to.Ptr(true),
			DefaultToOAuthAuthentication: to.Ptr(false),
			Encryption: &armstorage.Encryption{
				KeySource:                       to.Ptr(armstorage.KeySourceMicrosoftStorage),
				RequireInfrastructureEncryption: to.Ptr(false),
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
			IsHnsEnabled:  to.Ptr(true),
			IsSftpEnabled: to.Ptr(true),
			KeyPolicy: &armstorage.KeyPolicy{
				KeyExpirationPeriodInDays: to.Ptr[int32](20),
			},
			MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
			RoutingPreference: &armstorage.RoutingPreference{
				PublishInternetEndpoints:  to.Ptr(true),
				PublishMicrosoftEndpoints: to.Ptr(true),
				RoutingChoice:             to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
			},
			SasPolicy: &armstorage.SasPolicy{
				ExpirationAction:    to.Ptr(armstorage.ExpirationActionLog),
				SasExpirationPeriod: to.Ptr("1.15:59:59"),
			},
		},
		SKU: &armstorage.SKU{
			Name: to.Ptr(armstorage.SKUNameStandardGRS),
		},
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
			"key2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto4445"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Storage/storageAccounts/sto4445"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	ExtendedLocation: &armstorage.ExtendedLocation{
	// 		Name: to.Ptr("losangeles001"),
	// 		Type: to.Ptr(armstorage.ExtendedLocationTypesEdgeZone),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AllowBlobPublicAccess: to.Ptr(false),
	// 		AllowSharedKeyAccess: to.Ptr(true),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T13:25:33.486Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
	// 			RequireInfrastructureEncryption: to.Ptr(false),
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		IsSftpEnabled: to.Ptr(true),
	// 		KeyCreationTime: &armstorage.KeyCreationTime{
	// 			Key1: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 			Key2: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 		},
	// 		KeyPolicy: &armstorage.KeyPolicy{
	// 			KeyExpirationPeriodInDays: to.Ptr[int32](20),
	// 		},
	// 		MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto4445.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto4445.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto4445.file.core.windows.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto4445-internetrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto4445-internetrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto4445-internetrouting.file.core.windows.net/"),
	// 				Web: to.Ptr("https://sto4445-internetrouting.web.core.windows.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto4445-microsoftrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto4445-microsoftrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto4445-microsoftrouting.file.core.windows.net/"),
	// 				Queue: to.Ptr("https://sto4445-microsoftrouting.queue.core.windows.net/"),
	// 				Table: to.Ptr("https://sto4445-microsoftrouting.table.core.windows.net/"),
	// 				Web: to.Ptr("https://sto4445-microsoftrouting.web.core.windows.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto4445.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto4445.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto4445.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2euap"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SasPolicy: &armstorage.SasPolicy{
	// 			ExpirationAction: to.Ptr(armstorage.ExpirationActionLog),
	// 			SasExpirationPeriod: to.Ptr("1.15:59:59"),
	// 		},
	// 		SecondaryLocation: to.Ptr("centraluseuap"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(true),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountCreateAllowedCopyScopeToAAD.json
func ExampleAccountsClient_BeginCreate_storageAccountCreateAllowedCopyScopeToAad() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginCreate(ctx, "res9101", "sto4445", armstorage.AccountCreateParameters{
		Kind:     to.Ptr(armstorage.KindStorage),
		Location: to.Ptr("eastus"),
		Properties: &armstorage.AccountPropertiesCreateParameters{
			AllowBlobPublicAccess: to.Ptr(false),
			AllowSharedKeyAccess:  to.Ptr(true),
			AllowedCopyScope:      to.Ptr(armstorage.AllowedCopyScopeAAD),
			Encryption: &armstorage.Encryption{
				KeySource:                       to.Ptr(armstorage.KeySourceMicrosoftStorage),
				RequireInfrastructureEncryption: to.Ptr(false),
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
			IsHnsEnabled: to.Ptr(true),
			KeyPolicy: &armstorage.KeyPolicy{
				KeyExpirationPeriodInDays: to.Ptr[int32](20),
			},
			MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
			RoutingPreference: &armstorage.RoutingPreference{
				PublishInternetEndpoints:  to.Ptr(true),
				PublishMicrosoftEndpoints: to.Ptr(true),
				RoutingChoice:             to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
			},
			SasPolicy: &armstorage.SasPolicy{
				ExpirationAction:    to.Ptr(armstorage.ExpirationActionLog),
				SasExpirationPeriod: to.Ptr("1.15:59:59"),
			},
		},
		SKU: &armstorage.SKU{
			Name: to.Ptr(armstorage.SKUNameStandardGRS),
		},
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
			"key2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto4445"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Storage/storageAccounts/sto4445"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	ExtendedLocation: &armstorage.ExtendedLocation{
	// 		Name: to.Ptr("losangeles001"),
	// 		Type: to.Ptr(armstorage.ExtendedLocationTypesEdgeZone),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AllowBlobPublicAccess: to.Ptr(false),
	// 		AllowSharedKeyAccess: to.Ptr(true),
	// 		AllowedCopyScope: to.Ptr(armstorage.AllowedCopyScopeAAD),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T13:25:33.486Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
	// 			RequireInfrastructureEncryption: to.Ptr(false),
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		KeyCreationTime: &armstorage.KeyCreationTime{
	// 			Key1: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 			Key2: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 		},
	// 		KeyPolicy: &armstorage.KeyPolicy{
	// 			KeyExpirationPeriodInDays: to.Ptr[int32](20),
	// 		},
	// 		MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto4445.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto4445.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto4445.file.core.windows.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto4445-internetrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto4445-internetrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto4445-internetrouting.file.core.windows.net/"),
	// 				Web: to.Ptr("https://sto4445-internetrouting.web.core.windows.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto4445-microsoftrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto4445-microsoftrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto4445-microsoftrouting.file.core.windows.net/"),
	// 				Queue: to.Ptr("https://sto4445-microsoftrouting.queue.core.windows.net/"),
	// 				Table: to.Ptr("https://sto4445-microsoftrouting.table.core.windows.net/"),
	// 				Web: to.Ptr("https://sto4445-microsoftrouting.web.core.windows.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto4445.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto4445.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto4445.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2euap"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SasPolicy: &armstorage.SasPolicy{
	// 			ExpirationAction: to.Ptr(armstorage.ExpirationActionLog),
	// 			SasExpirationPeriod: to.Ptr("1.15:59:59"),
	// 		},
	// 		SecondaryLocation: to.Ptr("centraluseuap"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(true),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountCreateAllowedCopyScopeToPrivateLink.json
func ExampleAccountsClient_BeginCreate_storageAccountCreateAllowedCopyScopeToPrivateLink() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginCreate(ctx, "res9101", "sto4445", armstorage.AccountCreateParameters{
		Kind:     to.Ptr(armstorage.KindStorage),
		Location: to.Ptr("eastus"),
		Properties: &armstorage.AccountPropertiesCreateParameters{
			AllowBlobPublicAccess: to.Ptr(false),
			AllowSharedKeyAccess:  to.Ptr(true),
			AllowedCopyScope:      to.Ptr(armstorage.AllowedCopyScopePrivateLink),
			Encryption: &armstorage.Encryption{
				KeySource:                       to.Ptr(armstorage.KeySourceMicrosoftStorage),
				RequireInfrastructureEncryption: to.Ptr(false),
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
			IsHnsEnabled: to.Ptr(true),
			KeyPolicy: &armstorage.KeyPolicy{
				KeyExpirationPeriodInDays: to.Ptr[int32](20),
			},
			MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
			RoutingPreference: &armstorage.RoutingPreference{
				PublishInternetEndpoints:  to.Ptr(true),
				PublishMicrosoftEndpoints: to.Ptr(true),
				RoutingChoice:             to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
			},
			SasPolicy: &armstorage.SasPolicy{
				ExpirationAction:    to.Ptr(armstorage.ExpirationActionLog),
				SasExpirationPeriod: to.Ptr("1.15:59:59"),
			},
		},
		SKU: &armstorage.SKU{
			Name: to.Ptr(armstorage.SKUNameStandardGRS),
		},
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
			"key2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto4445"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Storage/storageAccounts/sto4445"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	ExtendedLocation: &armstorage.ExtendedLocation{
	// 		Name: to.Ptr("losangeles001"),
	// 		Type: to.Ptr(armstorage.ExtendedLocationTypesEdgeZone),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AllowBlobPublicAccess: to.Ptr(false),
	// 		AllowSharedKeyAccess: to.Ptr(true),
	// 		AllowedCopyScope: to.Ptr(armstorage.AllowedCopyScopePrivateLink),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T13:25:33.486Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
	// 			RequireInfrastructureEncryption: to.Ptr(false),
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		KeyCreationTime: &armstorage.KeyCreationTime{
	// 			Key1: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 			Key2: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 		},
	// 		KeyPolicy: &armstorage.KeyPolicy{
	// 			KeyExpirationPeriodInDays: to.Ptr[int32](20),
	// 		},
	// 		MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto4445.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto4445.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto4445.file.core.windows.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto4445-internetrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto4445-internetrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto4445-internetrouting.file.core.windows.net/"),
	// 				Web: to.Ptr("https://sto4445-internetrouting.web.core.windows.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto4445-microsoftrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto4445-microsoftrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto4445-microsoftrouting.file.core.windows.net/"),
	// 				Queue: to.Ptr("https://sto4445-microsoftrouting.queue.core.windows.net/"),
	// 				Table: to.Ptr("https://sto4445-microsoftrouting.table.core.windows.net/"),
	// 				Web: to.Ptr("https://sto4445-microsoftrouting.web.core.windows.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto4445.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto4445.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto4445.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2euap"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SasPolicy: &armstorage.SasPolicy{
	// 			ExpirationAction: to.Ptr(armstorage.ExpirationActionLog),
	// 			SasExpirationPeriod: to.Ptr("1.15:59:59"),
	// 		},
	// 		SecondaryLocation: to.Ptr("centraluseuap"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(true),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountCreateDisallowPublicNetworkAccess.json
func ExampleAccountsClient_BeginCreate_storageAccountCreateDisallowPublicNetworkAccess() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginCreate(ctx, "res9101", "sto4445", armstorage.AccountCreateParameters{
		ExtendedLocation: &armstorage.ExtendedLocation{
			Name: to.Ptr("losangeles001"),
			Type: to.Ptr(armstorage.ExtendedLocationTypesEdgeZone),
		},
		Kind:     to.Ptr(armstorage.KindStorage),
		Location: to.Ptr("eastus"),
		Properties: &armstorage.AccountPropertiesCreateParameters{
			AllowBlobPublicAccess: to.Ptr(false),
			AllowSharedKeyAccess:  to.Ptr(true),
			Encryption: &armstorage.Encryption{
				KeySource:                       to.Ptr(armstorage.KeySourceMicrosoftStorage),
				RequireInfrastructureEncryption: to.Ptr(false),
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
			IsHnsEnabled: to.Ptr(true),
			KeyPolicy: &armstorage.KeyPolicy{
				KeyExpirationPeriodInDays: to.Ptr[int32](20),
			},
			MinimumTLSVersion:   to.Ptr(armstorage.MinimumTLSVersionTLS12),
			PublicNetworkAccess: to.Ptr(armstorage.PublicNetworkAccessDisabled),
			RoutingPreference: &armstorage.RoutingPreference{
				PublishInternetEndpoints:  to.Ptr(true),
				PublishMicrosoftEndpoints: to.Ptr(true),
				RoutingChoice:             to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
			},
			SasPolicy: &armstorage.SasPolicy{
				ExpirationAction:    to.Ptr(armstorage.ExpirationActionLog),
				SasExpirationPeriod: to.Ptr("1.15:59:59"),
			},
		},
		SKU: &armstorage.SKU{
			Name: to.Ptr(armstorage.SKUNameStandardGRS),
		},
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
			"key2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto4445"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Storage/storageAccounts/sto4445"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	ExtendedLocation: &armstorage.ExtendedLocation{
	// 		Name: to.Ptr("losangeles001"),
	// 		Type: to.Ptr(armstorage.ExtendedLocationTypesEdgeZone),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AllowBlobPublicAccess: to.Ptr(false),
	// 		AllowSharedKeyAccess: to.Ptr(true),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T13:25:33.486Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
	// 			RequireInfrastructureEncryption: to.Ptr(false),
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		KeyCreationTime: &armstorage.KeyCreationTime{
	// 			Key1: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 			Key2: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 		},
	// 		KeyPolicy: &armstorage.KeyPolicy{
	// 			KeyExpirationPeriodInDays: to.Ptr[int32](20),
	// 		},
	// 		MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto4445.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto4445.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto4445.file.core.windows.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto4445-internetrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto4445-internetrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto4445-internetrouting.file.core.windows.net/"),
	// 				Web: to.Ptr("https://sto4445-internetrouting.web.core.windows.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto4445-microsoftrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto4445-microsoftrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto4445-microsoftrouting.file.core.windows.net/"),
	// 				Queue: to.Ptr("https://sto4445-microsoftrouting.queue.core.windows.net/"),
	// 				Table: to.Ptr("https://sto4445-microsoftrouting.table.core.windows.net/"),
	// 				Web: to.Ptr("https://sto4445-microsoftrouting.web.core.windows.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto4445.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto4445.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto4445.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2euap"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armstorage.PublicNetworkAccessDisabled),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SasPolicy: &armstorage.SasPolicy{
	// 			ExpirationAction: to.Ptr(armstorage.ExpirationActionLog),
	// 			SasExpirationPeriod: to.Ptr("1.15:59:59"),
	// 		},
	// 		SecondaryLocation: to.Ptr("centraluseuap"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(true),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountCreateDnsEndpointTypeToAzureDnsZone.json
func ExampleAccountsClient_BeginCreate_storageAccountCreateDnsEndpointTypeToAzureDnsZone() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginCreate(ctx, "res9101", "sto4445", armstorage.AccountCreateParameters{
		ExtendedLocation: &armstorage.ExtendedLocation{
			Name: to.Ptr("losangeles001"),
			Type: to.Ptr(armstorage.ExtendedLocationTypesEdgeZone),
		},
		Kind:     to.Ptr(armstorage.KindStorage),
		Location: to.Ptr("eastus"),
		Properties: &armstorage.AccountPropertiesCreateParameters{
			AllowBlobPublicAccess:        to.Ptr(false),
			AllowSharedKeyAccess:         to.Ptr(true),
			DefaultToOAuthAuthentication: to.Ptr(false),
			DNSEndpointType:              to.Ptr(armstorage.DNSEndpointTypeAzureDNSZone),
			Encryption: &armstorage.Encryption{
				KeySource:                       to.Ptr(armstorage.KeySourceMicrosoftStorage),
				RequireInfrastructureEncryption: to.Ptr(false),
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
			IsHnsEnabled:  to.Ptr(true),
			IsSftpEnabled: to.Ptr(true),
			KeyPolicy: &armstorage.KeyPolicy{
				KeyExpirationPeriodInDays: to.Ptr[int32](20),
			},
			MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
			RoutingPreference: &armstorage.RoutingPreference{
				PublishInternetEndpoints:  to.Ptr(true),
				PublishMicrosoftEndpoints: to.Ptr(true),
				RoutingChoice:             to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
			},
			SasPolicy: &armstorage.SasPolicy{
				ExpirationAction:    to.Ptr(armstorage.ExpirationActionLog),
				SasExpirationPeriod: to.Ptr("1.15:59:59"),
			},
		},
		SKU: &armstorage.SKU{
			Name: to.Ptr(armstorage.SKUNameStandardGRS),
		},
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
			"key2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto4445"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Storage/storageAccounts/sto4445"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	ExtendedLocation: &armstorage.ExtendedLocation{
	// 		Name: to.Ptr("losangeles001"),
	// 		Type: to.Ptr(armstorage.ExtendedLocationTypesEdgeZone),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AllowBlobPublicAccess: to.Ptr(false),
	// 		AllowSharedKeyAccess: to.Ptr(true),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T13:25:33.486Z"); return t}()),
	// 		DNSEndpointType: to.Ptr(armstorage.DNSEndpointTypeAzureDNSZone),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
	// 			RequireInfrastructureEncryption: to.Ptr(false),
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		IsSftpEnabled: to.Ptr(true),
	// 		KeyCreationTime: &armstorage.KeyCreationTime{
	// 			Key1: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 			Key2: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 		},
	// 		KeyPolicy: &armstorage.KeyPolicy{
	// 			KeyExpirationPeriodInDays: to.Ptr[int32](20),
	// 		},
	// 		MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto4445.z24.blob.storage.azure.net/"),
	// 			Dfs: to.Ptr("https://sto4445.z24.dfs.storage.azure.net/"),
	// 			File: to.Ptr("https://sto4445.z24.file.storage.azure.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto4445-internetrouting.z24.blob.storage.azure.net/"),
	// 				Dfs: to.Ptr("https://sto4445-internetrouting.z24.dfs.storage.azure.net/"),
	// 				File: to.Ptr("https://sto4445-internetrouting.z24.file.storage.azure.net/"),
	// 				Web: to.Ptr("https://sto4445-internetrouting.z24.web.storage.azure.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto4445-microsoftrouting.z24.blob.storage.azure.net/"),
	// 				Dfs: to.Ptr("https://sto4445-microsoftrouting.z24.dfs.storage.azure.net/"),
	// 				File: to.Ptr("https://sto4445-microsoftrouting.z24.file.storage.azure.net/"),
	// 				Queue: to.Ptr("https://sto4445-microsoftrouting.z24.queue.storage.azure.net/"),
	// 				Table: to.Ptr("https://sto4445-microsoftrouting.z24.table.storage.azure.net/"),
	// 				Web: to.Ptr("https://sto4445-microsoftrouting.z24.web.storage.azure.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto4445.z24.queue.storage.azure.net/"),
	// 			Table: to.Ptr("https://sto4445.z24.table.storage.azure.net/"),
	// 			Web: to.Ptr("https://sto4445.z24.web.storage.azure.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2euap"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SasPolicy: &armstorage.SasPolicy{
	// 			ExpirationAction: to.Ptr(armstorage.ExpirationActionLog),
	// 			SasExpirationPeriod: to.Ptr("1.15:59:59"),
	// 		},
	// 		SecondaryLocation: to.Ptr("centraluseuap"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(true),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountCreateDnsEndpointTypeToStandard.json
func ExampleAccountsClient_BeginCreate_storageAccountCreateDnsEndpointTypeToStandard() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginCreate(ctx, "res9101", "sto4445", armstorage.AccountCreateParameters{
		ExtendedLocation: &armstorage.ExtendedLocation{
			Name: to.Ptr("losangeles001"),
			Type: to.Ptr(armstorage.ExtendedLocationTypesEdgeZone),
		},
		Kind:     to.Ptr(armstorage.KindStorage),
		Location: to.Ptr("eastus"),
		Properties: &armstorage.AccountPropertiesCreateParameters{
			AllowBlobPublicAccess:        to.Ptr(false),
			AllowSharedKeyAccess:         to.Ptr(true),
			DefaultToOAuthAuthentication: to.Ptr(false),
			DNSEndpointType:              to.Ptr(armstorage.DNSEndpointTypeStandard),
			Encryption: &armstorage.Encryption{
				KeySource:                       to.Ptr(armstorage.KeySourceMicrosoftStorage),
				RequireInfrastructureEncryption: to.Ptr(false),
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
			IsHnsEnabled:  to.Ptr(true),
			IsSftpEnabled: to.Ptr(true),
			KeyPolicy: &armstorage.KeyPolicy{
				KeyExpirationPeriodInDays: to.Ptr[int32](20),
			},
			MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
			RoutingPreference: &armstorage.RoutingPreference{
				PublishInternetEndpoints:  to.Ptr(true),
				PublishMicrosoftEndpoints: to.Ptr(true),
				RoutingChoice:             to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
			},
			SasPolicy: &armstorage.SasPolicy{
				ExpirationAction:    to.Ptr(armstorage.ExpirationActionLog),
				SasExpirationPeriod: to.Ptr("1.15:59:59"),
			},
		},
		SKU: &armstorage.SKU{
			Name: to.Ptr(armstorage.SKUNameStandardGRS),
		},
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
			"key2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto4445"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Storage/storageAccounts/sto4445"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	ExtendedLocation: &armstorage.ExtendedLocation{
	// 		Name: to.Ptr("losangeles001"),
	// 		Type: to.Ptr(armstorage.ExtendedLocationTypesEdgeZone),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AllowBlobPublicAccess: to.Ptr(false),
	// 		AllowSharedKeyAccess: to.Ptr(true),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T13:25:33.486Z"); return t}()),
	// 		DNSEndpointType: to.Ptr(armstorage.DNSEndpointTypeStandard),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
	// 			RequireInfrastructureEncryption: to.Ptr(false),
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		IsSftpEnabled: to.Ptr(true),
	// 		KeyCreationTime: &armstorage.KeyCreationTime{
	// 			Key1: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 			Key2: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 		},
	// 		KeyPolicy: &armstorage.KeyPolicy{
	// 			KeyExpirationPeriodInDays: to.Ptr[int32](20),
	// 		},
	// 		MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto4445.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto4445.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto4445.file.core.windows.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto4445-internetrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto4445-internetrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto4445-internetrouting.file.core.windows.net/"),
	// 				Web: to.Ptr("https://sto4445-internetrouting.web.core.windows.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto4445-microsoftrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto4445-microsoftrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto4445-microsoftrouting.file.core.windows.net/"),
	// 				Queue: to.Ptr("https://sto4445-microsoftrouting.queue.core.windows.net/"),
	// 				Table: to.Ptr("https://sto4445-microsoftrouting.table.core.windows.net/"),
	// 				Web: to.Ptr("https://sto4445-microsoftrouting.web.core.windows.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto4445.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto4445.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto4445.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2euap"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SasPolicy: &armstorage.SasPolicy{
	// 			ExpirationAction: to.Ptr(armstorage.ExpirationActionLog),
	// 			SasExpirationPeriod: to.Ptr("1.15:59:59"),
	// 		},
	// 		SecondaryLocation: to.Ptr("centraluseuap"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(true),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountCreateEnablePublicNetworkAccess.json
func ExampleAccountsClient_BeginCreate_storageAccountCreateEnablePublicNetworkAccess() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginCreate(ctx, "res9101", "sto4445", armstorage.AccountCreateParameters{
		ExtendedLocation: &armstorage.ExtendedLocation{
			Name: to.Ptr("losangeles001"),
			Type: to.Ptr(armstorage.ExtendedLocationTypesEdgeZone),
		},
		Kind:     to.Ptr(armstorage.KindStorage),
		Location: to.Ptr("eastus"),
		Properties: &armstorage.AccountPropertiesCreateParameters{
			AllowBlobPublicAccess: to.Ptr(false),
			AllowSharedKeyAccess:  to.Ptr(true),
			Encryption: &armstorage.Encryption{
				KeySource:                       to.Ptr(armstorage.KeySourceMicrosoftStorage),
				RequireInfrastructureEncryption: to.Ptr(false),
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
			IsHnsEnabled: to.Ptr(true),
			KeyPolicy: &armstorage.KeyPolicy{
				KeyExpirationPeriodInDays: to.Ptr[int32](20),
			},
			MinimumTLSVersion:   to.Ptr(armstorage.MinimumTLSVersionTLS12),
			PublicNetworkAccess: to.Ptr(armstorage.PublicNetworkAccessEnabled),
			RoutingPreference: &armstorage.RoutingPreference{
				PublishInternetEndpoints:  to.Ptr(true),
				PublishMicrosoftEndpoints: to.Ptr(true),
				RoutingChoice:             to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
			},
			SasPolicy: &armstorage.SasPolicy{
				ExpirationAction:    to.Ptr(armstorage.ExpirationActionLog),
				SasExpirationPeriod: to.Ptr("1.15:59:59"),
			},
		},
		SKU: &armstorage.SKU{
			Name: to.Ptr(armstorage.SKUNameStandardGRS),
		},
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
			"key2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto4445"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Storage/storageAccounts/sto4445"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	ExtendedLocation: &armstorage.ExtendedLocation{
	// 		Name: to.Ptr("losangeles001"),
	// 		Type: to.Ptr(armstorage.ExtendedLocationTypesEdgeZone),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AllowBlobPublicAccess: to.Ptr(false),
	// 		AllowSharedKeyAccess: to.Ptr(true),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T13:25:33.486Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
	// 			RequireInfrastructureEncryption: to.Ptr(false),
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		KeyCreationTime: &armstorage.KeyCreationTime{
	// 			Key1: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 			Key2: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 		},
	// 		KeyPolicy: &armstorage.KeyPolicy{
	// 			KeyExpirationPeriodInDays: to.Ptr[int32](20),
	// 		},
	// 		MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto4445.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto4445.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto4445.file.core.windows.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto4445-internetrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto4445-internetrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto4445-internetrouting.file.core.windows.net/"),
	// 				Web: to.Ptr("https://sto4445-internetrouting.web.core.windows.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto4445-microsoftrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto4445-microsoftrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto4445-microsoftrouting.file.core.windows.net/"),
	// 				Queue: to.Ptr("https://sto4445-microsoftrouting.queue.core.windows.net/"),
	// 				Table: to.Ptr("https://sto4445-microsoftrouting.table.core.windows.net/"),
	// 				Web: to.Ptr("https://sto4445-microsoftrouting.web.core.windows.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto4445.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto4445.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto4445.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2euap"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armstorage.PublicNetworkAccessEnabled),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SasPolicy: &armstorage.SasPolicy{
	// 			ExpirationAction: to.Ptr(armstorage.ExpirationActionLog),
	// 			SasExpirationPeriod: to.Ptr("1.15:59:59"),
	// 		},
	// 		SecondaryLocation: to.Ptr("centraluseuap"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(true),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountCreatePremiumBlockBlobStorage.json
func ExampleAccountsClient_BeginCreate_storageAccountCreatePremiumBlockBlobStorage() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginCreate(ctx, "res9101", "sto4445", armstorage.AccountCreateParameters{
		Kind:     to.Ptr(armstorage.KindBlockBlobStorage),
		Location: to.Ptr("eastus"),
		Properties: &armstorage.AccountPropertiesCreateParameters{
			AllowSharedKeyAccess: to.Ptr(true),
			Encryption: &armstorage.Encryption{
				KeySource:                       to.Ptr(armstorage.KeySourceMicrosoftStorage),
				RequireInfrastructureEncryption: to.Ptr(false),
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
			MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
		},
		SKU: &armstorage.SKU{
			Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		},
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
			"key2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto4445"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Storage/storageAccounts/sto4445"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AccessTier: to.Ptr(armstorage.AccessTierPremium),
	// 		AllowBlobPublicAccess: to.Ptr(false),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T13:25:33.486Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
	// 			RequireInfrastructureEncryption: to.Ptr(false),
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto4445.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto4445.dfs.core.windows.net/"),
	// 			Web: to.Ptr("https://sto4445.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2euap"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(true),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNamePremiumLRS),
	// 		Tier: to.Ptr(armstorage.SKUTierPremium),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountCreateUserAssignedEncryptionIdentityWithCMK.json
func ExampleAccountsClient_BeginCreate_storageAccountCreateUserAssignedEncryptionIdentityWithCmk() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginCreate(ctx, "res9101", "sto4445", armstorage.AccountCreateParameters{
		Identity: &armstorage.Identity{
			Type: to.Ptr(armstorage.IdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armstorage.UserAssignedIdentity{
				"/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}": {},
			},
		},
		Kind:     to.Ptr(armstorage.KindStorage),
		Location: to.Ptr("eastus"),
		Properties: &armstorage.AccountPropertiesCreateParameters{
			Encryption: &armstorage.Encryption{
				EncryptionIdentity: &armstorage.EncryptionIdentity{
					EncryptionUserAssignedIdentity: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}"),
				},
				KeySource: to.Ptr(armstorage.KeySourceMicrosoftKeyvault),
				KeyVaultProperties: &armstorage.KeyVaultProperties{
					KeyName:     to.Ptr("wrappingKey"),
					KeyVaultURI: to.Ptr("https://myvault8569.vault.azure.net"),
					KeyVersion:  to.Ptr(""),
				},
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
		},
		SKU: &armstorage.SKU{
			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto4445"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Storage/storageAccounts/sto4445"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armstorage.Identity{
	// 		Type: to.Ptr(armstorage.IdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armstorage.UserAssignedIdentity{
	// 			"/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}": &armstorage.UserAssignedIdentity{
	// 				ClientID: to.Ptr("fbaa6278-1ecc-415c-819f-6e2058d3acb5"),
	// 				PrincipalID: to.Ptr("8d823284-1060-42a5-9ec4-ed3d831e24d7"),
	// 			},
	// 		},
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorageV2),
	// 	Properties: &armstorage.AccountProperties{
	// 		AccessTier: to.Ptr(armstorage.AccessTierHot),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-15T00:43:14.083Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			EncryptionIdentity: &armstorage.EncryptionIdentity{
	// 				EncryptionUserAssignedIdentity: to.Ptr("/subscriptions/{subscription-id}/resourcegroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}"),
	// 			},
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftKeyvault),
	// 			KeyVaultProperties: &armstorage.KeyVaultProperties{
	// 				CurrentVersionedKeyIdentifier: to.Ptr("https://myvault8569.vault.azure.net/keys/wrappingKey/0682afdd9c104f4285df20107e956cad"),
	// 				KeyName: to.Ptr("wrappingKey"),
	// 				KeyVaultURI: to.Ptr("https://myvault8569.vault.azure.net"),
	// 				KeyVersion: to.Ptr(""),
	// 				LastKeyRotationTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-13T20:36:23.702Z"); return t}()),
	// 			},
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-15T00:43:14.173Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-15T00:43:14.173Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		NetworkRuleSet: &armstorage.NetworkRuleSet{
	// 			Bypass: to.Ptr(armstorage.BypassAzureServices),
	// 			DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
	// 			IPRules: []*armstorage.IPRule{
	// 			},
	// 			VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
	// 			},
	// 		},
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto4445.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto4445.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto4445.file.core.windows.net/"),
	// 			Queue: to.Ptr("https://sto4445.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto4445.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto4445.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus"),
	// 		PrivateEndpointConnections: []*armstorage.PrivateEndpointConnection{
	// 		},
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(true),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardLRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountCreateUserAssignedIdentityWithFederatedIdentityClientId.json
func ExampleAccountsClient_BeginCreate_storageAccountCreateUserAssignedIdentityWithFederatedIdentityClientId() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginCreate(ctx, "res131918", "sto131918", armstorage.AccountCreateParameters{
		Identity: &armstorage.Identity{
			Type: to.Ptr(armstorage.IdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armstorage.UserAssignedIdentity{
				"/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}": {},
			},
		},
		Kind:     to.Ptr(armstorage.KindStorage),
		Location: to.Ptr("eastus"),
		Properties: &armstorage.AccountPropertiesCreateParameters{
			Encryption: &armstorage.Encryption{
				EncryptionIdentity: &armstorage.EncryptionIdentity{
					EncryptionFederatedIdentityClientID: to.Ptr("f83c6b1b-4d34-47e4-bb34-9d83df58b540"),
					EncryptionUserAssignedIdentity:      to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}"),
				},
				KeySource: to.Ptr(armstorage.KeySourceMicrosoftKeyvault),
				KeyVaultProperties: &armstorage.KeyVaultProperties{
					KeyName:     to.Ptr("wrappingKey"),
					KeyVaultURI: to.Ptr("https://myvault8569.vault.azure.net"),
					KeyVersion:  to.Ptr(""),
				},
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
		},
		SKU: &armstorage.SKU{
			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto4445"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Storage/storageAccounts/sto4445"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armstorage.Identity{
	// 		Type: to.Ptr(armstorage.IdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armstorage.UserAssignedIdentity{
	// 			"/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}": &armstorage.UserAssignedIdentity{
	// 				ClientID: to.Ptr("fbaa6278-1ecc-415c-819f-6e2058d3acb5"),
	// 				PrincipalID: to.Ptr("8d823284-1060-42a5-9ec4-ed3d831e24d7"),
	// 			},
	// 		},
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorageV2),
	// 	Properties: &armstorage.AccountProperties{
	// 		AccessTier: to.Ptr(armstorage.AccessTierHot),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-15T00:43:14.083Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			EncryptionIdentity: &armstorage.EncryptionIdentity{
	// 				EncryptionFederatedIdentityClientID: to.Ptr("f83c6b1b-4d34-47e4-bb34-9d83df58b540"),
	// 				EncryptionUserAssignedIdentity: to.Ptr("/subscriptions/{subscription-id}/resourcegroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}"),
	// 			},
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftKeyvault),
	// 			KeyVaultProperties: &armstorage.KeyVaultProperties{
	// 				CurrentVersionedKeyIdentifier: to.Ptr("https://myvault8569.vault.azure.net/keys/wrappingKey/0682afdd9c104f4285df20107e956cad"),
	// 				KeyName: to.Ptr("wrappingKey"),
	// 				KeyVaultURI: to.Ptr("https://myvault8569.vault.azure.net"),
	// 				KeyVersion: to.Ptr(""),
	// 				LastKeyRotationTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-13T20:36:23.702Z"); return t}()),
	// 			},
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-15T00:43:14.173Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-15T00:43:14.173Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		NetworkRuleSet: &armstorage.NetworkRuleSet{
	// 			Bypass: to.Ptr(armstorage.BypassAzureServices),
	// 			DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
	// 			IPRules: []*armstorage.IPRule{
	// 			},
	// 			VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
	// 			},
	// 		},
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto4445.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto4445.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto4445.file.core.windows.net/"),
	// 			Queue: to.Ptr("https://sto4445.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto4445.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto4445.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus"),
	// 		PrivateEndpointConnections: []*armstorage.PrivateEndpointConnection{
	// 		},
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(true),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardLRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountCreateWithImmutabilityPolicy.json
func ExampleAccountsClient_BeginCreate_storageAccountCreateWithImmutabilityPolicy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginCreate(ctx, "res9101", "sto4445", armstorage.AccountCreateParameters{
		ExtendedLocation: &armstorage.ExtendedLocation{
			Name: to.Ptr("losangeles001"),
			Type: to.Ptr(armstorage.ExtendedLocationTypesEdgeZone),
		},
		Kind:     to.Ptr(armstorage.KindStorage),
		Location: to.Ptr("eastus"),
		Properties: &armstorage.AccountPropertiesCreateParameters{
			ImmutableStorageWithVersioning: &armstorage.ImmutableStorageAccount{
				Enabled: to.Ptr(true),
				ImmutabilityPolicy: &armstorage.AccountImmutabilityPolicyProperties{
					AllowProtectedAppendWrites:            to.Ptr(true),
					ImmutabilityPeriodSinceCreationInDays: to.Ptr[int32](15),
					State:                                 to.Ptr(armstorage.AccountImmutabilityPolicyStateUnlocked),
				},
			},
		},
		SKU: &armstorage.SKU{
			Name: to.Ptr(armstorage.SKUNameStandardGRS),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto4445"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Storage/storageAccounts/sto4445"),
	// 	Location: to.Ptr("eastus"),
	// 	ExtendedLocation: &armstorage.ExtendedLocation{
	// 		Name: to.Ptr("losangeles001"),
	// 		Type: to.Ptr(armstorage.ExtendedLocationTypesEdgeZone),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T13:25:33.486Z"); return t}()),
	// 		ImmutableStorageWithVersioning: &armstorage.ImmutableStorageAccount{
	// 			Enabled: to.Ptr(true),
	// 			ImmutabilityPolicy: &armstorage.AccountImmutabilityPolicyProperties{
	// 				AllowProtectedAppendWrites: to.Ptr(true),
	// 				ImmutabilityPeriodSinceCreationInDays: to.Ptr[int32](15),
	// 				State: to.Ptr(armstorage.AccountImmutabilityPolicyStateUnlocked),
	// 			},
	// 		},
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto4445.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto4445.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto4445.file.core.windows.net/"),
	// 			Queue: to.Ptr("https://sto4445.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto4445.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto4445.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2euap"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountDelete.json
func ExampleAccountsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAccountsClient().Delete(ctx, "res4228", "sto2434", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountGetAsyncSkuConversionStatus.json
func ExampleAccountsClient_GetProperties_storageAccountGetAsyncSkuConversionStatus() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().GetProperties(ctx, "res9407", "sto8596", &armstorage.AccountsClientGetPropertiesOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto8596"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9407/providers/Microsoft.Storage/storageAccounts/sto8596"),
	// 	Location: to.Ptr("eastus"),
	// 	Kind: to.Ptr(armstorage.KindStorageV2),
	// 	Properties: &armstorage.AccountProperties{
	// 		AllowBlobPublicAccess: to.Ptr(false),
	// 		MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
	// 		StorageAccountSKUConversionStatus: &armstorage.AccountSKUConversionStatus{
	// 			EndTime: to.Ptr("2021-09-02T02:53:39.0932539Z"),
	// 			SKUConversionStatus: to.Ptr(armstorage.SKUConversionStatusInProgress),
	// 			StartTime: to.Ptr("2022-09-01T02:53:39.0932539Z"),
	// 			TargetSKUName: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		},
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountGetProperties.json
func ExampleAccountsClient_GetProperties_storageAccountGetProperties() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().GetProperties(ctx, "res9407", "sto8596", &armstorage.AccountsClientGetPropertiesOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto8596"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9407/providers/Microsoft.Storage/storageAccounts/sto8596"),
	// 	Location: to.Ptr("eastus2(stage)"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AccountMigrationInProgress: to.Ptr(false),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T02:42:41.763Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		GeoReplicationStats: &armstorage.GeoReplicationStats{
	// 			CanFailover: to.Ptr(true),
	// 			LastSyncTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-10-30T00:25:34.000Z"); return t}()),
	// 			Status: to.Ptr(armstorage.GeoReplicationStatusLive),
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		IsSKUConversionBlocked: to.Ptr(false),
	// 		KeyCreationTime: &armstorage.KeyCreationTime{
	// 			Key1: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 			Key2: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 		},
	// 		NetworkRuleSet: &armstorage.NetworkRuleSet{
	// 			Bypass: to.Ptr(armstorage.BypassAzureServices),
	// 			DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
	// 			IPRules: []*armstorage.IPRule{
	// 			},
	// 			ResourceAccessRules: []*armstorage.ResourceAccessRule{
	// 				{
	// 					ResourceID: to.Ptr("/subscriptions/a7e99807-abbf-4642-bdec-2c809a96a8bc/resourceGroups/res9407/providers/Microsoft.Synapse/workspaces/testworkspace"),
	// 					TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 			}},
	// 			VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
	// 			},
	// 		},
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto8596.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto8596.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto8596.file.core.windows.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto8596-internetrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-internetrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-internetrouting.file.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-internetrouting.web.core.windows.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto8596-microsoftrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-microsoftrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-microsoftrouting.file.core.windows.net/"),
	// 				Queue: to.Ptr("https://sto8596-microsoftrouting.queue.core.windows.net/"),
	// 				Table: to.Ptr("https://sto8596-microsoftrouting.table.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-microsoftrouting.web.core.windows.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto8596.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto8596.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto8596.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2(stage)"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SecondaryLocation: to.Ptr("northcentralus(stage)"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(false),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountGetPropertiesCMKEnabled.json
func ExampleAccountsClient_GetProperties_storageAccountGetPropertiesCmkEnabled() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().GetProperties(ctx, "res9407", "sto8596", &armstorage.AccountsClientGetPropertiesOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto8596"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9407/providers/Microsoft.Storage/storageAccounts/sto8596"),
	// 	Location: to.Ptr("eastus2(stage)"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Identity: &armstorage.Identity{
	// 		Type: to.Ptr(armstorage.IdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("911871cc-ffd1-4fc4-ac11-7a316433ea66"),
	// 		TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T02:42:41.763Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftKeyvault),
	// 			KeyVaultProperties: &armstorage.KeyVaultProperties{
	// 				CurrentVersionedKeyIdentifier: to.Ptr("https://myvault8569.vault.azure.net/keys/wrappingKey/0682afdd9c104f4285df20107e956cad"),
	// 				KeyName: to.Ptr("wrappingKey"),
	// 				KeyVaultURI: to.Ptr("https://myvault8569.vault.azure.net"),
	// 				KeyVersion: to.Ptr(""),
	// 				LastKeyRotationTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-13T20:36:23.702Z"); return t}()),
	// 			},
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		GeoReplicationStats: &armstorage.GeoReplicationStats{
	// 			CanFailover: to.Ptr(true),
	// 			LastSyncTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-10-30T00:25:34.000Z"); return t}()),
	// 			Status: to.Ptr(armstorage.GeoReplicationStatusLive),
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		NetworkRuleSet: &armstorage.NetworkRuleSet{
	// 			Bypass: to.Ptr(armstorage.BypassAzureServices),
	// 			DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
	// 			IPRules: []*armstorage.IPRule{
	// 			},
	// 			ResourceAccessRules: []*armstorage.ResourceAccessRule{
	// 			},
	// 			VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
	// 			},
	// 		},
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto8596.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto8596.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto8596.file.core.windows.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto8596-internetrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-internetrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-internetrouting.file.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-internetrouting.web.core.windows.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto8596-microsoftrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-microsoftrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-microsoftrouting.file.core.windows.net/"),
	// 				Queue: to.Ptr("https://sto8596-microsoftrouting.queue.core.windows.net/"),
	// 				Table: to.Ptr("https://sto8596-microsoftrouting.table.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-microsoftrouting.web.core.windows.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto8596.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto8596.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto8596.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2(stage)"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SecondaryLocation: to.Ptr("northcentralus(stage)"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(false),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountGetPropertiesCMKVersionExpirationTime.json
func ExampleAccountsClient_GetProperties_storageAccountGetPropertiesCmkVersionExpirationTime() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().GetProperties(ctx, "res9407", "sto8596", &armstorage.AccountsClientGetPropertiesOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto8596"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9407/providers/Microsoft.Storage/storageAccounts/sto8596"),
	// 	Location: to.Ptr("eastus2(stage)"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Identity: &armstorage.Identity{
	// 		Type: to.Ptr(armstorage.IdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("911871cc-ffd1-4fc4-ac11-7a316433ea66"),
	// 		TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T02:42:41.763Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftKeyvault),
	// 			KeyVaultProperties: &armstorage.KeyVaultProperties{
	// 				CurrentVersionedKeyExpirationTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-13T20:36:23.702Z"); return t}()),
	// 				CurrentVersionedKeyIdentifier: to.Ptr("https://myvault8569.vault.azure.net/keys/wrappingKey/0682afdd9c104f4285df20107e956cad"),
	// 				KeyName: to.Ptr("wrappingKey"),
	// 				KeyVaultURI: to.Ptr("https://myvault8569.vault.azure.net"),
	// 				KeyVersion: to.Ptr(""),
	// 				LastKeyRotationTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-13T20:36:23.702Z"); return t}()),
	// 			},
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		GeoReplicationStats: &armstorage.GeoReplicationStats{
	// 			CanFailover: to.Ptr(true),
	// 			LastSyncTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-10-30T00:25:34.000Z"); return t}()),
	// 			Status: to.Ptr(armstorage.GeoReplicationStatusLive),
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		NetworkRuleSet: &armstorage.NetworkRuleSet{
	// 			Bypass: to.Ptr(armstorage.BypassAzureServices),
	// 			DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
	// 			IPRules: []*armstorage.IPRule{
	// 			},
	// 			ResourceAccessRules: []*armstorage.ResourceAccessRule{
	// 			},
	// 			VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
	// 			},
	// 		},
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto8596.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto8596.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto8596.file.core.windows.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto8596-internetrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-internetrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-internetrouting.file.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-internetrouting.web.core.windows.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto8596-microsoftrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-microsoftrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-microsoftrouting.file.core.windows.net/"),
	// 				Queue: to.Ptr("https://sto8596-microsoftrouting.queue.core.windows.net/"),
	// 				Table: to.Ptr("https://sto8596-microsoftrouting.table.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-microsoftrouting.web.core.windows.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto8596.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto8596.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto8596.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2(stage)"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SecondaryLocation: to.Ptr("northcentralus(stage)"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(false),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountGetPropertiesGeoReplicationStatscanFailoverFalse.json
func ExampleAccountsClient_GetProperties_storageAccountGetPropertiesGeoReplicationStatscanFailoverFalse() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().GetProperties(ctx, "res9407", "sto8596", &armstorage.AccountsClientGetPropertiesOptions{Expand: to.Ptr(armstorage.StorageAccountExpandGeoReplicationStats)})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto8596"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9407/providers/Microsoft.Storage/storageAccounts/sto8596"),
	// 	Location: to.Ptr("eastus2(stage)"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AccountMigrationInProgress: to.Ptr(false),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T02:42:41.763Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		GeoReplicationStats: &armstorage.GeoReplicationStats{
	// 			CanFailover: to.Ptr(false),
	// 			CanPlannedFailover: to.Ptr(false),
	// 			LastSyncTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-10-30T00:25:34.000Z"); return t}()),
	// 			PostFailoverRedundancy: to.Ptr(armstorage.PostFailoverRedundancyStandardLRS),
	// 			PostPlannedFailoverRedundancy: to.Ptr(armstorage.PostPlannedFailoverRedundancyStandardGRS),
	// 			Status: to.Ptr(armstorage.GeoReplicationStatusLive),
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		IsSKUConversionBlocked: to.Ptr(false),
	// 		KeyCreationTime: &armstorage.KeyCreationTime{
	// 			Key1: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 			Key2: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 		},
	// 		NetworkRuleSet: &armstorage.NetworkRuleSet{
	// 			Bypass: to.Ptr(armstorage.BypassAzureServices),
	// 			DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
	// 			IPRules: []*armstorage.IPRule{
	// 			},
	// 			ResourceAccessRules: []*armstorage.ResourceAccessRule{
	// 				{
	// 					ResourceID: to.Ptr("/subscriptions/a7e99807-abbf-4642-bdec-2c809a96a8bc/resourceGroups/res9407/providers/Microsoft.Synapse/workspaces/testworkspace"),
	// 					TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 			}},
	// 			VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
	// 			},
	// 		},
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto8596.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto8596.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto8596.file.core.windows.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto8596-internetrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-internetrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-internetrouting.file.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-internetrouting.web.core.windows.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto8596-microsoftrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-microsoftrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-microsoftrouting.file.core.windows.net/"),
	// 				Queue: to.Ptr("https://sto8596-microsoftrouting.queue.core.windows.net/"),
	// 				Table: to.Ptr("https://sto8596-microsoftrouting.table.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-microsoftrouting.web.core.windows.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto8596.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto8596.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto8596.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2(stage)"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SecondaryLocation: to.Ptr("northcentralus(stage)"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(false),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountGetPropertiesGeoReplicationStatscanFailoverTrue.json
func ExampleAccountsClient_GetProperties_storageAccountGetPropertiesGeoReplicationStatscanFailoverTrue() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().GetProperties(ctx, "res9407", "sto8596", &armstorage.AccountsClientGetPropertiesOptions{Expand: to.Ptr(armstorage.StorageAccountExpandGeoReplicationStats)})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto8596"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9407/providers/Microsoft.Storage/storageAccounts/sto8596"),
	// 	Location: to.Ptr("eastus2(stage)"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AccountMigrationInProgress: to.Ptr(false),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T02:42:41.763Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		GeoReplicationStats: &armstorage.GeoReplicationStats{
	// 			CanFailover: to.Ptr(true),
	// 			CanPlannedFailover: to.Ptr(true),
	// 			LastSyncTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-10-30T00:25:34.000Z"); return t}()),
	// 			PostFailoverRedundancy: to.Ptr(armstorage.PostFailoverRedundancyStandardLRS),
	// 			PostPlannedFailoverRedundancy: to.Ptr(armstorage.PostPlannedFailoverRedundancyStandardGRS),
	// 			Status: to.Ptr(armstorage.GeoReplicationStatusLive),
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		IsSKUConversionBlocked: to.Ptr(false),
	// 		KeyCreationTime: &armstorage.KeyCreationTime{
	// 			Key1: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 			Key2: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 		},
	// 		NetworkRuleSet: &armstorage.NetworkRuleSet{
	// 			Bypass: to.Ptr(armstorage.BypassAzureServices),
	// 			DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
	// 			IPRules: []*armstorage.IPRule{
	// 			},
	// 			ResourceAccessRules: []*armstorage.ResourceAccessRule{
	// 				{
	// 					ResourceID: to.Ptr("/subscriptions/a7e99807-abbf-4642-bdec-2c809a96a8bc/resourceGroups/res9407/providers/Microsoft.Synapse/workspaces/testworkspace"),
	// 					TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 			}},
	// 			VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
	// 			},
	// 		},
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto8596.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto8596.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto8596.file.core.windows.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto8596-internetrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-internetrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-internetrouting.file.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-internetrouting.web.core.windows.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto8596-microsoftrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-microsoftrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-microsoftrouting.file.core.windows.net/"),
	// 				Queue: to.Ptr("https://sto8596-microsoftrouting.queue.core.windows.net/"),
	// 				Table: to.Ptr("https://sto8596-microsoftrouting.table.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-microsoftrouting.web.core.windows.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto8596.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto8596.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto8596.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2(stage)"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SecondaryLocation: to.Ptr("northcentralus(stage)"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(false),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountEnableAD.json
func ExampleAccountsClient_Update_storageAccountEnableAd() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Update(ctx, "res9407", "sto8596", armstorage.AccountUpdateParameters{
		Properties: &armstorage.AccountPropertiesUpdateParameters{
			AzureFilesIdentityBasedAuthentication: &armstorage.AzureFilesIdentityBasedAuthentication{
				ActiveDirectoryProperties: &armstorage.ActiveDirectoryProperties{
					AccountType:       to.Ptr(armstorage.ActiveDirectoryPropertiesAccountTypeUser),
					AzureStorageSid:   to.Ptr("S-1-5-21-2400535526-2334094090-2402026252-0012"),
					DomainGUID:        to.Ptr("aebfc118-9fa9-4732-a21f-d98e41a77ae1"),
					DomainName:        to.Ptr("adtest.com"),
					DomainSid:         to.Ptr("S-1-5-21-2400535526-2334094090-2402026252"),
					ForestName:        to.Ptr("adtest.com"),
					NetBiosDomainName: to.Ptr("adtest.com"),
					SamAccountName:    to.Ptr("sam12498"),
				},
				DirectoryServiceOptions: to.Ptr(armstorage.DirectoryServiceOptionsAD),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto8596"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9407/providers/Microsoft.Storage/storageAccounts/sto8596"),
	// 	Location: to.Ptr("eastus2(stage)"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AzureFilesIdentityBasedAuthentication: &armstorage.AzureFilesIdentityBasedAuthentication{
	// 			ActiveDirectoryProperties: &armstorage.ActiveDirectoryProperties{
	// 				AccountType: to.Ptr(armstorage.ActiveDirectoryPropertiesAccountTypeUser),
	// 				AzureStorageSid: to.Ptr("S-1-5-21-2400535526-2334094090-2402026252-0012"),
	// 				DomainGUID: to.Ptr("aebfc118-9fa9-4732-a21f-d98e41a77ae1"),
	// 				DomainName: to.Ptr("adtest.com"),
	// 				DomainSid: to.Ptr("S-1-5-21-2400535526-2334094090-2402026252"),
	// 				ForestName: to.Ptr("adtest.com"),
	// 				NetBiosDomainName: to.Ptr("adtest.com"),
	// 				SamAccountName: to.Ptr("sam12498"),
	// 			},
	// 			DirectoryServiceOptions: to.Ptr(armstorage.DirectoryServiceOptionsAD),
	// 		},
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T02:42:41.763Z"); return t}()),
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto8596.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto8596.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto8596.file.core.windows.net/"),
	// 			Queue: to.Ptr("https://sto8596.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto8596.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto8596.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2(stage)"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		SecondaryLocation: to.Ptr("northcentralus(stage)"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(false),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountEnableCMK.json
func ExampleAccountsClient_Update_storageAccountEnableCmk() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Update(ctx, "res9407", "sto8596", armstorage.AccountUpdateParameters{
		Properties: &armstorage.AccountPropertiesUpdateParameters{
			Encryption: &armstorage.Encryption{
				KeySource: to.Ptr(armstorage.KeySourceMicrosoftKeyvault),
				KeyVaultProperties: &armstorage.KeyVaultProperties{
					KeyName:     to.Ptr("wrappingKey"),
					KeyVaultURI: to.Ptr("https://myvault8569.vault.azure.net"),
					KeyVersion:  to.Ptr(""),
				},
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto8596"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9407/providers/Microsoft.Storage/storageAccounts/sto8596"),
	// 	Location: to.Ptr("eastus2(stage)"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Identity: &armstorage.Identity{
	// 		Type: to.Ptr(armstorage.IdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("911871cc-ffd1-4fc4-ac11-7a316433ea66"),
	// 		TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T02:42:41.763Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftKeyvault),
	// 			KeyVaultProperties: &armstorage.KeyVaultProperties{
	// 				CurrentVersionedKeyIdentifier: to.Ptr("https://myvault8569.vault.azure.net/keys/wrappingKey/0682afdd9c104f4285df20107e956cad"),
	// 				KeyName: to.Ptr("wrappingKey"),
	// 				KeyVaultURI: to.Ptr("https://myvault8569.vault.azure.net"),
	// 				KeyVersion: to.Ptr(""),
	// 				LastKeyRotationTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-13T20:36:23.702Z"); return t}()),
	// 			},
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto8596.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto8596.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto8596.file.core.windows.net/"),
	// 			Queue: to.Ptr("https://sto8596.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto8596.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto8596.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2(stage)"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		SecondaryLocation: to.Ptr("northcentralus(stage)"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(false),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountUpdate.json
func ExampleAccountsClient_Update_storageAccountUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Update(ctx, "res9407", "sto8596", armstorage.AccountUpdateParameters{
		Properties: &armstorage.AccountPropertiesUpdateParameters{
			AllowBlobPublicAccess:        to.Ptr(false),
			AllowSharedKeyAccess:         to.Ptr(true),
			DefaultToOAuthAuthentication: to.Ptr(false),
			EnableExtendedGroups:         to.Ptr(true),
			Encryption: &armstorage.Encryption{
				KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
			IsLocalUserEnabled: to.Ptr(true),
			IsSftpEnabled:      to.Ptr(true),
			KeyPolicy: &armstorage.KeyPolicy{
				KeyExpirationPeriodInDays: to.Ptr[int32](20),
			},
			MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
			NetworkRuleSet: &armstorage.NetworkRuleSet{
				DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
				ResourceAccessRules: []*armstorage.ResourceAccessRule{
					{
						ResourceID: to.Ptr("/subscriptions/a7e99807-abbf-4642-bdec-2c809a96a8bc/resourceGroups/res9407/providers/Microsoft.Synapse/workspaces/testworkspace"),
						TenantID:   to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
					}},
			},
			RoutingPreference: &armstorage.RoutingPreference{
				PublishInternetEndpoints:  to.Ptr(true),
				PublishMicrosoftEndpoints: to.Ptr(true),
				RoutingChoice:             to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
			},
			SasPolicy: &armstorage.SasPolicy{
				ExpirationAction:    to.Ptr(armstorage.ExpirationActionLog),
				SasExpirationPeriod: to.Ptr("1.15:59:59"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto8596"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9407/providers/Microsoft.Storage/storageAccounts/sto8596"),
	// 	Location: to.Ptr("eastus2(stage)"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AllowBlobPublicAccess: to.Ptr(false),
	// 		AllowSharedKeyAccess: to.Ptr(true),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T02:42:41.763Z"); return t}()),
	// 		EnableExtendedGroups: to.Ptr(true),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		IsLocalUserEnabled: to.Ptr(true),
	// 		IsSftpEnabled: to.Ptr(true),
	// 		KeyCreationTime: &armstorage.KeyCreationTime{
	// 			Key1: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 			Key2: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 		},
	// 		KeyPolicy: &armstorage.KeyPolicy{
	// 			KeyExpirationPeriodInDays: to.Ptr[int32](20),
	// 		},
	// 		MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
	// 		NetworkRuleSet: &armstorage.NetworkRuleSet{
	// 			Bypass: to.Ptr(armstorage.BypassAzureServices),
	// 			DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
	// 			IPRules: []*armstorage.IPRule{
	// 			},
	// 			ResourceAccessRules: []*armstorage.ResourceAccessRule{
	// 				{
	// 					ResourceID: to.Ptr("/subscriptions/a7e99807-abbf-4642-bdec-2c809a96a8bc/resourceGroups/res9407/providers/Microsoft.Synapse/workspaces/testworkspace"),
	// 					TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 			}},
	// 			VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
	// 			},
	// 		},
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto8596.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto8596.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto8596.file.core.windows.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto8596-internetrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-internetrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-internetrouting.file.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-internetrouting.web.core.windows.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto8596-microsoftrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-microsoftrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-microsoftrouting.file.core.windows.net/"),
	// 				Queue: to.Ptr("https://sto8596-microsoftrouting.queue.core.windows.net/"),
	// 				Table: to.Ptr("https://sto8596-microsoftrouting.table.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-microsoftrouting.web.core.windows.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto8596.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto8596.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto8596.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2(stage)"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SasPolicy: &armstorage.SasPolicy{
	// 			ExpirationAction: to.Ptr(armstorage.ExpirationActionLog),
	// 			SasExpirationPeriod: to.Ptr("1.15:59:59"),
	// 		},
	// 		SecondaryLocation: to.Ptr("northcentralus(stage)"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(false),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountUpdateAllowedCopyScopeToAAD.json
func ExampleAccountsClient_Update_storageAccountUpdateAllowedCopyScopeToAad() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Update(ctx, "res9407", "sto8596", armstorage.AccountUpdateParameters{
		Properties: &armstorage.AccountPropertiesUpdateParameters{
			AllowBlobPublicAccess: to.Ptr(false),
			AllowSharedKeyAccess:  to.Ptr(true),
			AllowedCopyScope:      to.Ptr(armstorage.AllowedCopyScopeAAD),
			Encryption: &armstorage.Encryption{
				KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
			KeyPolicy: &armstorage.KeyPolicy{
				KeyExpirationPeriodInDays: to.Ptr[int32](20),
			},
			MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
			NetworkRuleSet: &armstorage.NetworkRuleSet{
				DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
				ResourceAccessRules: []*armstorage.ResourceAccessRule{
					{
						ResourceID: to.Ptr("/subscriptions/a7e99807-abbf-4642-bdec-2c809a96a8bc/resourceGroups/res9407/providers/Microsoft.Synapse/workspaces/testworkspace"),
						TenantID:   to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
					}},
			},
			RoutingPreference: &armstorage.RoutingPreference{
				PublishInternetEndpoints:  to.Ptr(true),
				PublishMicrosoftEndpoints: to.Ptr(true),
				RoutingChoice:             to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
			},
			SasPolicy: &armstorage.SasPolicy{
				ExpirationAction:    to.Ptr(armstorage.ExpirationActionLog),
				SasExpirationPeriod: to.Ptr("1.15:59:59"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto8596"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9407/providers/Microsoft.Storage/storageAccounts/sto8596"),
	// 	Location: to.Ptr("eastus2(stage)"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AllowBlobPublicAccess: to.Ptr(false),
	// 		AllowSharedKeyAccess: to.Ptr(true),
	// 		AllowedCopyScope: to.Ptr(armstorage.AllowedCopyScopeAAD),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T02:42:41.763Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		KeyCreationTime: &armstorage.KeyCreationTime{
	// 			Key1: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 			Key2: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 		},
	// 		KeyPolicy: &armstorage.KeyPolicy{
	// 			KeyExpirationPeriodInDays: to.Ptr[int32](20),
	// 		},
	// 		MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
	// 		NetworkRuleSet: &armstorage.NetworkRuleSet{
	// 			Bypass: to.Ptr(armstorage.BypassAzureServices),
	// 			DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
	// 			IPRules: []*armstorage.IPRule{
	// 			},
	// 			ResourceAccessRules: []*armstorage.ResourceAccessRule{
	// 				{
	// 					ResourceID: to.Ptr("/subscriptions/a7e99807-abbf-4642-bdec-2c809a96a8bc/resourceGroups/res9407/providers/Microsoft.Synapse/workspaces/testworkspace"),
	// 					TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 			}},
	// 			VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
	// 			},
	// 		},
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto8596.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto8596.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto8596.file.core.windows.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto8596-internetrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-internetrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-internetrouting.file.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-internetrouting.web.core.windows.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto8596-microsoftrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-microsoftrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-microsoftrouting.file.core.windows.net/"),
	// 				Queue: to.Ptr("https://sto8596-microsoftrouting.queue.core.windows.net/"),
	// 				Table: to.Ptr("https://sto8596-microsoftrouting.table.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-microsoftrouting.web.core.windows.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto8596.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto8596.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto8596.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2(stage)"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SasPolicy: &armstorage.SasPolicy{
	// 			ExpirationAction: to.Ptr(armstorage.ExpirationActionLog),
	// 			SasExpirationPeriod: to.Ptr("1.15:59:59"),
	// 		},
	// 		SecondaryLocation: to.Ptr("northcentralus(stage)"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(false),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountUpdateDisablePublicNetworkAccess.json
func ExampleAccountsClient_Update_storageAccountUpdateDisablePublicNetworkAccess() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Update(ctx, "res9407", "sto8596", armstorage.AccountUpdateParameters{
		Properties: &armstorage.AccountPropertiesUpdateParameters{
			AllowBlobPublicAccess: to.Ptr(false),
			AllowSharedKeyAccess:  to.Ptr(true),
			Encryption: &armstorage.Encryption{
				KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
			KeyPolicy: &armstorage.KeyPolicy{
				KeyExpirationPeriodInDays: to.Ptr[int32](20),
			},
			MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
			NetworkRuleSet: &armstorage.NetworkRuleSet{
				DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
				ResourceAccessRules: []*armstorage.ResourceAccessRule{
					{
						ResourceID: to.Ptr("/subscriptions/a7e99807-abbf-4642-bdec-2c809a96a8bc/resourceGroups/res9407/providers/Microsoft.Synapse/workspaces/testworkspace"),
						TenantID:   to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
					}},
			},
			PublicNetworkAccess: to.Ptr(armstorage.PublicNetworkAccessDisabled),
			RoutingPreference: &armstorage.RoutingPreference{
				PublishInternetEndpoints:  to.Ptr(true),
				PublishMicrosoftEndpoints: to.Ptr(true),
				RoutingChoice:             to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
			},
			SasPolicy: &armstorage.SasPolicy{
				ExpirationAction:    to.Ptr(armstorage.ExpirationActionLog),
				SasExpirationPeriod: to.Ptr("1.15:59:59"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto8596"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9407/providers/Microsoft.Storage/storageAccounts/sto8596"),
	// 	Location: to.Ptr("eastus2(stage)"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		AllowBlobPublicAccess: to.Ptr(false),
	// 		AllowSharedKeyAccess: to.Ptr(true),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T02:42:41.763Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		IsHnsEnabled: to.Ptr(true),
	// 		KeyCreationTime: &armstorage.KeyCreationTime{
	// 			Key1: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 			Key2: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-18T04:42:22.432Z"); return t}()),
	// 		},
	// 		KeyPolicy: &armstorage.KeyPolicy{
	// 			KeyExpirationPeriodInDays: to.Ptr[int32](20),
	// 		},
	// 		MinimumTLSVersion: to.Ptr(armstorage.MinimumTLSVersionTLS12),
	// 		NetworkRuleSet: &armstorage.NetworkRuleSet{
	// 			Bypass: to.Ptr(armstorage.BypassAzureServices),
	// 			DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
	// 			IPRules: []*armstorage.IPRule{
	// 			},
	// 			ResourceAccessRules: []*armstorage.ResourceAccessRule{
	// 				{
	// 					ResourceID: to.Ptr("/subscriptions/a7e99807-abbf-4642-bdec-2c809a96a8bc/resourceGroups/res9407/providers/Microsoft.Synapse/workspaces/testworkspace"),
	// 					TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 			}},
	// 			VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
	// 			},
	// 		},
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto8596.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto8596.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto8596.file.core.windows.net/"),
	// 			InternetEndpoints: &armstorage.AccountInternetEndpoints{
	// 				Blob: to.Ptr("https://sto8596-internetrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-internetrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-internetrouting.file.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-internetrouting.web.core.windows.net/"),
	// 			},
	// 			MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
	// 				Blob: to.Ptr("https://sto8596-microsoftrouting.blob.core.windows.net/"),
	// 				Dfs: to.Ptr("https://sto8596-microsoftrouting.dfs.core.windows.net/"),
	// 				File: to.Ptr("https://sto8596-microsoftrouting.file.core.windows.net/"),
	// 				Queue: to.Ptr("https://sto8596-microsoftrouting.queue.core.windows.net/"),
	// 				Table: to.Ptr("https://sto8596-microsoftrouting.table.core.windows.net/"),
	// 				Web: to.Ptr("https://sto8596-microsoftrouting.web.core.windows.net/"),
	// 			},
	// 			Queue: to.Ptr("https://sto8596.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto8596.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto8596.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus2(stage)"),
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armstorage.PublicNetworkAccessDisabled),
	// 		RoutingPreference: &armstorage.RoutingPreference{
	// 			PublishInternetEndpoints: to.Ptr(true),
	// 			PublishMicrosoftEndpoints: to.Ptr(true),
	// 			RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
	// 		},
	// 		SasPolicy: &armstorage.SasPolicy{
	// 			ExpirationAction: to.Ptr(armstorage.ExpirationActionLog),
	// 			SasExpirationPeriod: to.Ptr("1.15:59:59"),
	// 		},
	// 		SecondaryLocation: to.Ptr("northcentralus(stage)"),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(false),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountUpdateUserAssignedEncryptionIdentityWithCMK.json
func ExampleAccountsClient_Update_storageAccountUpdateUserAssignedEncryptionIdentityWithCmk() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Update(ctx, "res9101", "sto4445", armstorage.AccountUpdateParameters{
		Identity: &armstorage.Identity{
			Type: to.Ptr(armstorage.IdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armstorage.UserAssignedIdentity{
				"/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}": {},
			},
		},
		Kind: to.Ptr(armstorage.KindStorage),
		Properties: &armstorage.AccountPropertiesUpdateParameters{
			Encryption: &armstorage.Encryption{
				EncryptionIdentity: &armstorage.EncryptionIdentity{
					EncryptionUserAssignedIdentity: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}"),
				},
				KeySource: to.Ptr(armstorage.KeySourceMicrosoftKeyvault),
				KeyVaultProperties: &armstorage.KeyVaultProperties{
					KeyName:     to.Ptr("wrappingKey"),
					KeyVaultURI: to.Ptr("https://myvault8569.vault.azure.net"),
					KeyVersion:  to.Ptr(""),
				},
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
		},
		SKU: &armstorage.SKU{
			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto4445"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Storage/storageAccounts/sto4445"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armstorage.Identity{
	// 		Type: to.Ptr(armstorage.IdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armstorage.UserAssignedIdentity{
	// 			"/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}": &armstorage.UserAssignedIdentity{
	// 				ClientID: to.Ptr("fbaa6278-1ecc-415c-819f-6e2058d3acb5"),
	// 				PrincipalID: to.Ptr("8d823284-1060-42a5-9ec4-ed3d831e24d7"),
	// 			},
	// 		},
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorageV2),
	// 	Properties: &armstorage.AccountProperties{
	// 		AccessTier: to.Ptr(armstorage.AccessTierHot),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-15T00:43:14.083Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			EncryptionIdentity: &armstorage.EncryptionIdentity{
	// 				EncryptionUserAssignedIdentity: to.Ptr("/subscriptions/{subscription-id}/resourcegroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}"),
	// 			},
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftKeyvault),
	// 			KeyVaultProperties: &armstorage.KeyVaultProperties{
	// 				CurrentVersionedKeyIdentifier: to.Ptr("https://myvault8569.vault.azure.net/keys/wrappingKey/0682afdd9c104f4285df20107e956cad"),
	// 				KeyName: to.Ptr("wrappingKey"),
	// 				KeyVaultURI: to.Ptr("https://myvault8569.vault.azure.net"),
	// 				KeyVersion: to.Ptr(""),
	// 				LastKeyRotationTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-13T20:36:23.702Z"); return t}()),
	// 			},
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-15T00:43:14.173Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-15T00:43:14.173Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		NetworkRuleSet: &armstorage.NetworkRuleSet{
	// 			Bypass: to.Ptr(armstorage.BypassAzureServices),
	// 			DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
	// 			IPRules: []*armstorage.IPRule{
	// 			},
	// 			VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
	// 			},
	// 		},
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto4445.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto4445.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto4445.file.core.windows.net/"),
	// 			Queue: to.Ptr("https://sto4445.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto4445.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto4445.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus"),
	// 		PrivateEndpointConnections: []*armstorage.PrivateEndpointConnection{
	// 		},
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(true),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardLRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountUpdateUserAssignedIdentityWithFederatedIdentityClientId.json
func ExampleAccountsClient_Update_storageAccountUpdateUserAssignedIdentityWithFederatedIdentityClientId() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Update(ctx, "res131918", "sto131918", armstorage.AccountUpdateParameters{
		Identity: &armstorage.Identity{
			Type: to.Ptr(armstorage.IdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armstorage.UserAssignedIdentity{
				"/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}": {},
			},
		},
		Kind: to.Ptr(armstorage.KindStorage),
		Properties: &armstorage.AccountPropertiesUpdateParameters{
			Encryption: &armstorage.Encryption{
				EncryptionIdentity: &armstorage.EncryptionIdentity{
					EncryptionFederatedIdentityClientID: to.Ptr("3109d1c4-a5de-4d84-8832-feabb916a4b6"),
					EncryptionUserAssignedIdentity:      to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}"),
				},
				KeySource: to.Ptr(armstorage.KeySourceMicrosoftKeyvault),
				KeyVaultProperties: &armstorage.KeyVaultProperties{
					KeyName:     to.Ptr("wrappingKey"),
					KeyVaultURI: to.Ptr("https://myvault8569.vault.azure.net"),
					KeyVersion:  to.Ptr(""),
				},
				Services: &armstorage.EncryptionServices{
					Blob: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
					File: &armstorage.EncryptionService{
						Enabled: to.Ptr(true),
						KeyType: to.Ptr(armstorage.KeyTypeAccount),
					},
				},
			},
		},
		SKU: &armstorage.SKU{
			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto4445"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Storage/storageAccounts/sto4445"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armstorage.Identity{
	// 		Type: to.Ptr(armstorage.IdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armstorage.UserAssignedIdentity{
	// 			"/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}": &armstorage.UserAssignedIdentity{
	// 				ClientID: to.Ptr("fbaa6278-1ecc-415c-819f-6e2058d3acb5"),
	// 				PrincipalID: to.Ptr("8d823284-1060-42a5-9ec4-ed3d831e24d7"),
	// 			},
	// 		},
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorageV2),
	// 	Properties: &armstorage.AccountProperties{
	// 		AccessTier: to.Ptr(armstorage.AccessTierHot),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-15T00:43:14.083Z"); return t}()),
	// 		Encryption: &armstorage.Encryption{
	// 			EncryptionIdentity: &armstorage.EncryptionIdentity{
	// 				EncryptionFederatedIdentityClientID: to.Ptr("3109d1c4-a5de-4d84-8832-feabb916a4b6"),
	// 				EncryptionUserAssignedIdentity: to.Ptr("/subscriptions/{subscription-id}/resourcegroups/res9101/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{managed-identity-name}"),
	// 			},
	// 			KeySource: to.Ptr(armstorage.KeySourceMicrosoftKeyvault),
	// 			KeyVaultProperties: &armstorage.KeyVaultProperties{
	// 				CurrentVersionedKeyIdentifier: to.Ptr("https://myvault8569.vault.azure.net/keys/wrappingKey/0682afdd9c104f4285df20107e956cad"),
	// 				KeyName: to.Ptr("wrappingKey"),
	// 				KeyVaultURI: to.Ptr("https://myvault8569.vault.azure.net"),
	// 				KeyVersion: to.Ptr(""),
	// 				LastKeyRotationTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-13T20:36:23.702Z"); return t}()),
	// 			},
	// 			Services: &armstorage.EncryptionServices{
	// 				Blob: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-15T00:43:14.173Z"); return t}()),
	// 				},
	// 				File: &armstorage.EncryptionService{
	// 					Enabled: to.Ptr(true),
	// 					KeyType: to.Ptr(armstorage.KeyTypeAccount),
	// 					LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-15T00:43:14.173Z"); return t}()),
	// 				},
	// 			},
	// 		},
	// 		NetworkRuleSet: &armstorage.NetworkRuleSet{
	// 			Bypass: to.Ptr(armstorage.BypassAzureServices),
	// 			DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
	// 			IPRules: []*armstorage.IPRule{
	// 			},
	// 			VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
	// 			},
	// 		},
	// 		PrimaryEndpoints: &armstorage.Endpoints{
	// 			Blob: to.Ptr("https://sto4445.blob.core.windows.net/"),
	// 			Dfs: to.Ptr("https://sto4445.dfs.core.windows.net/"),
	// 			File: to.Ptr("https://sto4445.file.core.windows.net/"),
	// 			Queue: to.Ptr("https://sto4445.queue.core.windows.net/"),
	// 			Table: to.Ptr("https://sto4445.table.core.windows.net/"),
	// 			Web: to.Ptr("https://sto4445.web.core.windows.net/"),
	// 		},
	// 		PrimaryLocation: to.Ptr("eastus"),
	// 		PrivateEndpointConnections: []*armstorage.PrivateEndpointConnection{
	// 		},
	// 		ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
	// 		StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
	// 		EnableHTTPSTrafficOnly: to.Ptr(true),
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardLRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountUpdateWithImmutabilityPolicy.json
func ExampleAccountsClient_Update_storageAccountUpdateWithImmutabilityPolicy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Update(ctx, "res9407", "sto8596", armstorage.AccountUpdateParameters{
		Properties: &armstorage.AccountPropertiesUpdateParameters{
			ImmutableStorageWithVersioning: &armstorage.ImmutableStorageAccount{
				Enabled: to.Ptr(true),
				ImmutabilityPolicy: &armstorage.AccountImmutabilityPolicyProperties{
					AllowProtectedAppendWrites:            to.Ptr(true),
					ImmutabilityPeriodSinceCreationInDays: to.Ptr[int32](15),
					State:                                 to.Ptr(armstorage.AccountImmutabilityPolicyStateLocked),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armstorage.Account{
	// 	Name: to.Ptr("sto8596"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9407/providers/Microsoft.Storage/storageAccounts/sto8596"),
	// 	Location: to.Ptr("eastus2(stage)"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Kind: to.Ptr(armstorage.KindStorage),
	// 	Properties: &armstorage.AccountProperties{
	// 		ImmutableStorageWithVersioning: &armstorage.ImmutableStorageAccount{
	// 			Enabled: to.Ptr(true),
	// 			ImmutabilityPolicy: &armstorage.AccountImmutabilityPolicyProperties{
	// 				AllowProtectedAppendWrites: to.Ptr(true),
	// 				ImmutabilityPeriodSinceCreationInDays: to.Ptr[int32](15),
	// 				State: to.Ptr(armstorage.AccountImmutabilityPolicyStateLocked),
	// 			},
	// 		},
	// 	},
	// 	SKU: &armstorage.SKU{
	// 		Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 		Tier: to.Ptr(armstorage.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountList.json
func ExampleAccountsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAccountsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AccountListResult = armstorage.AccountListResult{
		// 	Value: []*armstorage.Account{
		// 		{
		// 			Name: to.Ptr("sto1125"),
		// 			Type: to.Ptr("Microsoft.Storage/storageAccounts"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res2627/providers/Microsoft.Storage/storageAccounts/sto1125"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key2": to.Ptr("value2"),
		// 			},
		// 			Kind: to.Ptr(armstorage.KindStorage),
		// 			Properties: &armstorage.AccountProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T13:28:53.454Z"); return t}()),
		// 				Encryption: &armstorage.Encryption{
		// 					KeySource: to.Ptr(armstorage.KeySourceMicrosoftStorage),
		// 					Services: &armstorage.EncryptionServices{
		// 						Blob: &armstorage.EncryptionService{
		// 							Enabled: to.Ptr(true),
		// 							KeyType: to.Ptr(armstorage.KeyTypeAccount),
		// 							LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
		// 						},
		// 						File: &armstorage.EncryptionService{
		// 							Enabled: to.Ptr(true),
		// 							KeyType: to.Ptr(armstorage.KeyTypeAccount),
		// 							LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
		// 						},
		// 					},
		// 				},
		// 				IsHnsEnabled: to.Ptr(true),
		// 				PrimaryEndpoints: &armstorage.Endpoints{
		// 					Blob: to.Ptr("https://sto1125.blob.core.windows.net/"),
		// 					Dfs: to.Ptr("https://sto1125.dfs.core.windows.net/"),
		// 					File: to.Ptr("https://sto1125.file.core.windows.net/"),
		// 					InternetEndpoints: &armstorage.AccountInternetEndpoints{
		// 						Blob: to.Ptr("https://sto1125-internetrouting.blob.core.windows.net/"),
		// 						Dfs: to.Ptr("https://sto1125-internetrouting.dfs.core.windows.net/"),
		// 						File: to.Ptr("https://sto1125-internetrouting.file.core.windows.net/"),
		// 						Web: to.Ptr("https://sto1125-internetrouting.web.core.windows.net/"),
		// 					},
		// 					MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
		// 						Blob: to.Ptr("https://sto1125-microsoftrouting.blob.core.windows.net/"),
		// 						Dfs: to.Ptr("https://sto1125-microsoftrouting.dfs.core.windows.net/"),
		// 						File: to.Ptr("https://sto1125-microsoftrouting.file.core.windows.net/"),
		// 						Queue: to.Ptr("https://sto1125-microsoftrouting.queue.core.windows.net/"),
		// 						Table: to.Ptr("https://sto1125-microsoftrouting.table.core.windows.net/"),
		// 						Web: to.Ptr("https://sto1125-microsoftrouting.web.core.windows.net/"),
		// 					},
		// 					Queue: to.Ptr("https://sto1125.queue.core.windows.net/"),
		// 					Table: to.Ptr("https://sto1125.table.core.windows.net/"),
		// 					Web: to.Ptr("https://sto1125.web.core.windows.net/"),
		// 				},
		// 				PrimaryLocation: to.Ptr("eastus"),
		// 				ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
		// 				RoutingPreference: &armstorage.RoutingPreference{
		// 					PublishInternetEndpoints: to.Ptr(true),
		// 					PublishMicrosoftEndpoints: to.Ptr(true),
		// 					RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
		// 				},
		// 				SecondaryLocation: to.Ptr("centraluseuap"),
		// 				StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				EnableHTTPSTrafficOnly: to.Ptr(false),
		// 			},
		// 			SKU: &armstorage.SKU{
		// 				Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sto3699"),
		// 			Type: to.Ptr("Microsoft.Storage/storageAccounts"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/testcmk3/providers/Microsoft.Storage/storageAccounts/sto3699"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key2": to.Ptr("value2"),
		// 			},
		// 			Identity: &armstorage.Identity{
		// 				Type: to.Ptr(armstorage.IdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("356d057d-cba5-44dd-8a30-b2e547bc416b"),
		// 				TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 			Kind: to.Ptr(armstorage.KindStorage),
		// 			Properties: &armstorage.AccountProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T10:06:30.609Z"); return t}()),
		// 				PrimaryEndpoints: &armstorage.Endpoints{
		// 					Blob: to.Ptr("https://sto3699.blob.core.windows.net/"),
		// 					File: to.Ptr("https://sto3699.file.core.windows.net/"),
		// 					Queue: to.Ptr("https://sto3699.queue.core.windows.net/"),
		// 					Table: to.Ptr("https://sto3699.table.core.windows.net/"),
		// 				},
		// 				PrimaryLocation: to.Ptr("eastus"),
		// 				ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
		// 				SecondaryLocation: to.Ptr("centraluseuap"),
		// 				StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				EnableHTTPSTrafficOnly: to.Ptr(false),
		// 			},
		// 			SKU: &armstorage.SKU{
		// 				Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sto8596"),
		// 			Type: to.Ptr("Microsoft.Storage/storageAccounts"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res9407/providers/Microsoft.Storage/storageAccounts/sto8596"),
		// 			Location: to.Ptr("eastus2(stage)"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key2": to.Ptr("value2"),
		// 			},
		// 			Identity: &armstorage.Identity{
		// 				Type: to.Ptr(armstorage.IdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("911871cc-ffd1-4fc4-ac11-7a316433ea66"),
		// 				TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 			Kind: to.Ptr(armstorage.KindStorage),
		// 			Properties: &armstorage.AccountProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T02:42:41.763Z"); return t}()),
		// 				Encryption: &armstorage.Encryption{
		// 					KeySource: to.Ptr(armstorage.KeySourceMicrosoftKeyvault),
		// 					KeyVaultProperties: &armstorage.KeyVaultProperties{
		// 						CurrentVersionedKeyIdentifier: to.Ptr("https://myvault8569.vault.azure.net/keys/wrappingKey/0682afdd9c104f4285df20107e956cad"),
		// 						KeyName: to.Ptr("wrappingKey"),
		// 						KeyVaultURI: to.Ptr("https://myvault8569.vault.azure.net"),
		// 						KeyVersion: to.Ptr(""),
		// 						LastKeyRotationTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-13T20:36:23.702Z"); return t}()),
		// 					},
		// 					Services: &armstorage.EncryptionServices{
		// 						Blob: &armstorage.EncryptionService{
		// 							Enabled: to.Ptr(true),
		// 							KeyType: to.Ptr(armstorage.KeyTypeAccount),
		// 							LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
		// 						},
		// 						File: &armstorage.EncryptionService{
		// 							Enabled: to.Ptr(true),
		// 							KeyType: to.Ptr(armstorage.KeyTypeAccount),
		// 							LastEnabledTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-11T20:49:31.703Z"); return t}()),
		// 						},
		// 					},
		// 				},
		// 				GeoReplicationStats: &armstorage.GeoReplicationStats{
		// 					CanFailover: to.Ptr(true),
		// 					LastSyncTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-10-30T00:25:34.000Z"); return t}()),
		// 					Status: to.Ptr(armstorage.GeoReplicationStatusLive),
		// 				},
		// 				IsHnsEnabled: to.Ptr(true),
		// 				NetworkRuleSet: &armstorage.NetworkRuleSet{
		// 					Bypass: to.Ptr(armstorage.BypassAzureServices),
		// 					DefaultAction: to.Ptr(armstorage.DefaultActionAllow),
		// 					IPRules: []*armstorage.IPRule{
		// 					},
		// 					ResourceAccessRules: []*armstorage.ResourceAccessRule{
		// 						{
		// 							ResourceID: to.Ptr("/subscriptions/a7e99807-abbf-4642-bdec-2c809a96a8bc/resourceGroups/res9407/providers/Microsoft.Synapse/workspaces/testworkspace"),
		// 							TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 					}},
		// 					VirtualNetworkRules: []*armstorage.VirtualNetworkRule{
		// 					},
		// 				},
		// 				PrimaryEndpoints: &armstorage.Endpoints{
		// 					Blob: to.Ptr("https://sto8596.blob.core.windows.net/"),
		// 					Dfs: to.Ptr("https://sto8596.dfs.core.windows.net/"),
		// 					File: to.Ptr("https://sto8596.file.core.windows.net/"),
		// 					InternetEndpoints: &armstorage.AccountInternetEndpoints{
		// 						Blob: to.Ptr("https://sto8596-internetrouting.blob.core.windows.net/"),
		// 						Dfs: to.Ptr("https://sto8596-internetrouting.dfs.core.windows.net/"),
		// 						File: to.Ptr("https://sto8596-internetrouting.file.core.windows.net/"),
		// 						Web: to.Ptr("https://sto8596-internetrouting.web.core.windows.net/"),
		// 					},
		// 					MicrosoftEndpoints: &armstorage.AccountMicrosoftEndpoints{
		// 						Blob: to.Ptr("https://sto8596-microsoftrouting.blob.core.windows.net/"),
		// 						Dfs: to.Ptr("https://sto8596-microsoftrouting.dfs.core.windows.net/"),
		// 						File: to.Ptr("https://sto8596-microsoftrouting.file.core.windows.net/"),
		// 						Queue: to.Ptr("https://sto8596-microsoftrouting.queue.core.windows.net/"),
		// 						Table: to.Ptr("https://sto8596-microsoftrouting.table.core.windows.net/"),
		// 						Web: to.Ptr("https://sto8596-microsoftrouting.web.core.windows.net/"),
		// 					},
		// 					Queue: to.Ptr("https://sto8596.queue.core.windows.net/"),
		// 					Table: to.Ptr("https://sto8596.table.core.windows.net/"),
		// 					Web: to.Ptr("https://sto8596.web.core.windows.net/"),
		// 				},
		// 				PrimaryLocation: to.Ptr("eastus2(stage)"),
		// 				ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
		// 				RoutingPreference: &armstorage.RoutingPreference{
		// 					PublishInternetEndpoints: to.Ptr(true),
		// 					PublishMicrosoftEndpoints: to.Ptr(true),
		// 					RoutingChoice: to.Ptr(armstorage.RoutingChoiceMicrosoftRouting),
		// 				},
		// 				SecondaryLocation: to.Ptr("northcentralus(stage)"),
		// 				StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				EnableHTTPSTrafficOnly: to.Ptr(false),
		// 			},
		// 			SKU: &armstorage.SKU{
		// 				Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sto6637"),
		// 			Type: to.Ptr("Microsoft.Storage/storageAccounts"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/testcmk3/providers/Microsoft.Storage/storageAccounts/sto6637"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key2": to.Ptr("value2"),
		// 			},
		// 			Identity: &armstorage.Identity{
		// 				Type: to.Ptr(armstorage.IdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("911871cc-ffd1-4fc4-ac11-7a316433ea66"),
		// 				TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 			Kind: to.Ptr(armstorage.KindStorage),
		// 			Properties: &armstorage.AccountProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T10:09:39.562Z"); return t}()),
		// 				PrimaryEndpoints: &armstorage.Endpoints{
		// 					Blob: to.Ptr("https://sto6637.blob.core.windows.net/"),
		// 					File: to.Ptr("https://sto6637.file.core.windows.net/"),
		// 					Queue: to.Ptr("https://sto6637.queue.core.windows.net/"),
		// 					Table: to.Ptr("https://sto6637.table.core.windows.net/"),
		// 				},
		// 				PrimaryLocation: to.Ptr("eastus"),
		// 				ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
		// 				SecondaryLocation: to.Ptr("centraluseuap"),
		// 				StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				EnableHTTPSTrafficOnly: to.Ptr(false),
		// 			},
		// 			SKU: &armstorage.SKU{
		// 				Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sto834"),
		// 			Type: to.Ptr("Microsoft.Storage/storageAccounts"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res8186/providers/Microsoft.Storage/storageAccounts/sto834"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key2": to.Ptr("value2"),
		// 			},
		// 			Kind: to.Ptr(armstorage.KindStorage),
		// 			Properties: &armstorage.AccountProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T13:28:20.868Z"); return t}()),
		// 				PrimaryEndpoints: &armstorage.Endpoints{
		// 					Blob: to.Ptr("https://sto834.blob.core.windows.net/"),
		// 					File: to.Ptr("https://sto834.file.core.windows.net/"),
		// 					Queue: to.Ptr("https://sto834.queue.core.windows.net/"),
		// 					Table: to.Ptr("https://sto834.table.core.windows.net/"),
		// 				},
		// 				PrimaryLocation: to.Ptr("eastus"),
		// 				ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
		// 				SecondaryLocation: to.Ptr("centraluseuap"),
		// 				StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				EnableHTTPSTrafficOnly: to.Ptr(false),
		// 			},
		// 			SKU: &armstorage.SKU{
		// 				Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sto9174"),
		// 			Type: to.Ptr("Microsoft.Storage/storageAccounts"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/testcmk3/providers/Microsoft.Storage/storageAccounts/sto9174"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key2": to.Ptr("value2"),
		// 			},
		// 			Identity: &armstorage.Identity{
		// 				Type: to.Ptr(armstorage.IdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("933e3ddf-1802-4a51-9469-18a33b576f88"),
		// 				TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 			Kind: to.Ptr(armstorage.KindStorage),
		// 			Properties: &armstorage.AccountProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T09:46:19.655Z"); return t}()),
		// 				PrimaryEndpoints: &armstorage.Endpoints{
		// 					Blob: to.Ptr("https://sto9174.blob.core.windows.net/"),
		// 					File: to.Ptr("https://sto9174.file.core.windows.net/"),
		// 					Queue: to.Ptr("https://sto9174.queue.core.windows.net/"),
		// 					Table: to.Ptr("https://sto9174.table.core.windows.net/"),
		// 				},
		// 				PrimaryLocation: to.Ptr("eastus"),
		// 				ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
		// 				SecondaryLocation: to.Ptr("centraluseuap"),
		// 				StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				EnableHTTPSTrafficOnly: to.Ptr(false),
		// 			},
		// 			SKU: &armstorage.SKU{
		// 				Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountListByResourceGroup.json
func ExampleAccountsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAccountsClient().NewListByResourceGroupPager("res6117", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AccountListResult = armstorage.AccountListResult{
		// 	Value: []*armstorage.Account{
		// 		{
		// 			Name: to.Ptr("sto4036"),
		// 			Type: to.Ptr("Microsoft.Storage/storageAccounts"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res6117/providers/Microsoft.Storage/storageAccounts/sto4036"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key2": to.Ptr("value2"),
		// 			},
		// 			Kind: to.Ptr(armstorage.KindStorage),
		// 			Properties: &armstorage.AccountProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T13:24:47.818Z"); return t}()),
		// 				IsHnsEnabled: to.Ptr(true),
		// 				PrimaryEndpoints: &armstorage.Endpoints{
		// 					Blob: to.Ptr("https://sto4036.blob.core.windows.net/"),
		// 					Dfs: to.Ptr("https://sto4036.dfs.core.windows.net/"),
		// 					File: to.Ptr("https://sto4036.file.core.windows.net/"),
		// 					Queue: to.Ptr("https://sto4036.queue.core.windows.net/"),
		// 					Table: to.Ptr("https://sto4036.table.core.windows.net/"),
		// 					Web: to.Ptr("https://sto4036.web.core.windows.net/"),
		// 				},
		// 				PrimaryLocation: to.Ptr("eastus"),
		// 				ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
		// 				SecondaryLocation: to.Ptr("centraluseuap"),
		// 				StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				EnableHTTPSTrafficOnly: to.Ptr(false),
		// 			},
		// 			SKU: &armstorage.SKU{
		// 				Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sto4452"),
		// 			Type: to.Ptr("Microsoft.Storage/storageAccounts"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res6117/providers/Microsoft.Storage/storageAccounts/sto4452"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key2": to.Ptr("value2"),
		// 			},
		// 			Kind: to.Ptr(armstorage.KindStorage),
		// 			Properties: &armstorage.AccountProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T13:24:15.706Z"); return t}()),
		// 				PrimaryEndpoints: &armstorage.Endpoints{
		// 					Blob: to.Ptr("https://sto4452.blob.core.windows.net/"),
		// 					File: to.Ptr("https://sto4452.file.core.windows.net/"),
		// 					Queue: to.Ptr("https://sto4452.queue.core.windows.net/"),
		// 					Table: to.Ptr("https://sto4452.table.core.windows.net/"),
		// 				},
		// 				PrimaryLocation: to.Ptr("eastus"),
		// 				ProvisioningState: to.Ptr(armstorage.ProvisioningStateSucceeded),
		// 				SecondaryLocation: to.Ptr("centraluseuap"),
		// 				StatusOfPrimary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				StatusOfSecondary: to.Ptr(armstorage.AccountStatusAvailable),
		// 				EnableHTTPSTrafficOnly: to.Ptr(false),
		// 			},
		// 			SKU: &armstorage.SKU{
		// 				Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountListKeys.json
func ExampleAccountsClient_ListKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().ListKeys(ctx, "res418", "sto2220", &armstorage.AccountsClientListKeysOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountListKeysResult = armstorage.AccountListKeysResult{
	// 	Keys: []*armstorage.AccountKey{
	// 		{
	// 			KeyName: to.Ptr("key1"),
	// 			Permissions: to.Ptr(armstorage.KeyPermissionFull),
	// 			Value: to.Ptr("<value>"),
	// 		},
	// 		{
	// 			KeyName: to.Ptr("key2"),
	// 			Permissions: to.Ptr(armstorage.KeyPermissionFull),
	// 			Value: to.Ptr("<value>"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountRegenerateKerbKey.json
func ExampleAccountsClient_RegenerateKey_storageAccountRegenerateKerbKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().RegenerateKey(ctx, "res4167", "sto3539", armstorage.AccountRegenerateKeyParameters{
		KeyName: to.Ptr("kerb1"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountListKeysResult = armstorage.AccountListKeysResult{
	// 	Keys: []*armstorage.AccountKey{
	// 		{
	// 			KeyName: to.Ptr("key1"),
	// 			Permissions: to.Ptr(armstorage.KeyPermissionFull),
	// 			Value: to.Ptr("<value>"),
	// 		},
	// 		{
	// 			KeyName: to.Ptr("key2"),
	// 			Permissions: to.Ptr(armstorage.KeyPermissionFull),
	// 			Value: to.Ptr("<value>"),
	// 		},
	// 		{
	// 			KeyName: to.Ptr("kerb1"),
	// 			Permissions: to.Ptr(armstorage.KeyPermissionFull),
	// 			Value: to.Ptr("<value>"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountRegenerateKey.json
func ExampleAccountsClient_RegenerateKey_storageAccountRegenerateKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().RegenerateKey(ctx, "res4167", "sto3539", armstorage.AccountRegenerateKeyParameters{
		KeyName: to.Ptr("key2"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountListKeysResult = armstorage.AccountListKeysResult{
	// 	Keys: []*armstorage.AccountKey{
	// 		{
	// 			KeyName: to.Ptr("key1"),
	// 			Permissions: to.Ptr(armstorage.KeyPermissionFull),
	// 			Value: to.Ptr("<value>"),
	// 		},
	// 		{
	// 			KeyName: to.Ptr("key2"),
	// 			Permissions: to.Ptr(armstorage.KeyPermissionFull),
	// 			Value: to.Ptr("<value>"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountListAccountSAS.json
func ExampleAccountsClient_ListAccountSAS() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().ListAccountSAS(ctx, "res7985", "sto8588", armstorage.AccountSasParameters{
		KeyToSign:              to.Ptr("key1"),
		SharedAccessExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T11:42:03.156Z"); return t }()),
		Permissions:            to.Ptr(armstorage.PermissionsR),
		Protocols:              to.Ptr(armstorage.HTTPProtocolHTTPSHTTP),
		ResourceTypes:          to.Ptr(armstorage.SignedResourceTypesS),
		Services:               to.Ptr(armstorage.ServicesB),
		SharedAccessStartTime:  to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T10:42:03.156Z"); return t }()),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ListAccountSasResponse = armstorage.ListAccountSasResponse{
	// 	AccountSasToken: to.Ptr("sv=2015-04-05&ss=b&srt=s&sp=r&st=2017-05-24T10%3A42%3A03Z&se=2017-05-24T11%3A42%3A03Z&spr=https,http&sig=Z0I%2BEpM%2BPPlTC8ApfUf%2BcffO2aahMgZim3U0iArqsS0%3D"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountListServiceSAS.json
func ExampleAccountsClient_ListServiceSAS() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().ListServiceSAS(ctx, "res7439", "sto1299", armstorage.ServiceSasParameters{
		CanonicalizedResource:  to.Ptr("/blob/sto1299/music"),
		SharedAccessExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T11:32:48.845Z"); return t }()),
		Permissions:            to.Ptr(armstorage.PermissionsL),
		Resource:               to.Ptr(armstorage.SignedResourceC),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ListServiceSasResponse = armstorage.ListServiceSasResponse{
	// 	ServiceSasToken: to.Ptr("sv=2015-04-05&sr=c&se=2017-05-24T11%3A32%3A48Z&sp=l&sig=PoF8yBUGixsjzwroLmw7vG3VbGz4KB2woZC2D4C2oio%3D"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountFailover.json
func ExampleAccountsClient_BeginFailover_storageAccountFailover() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginFailover(ctx, "res4228", "sto2434", &armstorage.AccountsClientBeginFailoverOptions{FailoverType: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountFailoverPlanned.json
func ExampleAccountsClient_BeginFailover_storageAccountFailoverPlanned() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginFailover(ctx, "res4228", "sto2434", &armstorage.AccountsClientBeginFailoverOptions{FailoverType: to.Ptr("Planned")})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountHierarchicalNamespaceMigration.json
func ExampleAccountsClient_BeginHierarchicalNamespaceMigration() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginHierarchicalNamespaceMigration(ctx, "res4228", "sto2434", "HnsOnValidationRequest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountAbortHierarchicalNamespaceMigration.json
func ExampleAccountsClient_BeginAbortHierarchicalNamespaceMigration() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginAbortHierarchicalNamespaceMigration(ctx, "res4228", "sto2434", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountPostMigration.json
func ExampleAccountsClient_BeginCustomerInitiatedMigration() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginCustomerInitiatedMigration(ctx, "resource-group-name", "accountname", armstorage.AccountMigration{
		StorageAccountMigrationDetails: &armstorage.AccountMigrationProperties{
			TargetSKUName: to.Ptr(armstorage.SKUNameStandardZRS),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountGetMigrationFailed.json
func ExampleAccountsClient_GetCustomerInitiatedMigration_storageAccountGetMigrationFailed() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().GetCustomerInitiatedMigration(ctx, "resource-group-name", "accountname", armstorage.MigrationNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountMigration = armstorage.AccountMigration{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts/accountMigrations"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/resource-group-name/providers/Microsoft.Storage/storageAccounts/accountname/accountMigrations/default"),
	// 	StorageAccountMigrationDetails: &armstorage.AccountMigrationProperties{
	// 		MigrationFailedDetailedReason: to.Ptr("ZRS is not supported for accounts with archive data."),
	// 		MigrationFailedReason: to.Ptr("ZrsNotSupportedForAccountWithArchiveData"),
	// 		MigrationStatus: to.Ptr(armstorage.MigrationStatusFailed),
	// 		TargetSKUName: to.Ptr(armstorage.SKUNameStandardZRS),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountGetMigrationInProgress.json
func ExampleAccountsClient_GetCustomerInitiatedMigration_storageAccountGetMigrationInProgress() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().GetCustomerInitiatedMigration(ctx, "resource-group-name", "accountname", armstorage.MigrationNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountMigration = armstorage.AccountMigration{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts/accountMigrations"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/resource-group-name/providers/Microsoft.Storage/storageAccounts/accountname/accountMigrations/default"),
	// 	StorageAccountMigrationDetails: &armstorage.AccountMigrationProperties{
	// 		MigrationStatus: to.Ptr(armstorage.MigrationStatusInProgress),
	// 		TargetSKUName: to.Ptr(armstorage.SKUNameStandardZRS),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/BlobRangesRestore.json
func ExampleAccountsClient_BeginRestoreBlobRanges() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginRestoreBlobRanges(ctx, "res9101", "sto4445", armstorage.BlobRestoreParameters{
		BlobRanges: []*armstorage.BlobRestoreRange{
			{
				EndRange:   to.Ptr("container/blobpath2"),
				StartRange: to.Ptr("container/blobpath1"),
			},
			{
				EndRange:   to.Ptr(""),
				StartRange: to.Ptr("container2/blobpath3"),
			}},
		TimeToRestore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-20T15:30:00.000Z"); return t }()),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BlobRestoreStatus = armstorage.BlobRestoreStatus{
	// 	Parameters: &armstorage.BlobRestoreParameters{
	// 		BlobRanges: []*armstorage.BlobRestoreRange{
	// 			{
	// 				EndRange: to.Ptr("container/blobpath2"),
	// 				StartRange: to.Ptr("container/blobpath1"),
	// 			},
	// 			{
	// 				EndRange: to.Ptr(""),
	// 				StartRange: to.Ptr("container2/blobpath3"),
	// 		}},
	// 		TimeToRestore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-20T15:30:00.000Z"); return t}()),
	// 	},
	// 	RestoreID: to.Ptr("{restore_id}"),
	// 	Status: to.Ptr(armstorage.BlobRestoreProgressStatus("Succeeded")),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/86c6306649b02e542117adb46c61e8019dbd78e9/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/StorageAccountRevokeUserDelegationKeys.json
func ExampleAccountsClient_RevokeUserDelegationKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAccountsClient().RevokeUserDelegationKeys(ctx, "res4167", "sto3539", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
