// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storage/armstorage"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// EncryptionScopesServer is a fake server for instances of the armstorage.EncryptionScopesClient type.
type EncryptionScopesServer struct {
	// Get is the fake for method EncryptionScopesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, encryptionScopeName string, options *armstorage.EncryptionScopesClientGetOptions) (resp azfake.Responder[armstorage.EncryptionScopesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method EncryptionScopesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, accountName string, options *armstorage.EncryptionScopesClientListOptions) (resp azfake.PagerResponder[armstorage.EncryptionScopesClientListResponse])

	// Patch is the fake for method EncryptionScopesClient.Patch
	// HTTP status codes to indicate success: http.StatusOK
	Patch func(ctx context.Context, resourceGroupName string, accountName string, encryptionScopeName string, encryptionScope armstorage.EncryptionScope, options *armstorage.EncryptionScopesClientPatchOptions) (resp azfake.Responder[armstorage.EncryptionScopesClientPatchResponse], errResp azfake.ErrorResponder)

	// Put is the fake for method EncryptionScopesClient.Put
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Put func(ctx context.Context, resourceGroupName string, accountName string, encryptionScopeName string, encryptionScope armstorage.EncryptionScope, options *armstorage.EncryptionScopesClientPutOptions) (resp azfake.Responder[armstorage.EncryptionScopesClientPutResponse], errResp azfake.ErrorResponder)
}

// NewEncryptionScopesServerTransport creates a new instance of EncryptionScopesServerTransport with the provided implementation.
// The returned EncryptionScopesServerTransport instance is connected to an instance of armstorage.EncryptionScopesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewEncryptionScopesServerTransport(srv *EncryptionScopesServer) *EncryptionScopesServerTransport {
	return &EncryptionScopesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armstorage.EncryptionScopesClientListResponse]](),
	}
}

// EncryptionScopesServerTransport connects instances of armstorage.EncryptionScopesClient to instances of EncryptionScopesServer.
// Don't use this type directly, use NewEncryptionScopesServerTransport instead.
type EncryptionScopesServerTransport struct {
	srv          *EncryptionScopesServer
	newListPager *tracker[azfake.PagerResponder[armstorage.EncryptionScopesClientListResponse]]
}

// Do implements the policy.Transporter interface for EncryptionScopesServerTransport.
func (e *EncryptionScopesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	return e.dispatchToMethodFake(req, method)
}

func (e *EncryptionScopesServerTransport) dispatchToMethodFake(req *http.Request, method string) (*http.Response, error) {
	resultChan := make(chan result)
	defer close(resultChan)

	go func() {
		var intercepted bool
		var res result
		if encryptionScopesServerTransportInterceptor != nil {
			res.resp, res.err, intercepted = encryptionScopesServerTransportInterceptor.Do(req)
		}
		if !intercepted {
			switch method {
			case "EncryptionScopesClient.Get":
				res.resp, res.err = e.dispatchGet(req)
			case "EncryptionScopesClient.NewListPager":
				res.resp, res.err = e.dispatchNewListPager(req)
			case "EncryptionScopesClient.Patch":
				res.resp, res.err = e.dispatchPatch(req)
			case "EncryptionScopesClient.Put":
				res.resp, res.err = e.dispatchPut(req)
			default:
				res.err = fmt.Errorf("unhandled API %s", method)
			}

		}
		select {
		case resultChan <- res:
		case <-req.Context().Done():
		}
	}()

	select {
	case <-req.Context().Done():
		return nil, req.Context().Err()
	case res := <-resultChan:
		return res.resp, res.err
	}
}

func (e *EncryptionScopesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/encryptionScopes/(?P<encryptionScopeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	encryptionScopeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("encryptionScopeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, encryptionScopeNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EncryptionScope, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EncryptionScopesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := e.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/encryptionScopes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		maxpagesizeUnescaped, err := url.QueryUnescape(qp.Get("$maxpagesize"))
		if err != nil {
			return nil, err
		}
		maxpagesizeParam, err := parseOptional(maxpagesizeUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		includeUnescaped, err := url.QueryUnescape(qp.Get("$include"))
		if err != nil {
			return nil, err
		}
		includeParam := getOptional(armstorage.ListEncryptionScopesInclude(includeUnescaped))
		var options *armstorage.EncryptionScopesClientListOptions
		if maxpagesizeParam != nil || filterParam != nil || includeParam != nil {
			options = &armstorage.EncryptionScopesClientListOptions{
				Maxpagesize: maxpagesizeParam,
				Filter:      filterParam,
				Include:     includeParam,
			}
		}
		resp := e.srv.NewListPager(resourceGroupNameParam, accountNameParam, options)
		newListPager = &resp
		e.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armstorage.EncryptionScopesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		e.newListPager.remove(req)
	}
	return resp, nil
}

func (e *EncryptionScopesServerTransport) dispatchPatch(req *http.Request) (*http.Response, error) {
	if e.srv.Patch == nil {
		return nil, &nonRetriableError{errors.New("fake for method Patch not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/encryptionScopes/(?P<encryptionScopeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorage.EncryptionScope](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	encryptionScopeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("encryptionScopeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Patch(req.Context(), resourceGroupNameParam, accountNameParam, encryptionScopeNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EncryptionScope, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EncryptionScopesServerTransport) dispatchPut(req *http.Request) (*http.Response, error) {
	if e.srv.Put == nil {
		return nil, &nonRetriableError{errors.New("fake for method Put not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/encryptionScopes/(?P<encryptionScopeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorage.EncryptionScope](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	encryptionScopeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("encryptionScopeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Put(req.Context(), resourceGroupNameParam, accountNameParam, encryptionScopeNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EncryptionScope, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// set this to conditionally intercept incoming requests to EncryptionScopesServerTransport
var encryptionScopesServerTransportInterceptor interface {
	// Do returns true if the server transport should use the returned response/error
	Do(*http.Request) (*http.Response, error, bool)
}
