//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package generated

import (
	"context"
	"encoding/xml"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"net/http"
	"strconv"
	"strings"
	"time"
)

// ShareClient contains the methods for the Share group.
// Don't use this type directly, use a constructor function instead.
type ShareClient struct {
	internal          *azcore.Client
	endpoint          string
	fileRequestIntent *ShareTokenIntent
}

// AcquireLease - The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and
// delete share operations.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - duration - Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never expires. A non-infinite
//     lease can be between 15 and 60 seconds. A lease duration cannot be changed using
//     renew or change.
//   - options - ShareClientAcquireLeaseOptions contains the optional parameters for the ShareClient.AcquireLease method.
func (client *ShareClient) AcquireLease(ctx context.Context, duration int32, options *ShareClientAcquireLeaseOptions) (ShareClientAcquireLeaseResponse, error) {
	var err error
	req, err := client.acquireLeaseCreateRequest(ctx, duration, options)
	if err != nil {
		return ShareClientAcquireLeaseResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientAcquireLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientAcquireLeaseResponse{}, err
	}
	resp, err := client.acquireLeaseHandleResponse(httpResp)
	return resp, err
}

// acquireLeaseCreateRequest creates the AcquireLease request.
func (client *ShareClient) acquireLeaseCreateRequest(ctx context.Context, duration int32, options *ShareClientAcquireLeaseOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	reqQP.Set("restype", "share")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if options != nil && options.Sharesnapshot != nil {
		reqQP.Set("sharesnapshot", *options.Sharesnapshot)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-lease-action"] = []string{"acquire"}
	req.Raw().Header["x-ms-lease-duration"] = []string{strconv.FormatInt(int64(duration), 10)}
	if options != nil && options.ProposedLeaseID != nil {
		req.Raw().Header["x-ms-proposed-lease-id"] = []string{*options.ProposedLeaseID}
	}
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// acquireLeaseHandleResponse handles the AcquireLease response.
func (client *ShareClient) acquireLeaseHandleResponse(resp *http.Response) (ShareClientAcquireLeaseResponse, error) {
	result := ShareClientAcquireLeaseResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientAcquireLeaseResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientAcquireLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-id"); val != "" {
		result.LeaseID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// BreakLease - The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and
// delete share operations.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - options - ShareClientBreakLeaseOptions contains the optional parameters for the ShareClient.BreakLease method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *ShareClient) BreakLease(ctx context.Context, options *ShareClientBreakLeaseOptions, leaseAccessConditions *LeaseAccessConditions) (ShareClientBreakLeaseResponse, error) {
	var err error
	req, err := client.breakLeaseCreateRequest(ctx, options, leaseAccessConditions)
	if err != nil {
		return ShareClientBreakLeaseResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientBreakLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientBreakLeaseResponse{}, err
	}
	resp, err := client.breakLeaseHandleResponse(httpResp)
	return resp, err
}

// breakLeaseCreateRequest creates the BreakLease request.
func (client *ShareClient) breakLeaseCreateRequest(ctx context.Context, options *ShareClientBreakLeaseOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	reqQP.Set("restype", "share")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if options != nil && options.Sharesnapshot != nil {
		reqQP.Set("sharesnapshot", *options.Sharesnapshot)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-lease-action"] = []string{"break"}
	if options != nil && options.BreakPeriod != nil {
		req.Raw().Header["x-ms-lease-break-period"] = []string{strconv.FormatInt(int64(*options.BreakPeriod), 10)}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// breakLeaseHandleResponse handles the BreakLease response.
func (client *ShareClient) breakLeaseHandleResponse(resp *http.Response) (ShareClientBreakLeaseResponse, error) {
	result := ShareClientBreakLeaseResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientBreakLeaseResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientBreakLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-id"); val != "" {
		result.LeaseID = &val
	}
	if val := resp.Header.Get("x-ms-lease-time"); val != "" {
		leaseTime32, err := strconv.ParseInt(val, 10, 32)
		leaseTime := int32(leaseTime32)
		if err != nil {
			return ShareClientBreakLeaseResponse{}, err
		}
		result.LeaseTime = &leaseTime
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// ChangeLease - The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and
// delete share operations.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - leaseID - Specifies the current lease ID on the resource.
//   - options - ShareClientChangeLeaseOptions contains the optional parameters for the ShareClient.ChangeLease method.
func (client *ShareClient) ChangeLease(ctx context.Context, leaseID string, options *ShareClientChangeLeaseOptions) (ShareClientChangeLeaseResponse, error) {
	var err error
	req, err := client.changeLeaseCreateRequest(ctx, leaseID, options)
	if err != nil {
		return ShareClientChangeLeaseResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientChangeLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientChangeLeaseResponse{}, err
	}
	resp, err := client.changeLeaseHandleResponse(httpResp)
	return resp, err
}

// changeLeaseCreateRequest creates the ChangeLease request.
func (client *ShareClient) changeLeaseCreateRequest(ctx context.Context, leaseID string, options *ShareClientChangeLeaseOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	reqQP.Set("restype", "share")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if options != nil && options.Sharesnapshot != nil {
		reqQP.Set("sharesnapshot", *options.Sharesnapshot)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-lease-action"] = []string{"change"}
	req.Raw().Header["x-ms-lease-id"] = []string{leaseID}
	if options != nil && options.ProposedLeaseID != nil {
		req.Raw().Header["x-ms-proposed-lease-id"] = []string{*options.ProposedLeaseID}
	}
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// changeLeaseHandleResponse handles the ChangeLease response.
func (client *ShareClient) changeLeaseHandleResponse(resp *http.Response) (ShareClientChangeLeaseResponse, error) {
	result := ShareClientChangeLeaseResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientChangeLeaseResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientChangeLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-id"); val != "" {
		result.LeaseID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// Create - Creates a new share under the specified account. If the share with the same name already exists, the operation
// fails.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - options - ShareClientCreateOptions contains the optional parameters for the ShareClient.Create method.
func (client *ShareClient) Create(ctx context.Context, options *ShareClientCreateOptions) (ShareClientCreateResponse, error) {
	var err error
	req, err := client.createCreateRequest(ctx, options)
	if err != nil {
		return ShareClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *ShareClient) createCreateRequest(ctx context.Context, options *ShareClientCreateOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "share")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.Metadata != nil {
		for k, v := range options.Metadata {
			if v != nil {
				req.Raw().Header["x-ms-meta-"+k] = []string{*v}
			}
		}
	}
	if options != nil && options.Quota != nil {
		req.Raw().Header["x-ms-share-quota"] = []string{strconv.FormatInt(int64(*options.Quota), 10)}
	}
	if options != nil && options.AccessTier != nil {
		req.Raw().Header["x-ms-access-tier"] = []string{string(*options.AccessTier)}
	}
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if options != nil && options.EnabledProtocols != nil {
		req.Raw().Header["x-ms-enabled-protocols"] = []string{*options.EnabledProtocols}
	}
	if options != nil && options.RootSquash != nil {
		req.Raw().Header["x-ms-root-squash"] = []string{string(*options.RootSquash)}
	}
	if options != nil && options.EnableSnapshotVirtualDirectoryAccess != nil {
		req.Raw().Header["x-ms-enable-snapshot-virtual-directory-access"] = []string{strconv.FormatBool(*options.EnableSnapshotVirtualDirectoryAccess)}
	}
	if options != nil && options.PaidBurstingEnabled != nil {
		req.Raw().Header["x-ms-share-paid-bursting-enabled"] = []string{strconv.FormatBool(*options.PaidBurstingEnabled)}
	}
	if options != nil && options.PaidBurstingMaxBandwidthMibps != nil {
		req.Raw().Header["x-ms-share-paid-bursting-max-bandwidth-mibps"] = []string{strconv.FormatInt(*options.PaidBurstingMaxBandwidthMibps, 10)}
	}
	if options != nil && options.PaidBurstingMaxIops != nil {
		req.Raw().Header["x-ms-share-paid-bursting-max-iops"] = []string{strconv.FormatInt(*options.PaidBurstingMaxIops, 10)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *ShareClient) createHandleResponse(resp *http.Response) (ShareClientCreateResponse, error) {
	result := ShareClientCreateResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientCreateResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientCreateResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// CreatePermission - Create a permission (a security descriptor).
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - sharePermission - A permission (a security descriptor) at the share level.
//   - options - ShareClientCreatePermissionOptions contains the optional parameters for the ShareClient.CreatePermission method.
func (client *ShareClient) CreatePermission(ctx context.Context, sharePermission SharePermission, options *ShareClientCreatePermissionOptions) (ShareClientCreatePermissionResponse, error) {
	var err error
	req, err := client.createPermissionCreateRequest(ctx, sharePermission, options)
	if err != nil {
		return ShareClientCreatePermissionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientCreatePermissionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientCreatePermissionResponse{}, err
	}
	resp, err := client.createPermissionHandleResponse(httpResp)
	return resp, err
}

// createPermissionCreateRequest creates the CreatePermission request.
func (client *ShareClient) createPermissionCreateRequest(ctx context.Context, sharePermission SharePermission, options *ShareClientCreatePermissionOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "share")
	reqQP.Set("comp", "filepermission")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	if err := runtime.MarshalAsJSON(req, sharePermission); err != nil {
		return nil, err
	}
	return req, nil
}

// createPermissionHandleResponse handles the CreatePermission response.
func (client *ShareClient) createPermissionHandleResponse(resp *http.Response) (ShareClientCreatePermissionResponse, error) {
	result := ShareClientCreatePermissionResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientCreatePermissionResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-file-permission-key"); val != "" {
		result.FilePermissionKey = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// CreateSnapshot - Creates a read-only snapshot of a share.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - options - ShareClientCreateSnapshotOptions contains the optional parameters for the ShareClient.CreateSnapshot method.
func (client *ShareClient) CreateSnapshot(ctx context.Context, options *ShareClientCreateSnapshotOptions) (ShareClientCreateSnapshotResponse, error) {
	var err error
	req, err := client.createSnapshotCreateRequest(ctx, options)
	if err != nil {
		return ShareClientCreateSnapshotResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientCreateSnapshotResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientCreateSnapshotResponse{}, err
	}
	resp, err := client.createSnapshotHandleResponse(httpResp)
	return resp, err
}

// createSnapshotCreateRequest creates the CreateSnapshot request.
func (client *ShareClient) createSnapshotCreateRequest(ctx context.Context, options *ShareClientCreateSnapshotOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "share")
	reqQP.Set("comp", "snapshot")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.Metadata != nil {
		for k, v := range options.Metadata {
			if v != nil {
				req.Raw().Header["x-ms-meta-"+k] = []string{*v}
			}
		}
	}
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// createSnapshotHandleResponse handles the CreateSnapshot response.
func (client *ShareClient) createSnapshotHandleResponse(resp *http.Response) (ShareClientCreateSnapshotResponse, error) {
	result := ShareClientCreateSnapshotResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientCreateSnapshotResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientCreateSnapshotResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-snapshot"); val != "" {
		result.Snapshot = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// Delete - Operation marks the specified share or share snapshot for deletion. The share or share snapshot and any files
// contained within it are later deleted during garbage collection.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - options - ShareClientDeleteOptions contains the optional parameters for the ShareClient.Delete method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *ShareClient) Delete(ctx context.Context, options *ShareClientDeleteOptions, leaseAccessConditions *LeaseAccessConditions) (ShareClientDeleteResponse, error) {
	var err error
	req, err := client.deleteCreateRequest(ctx, options, leaseAccessConditions)
	if err != nil {
		return ShareClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientDeleteResponse{}, err
	}
	resp, err := client.deleteHandleResponse(httpResp)
	return resp, err
}

// deleteCreateRequest creates the Delete request.
func (client *ShareClient) deleteCreateRequest(ctx context.Context, options *ShareClientDeleteOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodDelete, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "share")
	if options != nil && options.Sharesnapshot != nil {
		reqQP.Set("sharesnapshot", *options.Sharesnapshot)
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if options != nil && options.DeleteSnapshots != nil {
		req.Raw().Header["x-ms-delete-snapshots"] = []string{string(*options.DeleteSnapshots)}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// deleteHandleResponse handles the Delete response.
func (client *ShareClient) deleteHandleResponse(resp *http.Response) (ShareClientDeleteResponse, error) {
	result := ShareClientDeleteResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientDeleteResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// GetAccessPolicy - Returns information about stored access policies specified on the share.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - options - ShareClientGetAccessPolicyOptions contains the optional parameters for the ShareClient.GetAccessPolicy method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *ShareClient) GetAccessPolicy(ctx context.Context, options *ShareClientGetAccessPolicyOptions, leaseAccessConditions *LeaseAccessConditions) (ShareClientGetAccessPolicyResponse, error) {
	var err error
	req, err := client.getAccessPolicyCreateRequest(ctx, options, leaseAccessConditions)
	if err != nil {
		return ShareClientGetAccessPolicyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientGetAccessPolicyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientGetAccessPolicyResponse{}, err
	}
	resp, err := client.getAccessPolicyHandleResponse(httpResp)
	return resp, err
}

// getAccessPolicyCreateRequest creates the GetAccessPolicy request.
func (client *ShareClient) getAccessPolicyCreateRequest(ctx context.Context, options *ShareClientGetAccessPolicyOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "share")
	reqQP.Set("comp", "acl")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// getAccessPolicyHandleResponse handles the GetAccessPolicy response.
func (client *ShareClient) getAccessPolicyHandleResponse(resp *http.Response) (ShareClientGetAccessPolicyResponse, error) {
	result := ShareClientGetAccessPolicyResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientGetAccessPolicyResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientGetAccessPolicyResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if err := runtime.UnmarshalAsXML(resp, &result); err != nil {
		return ShareClientGetAccessPolicyResponse{}, err
	}
	return result, nil
}

// GetPermission - Returns the permission (security descriptor) for a given key
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - filePermissionKey - Key of the permission to be set for the directory/file.
//   - options - ShareClientGetPermissionOptions contains the optional parameters for the ShareClient.GetPermission method.
func (client *ShareClient) GetPermission(ctx context.Context, filePermissionKey string, options *ShareClientGetPermissionOptions) (ShareClientGetPermissionResponse, error) {
	var err error
	req, err := client.getPermissionCreateRequest(ctx, filePermissionKey, options)
	if err != nil {
		return ShareClientGetPermissionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientGetPermissionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientGetPermissionResponse{}, err
	}
	resp, err := client.getPermissionHandleResponse(httpResp)
	return resp, err
}

// getPermissionCreateRequest creates the GetPermission request.
func (client *ShareClient) getPermissionCreateRequest(ctx context.Context, filePermissionKey string, options *ShareClientGetPermissionOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "share")
	reqQP.Set("comp", "filepermission")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-file-permission-key"] = []string{filePermissionKey}
	if options != nil && options.FilePermissionFormat != nil {
		req.Raw().Header["x-ms-file-permission-format"] = []string{string(*options.FilePermissionFormat)}
	}
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPermissionHandleResponse handles the GetPermission response.
func (client *ShareClient) getPermissionHandleResponse(resp *http.Response) (ShareClientGetPermissionResponse, error) {
	result := ShareClientGetPermissionResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientGetPermissionResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.SharePermission); err != nil {
		return ShareClientGetPermissionResponse{}, err
	}
	return result, nil
}

// GetProperties - Returns all user-defined metadata and system properties for the specified share or share snapshot. The
// data returned does not include the share's list of files.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - options - ShareClientGetPropertiesOptions contains the optional parameters for the ShareClient.GetProperties method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *ShareClient) GetProperties(ctx context.Context, options *ShareClientGetPropertiesOptions, leaseAccessConditions *LeaseAccessConditions) (ShareClientGetPropertiesResponse, error) {
	var err error
	req, err := client.getPropertiesCreateRequest(ctx, options, leaseAccessConditions)
	if err != nil {
		return ShareClientGetPropertiesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientGetPropertiesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientGetPropertiesResponse{}, err
	}
	resp, err := client.getPropertiesHandleResponse(httpResp)
	return resp, err
}

// getPropertiesCreateRequest creates the GetProperties request.
func (client *ShareClient) getPropertiesCreateRequest(ctx context.Context, options *ShareClientGetPropertiesOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "share")
	if options != nil && options.Sharesnapshot != nil {
		reqQP.Set("sharesnapshot", *options.Sharesnapshot)
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// getPropertiesHandleResponse handles the GetProperties response.
func (client *ShareClient) getPropertiesHandleResponse(resp *http.Response) (ShareClientGetPropertiesResponse, error) {
	result := ShareClientGetPropertiesResponse{}
	if val := resp.Header.Get("x-ms-access-tier"); val != "" {
		result.AccessTier = &val
	}
	if val := resp.Header.Get("x-ms-access-tier-change-time"); val != "" {
		accessTierChangeTime, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientGetPropertiesResponse{}, err
		}
		result.AccessTierChangeTime = &accessTierChangeTime
	}
	if val := resp.Header.Get("x-ms-access-tier-transition-state"); val != "" {
		result.AccessTierTransitionState = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientGetPropertiesResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-enable-snapshot-virtual-directory-access"); val != "" {
		enableSnapshotVirtualDirectoryAccess, err := strconv.ParseBool(val)
		if err != nil {
			return ShareClientGetPropertiesResponse{}, err
		}
		result.EnableSnapshotVirtualDirectoryAccess = &enableSnapshotVirtualDirectoryAccess
	}
	if val := resp.Header.Get("x-ms-enabled-protocols"); val != "" {
		result.EnabledProtocols = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientGetPropertiesResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-duration"); val != "" {
		result.LeaseDuration = (*LeaseDurationType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-state"); val != "" {
		result.LeaseState = (*LeaseStateType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-status"); val != "" {
		result.LeaseStatus = (*LeaseStatusType)(&val)
	}
	for hh := range resp.Header {
		if len(hh) > len("x-ms-meta-") && strings.EqualFold(hh[:len("x-ms-meta-")], "x-ms-meta-") {
			if result.Metadata == nil {
				result.Metadata = map[string]*string{}
			}
			result.Metadata[hh[len("x-ms-meta-"):]] = to.Ptr(resp.Header.Get(hh))
		}
	}
	if val := resp.Header.Get("x-ms-share-next-allowed-quota-downgrade-time"); val != "" {
		nextAllowedQuotaDowngradeTime, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientGetPropertiesResponse{}, err
		}
		result.NextAllowedQuotaDowngradeTime = &nextAllowedQuotaDowngradeTime
	}
	if val := resp.Header.Get("x-ms-share-paid-bursting-enabled"); val != "" {
		paidBurstingEnabled, err := strconv.ParseBool(val)
		if err != nil {
			return ShareClientGetPropertiesResponse{}, err
		}
		result.PaidBurstingEnabled = &paidBurstingEnabled
	}
	if val := resp.Header.Get("x-ms-share-paid-bursting-max-bandwidth-mibps"); val != "" {
		paidBurstingMaxBandwidthMibps, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return ShareClientGetPropertiesResponse{}, err
		}
		result.PaidBurstingMaxBandwidthMibps = &paidBurstingMaxBandwidthMibps
	}
	if val := resp.Header.Get("x-ms-share-paid-bursting-max-iops"); val != "" {
		paidBurstingMaxIops, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return ShareClientGetPropertiesResponse{}, err
		}
		result.PaidBurstingMaxIops = &paidBurstingMaxIops
	}
	if val := resp.Header.Get("x-ms-share-provisioned-bandwidth-mibps"); val != "" {
		provisionedBandwidthMiBps32, err := strconv.ParseInt(val, 10, 32)
		provisionedBandwidthMiBps := int32(provisionedBandwidthMiBps32)
		if err != nil {
			return ShareClientGetPropertiesResponse{}, err
		}
		result.ProvisionedBandwidthMiBps = &provisionedBandwidthMiBps
	}
	if val := resp.Header.Get("x-ms-share-provisioned-egress-mbps"); val != "" {
		provisionedEgressMBps32, err := strconv.ParseInt(val, 10, 32)
		provisionedEgressMBps := int32(provisionedEgressMBps32)
		if err != nil {
			return ShareClientGetPropertiesResponse{}, err
		}
		result.ProvisionedEgressMBps = &provisionedEgressMBps
	}
	if val := resp.Header.Get("x-ms-share-provisioned-ingress-mbps"); val != "" {
		provisionedIngressMBps32, err := strconv.ParseInt(val, 10, 32)
		provisionedIngressMBps := int32(provisionedIngressMBps32)
		if err != nil {
			return ShareClientGetPropertiesResponse{}, err
		}
		result.ProvisionedIngressMBps = &provisionedIngressMBps
	}
	if val := resp.Header.Get("x-ms-share-provisioned-iops"); val != "" {
		provisionedIops32, err := strconv.ParseInt(val, 10, 32)
		provisionedIops := int32(provisionedIops32)
		if err != nil {
			return ShareClientGetPropertiesResponse{}, err
		}
		result.ProvisionedIops = &provisionedIops
	}
	if val := resp.Header.Get("x-ms-share-quota"); val != "" {
		quota32, err := strconv.ParseInt(val, 10, 32)
		quota := int32(quota32)
		if err != nil {
			return ShareClientGetPropertiesResponse{}, err
		}
		result.Quota = &quota
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-root-squash"); val != "" {
		result.RootSquash = (*ShareRootSquash)(&val)
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// GetStatistics - Retrieves statistics related to the share.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - options - ShareClientGetStatisticsOptions contains the optional parameters for the ShareClient.GetStatistics method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *ShareClient) GetStatistics(ctx context.Context, options *ShareClientGetStatisticsOptions, leaseAccessConditions *LeaseAccessConditions) (ShareClientGetStatisticsResponse, error) {
	var err error
	req, err := client.getStatisticsCreateRequest(ctx, options, leaseAccessConditions)
	if err != nil {
		return ShareClientGetStatisticsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientGetStatisticsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientGetStatisticsResponse{}, err
	}
	resp, err := client.getStatisticsHandleResponse(httpResp)
	return resp, err
}

// getStatisticsCreateRequest creates the GetStatistics request.
func (client *ShareClient) getStatisticsCreateRequest(ctx context.Context, options *ShareClientGetStatisticsOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "share")
	reqQP.Set("comp", "stats")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// getStatisticsHandleResponse handles the GetStatistics response.
func (client *ShareClient) getStatisticsHandleResponse(resp *http.Response) (ShareClientGetStatisticsResponse, error) {
	result := ShareClientGetStatisticsResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientGetStatisticsResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientGetStatisticsResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if err := runtime.UnmarshalAsXML(resp, &result.ShareStats); err != nil {
		return ShareClientGetStatisticsResponse{}, err
	}
	return result, nil
}

// ReleaseLease - The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and
// delete share operations.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - leaseID - Specifies the current lease ID on the resource.
//   - options - ShareClientReleaseLeaseOptions contains the optional parameters for the ShareClient.ReleaseLease method.
func (client *ShareClient) ReleaseLease(ctx context.Context, leaseID string, options *ShareClientReleaseLeaseOptions) (ShareClientReleaseLeaseResponse, error) {
	var err error
	req, err := client.releaseLeaseCreateRequest(ctx, leaseID, options)
	if err != nil {
		return ShareClientReleaseLeaseResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientReleaseLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientReleaseLeaseResponse{}, err
	}
	resp, err := client.releaseLeaseHandleResponse(httpResp)
	return resp, err
}

// releaseLeaseCreateRequest creates the ReleaseLease request.
func (client *ShareClient) releaseLeaseCreateRequest(ctx context.Context, leaseID string, options *ShareClientReleaseLeaseOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	reqQP.Set("restype", "share")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if options != nil && options.Sharesnapshot != nil {
		reqQP.Set("sharesnapshot", *options.Sharesnapshot)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-lease-action"] = []string{"release"}
	req.Raw().Header["x-ms-lease-id"] = []string{leaseID}
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// releaseLeaseHandleResponse handles the ReleaseLease response.
func (client *ShareClient) releaseLeaseHandleResponse(resp *http.Response) (ShareClientReleaseLeaseResponse, error) {
	result := ShareClientReleaseLeaseResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientReleaseLeaseResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientReleaseLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// RenewLease - The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and
// delete share operations.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - leaseID - Specifies the current lease ID on the resource.
//   - options - ShareClientRenewLeaseOptions contains the optional parameters for the ShareClient.RenewLease method.
func (client *ShareClient) RenewLease(ctx context.Context, leaseID string, options *ShareClientRenewLeaseOptions) (ShareClientRenewLeaseResponse, error) {
	var err error
	req, err := client.renewLeaseCreateRequest(ctx, leaseID, options)
	if err != nil {
		return ShareClientRenewLeaseResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientRenewLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientRenewLeaseResponse{}, err
	}
	resp, err := client.renewLeaseHandleResponse(httpResp)
	return resp, err
}

// renewLeaseCreateRequest creates the RenewLease request.
func (client *ShareClient) renewLeaseCreateRequest(ctx context.Context, leaseID string, options *ShareClientRenewLeaseOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	reqQP.Set("restype", "share")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if options != nil && options.Sharesnapshot != nil {
		reqQP.Set("sharesnapshot", *options.Sharesnapshot)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-lease-action"] = []string{"renew"}
	req.Raw().Header["x-ms-lease-id"] = []string{leaseID}
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// renewLeaseHandleResponse handles the RenewLease response.
func (client *ShareClient) renewLeaseHandleResponse(resp *http.Response) (ShareClientRenewLeaseResponse, error) {
	result := ShareClientRenewLeaseResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientRenewLeaseResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientRenewLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-id"); val != "" {
		result.LeaseID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// Restore - Restores a previously deleted Share.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - options - ShareClientRestoreOptions contains the optional parameters for the ShareClient.Restore method.
func (client *ShareClient) Restore(ctx context.Context, options *ShareClientRestoreOptions) (ShareClientRestoreResponse, error) {
	var err error
	req, err := client.restoreCreateRequest(ctx, options)
	if err != nil {
		return ShareClientRestoreResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientRestoreResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientRestoreResponse{}, err
	}
	resp, err := client.restoreHandleResponse(httpResp)
	return resp, err
}

// restoreCreateRequest creates the Restore request.
func (client *ShareClient) restoreCreateRequest(ctx context.Context, options *ShareClientRestoreOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "share")
	reqQP.Set("comp", "undelete")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if options != nil && options.DeletedShareName != nil {
		req.Raw().Header["x-ms-deleted-share-name"] = []string{*options.DeletedShareName}
	}
	if options != nil && options.DeletedShareVersion != nil {
		req.Raw().Header["x-ms-deleted-share-version"] = []string{*options.DeletedShareVersion}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// restoreHandleResponse handles the Restore response.
func (client *ShareClient) restoreHandleResponse(resp *http.Response) (ShareClientRestoreResponse, error) {
	result := ShareClientRestoreResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientRestoreResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientRestoreResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// SetAccessPolicy - Sets a stored access policy for use with shared access signatures.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - shareACL - The ACL for the share.
//   - options - ShareClientSetAccessPolicyOptions contains the optional parameters for the ShareClient.SetAccessPolicy method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *ShareClient) SetAccessPolicy(ctx context.Context, shareACL []*SignedIdentifier, options *ShareClientSetAccessPolicyOptions, leaseAccessConditions *LeaseAccessConditions) (ShareClientSetAccessPolicyResponse, error) {
	var err error
	req, err := client.setAccessPolicyCreateRequest(ctx, shareACL, options, leaseAccessConditions)
	if err != nil {
		return ShareClientSetAccessPolicyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientSetAccessPolicyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientSetAccessPolicyResponse{}, err
	}
	resp, err := client.setAccessPolicyHandleResponse(httpResp)
	return resp, err
}

// setAccessPolicyCreateRequest creates the SetAccessPolicy request.
func (client *ShareClient) setAccessPolicyCreateRequest(ctx context.Context, shareACL []*SignedIdentifier, options *ShareClientSetAccessPolicyOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "share")
	reqQP.Set("comp", "acl")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	type wrapper struct {
		XMLName  xml.Name             `xml:"SignedIdentifiers"`
		ShareACL *[]*SignedIdentifier `xml:"SignedIdentifier"`
	}
	if err := runtime.MarshalAsXML(req, wrapper{ShareACL: &shareACL}); err != nil {
		return nil, err
	}
	return req, nil
}

// setAccessPolicyHandleResponse handles the SetAccessPolicy response.
func (client *ShareClient) setAccessPolicyHandleResponse(resp *http.Response) (ShareClientSetAccessPolicyResponse, error) {
	result := ShareClientSetAccessPolicyResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientSetAccessPolicyResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientSetAccessPolicyResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// SetMetadata - Sets one or more user-defined name-value pairs for the specified share.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - options - ShareClientSetMetadataOptions contains the optional parameters for the ShareClient.SetMetadata method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *ShareClient) SetMetadata(ctx context.Context, options *ShareClientSetMetadataOptions, leaseAccessConditions *LeaseAccessConditions) (ShareClientSetMetadataResponse, error) {
	var err error
	req, err := client.setMetadataCreateRequest(ctx, options, leaseAccessConditions)
	if err != nil {
		return ShareClientSetMetadataResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientSetMetadataResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientSetMetadataResponse{}, err
	}
	resp, err := client.setMetadataHandleResponse(httpResp)
	return resp, err
}

// setMetadataCreateRequest creates the SetMetadata request.
func (client *ShareClient) setMetadataCreateRequest(ctx context.Context, options *ShareClientSetMetadataOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "share")
	reqQP.Set("comp", "metadata")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.Metadata != nil {
		for k, v := range options.Metadata {
			if v != nil {
				req.Raw().Header["x-ms-meta-"+k] = []string{*v}
			}
		}
	}
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// setMetadataHandleResponse handles the SetMetadata response.
func (client *ShareClient) setMetadataHandleResponse(resp *http.Response) (ShareClientSetMetadataResponse, error) {
	result := ShareClientSetMetadataResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientSetMetadataResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientSetMetadataResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// SetProperties - Sets properties for the specified share.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-11-04
//   - options - ShareClientSetPropertiesOptions contains the optional parameters for the ShareClient.SetProperties method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *ShareClient) SetProperties(ctx context.Context, options *ShareClientSetPropertiesOptions, leaseAccessConditions *LeaseAccessConditions) (ShareClientSetPropertiesResponse, error) {
	var err error
	req, err := client.setPropertiesCreateRequest(ctx, options, leaseAccessConditions)
	if err != nil {
		return ShareClientSetPropertiesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ShareClientSetPropertiesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ShareClientSetPropertiesResponse{}, err
	}
	resp, err := client.setPropertiesHandleResponse(httpResp)
	return resp, err
}

// setPropertiesCreateRequest creates the SetProperties request.
func (client *ShareClient) setPropertiesCreateRequest(ctx context.Context, options *ShareClientSetPropertiesOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "share")
	reqQP.Set("comp", "properties")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2024-11-04"}
	if options != nil && options.Quota != nil {
		req.Raw().Header["x-ms-share-quota"] = []string{strconv.FormatInt(int64(*options.Quota), 10)}
	}
	if options != nil && options.AccessTier != nil {
		req.Raw().Header["x-ms-access-tier"] = []string{string(*options.AccessTier)}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if options != nil && options.RootSquash != nil {
		req.Raw().Header["x-ms-root-squash"] = []string{string(*options.RootSquash)}
	}
	if options != nil && options.EnableSnapshotVirtualDirectoryAccess != nil {
		req.Raw().Header["x-ms-enable-snapshot-virtual-directory-access"] = []string{strconv.FormatBool(*options.EnableSnapshotVirtualDirectoryAccess)}
	}
	if options != nil && options.PaidBurstingEnabled != nil {
		req.Raw().Header["x-ms-share-paid-bursting-enabled"] = []string{strconv.FormatBool(*options.PaidBurstingEnabled)}
	}
	if options != nil && options.PaidBurstingMaxBandwidthMibps != nil {
		req.Raw().Header["x-ms-share-paid-bursting-max-bandwidth-mibps"] = []string{strconv.FormatInt(*options.PaidBurstingMaxBandwidthMibps, 10)}
	}
	if options != nil && options.PaidBurstingMaxIops != nil {
		req.Raw().Header["x-ms-share-paid-bursting-max-iops"] = []string{strconv.FormatInt(*options.PaidBurstingMaxIops, 10)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// setPropertiesHandleResponse handles the SetProperties response.
func (client *ShareClient) setPropertiesHandleResponse(resp *http.Response) (ShareClientSetPropertiesResponse, error) {
	result := ShareClientSetPropertiesResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientSetPropertiesResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ShareClientSetPropertiesResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}
