// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/entity_type.proto

package cxpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	EntityTypes_GetEntityType_FullMethodName     = "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/GetEntityType"
	EntityTypes_CreateEntityType_FullMethodName  = "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/CreateEntityType"
	EntityTypes_UpdateEntityType_FullMethodName  = "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/UpdateEntityType"
	EntityTypes_DeleteEntityType_FullMethodName  = "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/DeleteEntityType"
	EntityTypes_ListEntityTypes_FullMethodName   = "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/ListEntityTypes"
	EntityTypes_ExportEntityTypes_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/ExportEntityTypes"
	EntityTypes_ImportEntityTypes_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/ImportEntityTypes"
)

// EntityTypesClient is the client API for EntityTypes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EntityTypesClient interface {
	// Retrieves the specified entity type.
	GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Creates an entity type in the specified agent.
	CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Updates the specified entity type.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Deletes the specified entity type.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns the list of all entity types in the specified agent.
	ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error)
	// Exports the selected entity types.
	ExportEntityTypes(ctx context.Context, in *ExportEntityTypesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports the specified entitytypes into the agent.
	ImportEntityTypes(ctx context.Context, in *ImportEntityTypesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type entityTypesClient struct {
	cc grpc.ClientConnInterface
}

func NewEntityTypesClient(cc grpc.ClientConnInterface) EntityTypesClient {
	return &entityTypesClient{cc}
}

func (c *entityTypesClient) GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, EntityTypes_GetEntityType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, EntityTypes_CreateEntityType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, EntityTypes_UpdateEntityType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, EntityTypes_DeleteEntityType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error) {
	out := new(ListEntityTypesResponse)
	err := c.cc.Invoke(ctx, EntityTypes_ListEntityTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) ExportEntityTypes(ctx context.Context, in *ExportEntityTypesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EntityTypes_ExportEntityTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) ImportEntityTypes(ctx context.Context, in *ImportEntityTypesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EntityTypes_ImportEntityTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EntityTypesServer is the server API for EntityTypes service.
// All implementations should embed UnimplementedEntityTypesServer
// for forward compatibility
type EntityTypesServer interface {
	// Retrieves the specified entity type.
	GetEntityType(context.Context, *GetEntityTypeRequest) (*EntityType, error)
	// Creates an entity type in the specified agent.
	CreateEntityType(context.Context, *CreateEntityTypeRequest) (*EntityType, error)
	// Updates the specified entity type.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdateEntityType(context.Context, *UpdateEntityTypeRequest) (*EntityType, error)
	// Deletes the specified entity type.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	DeleteEntityType(context.Context, *DeleteEntityTypeRequest) (*emptypb.Empty, error)
	// Returns the list of all entity types in the specified agent.
	ListEntityTypes(context.Context, *ListEntityTypesRequest) (*ListEntityTypesResponse, error)
	// Exports the selected entity types.
	ExportEntityTypes(context.Context, *ExportEntityTypesRequest) (*longrunningpb.Operation, error)
	// Imports the specified entitytypes into the agent.
	ImportEntityTypes(context.Context, *ImportEntityTypesRequest) (*longrunningpb.Operation, error)
}

// UnimplementedEntityTypesServer should be embedded to have forward compatible implementations.
type UnimplementedEntityTypesServer struct {
}

func (UnimplementedEntityTypesServer) GetEntityType(context.Context, *GetEntityTypeRequest) (*EntityType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntityType not implemented")
}
func (UnimplementedEntityTypesServer) CreateEntityType(context.Context, *CreateEntityTypeRequest) (*EntityType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntityType not implemented")
}
func (UnimplementedEntityTypesServer) UpdateEntityType(context.Context, *UpdateEntityTypeRequest) (*EntityType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntityType not implemented")
}
func (UnimplementedEntityTypesServer) DeleteEntityType(context.Context, *DeleteEntityTypeRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntityType not implemented")
}
func (UnimplementedEntityTypesServer) ListEntityTypes(context.Context, *ListEntityTypesRequest) (*ListEntityTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntityTypes not implemented")
}
func (UnimplementedEntityTypesServer) ExportEntityTypes(context.Context, *ExportEntityTypesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportEntityTypes not implemented")
}
func (UnimplementedEntityTypesServer) ImportEntityTypes(context.Context, *ImportEntityTypesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportEntityTypes not implemented")
}

// UnsafeEntityTypesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EntityTypesServer will
// result in compilation errors.
type UnsafeEntityTypesServer interface {
	mustEmbedUnimplementedEntityTypesServer()
}

func RegisterEntityTypesServer(s grpc.ServiceRegistrar, srv EntityTypesServer) {
	s.RegisterService(&EntityTypes_ServiceDesc, srv)
}

func _EntityTypes_GetEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).GetEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_GetEntityType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).GetEntityType(ctx, req.(*GetEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_CreateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).CreateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_CreateEntityType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).CreateEntityType(ctx, req.(*CreateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_UpdateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).UpdateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_UpdateEntityType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).UpdateEntityType(ctx, req.(*UpdateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_DeleteEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).DeleteEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_DeleteEntityType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).DeleteEntityType(ctx, req.(*DeleteEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_ListEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).ListEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_ListEntityTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).ListEntityTypes(ctx, req.(*ListEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_ExportEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).ExportEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_ExportEntityTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).ExportEntityTypes(ctx, req.(*ExportEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_ImportEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).ImportEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_ImportEntityTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).ImportEntityTypes(ctx, req.(*ImportEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// EntityTypes_ServiceDesc is the grpc.ServiceDesc for EntityTypes service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var EntityTypes_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.EntityTypes",
	HandlerType: (*EntityTypesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetEntityType",
			Handler:    _EntityTypes_GetEntityType_Handler,
		},
		{
			MethodName: "CreateEntityType",
			Handler:    _EntityTypes_CreateEntityType_Handler,
		},
		{
			MethodName: "UpdateEntityType",
			Handler:    _EntityTypes_UpdateEntityType_Handler,
		},
		{
			MethodName: "DeleteEntityType",
			Handler:    _EntityTypes_DeleteEntityType_Handler,
		},
		{
			MethodName: "ListEntityTypes",
			Handler:    _EntityTypes_ListEntityTypes_Handler,
		},
		{
			MethodName: "ExportEntityTypes",
			Handler:    _EntityTypes_ExportEntityTypes_Handler,
		},
		{
			MethodName: "ImportEntityTypes",
			Handler:    _EntityTypes_ImportEntityTypes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/entity_type.proto",
}
