// Code generated by radius-dict-gen. DO NOT EDIT.

package rfc4679

import (
	"strconv"

	"layeh.com/radius"
	"layeh.com/radius/rfc2865"
)

const (
	_ADSLForum_VendorID = 3561
)

func _ADSLForum_AddVendor(p *radius.Packet, typ byte, attr radius.Attribute) (err error) {
	var vsa radius.Attribute
	vendor := make(radius.Attribute, 2+len(attr))
	vendor[0] = typ
	vendor[1] = byte(len(vendor))
	copy(vendor[2:], attr)
	vsa, err = radius.NewVendorSpecific(_ADSLForum_VendorID, vendor)
	if err != nil {
		return
	}
	p.Add(rfc2865.VendorSpecific_Type, vsa)
	return
}

func _ADSLForum_GetsVendor(p *radius.Packet, typ byte) (values []radius.Attribute) {
	for _, avp := range p.Attributes {
		if avp.Type != rfc2865.VendorSpecific_Type {
			continue
		}
		attr := avp.Attribute
		vendorID, vsa, err := radius.VendorSpecific(attr)
		if err != nil || vendorID != _ADSLForum_VendorID {
			continue
		}
		for len(vsa) >= 3 {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				break
			}
			if vsaTyp == typ {
				values = append(values, vsa[2:int(vsaLen)])
			}
			vsa = vsa[int(vsaLen):]
		}
	}
	return
}

func _ADSLForum_LookupVendor(p *radius.Packet, typ byte) (attr radius.Attribute, ok bool) {
	for _, avp := range p.Attributes {
		if avp.Type != rfc2865.VendorSpecific_Type {
			continue
		}
		attr := avp.Attribute
		vendorID, vsa, err := radius.VendorSpecific(attr)
		if err != nil || vendorID != _ADSLForum_VendorID {
			continue
		}
		for len(vsa) >= 3 {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				break
			}
			if vsaTyp == typ {
				return vsa[2:int(vsaLen)], true
			}
			vsa = vsa[int(vsaLen):]
		}
	}
	return
}

func _ADSLForum_SetVendor(p *radius.Packet, typ byte, attr radius.Attribute) (err error) {
	for i := 0; i < len(p.Attributes); {
		avp := p.Attributes[i]
		if avp.Type != rfc2865.VendorSpecific_Type {
			i++
			continue
		}
		vendorID, vsa, err := radius.VendorSpecific(avp.Attribute)
		if err != nil || vendorID != _ADSLForum_VendorID {
			i++
			continue
		}
		for j := 0; len(vsa[j:]) >= 3; {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa[j:]) || vsaLen < 3 {
				i++
				break
			}
			if vsaTyp == typ {
				vsa = append(vsa[:j], vsa[j+int(vsaLen):]...)
			}
			j += int(vsaLen)
		}
		if len(vsa) > 0 {
			copy(avp.Attribute[4:], vsa)
			i++
		} else {
			p.Attributes = append(p.Attributes[:i], p.Attributes[i+i:]...)
		}
	}
	return _ADSLForum_AddVendor(p, typ, attr)
}

func _ADSLForum_DelVendor(p *radius.Packet, typ byte) {
vsaLoop:
	for i := 0; i < len(p.Attributes); {
		avp := p.Attributes[i]
		if avp.Type != rfc2865.VendorSpecific_Type {
			i++
			continue
		}
		vendorID, vsa, err := radius.VendorSpecific(avp.Attribute)
		if err != nil || vendorID != _ADSLForum_VendorID {
			i++
			continue
		}
		offset := 0
		for len(vsa[offset:]) >= 3 {
			vsaTyp, vsaLen := vsa[offset], vsa[offset+1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				continue vsaLoop
			}
			if vsaTyp == typ {
				copy(vsa[offset:], vsa[offset+int(vsaLen):])
				vsa = vsa[:len(vsa)-int(vsaLen)]
			} else {
				offset += int(vsaLen)
			}
		}
		if offset == 0 {
			p.Attributes = append(p.Attributes[:i], p.Attributes[i+1:]...)
		} else {
			i++
		}
	}
	return
}

func ADSLForumDeviceManufacturerOUI_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 255, a)
}

func ADSLForumDeviceManufacturerOUI_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 255, a)
}

func ADSLForumDeviceManufacturerOUI_Get(p *radius.Packet) (value []byte) {
	value, _ = ADSLForumDeviceManufacturerOUI_Lookup(p)
	return
}

func ADSLForumDeviceManufacturerOUI_GetString(p *radius.Packet) (value string) {
	value, _ = ADSLForumDeviceManufacturerOUI_LookupString(p)
	return
}

func ADSLForumDeviceManufacturerOUI_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _ADSLForum_GetsVendor(p, 255) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ADSLForumDeviceManufacturerOUI_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _ADSLForum_GetsVendor(p, 255) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ADSLForumDeviceManufacturerOUI_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 255)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ADSLForumDeviceManufacturerOUI_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 255)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ADSLForumDeviceManufacturerOUI_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 255, a)
}

func ADSLForumDeviceManufacturerOUI_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 255, a)
}

func ADSLForumDeviceManufacturerOUI_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 255)
}

func ADSLForumDeviceSerialNumber_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 255, a)
}

func ADSLForumDeviceSerialNumber_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 255, a)
}

func ADSLForumDeviceSerialNumber_Get(p *radius.Packet) (value []byte) {
	value, _ = ADSLForumDeviceSerialNumber_Lookup(p)
	return
}

func ADSLForumDeviceSerialNumber_GetString(p *radius.Packet) (value string) {
	value, _ = ADSLForumDeviceSerialNumber_LookupString(p)
	return
}

func ADSLForumDeviceSerialNumber_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _ADSLForum_GetsVendor(p, 255) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ADSLForumDeviceSerialNumber_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _ADSLForum_GetsVendor(p, 255) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ADSLForumDeviceSerialNumber_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 255)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ADSLForumDeviceSerialNumber_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 255)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ADSLForumDeviceSerialNumber_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 255, a)
}

func ADSLForumDeviceSerialNumber_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 255, a)
}

func ADSLForumDeviceSerialNumber_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 255)
}

func ADSLForumDeviceProductClass_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 255, a)
}

func ADSLForumDeviceProductClass_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 255, a)
}

func ADSLForumDeviceProductClass_Get(p *radius.Packet) (value []byte) {
	value, _ = ADSLForumDeviceProductClass_Lookup(p)
	return
}

func ADSLForumDeviceProductClass_GetString(p *radius.Packet) (value string) {
	value, _ = ADSLForumDeviceProductClass_LookupString(p)
	return
}

func ADSLForumDeviceProductClass_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _ADSLForum_GetsVendor(p, 255) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ADSLForumDeviceProductClass_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _ADSLForum_GetsVendor(p, 255) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ADSLForumDeviceProductClass_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 255)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ADSLForumDeviceProductClass_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 255)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ADSLForumDeviceProductClass_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 255, a)
}

func ADSLForumDeviceProductClass_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 255, a)
}

func ADSLForumDeviceProductClass_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 255)
}

func ADSLForumGatewayManufacturerOUI_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 255, a)
}

func ADSLForumGatewayManufacturerOUI_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 255, a)
}

func ADSLForumGatewayManufacturerOUI_Get(p *radius.Packet) (value []byte) {
	value, _ = ADSLForumGatewayManufacturerOUI_Lookup(p)
	return
}

func ADSLForumGatewayManufacturerOUI_GetString(p *radius.Packet) (value string) {
	value, _ = ADSLForumGatewayManufacturerOUI_LookupString(p)
	return
}

func ADSLForumGatewayManufacturerOUI_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _ADSLForum_GetsVendor(p, 255) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ADSLForumGatewayManufacturerOUI_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _ADSLForum_GetsVendor(p, 255) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ADSLForumGatewayManufacturerOUI_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 255)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ADSLForumGatewayManufacturerOUI_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 255)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ADSLForumGatewayManufacturerOUI_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 255, a)
}

func ADSLForumGatewayManufacturerOUI_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 255, a)
}

func ADSLForumGatewayManufacturerOUI_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 255)
}

func ADSLAgentCircuitID_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 1, a)
}

func ADSLAgentCircuitID_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 1, a)
}

func ADSLAgentCircuitID_Get(p *radius.Packet) (value []byte) {
	value, _ = ADSLAgentCircuitID_Lookup(p)
	return
}

func ADSLAgentCircuitID_GetString(p *radius.Packet) (value string) {
	value, _ = ADSLAgentCircuitID_LookupString(p)
	return
}

func ADSLAgentCircuitID_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _ADSLForum_GetsVendor(p, 1) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ADSLAgentCircuitID_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _ADSLForum_GetsVendor(p, 1) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ADSLAgentCircuitID_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 1)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ADSLAgentCircuitID_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 1)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ADSLAgentCircuitID_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 1, a)
}

func ADSLAgentCircuitID_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 1, a)
}

func ADSLAgentCircuitID_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 1)
}

func ADSLAgentRemoteID_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 2, a)
}

func ADSLAgentRemoteID_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 2, a)
}

func ADSLAgentRemoteID_Get(p *radius.Packet) (value []byte) {
	value, _ = ADSLAgentRemoteID_Lookup(p)
	return
}

func ADSLAgentRemoteID_GetString(p *radius.Packet) (value string) {
	value, _ = ADSLAgentRemoteID_LookupString(p)
	return
}

func ADSLAgentRemoteID_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _ADSLForum_GetsVendor(p, 2) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ADSLAgentRemoteID_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _ADSLForum_GetsVendor(p, 2) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ADSLAgentRemoteID_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 2)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ADSLAgentRemoteID_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 2)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ADSLAgentRemoteID_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 2, a)
}

func ADSLAgentRemoteID_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 2, a)
}

func ADSLAgentRemoteID_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 2)
}

type ActualDataRateUpstream uint32

var ActualDataRateUpstream_Strings = map[ActualDataRateUpstream]string{}

func (a ActualDataRateUpstream) String() string {
	if str, ok := ActualDataRateUpstream_Strings[a]; ok {
		return str
	}
	return "ActualDataRateUpstream(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ActualDataRateUpstream_Add(p *radius.Packet, value ActualDataRateUpstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_AddVendor(p, 129, a)
}

func ActualDataRateUpstream_Get(p *radius.Packet) (value ActualDataRateUpstream) {
	value, _ = ActualDataRateUpstream_Lookup(p)
	return
}

func ActualDataRateUpstream_Gets(p *radius.Packet) (values []ActualDataRateUpstream, err error) {
	var i uint32
	for _, attr := range _ADSLForum_GetsVendor(p, 129) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ActualDataRateUpstream(i))
	}
	return
}

func ActualDataRateUpstream_Lookup(p *radius.Packet) (value ActualDataRateUpstream, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 129)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ActualDataRateUpstream(i)
	return
}

func ActualDataRateUpstream_Set(p *radius.Packet, value ActualDataRateUpstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_SetVendor(p, 129, a)
}

func ActualDataRateUpstream_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 129)
}

type ActualDataRateDownstream uint32

var ActualDataRateDownstream_Strings = map[ActualDataRateDownstream]string{}

func (a ActualDataRateDownstream) String() string {
	if str, ok := ActualDataRateDownstream_Strings[a]; ok {
		return str
	}
	return "ActualDataRateDownstream(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ActualDataRateDownstream_Add(p *radius.Packet, value ActualDataRateDownstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_AddVendor(p, 130, a)
}

func ActualDataRateDownstream_Get(p *radius.Packet) (value ActualDataRateDownstream) {
	value, _ = ActualDataRateDownstream_Lookup(p)
	return
}

func ActualDataRateDownstream_Gets(p *radius.Packet) (values []ActualDataRateDownstream, err error) {
	var i uint32
	for _, attr := range _ADSLForum_GetsVendor(p, 130) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ActualDataRateDownstream(i))
	}
	return
}

func ActualDataRateDownstream_Lookup(p *radius.Packet) (value ActualDataRateDownstream, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 130)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ActualDataRateDownstream(i)
	return
}

func ActualDataRateDownstream_Set(p *radius.Packet, value ActualDataRateDownstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_SetVendor(p, 130, a)
}

func ActualDataRateDownstream_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 130)
}

type MinimumDataRateUpstream uint32

var MinimumDataRateUpstream_Strings = map[MinimumDataRateUpstream]string{}

func (a MinimumDataRateUpstream) String() string {
	if str, ok := MinimumDataRateUpstream_Strings[a]; ok {
		return str
	}
	return "MinimumDataRateUpstream(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MinimumDataRateUpstream_Add(p *radius.Packet, value MinimumDataRateUpstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_AddVendor(p, 131, a)
}

func MinimumDataRateUpstream_Get(p *radius.Packet) (value MinimumDataRateUpstream) {
	value, _ = MinimumDataRateUpstream_Lookup(p)
	return
}

func MinimumDataRateUpstream_Gets(p *radius.Packet) (values []MinimumDataRateUpstream, err error) {
	var i uint32
	for _, attr := range _ADSLForum_GetsVendor(p, 131) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MinimumDataRateUpstream(i))
	}
	return
}

func MinimumDataRateUpstream_Lookup(p *radius.Packet) (value MinimumDataRateUpstream, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 131)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MinimumDataRateUpstream(i)
	return
}

func MinimumDataRateUpstream_Set(p *radius.Packet, value MinimumDataRateUpstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_SetVendor(p, 131, a)
}

func MinimumDataRateUpstream_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 131)
}

type MinimumDataRateDownstream uint32

var MinimumDataRateDownstream_Strings = map[MinimumDataRateDownstream]string{}

func (a MinimumDataRateDownstream) String() string {
	if str, ok := MinimumDataRateDownstream_Strings[a]; ok {
		return str
	}
	return "MinimumDataRateDownstream(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MinimumDataRateDownstream_Add(p *radius.Packet, value MinimumDataRateDownstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_AddVendor(p, 132, a)
}

func MinimumDataRateDownstream_Get(p *radius.Packet) (value MinimumDataRateDownstream) {
	value, _ = MinimumDataRateDownstream_Lookup(p)
	return
}

func MinimumDataRateDownstream_Gets(p *radius.Packet) (values []MinimumDataRateDownstream, err error) {
	var i uint32
	for _, attr := range _ADSLForum_GetsVendor(p, 132) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MinimumDataRateDownstream(i))
	}
	return
}

func MinimumDataRateDownstream_Lookup(p *radius.Packet) (value MinimumDataRateDownstream, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 132)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MinimumDataRateDownstream(i)
	return
}

func MinimumDataRateDownstream_Set(p *radius.Packet, value MinimumDataRateDownstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_SetVendor(p, 132, a)
}

func MinimumDataRateDownstream_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 132)
}

type AttainableDataRateUpstream uint32

var AttainableDataRateUpstream_Strings = map[AttainableDataRateUpstream]string{}

func (a AttainableDataRateUpstream) String() string {
	if str, ok := AttainableDataRateUpstream_Strings[a]; ok {
		return str
	}
	return "AttainableDataRateUpstream(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func AttainableDataRateUpstream_Add(p *radius.Packet, value AttainableDataRateUpstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_AddVendor(p, 133, a)
}

func AttainableDataRateUpstream_Get(p *radius.Packet) (value AttainableDataRateUpstream) {
	value, _ = AttainableDataRateUpstream_Lookup(p)
	return
}

func AttainableDataRateUpstream_Gets(p *radius.Packet) (values []AttainableDataRateUpstream, err error) {
	var i uint32
	for _, attr := range _ADSLForum_GetsVendor(p, 133) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, AttainableDataRateUpstream(i))
	}
	return
}

func AttainableDataRateUpstream_Lookup(p *radius.Packet) (value AttainableDataRateUpstream, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 133)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = AttainableDataRateUpstream(i)
	return
}

func AttainableDataRateUpstream_Set(p *radius.Packet, value AttainableDataRateUpstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_SetVendor(p, 133, a)
}

func AttainableDataRateUpstream_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 133)
}

type AttainableDataRateDownstream uint32

var AttainableDataRateDownstream_Strings = map[AttainableDataRateDownstream]string{}

func (a AttainableDataRateDownstream) String() string {
	if str, ok := AttainableDataRateDownstream_Strings[a]; ok {
		return str
	}
	return "AttainableDataRateDownstream(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func AttainableDataRateDownstream_Add(p *radius.Packet, value AttainableDataRateDownstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_AddVendor(p, 134, a)
}

func AttainableDataRateDownstream_Get(p *radius.Packet) (value AttainableDataRateDownstream) {
	value, _ = AttainableDataRateDownstream_Lookup(p)
	return
}

func AttainableDataRateDownstream_Gets(p *radius.Packet) (values []AttainableDataRateDownstream, err error) {
	var i uint32
	for _, attr := range _ADSLForum_GetsVendor(p, 134) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, AttainableDataRateDownstream(i))
	}
	return
}

func AttainableDataRateDownstream_Lookup(p *radius.Packet) (value AttainableDataRateDownstream, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 134)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = AttainableDataRateDownstream(i)
	return
}

func AttainableDataRateDownstream_Set(p *radius.Packet, value AttainableDataRateDownstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_SetVendor(p, 134, a)
}

func AttainableDataRateDownstream_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 134)
}

type MaximumDataRateUpstream uint32

var MaximumDataRateUpstream_Strings = map[MaximumDataRateUpstream]string{}

func (a MaximumDataRateUpstream) String() string {
	if str, ok := MaximumDataRateUpstream_Strings[a]; ok {
		return str
	}
	return "MaximumDataRateUpstream(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MaximumDataRateUpstream_Add(p *radius.Packet, value MaximumDataRateUpstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_AddVendor(p, 135, a)
}

func MaximumDataRateUpstream_Get(p *radius.Packet) (value MaximumDataRateUpstream) {
	value, _ = MaximumDataRateUpstream_Lookup(p)
	return
}

func MaximumDataRateUpstream_Gets(p *radius.Packet) (values []MaximumDataRateUpstream, err error) {
	var i uint32
	for _, attr := range _ADSLForum_GetsVendor(p, 135) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MaximumDataRateUpstream(i))
	}
	return
}

func MaximumDataRateUpstream_Lookup(p *radius.Packet) (value MaximumDataRateUpstream, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 135)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MaximumDataRateUpstream(i)
	return
}

func MaximumDataRateUpstream_Set(p *radius.Packet, value MaximumDataRateUpstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_SetVendor(p, 135, a)
}

func MaximumDataRateUpstream_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 135)
}

type MaximumDataRateDownstream uint32

var MaximumDataRateDownstream_Strings = map[MaximumDataRateDownstream]string{}

func (a MaximumDataRateDownstream) String() string {
	if str, ok := MaximumDataRateDownstream_Strings[a]; ok {
		return str
	}
	return "MaximumDataRateDownstream(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MaximumDataRateDownstream_Add(p *radius.Packet, value MaximumDataRateDownstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_AddVendor(p, 136, a)
}

func MaximumDataRateDownstream_Get(p *radius.Packet) (value MaximumDataRateDownstream) {
	value, _ = MaximumDataRateDownstream_Lookup(p)
	return
}

func MaximumDataRateDownstream_Gets(p *radius.Packet) (values []MaximumDataRateDownstream, err error) {
	var i uint32
	for _, attr := range _ADSLForum_GetsVendor(p, 136) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MaximumDataRateDownstream(i))
	}
	return
}

func MaximumDataRateDownstream_Lookup(p *radius.Packet) (value MaximumDataRateDownstream, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 136)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MaximumDataRateDownstream(i)
	return
}

func MaximumDataRateDownstream_Set(p *radius.Packet, value MaximumDataRateDownstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_SetVendor(p, 136, a)
}

func MaximumDataRateDownstream_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 136)
}

type MinimumDataRateUpstreamLowPower uint32

var MinimumDataRateUpstreamLowPower_Strings = map[MinimumDataRateUpstreamLowPower]string{}

func (a MinimumDataRateUpstreamLowPower) String() string {
	if str, ok := MinimumDataRateUpstreamLowPower_Strings[a]; ok {
		return str
	}
	return "MinimumDataRateUpstreamLowPower(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MinimumDataRateUpstreamLowPower_Add(p *radius.Packet, value MinimumDataRateUpstreamLowPower) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_AddVendor(p, 137, a)
}

func MinimumDataRateUpstreamLowPower_Get(p *radius.Packet) (value MinimumDataRateUpstreamLowPower) {
	value, _ = MinimumDataRateUpstreamLowPower_Lookup(p)
	return
}

func MinimumDataRateUpstreamLowPower_Gets(p *radius.Packet) (values []MinimumDataRateUpstreamLowPower, err error) {
	var i uint32
	for _, attr := range _ADSLForum_GetsVendor(p, 137) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MinimumDataRateUpstreamLowPower(i))
	}
	return
}

func MinimumDataRateUpstreamLowPower_Lookup(p *radius.Packet) (value MinimumDataRateUpstreamLowPower, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 137)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MinimumDataRateUpstreamLowPower(i)
	return
}

func MinimumDataRateUpstreamLowPower_Set(p *radius.Packet, value MinimumDataRateUpstreamLowPower) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_SetVendor(p, 137, a)
}

func MinimumDataRateUpstreamLowPower_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 137)
}

type MinimumDataRateDownstreamLowPower uint32

var MinimumDataRateDownstreamLowPower_Strings = map[MinimumDataRateDownstreamLowPower]string{}

func (a MinimumDataRateDownstreamLowPower) String() string {
	if str, ok := MinimumDataRateDownstreamLowPower_Strings[a]; ok {
		return str
	}
	return "MinimumDataRateDownstreamLowPower(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MinimumDataRateDownstreamLowPower_Add(p *radius.Packet, value MinimumDataRateDownstreamLowPower) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_AddVendor(p, 138, a)
}

func MinimumDataRateDownstreamLowPower_Get(p *radius.Packet) (value MinimumDataRateDownstreamLowPower) {
	value, _ = MinimumDataRateDownstreamLowPower_Lookup(p)
	return
}

func MinimumDataRateDownstreamLowPower_Gets(p *radius.Packet) (values []MinimumDataRateDownstreamLowPower, err error) {
	var i uint32
	for _, attr := range _ADSLForum_GetsVendor(p, 138) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MinimumDataRateDownstreamLowPower(i))
	}
	return
}

func MinimumDataRateDownstreamLowPower_Lookup(p *radius.Packet) (value MinimumDataRateDownstreamLowPower, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 138)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MinimumDataRateDownstreamLowPower(i)
	return
}

func MinimumDataRateDownstreamLowPower_Set(p *radius.Packet, value MinimumDataRateDownstreamLowPower) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_SetVendor(p, 138, a)
}

func MinimumDataRateDownstreamLowPower_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 138)
}

type MaximumInterleavingDelayUpstream uint32

var MaximumInterleavingDelayUpstream_Strings = map[MaximumInterleavingDelayUpstream]string{}

func (a MaximumInterleavingDelayUpstream) String() string {
	if str, ok := MaximumInterleavingDelayUpstream_Strings[a]; ok {
		return str
	}
	return "MaximumInterleavingDelayUpstream(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MaximumInterleavingDelayUpstream_Add(p *radius.Packet, value MaximumInterleavingDelayUpstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_AddVendor(p, 139, a)
}

func MaximumInterleavingDelayUpstream_Get(p *radius.Packet) (value MaximumInterleavingDelayUpstream) {
	value, _ = MaximumInterleavingDelayUpstream_Lookup(p)
	return
}

func MaximumInterleavingDelayUpstream_Gets(p *radius.Packet) (values []MaximumInterleavingDelayUpstream, err error) {
	var i uint32
	for _, attr := range _ADSLForum_GetsVendor(p, 139) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MaximumInterleavingDelayUpstream(i))
	}
	return
}

func MaximumInterleavingDelayUpstream_Lookup(p *radius.Packet) (value MaximumInterleavingDelayUpstream, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 139)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MaximumInterleavingDelayUpstream(i)
	return
}

func MaximumInterleavingDelayUpstream_Set(p *radius.Packet, value MaximumInterleavingDelayUpstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_SetVendor(p, 139, a)
}

func MaximumInterleavingDelayUpstream_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 139)
}

type ActualInterleavingDelayUpstream uint32

var ActualInterleavingDelayUpstream_Strings = map[ActualInterleavingDelayUpstream]string{}

func (a ActualInterleavingDelayUpstream) String() string {
	if str, ok := ActualInterleavingDelayUpstream_Strings[a]; ok {
		return str
	}
	return "ActualInterleavingDelayUpstream(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ActualInterleavingDelayUpstream_Add(p *radius.Packet, value ActualInterleavingDelayUpstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_AddVendor(p, 140, a)
}

func ActualInterleavingDelayUpstream_Get(p *radius.Packet) (value ActualInterleavingDelayUpstream) {
	value, _ = ActualInterleavingDelayUpstream_Lookup(p)
	return
}

func ActualInterleavingDelayUpstream_Gets(p *radius.Packet) (values []ActualInterleavingDelayUpstream, err error) {
	var i uint32
	for _, attr := range _ADSLForum_GetsVendor(p, 140) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ActualInterleavingDelayUpstream(i))
	}
	return
}

func ActualInterleavingDelayUpstream_Lookup(p *radius.Packet) (value ActualInterleavingDelayUpstream, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 140)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ActualInterleavingDelayUpstream(i)
	return
}

func ActualInterleavingDelayUpstream_Set(p *radius.Packet, value ActualInterleavingDelayUpstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_SetVendor(p, 140, a)
}

func ActualInterleavingDelayUpstream_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 140)
}

type MaximumInterleavingDelayDownstream uint32

var MaximumInterleavingDelayDownstream_Strings = map[MaximumInterleavingDelayDownstream]string{}

func (a MaximumInterleavingDelayDownstream) String() string {
	if str, ok := MaximumInterleavingDelayDownstream_Strings[a]; ok {
		return str
	}
	return "MaximumInterleavingDelayDownstream(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MaximumInterleavingDelayDownstream_Add(p *radius.Packet, value MaximumInterleavingDelayDownstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_AddVendor(p, 141, a)
}

func MaximumInterleavingDelayDownstream_Get(p *radius.Packet) (value MaximumInterleavingDelayDownstream) {
	value, _ = MaximumInterleavingDelayDownstream_Lookup(p)
	return
}

func MaximumInterleavingDelayDownstream_Gets(p *radius.Packet) (values []MaximumInterleavingDelayDownstream, err error) {
	var i uint32
	for _, attr := range _ADSLForum_GetsVendor(p, 141) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MaximumInterleavingDelayDownstream(i))
	}
	return
}

func MaximumInterleavingDelayDownstream_Lookup(p *radius.Packet) (value MaximumInterleavingDelayDownstream, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 141)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MaximumInterleavingDelayDownstream(i)
	return
}

func MaximumInterleavingDelayDownstream_Set(p *radius.Packet, value MaximumInterleavingDelayDownstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_SetVendor(p, 141, a)
}

func MaximumInterleavingDelayDownstream_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 141)
}

type ActualInterleavingDelayDownstream uint32

var ActualInterleavingDelayDownstream_Strings = map[ActualInterleavingDelayDownstream]string{}

func (a ActualInterleavingDelayDownstream) String() string {
	if str, ok := ActualInterleavingDelayDownstream_Strings[a]; ok {
		return str
	}
	return "ActualInterleavingDelayDownstream(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ActualInterleavingDelayDownstream_Add(p *radius.Packet, value ActualInterleavingDelayDownstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_AddVendor(p, 142, a)
}

func ActualInterleavingDelayDownstream_Get(p *radius.Packet) (value ActualInterleavingDelayDownstream) {
	value, _ = ActualInterleavingDelayDownstream_Lookup(p)
	return
}

func ActualInterleavingDelayDownstream_Gets(p *radius.Packet) (values []ActualInterleavingDelayDownstream, err error) {
	var i uint32
	for _, attr := range _ADSLForum_GetsVendor(p, 142) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ActualInterleavingDelayDownstream(i))
	}
	return
}

func ActualInterleavingDelayDownstream_Lookup(p *radius.Packet) (value ActualInterleavingDelayDownstream, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 142)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ActualInterleavingDelayDownstream(i)
	return
}

func ActualInterleavingDelayDownstream_Set(p *radius.Packet, value ActualInterleavingDelayDownstream) (err error) {
	a := radius.NewInteger(uint32(value))
	return _ADSLForum_SetVendor(p, 142, a)
}

func ActualInterleavingDelayDownstream_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 142)
}

func AccessLoopEncapsulation_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 144, a)
}

func AccessLoopEncapsulation_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 144, a)
}

func AccessLoopEncapsulation_Get(p *radius.Packet) (value []byte) {
	value, _ = AccessLoopEncapsulation_Lookup(p)
	return
}

func AccessLoopEncapsulation_GetString(p *radius.Packet) (value string) {
	value, _ = AccessLoopEncapsulation_LookupString(p)
	return
}

func AccessLoopEncapsulation_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _ADSLForum_GetsVendor(p, 144) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func AccessLoopEncapsulation_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _ADSLForum_GetsVendor(p, 144) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func AccessLoopEncapsulation_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 144)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func AccessLoopEncapsulation_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 144)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func AccessLoopEncapsulation_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 144, a)
}

func AccessLoopEncapsulation_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 144, a)
}

func AccessLoopEncapsulation_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 144)
}

func IWFSession_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 254, a)
}

func IWFSession_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_AddVendor(p, 254, a)
}

func IWFSession_Get(p *radius.Packet) (value []byte) {
	value, _ = IWFSession_Lookup(p)
	return
}

func IWFSession_GetString(p *radius.Packet) (value string) {
	value, _ = IWFSession_LookupString(p)
	return
}

func IWFSession_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _ADSLForum_GetsVendor(p, 254) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func IWFSession_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _ADSLForum_GetsVendor(p, 254) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func IWFSession_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 254)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func IWFSession_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _ADSLForum_LookupVendor(p, 254)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func IWFSession_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 254, a)
}

func IWFSession_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _ADSLForum_SetVendor(p, 254, a)
}

func IWFSession_Del(p *radius.Packet) {
	_ADSLForum_DelVendor(p, 254)
}
