/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha2

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	apisv1alpha2 "sigs.k8s.io/gateway-api/apis/applyconfiguration/apis/v1alpha2"
	v1alpha2 "sigs.k8s.io/gateway-api/apis/v1alpha2"
	scheme "sigs.k8s.io/gateway-api/pkg/client/clientset/versioned/scheme"
)

// TLSRoutesGetter has a method to return a TLSRouteInterface.
// A group's client should implement this interface.
type TLSRoutesGetter interface {
	TLSRoutes(namespace string) TLSRouteInterface
}

// TLSRouteInterface has methods to work with TLSRoute resources.
type TLSRouteInterface interface {
	Create(ctx context.Context, tLSRoute *v1alpha2.TLSRoute, opts v1.CreateOptions) (*v1alpha2.TLSRoute, error)
	Update(ctx context.Context, tLSRoute *v1alpha2.TLSRoute, opts v1.UpdateOptions) (*v1alpha2.TLSRoute, error)
	UpdateStatus(ctx context.Context, tLSRoute *v1alpha2.TLSRoute, opts v1.UpdateOptions) (*v1alpha2.TLSRoute, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha2.TLSRoute, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha2.TLSRouteList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.TLSRoute, err error)
	Apply(ctx context.Context, tLSRoute *apisv1alpha2.TLSRouteApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha2.TLSRoute, err error)
	ApplyStatus(ctx context.Context, tLSRoute *apisv1alpha2.TLSRouteApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha2.TLSRoute, err error)
	TLSRouteExpansion
}

// tLSRoutes implements TLSRouteInterface
type tLSRoutes struct {
	client rest.Interface
	ns     string
}

// newTLSRoutes returns a TLSRoutes
func newTLSRoutes(c *GatewayV1alpha2Client, namespace string) *tLSRoutes {
	return &tLSRoutes{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the tLSRoute, and returns the corresponding tLSRoute object, and an error if there is any.
func (c *tLSRoutes) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha2.TLSRoute, err error) {
	result = &v1alpha2.TLSRoute{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tlsroutes").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TLSRoutes that match those selectors.
func (c *tLSRoutes) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha2.TLSRouteList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha2.TLSRouteList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tlsroutes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tLSRoutes.
func (c *tLSRoutes) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("tlsroutes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tLSRoute and creates it.  Returns the server's representation of the tLSRoute, and an error, if there is any.
func (c *tLSRoutes) Create(ctx context.Context, tLSRoute *v1alpha2.TLSRoute, opts v1.CreateOptions) (result *v1alpha2.TLSRoute, err error) {
	result = &v1alpha2.TLSRoute{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("tlsroutes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tLSRoute).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tLSRoute and updates it. Returns the server's representation of the tLSRoute, and an error, if there is any.
func (c *tLSRoutes) Update(ctx context.Context, tLSRoute *v1alpha2.TLSRoute, opts v1.UpdateOptions) (result *v1alpha2.TLSRoute, err error) {
	result = &v1alpha2.TLSRoute{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tlsroutes").
		Name(tLSRoute.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tLSRoute).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *tLSRoutes) UpdateStatus(ctx context.Context, tLSRoute *v1alpha2.TLSRoute, opts v1.UpdateOptions) (result *v1alpha2.TLSRoute, err error) {
	result = &v1alpha2.TLSRoute{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tlsroutes").
		Name(tLSRoute.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tLSRoute).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tLSRoute and deletes it. Returns an error if one occurs.
func (c *tLSRoutes) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tlsroutes").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tLSRoutes) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tlsroutes").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tLSRoute.
func (c *tLSRoutes) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.TLSRoute, err error) {
	result = &v1alpha2.TLSRoute{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("tlsroutes").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied tLSRoute.
func (c *tLSRoutes) Apply(ctx context.Context, tLSRoute *apisv1alpha2.TLSRouteApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha2.TLSRoute, err error) {
	if tLSRoute == nil {
		return nil, fmt.Errorf("tLSRoute provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(tLSRoute)
	if err != nil {
		return nil, err
	}
	name := tLSRoute.Name
	if name == nil {
		return nil, fmt.Errorf("tLSRoute.Name must be provided to Apply")
	}
	result = &v1alpha2.TLSRoute{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("tlsroutes").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *tLSRoutes) ApplyStatus(ctx context.Context, tLSRoute *apisv1alpha2.TLSRouteApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha2.TLSRoute, err error) {
	if tLSRoute == nil {
		return nil, fmt.Errorf("tLSRoute provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(tLSRoute)
	if err != nil {
		return nil, err
	}

	name := tLSRoute.Name
	if name == nil {
		return nil, fmt.Errorf("tLSRoute.Name must be provided to Apply")
	}

	result = &v1alpha2.TLSRoute{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("tlsroutes").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
