package filesystemapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/datalake/store/2016-11-01/filesystem"
	"github.com/Azure/go-autorest/autorest"
	"github.com/gofrs/uuid"
	"io"
)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	Append(ctx context.Context, accountName string, pathParameter string, streamContents io.ReadCloser, offset *int64, syncFlag filesystem.SyncFlag, leaseID *uuid.UUID, fileSessionID *uuid.UUID) (result autorest.Response, err error)
	CheckAccess(ctx context.Context, accountName string, pathParameter string, fsaction string) (result autorest.Response, err error)
	Concat(ctx context.Context, accountName string, pathParameter string, sources []string) (result autorest.Response, err error)
	ConcurrentAppend(ctx context.Context, accountName string, pathParameter string, streamContents io.ReadCloser, appendMode filesystem.AppendModeType, syncFlag filesystem.SyncFlag) (result autorest.Response, err error)
	Create(ctx context.Context, accountName string, pathParameter string, streamContents io.ReadCloser, overwrite *bool, syncFlag filesystem.SyncFlag, leaseID *uuid.UUID, permission *int32) (result autorest.Response, err error)
	Delete(ctx context.Context, accountName string, pathParameter string, recursive *bool) (result filesystem.FileOperationResult, err error)
	GetACLStatus(ctx context.Context, accountName string, pathParameter string, tooID *bool) (result filesystem.ACLStatusResult, err error)
	GetContentSummary(ctx context.Context, accountName string, pathParameter string) (result filesystem.ContentSummaryResult, err error)
	GetFileStatus(ctx context.Context, accountName string, pathParameter string, tooID *bool) (result filesystem.FileStatusResult, err error)
	ListFileStatus(ctx context.Context, accountName string, pathParameter string, listSize *int32, listAfter string, listBefore string, tooID *bool) (result filesystem.FileStatusesResult, err error)
	Mkdirs(ctx context.Context, accountName string, pathParameter string, permission *int32) (result filesystem.FileOperationResult, err error)
	ModifyACLEntries(ctx context.Context, accountName string, pathParameter string, aclspec string) (result autorest.Response, err error)
	MsConcat(ctx context.Context, accountName string, pathParameter string, streamContents io.ReadCloser, deleteSourceDirectory *bool) (result autorest.Response, err error)
	Open(ctx context.Context, accountName string, pathParameter string, length *int64, offset *int64, fileSessionID *uuid.UUID) (result filesystem.ReadCloser, err error)
	RemoveACL(ctx context.Context, accountName string, pathParameter string) (result autorest.Response, err error)
	RemoveACLEntries(ctx context.Context, accountName string, pathParameter string, aclspec string) (result autorest.Response, err error)
	RemoveDefaultACL(ctx context.Context, accountName string, pathParameter string) (result autorest.Response, err error)
	Rename(ctx context.Context, accountName string, pathParameter string, destination string) (result filesystem.FileOperationResult, err error)
	SetACL(ctx context.Context, accountName string, pathParameter string, aclspec string) (result autorest.Response, err error)
	SetFileExpiry(ctx context.Context, accountName string, pathParameter string, expiryOption filesystem.ExpiryOptionType, expireTime *int64) (result autorest.Response, err error)
	SetOwner(ctx context.Context, accountName string, pathParameter string, owner string, group string) (result autorest.Response, err error)
	SetPermission(ctx context.Context, accountName string, pathParameter string, permission string) (result autorest.Response, err error)
}

var _ ClientAPI = (*filesystem.Client)(nil)
