package insightsapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/monitor/mgmt/2020-10-01/insights"
	"github.com/Azure/go-autorest/autorest"
)

// ActivityLogAlertsClientAPI contains the set of methods on the ActivityLogAlertsClient type.
type ActivityLogAlertsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, activityLogAlertName string, activityLogAlertRule insights.ActivityLogAlertResource) (result insights.ActivityLogAlertResource, err error)
	Delete(ctx context.Context, resourceGroupName string, activityLogAlertName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, activityLogAlertName string) (result insights.ActivityLogAlertResource, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result insights.AlertRuleListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result insights.AlertRuleListIterator, err error)
	ListBySubscriptionID(ctx context.Context) (result insights.AlertRuleListPage, err error)
	ListBySubscriptionIDComplete(ctx context.Context) (result insights.AlertRuleListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, activityLogAlertName string, activityLogAlertRulePatch insights.AlertRulePatchObject) (result insights.ActivityLogAlertResource, err error)
}

var _ ActivityLogAlertsClientAPI = (*insights.ActivityLogAlertsClient)(nil)
