package operationalinsights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/operationalinsights/mgmt/2020-10-01/operationalinsights"

// AssociatedWorkspace the list of Log Analytics workspaces associated with the cluster.
type AssociatedWorkspace struct {
	// WorkspaceID - READ-ONLY; The id of the assigned workspace.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// WorkspaceName - READ-ONLY; The name id the assigned workspace.
	WorkspaceName *string `json:"workspaceName,omitempty"`
	// ResourceID - READ-ONLY; The ResourceId id the assigned workspace.
	ResourceID *string `json:"resourceId,omitempty"`
	// AssociateDate - READ-ONLY; The time of workspace association.
	AssociateDate *string `json:"associateDate,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// CapacityReservationProperties the Capacity Reservation properties.
type CapacityReservationProperties struct {
	// LastSkuUpdate - READ-ONLY; The last time Sku was updated.
	LastSkuUpdate *string `json:"lastSkuUpdate,omitempty"`
	// MinCapacity - READ-ONLY; Minimum CapacityReservation value in GB.
	MinCapacity *int64 `json:"minCapacity,omitempty"`
	// MaxCapacity - READ-ONLY; Maximum CapacityReservation value in GB.
	MaxCapacity *int64 `json:"maxCapacity,omitempty"`
}

// Cluster the top level Log Analytics cluster resource container.
type Cluster struct {
	autorest.Response `json:"-"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Sku - The sku properties.
	Sku *ClusterSku `json:"sku,omitempty"`
	// ClusterProperties - Log Analytics cluster properties.
	*ClusterProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Identity != nil {
		objectMap["identity"] = c.Identity
	}
	if c.Sku != nil {
		objectMap["sku"] = c.Sku
	}
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				c.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku ClusterSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				c.Sku = &sku
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ClusterListResult the list clusters operation response.
type ClusterListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of recommendations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - A list of Log Analytics clusters.
	Value *[]Cluster `json:"value,omitempty"`
}

// ClusterListResultIterator provides access to a complete listing of Cluster values.
type ClusterListResultIterator struct {
	i    int
	page ClusterListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListResultIterator) Response() ClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListResultIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterListResultIterator type.
func NewClusterListResultIterator(page ClusterListResultPage) ClusterListResultIterator {
	return ClusterListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr ClusterListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr ClusterListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// clusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr ClusterListResult) clusterListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// ClusterListResultPage contains a page of Cluster values.
type ClusterListResultPage struct {
	fn  func(context.Context, ClusterListResult) (ClusterListResult, error)
	clr ClusterListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListResultPage) Response() ClusterListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListResultPage) Values() []Cluster {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the ClusterListResultPage type.
func NewClusterListResultPage(cur ClusterListResult, getNextPage func(context.Context, ClusterListResult) (ClusterListResult, error)) ClusterListResultPage {
	return ClusterListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// ClusterPatch the top level Log Analytics cluster resource container.
type ClusterPatch struct {
	// ClusterPatchProperties - Log Analytics cluster properties.
	*ClusterPatchProperties `json:"properties,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Sku - The sku properties.
	Sku *ClusterSku `json:"sku,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ClusterPatch.
func (cp ClusterPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.ClusterPatchProperties != nil {
		objectMap["properties"] = cp.ClusterPatchProperties
	}
	if cp.Identity != nil {
		objectMap["identity"] = cp.Identity
	}
	if cp.Sku != nil {
		objectMap["sku"] = cp.Sku
	}
	if cp.Tags != nil {
		objectMap["tags"] = cp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterPatch struct.
func (cp *ClusterPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterPatchProperties ClusterPatchProperties
				err = json.Unmarshal(*v, &clusterPatchProperties)
				if err != nil {
					return err
				}
				cp.ClusterPatchProperties = &clusterPatchProperties
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				cp.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku ClusterSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				cp.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cp.Tags = tags
			}
		}
	}

	return nil
}

// ClusterPatchProperties log Analytics cluster patch properties.
type ClusterPatchProperties struct {
	// KeyVaultProperties - The associated key properties.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
}

// ClusterProperties cluster properties.
type ClusterProperties struct {
	// ClusterID - READ-ONLY; The ID associated with the cluster.
	ClusterID *string `json:"clusterId,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the cluster. Possible values include: 'Creating', 'Succeeded', 'Failed', 'Canceled', 'Deleting', 'ProvisioningAccount', 'Updating'
	ProvisioningState ClusterEntityStatus `json:"provisioningState,omitempty"`
	// IsDoubleEncryptionEnabled - Configures whether cluster will use double encryption. This Property can not be modified after cluster creation. Default value is 'true'
	IsDoubleEncryptionEnabled *bool `json:"isDoubleEncryptionEnabled,omitempty"`
	// IsAvailabilityZonesEnabled - Sets whether the cluster will support availability zones. This can be set as true only in regions where Azure Data Explorer support Availability Zones. This Property can not be modified after cluster creation. Default value is 'true' if region supports Availability Zones.
	IsAvailabilityZonesEnabled *bool `json:"isAvailabilityZonesEnabled,omitempty"`
	// BillingType - Configures whether billing will be only on the cluster or each workspace will be billed by its proportional use. This does not change the overall billing, only how it will be distributed. Default value is 'Cluster'. Possible values include: 'BillingTypeCluster', 'BillingTypeWorkspaces'
	BillingType BillingType `json:"billingType,omitempty"`
	// KeyVaultProperties - The associated key properties.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
	// LastModifiedDate - READ-ONLY; The last time the cluster was updated.
	LastModifiedDate *string `json:"lastModifiedDate,omitempty"`
	// CreatedDate - READ-ONLY; The cluster creation time
	CreatedDate *string `json:"createdDate,omitempty"`
	// AssociatedWorkspaces - The list of Log Analytics workspaces associated with the cluster
	AssociatedWorkspaces *[]AssociatedWorkspace `json:"associatedWorkspaces,omitempty"`
	// CapacityReservationProperties - Additional properties for capacity reservation
	CapacityReservationProperties *CapacityReservationProperties `json:"capacityReservationProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterProperties.
func (cp ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.IsDoubleEncryptionEnabled != nil {
		objectMap["isDoubleEncryptionEnabled"] = cp.IsDoubleEncryptionEnabled
	}
	if cp.IsAvailabilityZonesEnabled != nil {
		objectMap["isAvailabilityZonesEnabled"] = cp.IsAvailabilityZonesEnabled
	}
	if cp.BillingType != "" {
		objectMap["billingType"] = cp.BillingType
	}
	if cp.KeyVaultProperties != nil {
		objectMap["keyVaultProperties"] = cp.KeyVaultProperties
	}
	if cp.AssociatedWorkspaces != nil {
		objectMap["associatedWorkspaces"] = cp.AssociatedWorkspaces
	}
	if cp.CapacityReservationProperties != nil {
		objectMap["capacityReservationProperties"] = cp.CapacityReservationProperties
	}
	return json.Marshal(objectMap)
}

// ClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// ClusterSku the cluster sku definition.
type ClusterSku struct {
	// Capacity - The capacity value
	Capacity *int64 `json:"capacity,omitempty"`
	// Name - The name of the SKU. Possible values include: 'CapacityReservation'
	Name ClusterSkuNameEnum `json:"name,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. Possible values include: 'SystemAssigned', 'UserAssigned', 'None'
	Type IdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserIdentityProperties `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	if i.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = i.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// KeyVaultProperties the key vault properties.
type KeyVaultProperties struct {
	// KeyVaultURI - The Key Vault uri which holds they key associated with the Log Analytics cluster.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`
	// KeyName - The name of the key associated with the Log Analytics cluster.
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - The version of the key associated with the Log Analytics cluster.
	KeyVersion *string `json:"keyVersion,omitempty"`
	// KeyRsaSize - Selected key minimum required size.
	KeyRsaSize *int32 `json:"keyRsaSize,omitempty"`
}

// Operation supported operation of OperationalInsights resource provider.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft OperationsManagement.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of operation
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list solution operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of solution operations supported by the OperationsManagement resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if olr.Value != nil {
		objectMap["value"] = olr.Value
	}
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// PrivateLinkScopedResource the private link scope resource reference.
type PrivateLinkScopedResource struct {
	// ResourceID - The full resource Id of the private link scope resource.
	ResourceID *string `json:"resourceId,omitempty"`
	// ScopeID - The private link scope unique Identifier.
	ScopeID *string `json:"scopeId,omitempty"`
}

// ProxyResource the resource model definition for an Azure Resource Manager proxy resource. It will have
// everything other than required location and tags
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UserIdentityProperties user assigned identity properties.
type UserIdentityProperties struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// Workspace the top level Workspace resource container.
type Workspace struct {
	autorest.Response `json:"-"`
	// WorkspaceProperties - Workspace properties.
	*WorkspaceProperties `json:"properties,omitempty"`
	// ETag - The ETag of the workspace.
	ETag *string `json:"eTag,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkspaceProperties != nil {
		objectMap["properties"] = w.WorkspaceProperties
	}
	if w.ETag != nil {
		objectMap["eTag"] = w.ETag
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				w.WorkspaceProperties = &workspaceProperties
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				w.ETag = &eTag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkspaceCapping the daily volume cap for ingestion.
type WorkspaceCapping struct {
	// DailyQuotaGb - The workspace daily quota for ingestion.
	DailyQuotaGb *float64 `json:"dailyQuotaGb,omitempty"`
	// QuotaNextResetTime - READ-ONLY; The time when the quota will be rest.
	QuotaNextResetTime *string `json:"quotaNextResetTime,omitempty"`
	// DataIngestionStatus - READ-ONLY; The status of data ingestion for this workspace. Possible values include: 'RespectQuota', 'ForceOn', 'ForceOff', 'OverQuota', 'SubscriptionSuspended', 'ApproachingQuota'
	DataIngestionStatus DataIngestionStatus `json:"dataIngestionStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceCapping.
func (wc WorkspaceCapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wc.DailyQuotaGb != nil {
		objectMap["dailyQuotaGb"] = wc.DailyQuotaGb
	}
	return json.Marshal(objectMap)
}

// WorkspaceListResult the list workspaces operation response.
type WorkspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of workspaces.
	Value *[]Workspace `json:"value,omitempty"`
}

// WorkspacePatch the top level Workspace resource container.
type WorkspacePatch struct {
	// WorkspaceProperties - Workspace properties.
	*WorkspaceProperties `json:"properties,omitempty"`
	// Tags - Resource tags. Optional.
	Tags map[string]*string `json:"tags"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspacePatch.
func (wp WorkspacePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.WorkspaceProperties != nil {
		objectMap["properties"] = wp.WorkspaceProperties
	}
	if wp.Tags != nil {
		objectMap["tags"] = wp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspacePatch struct.
func (wp *WorkspacePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				wp.WorkspaceProperties = &workspaceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wp.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				wp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wp.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkspaceProperties workspace properties.
type WorkspaceProperties struct {
	// ProvisioningState - The provisioning state of the workspace. Possible values include: 'WorkspaceEntityStatusCreating', 'WorkspaceEntityStatusSucceeded', 'WorkspaceEntityStatusFailed', 'WorkspaceEntityStatusCanceled', 'WorkspaceEntityStatusDeleting', 'WorkspaceEntityStatusProvisioningAccount', 'WorkspaceEntityStatusUpdating'
	ProvisioningState WorkspaceEntityStatus `json:"provisioningState,omitempty"`
	// CustomerID - READ-ONLY; This is a read-only property. Represents the ID associated with the workspace.
	CustomerID *string `json:"customerId,omitempty"`
	// Sku - The SKU of the workspace.
	Sku *WorkspaceSku `json:"sku,omitempty"`
	// RetentionInDays - The workspace data retention in days, between 30 and 730.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
	// WorkspaceCapping - The daily volume cap for ingestion.
	WorkspaceCapping *WorkspaceCapping `json:"workspaceCapping,omitempty"`
	// PublicNetworkAccessForIngestion - The network access type for accessing Log Analytics ingestion. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccessForIngestion PublicNetworkAccessType `json:"publicNetworkAccessForIngestion,omitempty"`
	// PublicNetworkAccessForQuery - The network access type for accessing Log Analytics query. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccessForQuery PublicNetworkAccessType `json:"publicNetworkAccessForQuery,omitempty"`
	// ForceCmkForQuery - Indicates whether customer managed storage is mandatory for query management.
	ForceCmkForQuery *bool `json:"forceCmkForQuery,omitempty"`
	// PrivateLinkScopedResources - READ-ONLY; List of linked private link scope resources.
	PrivateLinkScopedResources *[]PrivateLinkScopedResource `json:"privateLinkScopedResources,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceProperties.
func (wp WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.ProvisioningState != "" {
		objectMap["provisioningState"] = wp.ProvisioningState
	}
	if wp.Sku != nil {
		objectMap["sku"] = wp.Sku
	}
	if wp.RetentionInDays != nil {
		objectMap["retentionInDays"] = wp.RetentionInDays
	}
	if wp.WorkspaceCapping != nil {
		objectMap["workspaceCapping"] = wp.WorkspaceCapping
	}
	if wp.PublicNetworkAccessForIngestion != "" {
		objectMap["publicNetworkAccessForIngestion"] = wp.PublicNetworkAccessForIngestion
	}
	if wp.PublicNetworkAccessForQuery != "" {
		objectMap["publicNetworkAccessForQuery"] = wp.PublicNetworkAccessForQuery
	}
	if wp.ForceCmkForQuery != nil {
		objectMap["forceCmkForQuery"] = wp.ForceCmkForQuery
	}
	return json.Marshal(objectMap)
}

// WorkspacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspacesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (Workspace, error)
}

// WorkspacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (autorest.Response, error)
}

// WorkspaceSku the SKU (tier) of a workspace.
type WorkspaceSku struct {
	// Name - The name of the SKU. Possible values include: 'WorkspaceSkuNameEnumFree', 'WorkspaceSkuNameEnumStandard', 'WorkspaceSkuNameEnumPremium', 'WorkspaceSkuNameEnumPerNode', 'WorkspaceSkuNameEnumPerGB2018', 'WorkspaceSkuNameEnumStandalone', 'WorkspaceSkuNameEnumCapacityReservation', 'WorkspaceSkuNameEnumLACluster'
	Name WorkspaceSkuNameEnum `json:"name,omitempty"`
	// CapacityReservationLevel - The capacity reservation level for this workspace, when CapacityReservation sku is selected.
	CapacityReservationLevel *int32 `json:"capacityReservationLevel,omitempty"`
	// MaxCapacityReservationLevel - READ-ONLY; The maximum capacity reservation level available for this workspace, when CapacityReservation sku is selected.
	MaxCapacityReservationLevel *int32 `json:"maxCapacityReservationLevel,omitempty"`
	// LastSkuUpdate - READ-ONLY; The last time when the sku was updated.
	LastSkuUpdate *string `json:"lastSkuUpdate,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceSku.
func (ws WorkspaceSku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ws.Name != "" {
		objectMap["name"] = ws.Name
	}
	if ws.CapacityReservationLevel != nil {
		objectMap["capacityReservationLevel"] = ws.CapacityReservationLevel
	}
	return json.Marshal(objectMap)
}
