package personalizer

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// BadRequest Request could not be understood by the server.
	BadRequest ErrorCode = "BadRequest"
	// EvaluationNotFound Evaluation not found.
	EvaluationNotFound ErrorCode = "EvaluationNotFound"
	// FrontEndNotFound Front end not found.
	FrontEndNotFound ErrorCode = "FrontEndNotFound"
	// InternalServerError A generic error has occurred on the server.
	InternalServerError ErrorCode = "InternalServerError"
	// InvalidContainer SAS Uri must be the Uri to a container that has write permissions.
	InvalidContainer ErrorCode = "InvalidContainer"
	// InvalidEvaluationContract Invalid evaluation contract.
	InvalidEvaluationContract ErrorCode = "InvalidEvaluationContract"
	// InvalidEventIDToActivate Invalid activate event request.
	InvalidEventIDToActivate ErrorCode = "InvalidEventIdToActivate"
	// InvalidExportLogsRequest Invalid export logs request.
	InvalidExportLogsRequest ErrorCode = "InvalidExportLogsRequest"
	// InvalidPolicyConfiguration Invalid policy configuration.
	InvalidPolicyConfiguration ErrorCode = "InvalidPolicyConfiguration"
	// InvalidPolicyContract Invalid policy contract.
	InvalidPolicyContract ErrorCode = "InvalidPolicyContract"
	// InvalidRankRequest Invalid rank request.
	InvalidRankRequest ErrorCode = "InvalidRankRequest"
	// InvalidRewardRequest Invalid reward request.
	InvalidRewardRequest ErrorCode = "InvalidRewardRequest"
	// InvalidServiceConfiguration Invalid service configuration.
	InvalidServiceConfiguration ErrorCode = "InvalidServiceConfiguration"
	// LogsPropertiesNotFound Logs properties not found.
	LogsPropertiesNotFound ErrorCode = "LogsPropertiesNotFound"
	// ModelResetFailed Model reset failed.
	ModelResetFailed ErrorCode = "ModelResetFailed"
	// RankNullResponse Rank call returned null response.
	RankNullResponse ErrorCode = "RankNullResponse"
	// ResourceNotFound Requested resource does not exist on the server.
	ResourceNotFound ErrorCode = "ResourceNotFound"
	// UpdateConfigurationFailed Failed to update configuration.
	UpdateConfigurationFailed ErrorCode = "UpdateConfigurationFailed"
)

// PossibleErrorCodeValues returns an array of possible values for the ErrorCode const type.
func PossibleErrorCodeValues() []ErrorCode {
	return []ErrorCode{BadRequest, EvaluationNotFound, FrontEndNotFound, InternalServerError, InvalidContainer, InvalidEvaluationContract, InvalidEventIDToActivate, InvalidExportLogsRequest, InvalidPolicyConfiguration, InvalidPolicyContract, InvalidRankRequest, InvalidRewardRequest, InvalidServiceConfiguration, LogsPropertiesNotFound, ModelResetFailed, RankNullResponse, ResourceNotFound, UpdateConfigurationFailed}
}

// EvaluationJobStatus enumerates the values for evaluation job status.
type EvaluationJobStatus string

const (
	// Completed ...
	Completed EvaluationJobStatus = "completed"
	// Failed ...
	Failed EvaluationJobStatus = "failed"
	// NotSubmitted ...
	NotSubmitted EvaluationJobStatus = "notSubmitted"
	// Pending ...
	Pending EvaluationJobStatus = "pending"
)

// PossibleEvaluationJobStatusValues returns an array of possible values for the EvaluationJobStatus const type.
func PossibleEvaluationJobStatusValues() []EvaluationJobStatus {
	return []EvaluationJobStatus{Completed, Failed, NotSubmitted, Pending}
}
