package hardwaresecuritymodules

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// JSONWebKeyType enumerates the values for json web key type.
type JSONWebKeyType string

const (
	// Allocating A device is currently being allocated for the dedicated HSM resource.
	Allocating JSONWebKeyType = "Allocating"
	// CheckingQuota Validating the subscription has sufficient quota to allocate a dedicated HSM device.
	CheckingQuota JSONWebKeyType = "CheckingQuota"
	// Connecting The dedicated HSM is being connected to the virtual network.
	Connecting JSONWebKeyType = "Connecting"
	// Deleting The dedicated HSM is currently being deleted.
	Deleting JSONWebKeyType = "Deleting"
	// Failed Provisioning of the dedicated HSM has failed.
	Failed JSONWebKeyType = "Failed"
	// Provisioning The dedicated HSM is currently being provisioned.
	Provisioning JSONWebKeyType = "Provisioning"
	// Succeeded The dedicated HSM has been full provisioned.
	Succeeded JSONWebKeyType = "Succeeded"
)

// PossibleJSONWebKeyTypeValues returns an array of possible values for the JSONWebKeyType const type.
func PossibleJSONWebKeyTypeValues() []JSONWebKeyType {
	return []JSONWebKeyType{Allocating, CheckingQuota, Connecting, Deleting, Failed, Provisioning, Succeeded}
}

// Name enumerates the values for name.
type Name string

const (
	// SafeNetLunaNetworkHSMA790 ...
	SafeNetLunaNetworkHSMA790 Name = "SafeNet Luna Network HSM A790"
)

// PossibleNameValues returns an array of possible values for the Name const type.
func PossibleNameValues() []Name {
	return []Name{SafeNetLunaNetworkHSMA790}
}
