package servicefabricmesh

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// CodePackageClient is the service Fabric Mesh Management Client
type CodePackageClient struct {
	BaseClient
}

// NewCodePackageClient creates an instance of the CodePackageClient client.
func NewCodePackageClient(subscriptionID string) CodePackageClient {
	return NewCodePackageClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewCodePackageClientWithBaseURI creates an instance of the CodePackageClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewCodePackageClientWithBaseURI(baseURI string, subscriptionID string) CodePackageClient {
	return CodePackageClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// GetContainerLogs gets the logs for the container of the specified code package of the service replica.
// Parameters:
// resourceGroupName - azure resource group name
// applicationResourceName - the identity of the application.
// serviceResourceName - the identity of the service.
// replicaName - service Fabric replica name.
// codePackageName - the name of code package of the service.
// tail - number of lines to show from the end of the logs. Default is 100.
func (client CodePackageClient) GetContainerLogs(ctx context.Context, resourceGroupName string, applicationResourceName string, serviceResourceName string, replicaName string, codePackageName string, tail *int32) (result ContainerLogs, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CodePackageClient.GetContainerLogs")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetContainerLogsPreparer(ctx, resourceGroupName, applicationResourceName, serviceResourceName, replicaName, codePackageName, tail)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabricmesh.CodePackageClient", "GetContainerLogs", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetContainerLogsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "servicefabricmesh.CodePackageClient", "GetContainerLogs", resp, "Failure sending request")
		return
	}

	result, err = client.GetContainerLogsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabricmesh.CodePackageClient", "GetContainerLogs", resp, "Failure responding to request")
		return
	}

	return
}

// GetContainerLogsPreparer prepares the GetContainerLogs request.
func (client CodePackageClient) GetContainerLogsPreparer(ctx context.Context, resourceGroupName string, applicationResourceName string, serviceResourceName string, replicaName string, codePackageName string, tail *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"applicationResourceName": applicationResourceName,
		"codePackageName":         autorest.Encode("path", codePackageName),
		"replicaName":             replicaName,
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"serviceResourceName":     serviceResourceName,
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-09-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if tail != nil {
		queryParameters["tail"] = autorest.Encode("query", *tail)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabricMesh/applications/{applicationResourceName}/services/{serviceResourceName}/replicas/{replicaName}/codePackages/{codePackageName}/logs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetContainerLogsSender sends the GetContainerLogs request. The method will close the
// http.Response Body if it receives an error.
func (client CodePackageClient) GetContainerLogsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetContainerLogsResponder handles the response to the GetContainerLogs request. The method always
// closes the http.Response Body.
func (client CodePackageClient) GetContainerLogsResponder(resp *http.Response) (result ContainerLogs, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
