package artifacts

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// WorkspaceGitRepoManagementClient is the client for the WorkspaceGitRepoManagement methods of the Artifacts service.
type WorkspaceGitRepoManagementClient struct {
	BaseClient
}

// NewWorkspaceGitRepoManagementClient creates an instance of the WorkspaceGitRepoManagementClient client.
func NewWorkspaceGitRepoManagementClient(endpoint string) WorkspaceGitRepoManagementClient {
	return WorkspaceGitRepoManagementClient{New(endpoint)}
}

// GetGitHubAccessToken get the GitHub access token.
// Parameters:
// clientRequestID - can provide a guid, which is helpful for debugging and to provide better customer support
func (client WorkspaceGitRepoManagementClient) GetGitHubAccessToken(ctx context.Context, APIVersion string, gitHubAccessTokenRequest GitHubAccessTokenRequest, clientRequestID string) (result GitHubAccessTokenResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceGitRepoManagementClient.GetGitHubAccessToken")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: gitHubAccessTokenRequest,
			Constraints: []validation.Constraint{{Target: "gitHubAccessTokenRequest.GitHubClientID", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "gitHubAccessTokenRequest.GitHubAccessCode", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "gitHubAccessTokenRequest.GitHubAccessTokenBaseURL", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("artifacts.WorkspaceGitRepoManagementClient", "GetGitHubAccessToken", err.Error())
	}

	req, err := client.GetGitHubAccessTokenPreparer(ctx, APIVersion, gitHubAccessTokenRequest, clientRequestID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.WorkspaceGitRepoManagementClient", "GetGitHubAccessToken", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetGitHubAccessTokenSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "artifacts.WorkspaceGitRepoManagementClient", "GetGitHubAccessToken", resp, "Failure sending request")
		return
	}

	result, err = client.GetGitHubAccessTokenResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.WorkspaceGitRepoManagementClient", "GetGitHubAccessToken", resp, "Failure responding to request")
		return
	}

	return
}

// GetGitHubAccessTokenPreparer prepares the GetGitHubAccessToken request.
func (client WorkspaceGitRepoManagementClient) GetGitHubAccessTokenPreparer(ctx context.Context, APIVersion string, gitHubAccessTokenRequest GitHubAccessTokenRequest, clientRequestID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/getGitHubAccessToken"),
		autorest.WithJSON(gitHubAccessTokenRequest),
		autorest.WithQueryParameters(queryParameters))
	if len(clientRequestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(clientRequestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetGitHubAccessTokenSender sends the GetGitHubAccessToken request. The method will close the
// http.Response Body if it receives an error.
func (client WorkspaceGitRepoManagementClient) GetGitHubAccessTokenSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetGitHubAccessTokenResponder handles the response to the GetGitHubAccessToken request. The method always
// closes the http.Response Body.
func (client WorkspaceGitRepoManagementClient) GetGitHubAccessTokenResponder(resp *http.Response) (result GitHubAccessTokenResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
