/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lsp.Diagnostic;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.hints.pom.MavenResult;
import org.netbeans.modules.maven.hints.pom.MavenSelectionHintsTask;
import org.netbeans.modules.maven.hints.pom.PomModelUtils;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.lsp.ErrorProvider;
import org.openide.filesystems.FileObject;

public class LspMavenErrorProvider
implements ErrorProvider {
    private static Diagnostic error2Diagnostic(ErrorDescription error, LineDocument lineDocument, int idx) {
        int s = error.getRange().getBegin().getOffset();
        int e = error.getRange().getEnd().getOffset();
        Diagnostic.Builder diagBuilder = Diagnostic.Builder.create(() -> {
            if (lineDocument != null) {
                try {
                    return LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)lineDocument, (int)s);
                }
                catch (BadLocationException ex) {
                    return s;
                }
            }
            return s;
        }, () -> {
            if (lineDocument != null) {
                try {
                    return LineDocumentUtils.getLineLastNonWhitespace((LineDocument)lineDocument, (int)e);
                }
                catch (BadLocationException ex) {
                    return e;
                }
            }
            return e;
        }, (String)error.getDescription());
        switch (error.getSeverity()) {
            case VERIFIER: 
            case ERROR: {
                diagBuilder.setSeverity(Diagnostic.Severity.Error);
                break;
            }
            case WARNING: {
                diagBuilder.setSeverity(Diagnostic.Severity.Warning);
                break;
            }
            case HINT: {
                diagBuilder.setSeverity(Diagnostic.Severity.Information);
            }
        }
        String id = "errors:" + idx + "-" + error.getId();
        diagBuilder.setCode(id);
        return diagBuilder.build();
    }

    public List<? extends Diagnostic> computeErrors(ErrorProvider.Context context) {
        try {
            FileObject f = context.file();
            T task = new T(context);
            ParserManager.parse(Collections.singleton(Source.create((FileObject)f)), (UserTask)task);
            return task.diagnostics;
        }
        catch (ParseException ex) {
            throw new IllegalStateException("Parsing failed", ex);
        }
    }

    static final class T
    extends UserTask {
        final ErrorProvider.Context context;
        List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

        public T(ErrorProvider.Context context) {
            this.context = context;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            if (!(resultIterator.getParserResult() instanceof MavenResult)) {
                return;
            }
            MavenResult result = (MavenResult)resultIterator.getParserResult();
            FileObject fo = result.getPomFile();
            Project p = FileOwnerQuery.getOwner((FileObject)fo);
            Document doc = result.getSnapshot().getSource().getDocument(false);
            if (fo == null || p == null || doc == null) {
                return;
            }
            List<Object> errors = this.context.getOffset() > -1 ? MavenSelectionHintsTask.computeErrors(result, this.context.getOffset(), this.context.getOffset(), this.context.getOffset()) : new ArrayList<ErrorDescription>();
            errors.addAll(PomModelUtils.findHints(result.getProjectModel(), p));
            LineDocument lineDocument = doc != null ? (LineDocument)LineDocumentUtils.as((Document)doc, LineDocument.class) : null;
            int idx = 0;
            boolean wantsError = this.context.errorKind() == ErrorProvider.Kind.ERRORS;
            for (ErrorDescription errorDescription : errors) {
                boolean isE;
                boolean bl = isE = errorDescription.getSeverity() == Severity.ERROR || errorDescription.getSeverity() == Severity.VERIFIER;
                if (isE != wantsError) continue;
                this.diagnostics.add(LspMavenErrorProvider.error2Diagnostic(errorDescription, lineDocument, ++idx));
            }
        }
    }
}

