/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.Include;
import org.netbeans.modules.xml.schema.model.Redefine;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponentFactory;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.model.impl.GlobalComponentsIndexSupport;
import org.netbeans.modules.xml.schema.model.impl.RefCacheSupport;
import org.netbeans.modules.xml.schema.model.impl.SchemaAttributes;
import org.netbeans.modules.xml.schema.model.impl.SchemaComponentFactoryImpl;
import org.netbeans.modules.xml.schema.model.impl.SchemaElements;
import org.netbeans.modules.xml.schema.model.impl.SchemaImpl;
import org.netbeans.modules.xml.schema.model.impl.SyncUnitReviewVisitor;
import org.netbeans.modules.xml.schema.model.impl.Util;
import org.netbeans.modules.xml.schema.model.impl.resolver.ChamelionResolver;
import org.netbeans.modules.xml.schema.model.impl.resolver.ImportResolver;
import org.netbeans.modules.xml.schema.model.impl.resolver.IncludeResolver;
import org.netbeans.modules.xml.schema.model.impl.xdm.SyncUpdateVisitor;
import org.netbeans.modules.xml.xam.ComponentUpdater;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.ChangeInfo;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.netbeans.modules.xml.xam.dom.SyncUnit;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.w3c.dom.Element;

public class SchemaModelImpl
extends AbstractDocumentModel<SchemaComponent>
implements SchemaModel {
    private SchemaImpl mSchema;
    private SchemaComponentFactory csef;
    private RefCacheSupport mRefCacheSupport;
    private GlobalComponentsIndexSupport mGlobalIndexSupport;
    private final AtomicBoolean atomicCalled = new AtomicBoolean(false);

    public SchemaModelImpl(ModelSource modelSource) {
        super(modelSource);
        this.csef = new SchemaComponentFactoryImpl(this);
        this.mRefCacheSupport = new RefCacheSupport(this);
        this.mGlobalIndexSupport = new GlobalComponentsIndexSupport(this);
    }

    public RefCacheSupport getRefCacheSupport() {
        return this.mRefCacheSupport;
    }

    public GlobalComponentsIndexSupport getGlobalComponentsIndexSupport() {
        return this.mGlobalIndexSupport;
    }

    @Override
    public SchemaImpl getSchema() {
        return (SchemaImpl)this.getRootComponent();
    }

    @Override
    public SchemaComponentFactory getFactory() {
        return this.csef;
    }

    public SchemaComponent createRootComponent(Element root) {
        SchemaImpl newSchema = (SchemaImpl)this.csef.create(root, null);
        if (newSchema == null) {
            return null;
        }
        this.mSchema = newSchema;
        return this.getSchema();
    }

    public SchemaComponent getRootComponent() {
        return this.mSchema;
    }

    @Override
    public <T extends NamedReferenceable> T resolve(String namespace, String localName, Class<T> type) {
        if ("http://www.w3.org/2001/XMLSchema".equals(namespace) && "http://www.w3.org/2001/XMLSchema".equals(this.getSchema().getTargetNamespace())) {
            return this.resolveImpl(namespace, localName, type);
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(namespace)) {
            SchemaModel sm = SchemaModelFactory.getDefault().getPrimitiveTypesModel();
            return sm.findByNameAndType(localName, type);
        }
        return this.resolveImpl(namespace, localName, type);
    }

    protected <T extends NamedReferenceable> T resolveImpl(String namespace, String localName, Class<T> type) {
        if (this.getState() != Model.State.VALID) {
            return null;
        }
        SchemaImpl mySchema = this.getSchema();
        if (mySchema == null) {
            return null;
        }
        String targetNamespace = mySchema.getTargetNamespace();
        if (Util.equal(targetNamespace, namespace)) {
            return IncludeResolver.resolve(this, namespace, localName, type);
        }
        if (targetNamespace == null) {
            return ChamelionResolver.resolve(this, namespace, localName, type);
        }
        return ImportResolver.resole(this, namespace, localName, type);
    }

    public SchemaModelImpl resolve(SchemaModelReference ref) {
        if (this.mRefCacheSupport == null) {
            try {
                return (SchemaModelImpl)ref.resolveReferencedModel();
            }
            catch (CatalogModelException ex) {
                return null;
            }
        }
        return this.mRefCacheSupport.optimizedResolve(ref);
    }

    public Collection<SchemaModelReference> getSchemaModelReferences() {
        ArrayList<SchemaModelReference> refs = new ArrayList<SchemaModelReference>();
        SchemaImpl schema = this.getSchema();
        if (schema != null) {
            refs.addAll(schema.getRedefines());
            refs.addAll(schema.getIncludes());
            refs.addAll(schema.getImports());
        }
        return refs;
    }

    public Collection<SchemaModelReference> getNotImportRefrences() {
        ArrayList<SchemaModelReference> refs = new ArrayList<SchemaModelReference>();
        SchemaImpl schema = this.getSchema();
        if (schema != null) {
            refs.addAll(schema.getRedefines());
            refs.addAll(schema.getIncludes());
        }
        return refs;
    }

    @Override
    public <T extends NamedReferenceable> T findByNameAndType(String localName, Class<T> type) {
        return this.mGlobalIndexSupport.findByNameAndType(localName, type);
    }

    public Set<Schema> findSchemas(String namespace) {
        HashSet<Schema> result = new HashSet<Schema>();
        if ("http://www.w3.org/2001/XMLSchema".equals(namespace)) {
            SchemaModel primitiveModel = SchemaModelFactory.getDefault().getPrimitiveTypesModel();
            result.add(primitiveModel.getSchema());
            return result;
        }
        return this._findSchemas(namespace, result, null);
    }

    Set<Schema> _findSchemas(String namespace, Set<Schema> result, ReferenceType refType) {
        SchemaImpl schema = this.getSchema();
        if (schema == null) {
            return result;
        }
        String targetNamespace = schema.getTargetNamespace();
        if (targetNamespace != null && targetNamespace.equals(namespace) || targetNamespace == null && namespace == null) {
            result.add(schema);
        }
        if (refType != ReferenceType.IMPORT) {
            this.checkIncludeSchemas(namespace, result);
            this.checkRedefineSchemas(namespace, result);
            this.checkImportedSchemas(namespace, result);
        }
        return result;
    }

    private void checkIncludeSchemas(String namespace, Set<Schema> result) {
        Collection<Include> includes = this.getSchema().getIncludes();
        for (Include include : includes) {
            try {
                SchemaModel model = include.resolveReferencedModel();
                if (model.getState() == Model.State.NOT_WELL_FORMED || result.contains(model.getSchema())) continue;
                result.addAll(((SchemaModelImpl)model)._findSchemas(namespace, result, ReferenceType.INCLUDE));
            }
            catch (CatalogModelException catalogModelException) {}
        }
    }

    private void checkRedefineSchemas(String namespace, Set<Schema> result) {
        Collection<Redefine> redefines = this.getSchema().getRedefines();
        for (Redefine redefine : redefines) {
            try {
                SchemaModel model = redefine.resolveReferencedModel();
                if (model.getState() == Model.State.NOT_WELL_FORMED || result.contains(model.getSchema())) continue;
                result.addAll(((SchemaModelImpl)model)._findSchemas(namespace, result, ReferenceType.REDEFINE));
            }
            catch (CatalogModelException catalogModelException) {}
        }
    }

    private void checkImportedSchemas(String namespace, Set<Schema> result) {
        Collection<Import> imports = this.getSchema().getImports();
        for (Import imp : imports) {
            try {
                SchemaModel model = imp.resolveReferencedModel();
                if (model.getState() == Model.State.NOT_WELL_FORMED || result.contains(model.getSchema())) continue;
                result.addAll(((SchemaModelImpl)model)._findSchemas(namespace, result, ReferenceType.IMPORT));
            }
            catch (CatalogModelException catalogModelException) {}
        }
    }

    @Override
    public String getEffectiveNamespace(SchemaComponent component) {
        SchemaModel componentModel = component.getModel();
        SchemaImpl schema = this.getSchema();
        Schema componentSchema = componentModel.getSchema();
        String tns = schema.getTargetNamespace();
        String componentTNS = componentSchema.getTargetNamespace();
        if (this == componentModel) {
            return tns;
        }
        if (componentTNS == null && tns != null) {
            Collection<Import> imports = schema.getImports();
            for (Import imp : imports) {
                String importedTNS;
                SchemaModel m = null;
                try {
                    m = imp.resolveReferencedModel();
                }
                catch (CatalogModelException catalogModelException) {
                    // empty catch block
                }
                if (componentModel.equals(m)) {
                    return null;
                }
                if (m == null || m.getState() == Model.State.NOT_WELL_FORMED || (importedTNS = m.getSchema().getTargetNamespace()) == null) continue;
                Collection visibleSchemas = this.findSchemas(importedTNS);
                for (Schema visible : visibleSchemas) {
                    if (!componentModel.equals(visible.getModel())) continue;
                    return null;
                }
            }
            return tns;
        }
        return componentTNS;
    }

    public SchemaComponent createComponent(SchemaComponent parent, Element element) {
        return (SchemaComponent)this.csef.create(element, parent);
    }

    protected ComponentUpdater<SchemaComponent> getComponentUpdater() {
        return new SyncUpdateVisitor<SchemaComponent>();
    }

    public Set<QName> getQNames() {
        return SchemaElements.allQNames();
    }

    public SyncUnit prepareSyncUnit(ChangeInfo changes, SyncUnit unit) {
        if ((unit = super.prepareSyncUnit(changes, unit)) != null) {
            return new SyncUnitReviewVisitor().review(unit);
        }
        return null;
    }

    public DocumentModelAccess getAccess() {
        DocumentModelAccess acc = super.getAccess();
        if (!this.atomicCalled.getAndSet(true)) {
            super.getAccess().setAutoSync(true);
        }
        return acc;
    }

    public Map<QName, List<QName>> getQNameValuedAttributes() {
        return SchemaAttributes.getQNameValuedAttributes();
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    public String toString() {
        FileObject fileObject;
        Lookup lookup;
        ModelSource source = this.getModelSource();
        if (source != null && (lookup = source.getLookup()) != null && (fileObject = (FileObject)lookup.lookup(FileObject.class)) != null) {
            return fileObject.getNameExt();
        }
        return super.toString();
    }

    protected static enum ReferenceType {
        IMPORT,
        INCLUDE,
        REDEFINE;

    }
}

