/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.commons.Bundle;
import org.netbeans.modules.bugtracking.commons.LinkButton;
import org.netbeans.modules.bugtracking.commons.Support;
import org.netbeans.modules.team.ide.spi.IDEServices;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JiraUpdater {
    private static final String JIRA_CNB = "org.netbeans.modules.jira";
    private static JiraUpdater instance;

    private JiraUpdater() {
    }

    public static synchronized JiraUpdater getInstance() {
        if (instance == null) {
            instance = new JiraUpdater();
        }
        return instance;
    }

    public void downloadAndInstall(String projectUrl) {
        IDEServices.Plugin plugin;
        if (projectUrl != null && !JiraUpdater.notifyJiraDownload(projectUrl)) {
            return;
        }
        IDEServices ideServices = Support.getInstance().getIDEServices();
        if (ideServices != null && (plugin = ideServices.getPluginUpdates(JIRA_CNB, Bundle.MSG_JiraPluginName())) != null) {
            plugin.installOrUpdate();
        }
    }

    public static boolean isJiraInstalled() {
        IDEServices ideServices = Support.getInstance().getIDEServices();
        return ideServices != null && ideServices.isPluginInstalled(JIRA_CNB);
    }

    public static boolean notifyJiraDownload(String url) {
        if (JiraUpdater.isJiraInstalled()) {
            return false;
        }
        final JButton download = new JButton(NbBundle.getMessage(JiraUpdater.class, (String)"CTL_Action_Download"));
        JButton cancel = new JButton(NbBundle.getMessage(JiraUpdater.class, (String)"CTL_Action_Cancel"));
        URL openURL = null;
        if (url != null) {
            try {
                openURL = new URL(url);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        JPanel panel = JiraUpdater.createNotificationPanel(openURL);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(JiraUpdater.class, (String)"CTL_MissingJiraPlugin"), true, new Object[]{download, cancel}, (Object)download, 0, new HelpCtx(JiraUpdater.class), null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                download.requestFocusInWindow();
            }
        });
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == download;
    }

    private static JPanel createNotificationPanel(final URL url) {
        JPanel panel = new JPanel();
        JLabel msgLabel = new JLabel("<html>" + NbBundle.getMessage(JiraUpdater.class, (String)"MSG_PROJECT_NEEDS_JIRA"));
        LinkButton linkButton = new LinkButton();
        Mnemonics.setLocalizedText((AbstractButton)linkButton, (String)NbBundle.getMessage(JiraUpdater.class, (String)"MSG_PROJECT_NEEDS_JIRA_LINK"));
        if (url != null) {
            linkButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
                    if (displayer != null) {
                        displayer.showURL(url);
                    } else {
                        Support.LOG.warning("No URLDisplayer found.");
                    }
                }
            });
        } else {
            linkButton.setVisible(false);
        }
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(msgLabel, -2, 470, Short.MAX_VALUE).addComponent(linkButton)).addContainerGap());
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addComponent(msgLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(linkButton).addContainerGap(25, Short.MAX_VALUE));
        return panel;
    }
}

