/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteDrgRouteDistributionRequest
extends BmcRequest<Void> {
    private String drgRouteDistributionId;
    private String ifMatch;

    public String getDrgRouteDistributionId() {
        return this.drgRouteDistributionId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().drgRouteDistributionId(this.drgRouteDistributionId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",drgRouteDistributionId=").append(String.valueOf(this.drgRouteDistributionId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteDrgRouteDistributionRequest)) {
            return false;
        }
        DeleteDrgRouteDistributionRequest other = (DeleteDrgRouteDistributionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.drgRouteDistributionId, other.drgRouteDistributionId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.drgRouteDistributionId == null ? 43 : this.drgRouteDistributionId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDrgRouteDistributionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String drgRouteDistributionId = null;
        private String ifMatch = null;

        public Builder drgRouteDistributionId(String drgRouteDistributionId) {
            this.drgRouteDistributionId = drgRouteDistributionId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDrgRouteDistributionRequest o) {
            this.drgRouteDistributionId(o.getDrgRouteDistributionId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDrgRouteDistributionRequest build() {
            DeleteDrgRouteDistributionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteDrgRouteDistributionRequest buildWithoutInvocationCallback() {
            DeleteDrgRouteDistributionRequest request = new DeleteDrgRouteDistributionRequest();
            request.drgRouteDistributionId = this.drgRouteDistributionId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

