/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchType;
import org.openidex.search.Utils;

public class DataObjectSearchGroup
extends SearchGroup {
    private static boolean lowMemoryWarning = false;
    private static int lowMemoryWarningCount = 0;
    private static int MB = 0x100000;
    private static int REQUIRED_PER_ITERATION = 2 * MB;
    private static int REQUIRED_PER_FULL_GC = 7 * MB;

    @Override
    protected void add(SearchType searchType) {
        boolean ok = false;
        for (Class clazz : searchType.getSearchTypeClasses()) {
            if (clazz != DataObject.class) continue;
            ok = true;
            break;
        }
        if (ok) {
            super.add(searchType);
        }
    }

    @Override
    public void doSearch() {
        Node[] nodes = DataObjectSearchGroup.normalizeNodes(this.searchRoots.toArray(new Node[0]));
        lowMemoryWarning = false;
        lowMemoryWarningCount = 0;
        DataObjectSearchGroup.assureMemory(REQUIRED_PER_ITERATION, true);
        for (Node node : nodes) {
            SearchInfo info = Utils.getSearchInfo(node);
            if (info == null) continue;
            Iterator<DataObject> j = info.objectsToSearch();
            while (j.hasNext()) {
                if (this.stopped) {
                    return;
                }
                DataObjectSearchGroup.assureMemory(REQUIRED_PER_ITERATION, false);
                this.processSearchObject(j.next());
            }
        }
    }

    private static void assureMemory(int estimate, boolean tryGC) {
        Runtime rt = Runtime.getRuntime();
        long total = rt.totalMemory();
        long max = rt.maxMemory();
        long required = Math.max(total / 13L, (long)(estimate + REQUIRED_PER_FULL_GC));
        if (total == max && rt.freeMemory() < required) {
            if (tryGC) {
                try {
                    byte[] gcProvocation = new byte[(int)required];
                    gcProvocation[0] = 75;
                    gcProvocation = null;
                    return;
                }
                catch (OutOfMemoryError e) {
                    DataObjectSearchGroup.throwNoMemory();
                }
            } else {
                lowMemoryWarning = true;
            }
        } else if (lowMemoryWarning) {
            lowMemoryWarning = false;
            ++lowMemoryWarningCount;
        }
        if (lowMemoryWarningCount > 7 || total == max && rt.freeMemory() < (long)REQUIRED_PER_FULL_GC) {
            DataObjectSearchGroup.throwNoMemory();
        }
    }

    private static void throwNoMemory() {
        RuntimeException ex = new RuntimeException("Low memory condition");
        String msg = NbBundle.getMessage(DataObjectSearchGroup.class, (String)"EX_memory");
        ErrorManager.getDefault().annotate((Throwable)ex, 256, null, msg, null, null);
        throw ex;
    }

    @Override
    public Node getNodeForFoundObject(Object object) {
        if (!(object instanceof DataObject)) {
            return null;
        }
        return ((DataObject)object).getNodeDelegate();
    }

    private static Node[] normalizeNodes(Node[] nodes) {
        if (nodes.length < 2) {
            return nodes;
        }
        HashMap<Node, Boolean> badNodes = new HashMap<Node, Boolean>(2 * nodes.length, 0.75f);
        HashMap<Node, Boolean> goodNodes = new HashMap<Node, Boolean>(2 * nodes.length, 0.75f);
        ArrayList<Node> path = new ArrayList<Node>(10);
        ArrayList<Node> result = new ArrayList<Node>(nodes.length);
        for (Node node : nodes) {
            badNodes.put(node, Boolean.FALSE);
        }
        for (Node node : nodes) {
            path.clear();
            boolean isBad = false;
            for (Node n = node.getParentNode(); n != null; n = n.getParentNode()) {
                if (badNodes.containsKey(n)) {
                    isBad = true;
                    break;
                }
                if (goodNodes.containsKey(n)) break;
                path.add(n);
            }
            if (isBad) {
                badNodes.put(node, Boolean.TRUE);
                for (Node pathNode : path) {
                    badNodes.put(pathNode, Boolean.TRUE);
                }
                continue;
            }
            for (Node pathNode : path) {
                goodNodes.put(pathNode, Boolean.TRUE);
            }
            result.add(node);
        }
        return result.toArray(new Node[0]);
    }
}

