/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentElementEvent;
import org.netbeans.modules.editor.structure.api.DocumentElementListener;
import org.netbeans.modules.xml.text.navigator.HTMLTextEncoder;
import org.netbeans.modules.xml.text.navigator.NavigatorContent;
import org.openide.ErrorManager;

public class TreeNodeAdapter
implements TreeNode,
DocumentElementListener {
    private DocumentElement de;
    private DefaultTreeModel tm;
    private TreeNode parent;
    private JTree tree;
    private ArrayList children = null;
    private ArrayList textElements = new ArrayList();
    private String textContent = EMPTY_STRING;
    private boolean containsError = false;
    private int childrenErrorCount = 0;
    private static final String EMPTY_STRING = new String("");
    private boolean firingChange;
    private static final boolean debug = Boolean.getBoolean("org.netbeans.modules.xml.text.structure.debug");
    private static final int ATTRIBS_MAX_LEN = 100;
    private static final int TEXT_MAX_LEN = 50;

    public TreeNodeAdapter(DocumentElement de, DefaultTreeModel tm, JTree tree, TreeNode parent) {
        this.de = de;
        this.tm = tm;
        this.tree = tree;
        this.parent = parent;
    }

    public int getStart() {
        return this.de.getStartOffset();
    }

    public int getEnd() {
        return this.de.getEndOffset();
    }

    private String getDocumentContent() {
        this.checkChildrenAdapters();
        this.checkDocumentContent();
        return this.textContent;
    }

    public Enumeration children() {
        this.checkChildrenAdapters();
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int param) {
        this.checkChildrenAdapters();
        return (TreeNode)this.children.get(param);
    }

    @Override
    public int getChildCount() {
        this.checkChildrenAdapters();
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        this.checkChildrenAdapters();
        return this.children.indexOf(treeNode);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public DocumentElement getDocumentElement() {
        return this.de;
    }

    private TreeNodeAdapter getChildTreeNode(DocumentElement de) {
        this.checkChildrenAdapters();
        for (TreeNodeAdapter tn : this.children) {
            if (!tn.getDocumentElement().equals((Object)de)) continue;
            return tn;
        }
        return null;
    }

    public boolean containsError() {
        this.checkChildrenAdapters();
        return this.containsError;
    }

    public int getChildrenErrorCount() {
        this.checkChildrenAdapters();
        return this.childrenErrorCount;
    }

    public String toString() {
        return this.getText(false);
    }

    public String getText(boolean html) {
        if (this.de.getType().equals("tag") || this.de.getType().equals("empty_tag")) {
            String attribsVisibleText = "";
            AttributeSet attribs = this.getDocumentElement().getAttributes();
            if (attribs.getAttributeCount() > 0) {
                String attribsText = this.getAttribsText();
                if (NavigatorContent.showAttributes) {
                    attribsVisibleText = attribsText.length() > 100 ? attribsText.substring(0, 100) + "..." : attribsText.toString();
                }
            }
            String contentText = "";
            String documentText = this.getDocumentContent();
            if (NavigatorContent.showContent) {
                contentText = documentText.length() > 50 ? documentText.substring(0, 50) + "..." : documentText;
            }
            StringBuffer text = new StringBuffer();
            text.append(html ? "<html>" : "");
            text.append(html && this.containsError ? "<font color=FF0000><b>" : "");
            text.append(this.getDocumentElement().getName());
            text.append(html && this.containsError ? "</b></font>" : "");
            text.append(html ? "<font color=888888>" : "");
            if (attribsVisibleText.trim().length() > 0) {
                text.append(" ");
                text.append(attribsVisibleText);
            }
            text.append(html ? "</font>" : "");
            if (contentText.trim().length() > 0) {
                text.append(" (");
                text.append(HTMLTextEncoder.encodeHTMLText(contentText));
                text.append(")");
            }
            text.append(html ? "</html>" : "");
            return text.toString();
        }
        if (this.de.getType().equals("pi")) {
            String documentText = this.getPIText();
            documentText = documentText.length() > 50 ? documentText.substring(0, 50) + "..." : documentText;
            return documentText;
        }
        if (this.de.getType().equals("doctype")) {
            String documentText = this.getDoctypeText();
            String visibleText = documentText.length() > 50 ? documentText.substring(0, 50) + "..." : documentText;
            return visibleText;
        }
        if (this.de.getType().equals("cdata")) {
            String documentText = this.getCDATAText();
            String visibleText = documentText.length() > 50 ? documentText.substring(0, 50) + "..." : documentText;
            return visibleText;
        }
        return this.de.getName() + " [unknown content]";
    }

    public String getToolTipText() {
        if (this.de.getType().equals("tag") || this.de.getType().equals("empty_tag")) {
            return this.getAttribsText() + " " + this.getDocumentContent();
        }
        if (this.de.getType().equals("pi")) {
            return this.getPIText();
        }
        if (this.de.getType().equals("doctype")) {
            return this.getDoctypeText();
        }
        if (this.de.getType().equals("cdata")) {
            return this.getCDATAText();
        }
        return "";
    }

    private String getPIText() {
        String documentText = null;
        try {
            documentText = this.de.getDocumentModel().getDocument().getText(this.de.getStartOffset(), this.de.getEndOffset() - this.de.getStartOffset());
            int index = "<?".length() + this.de.getName().length();
            if (index > documentText.length() - 1) {
                index = documentText.length() - 1;
            }
            if (documentText.length() > 0) {
                documentText = documentText.substring(index, documentText.length() - 1).trim();
            }
        }
        catch (BadLocationException e) {
            return "???";
        }
        return documentText;
    }

    private String getDoctypeText() {
        String documentText = "???";
        try {
            documentText = this.de.getDocumentModel().getDocument().getText(this.de.getStartOffset(), this.de.getEndOffset() - this.de.getStartOffset());
            if (documentText.length() > 0) {
                documentText = documentText.substring("<!DOCTYPE ".length() + this.de.getName().length(), documentText.length() - 1).trim();
            }
        }
        catch (BadLocationException e) {
            return "???";
        }
        return documentText;
    }

    private String getCDATAText() {
        String documentText = "???";
        try {
            documentText = this.de.getDocumentModel().getDocument().getText(this.de.getStartOffset(), this.de.getEndOffset() - this.de.getStartOffset());
            String cdataStart = "<![CDATA[";
            String cdataEnd = "]]";
            if (documentText.length() > 0 && documentText.contains(cdataStart)) {
                documentText = documentText.substring(cdataStart.length()).trim();
            }
            if (documentText.length() > 0 && documentText.contains(cdataEnd)) {
                documentText = documentText.substring(0, documentText.indexOf(cdataEnd)).trim();
            }
        }
        catch (Exception e) {
            return "???";
        }
        return documentText;
    }

    public void childrenReordered(DocumentElementEvent ce) {
        this.tm.nodeStructureChanged(this);
    }

    public String getAttribsText() {
        StringBuffer attribsText = new StringBuffer();
        Enumeration<?> attrNames = this.getDocumentElement().getAttributes().getAttributeNames();
        if (attrNames.hasMoreElements()) {
            while (attrNames.hasMoreElements()) {
                String aname = (String)attrNames.nextElement();
                String value = (String)this.getDocumentElement().getAttributes().getAttribute(aname);
                attribsText.append(aname);
                attribsText.append("=\"");
                attribsText.append(value);
                attribsText.append("\"");
                if (!attrNames.hasMoreElements()) continue;
                attribsText.append(", ");
            }
        }
        return attribsText.toString();
    }

    public void elementAdded(DocumentElementEvent e) {
        DocumentElement ade = e.getChangedChild();
        if (debug) {
            System.out.println(">>> +EVENT called on " + this.hashCode() + " - " + this.de + ": element " + ade + " is going to be added");
        }
        if (ade.getType().equals("content")) {
            this.textElements.add(new TextElementWrapper(ade));
            this.childTextElementChanged();
        } else if (ade.getType().equals("error")) {
            this.markNodeAsError(this);
        } else if (!ade.getType().equals("comment")) {
            TreeNodeAdapter tn = new TreeNodeAdapter(ade, this.tm, this.tree, this);
            int insertIndex = this.getVisibleChildIndex(ade);
            if (this.getChildTreeNode(ade) == null) {
                if (this.children.size() < insertIndex) {
                    this.tm.nodeStructureChanged(this);
                } else {
                    this.children.add(insertIndex, tn);
                    int tnIndex = this.getIndex(tn);
                    this.tm.nodesWereInserted(this, new int[]{tnIndex});
                }
            }
            if (debug) {
                System.out.println("<<<EVENT finished (node " + tn + " added)");
            }
        }
        if (this.de.equals((Object)this.de.getDocumentModel().getRootElement())) {
            this.tree.expandPath(new TreePath(this));
        }
    }

    private void debugError(DocumentElementEvent e) {
        StringBuffer sb = new StringBuffer();
        sb.append("An inconsistency between XML navigator and XML DocumentModel occured when adding a new element in the XML DocumentModel! Please report the problem and add following debug messages to the issue along with the XML document you are editing.");
        sb.append("Debug for Node " + this + ":\n");
        sb.append("Children of current node:\n");
        Iterator itr = this.children.iterator();
        while (itr.hasNext()) {
            TreeNodeAdapter tna = (TreeNodeAdapter)itr.next();
            sb.append(tna.toString());
            sb.append("\n");
        }
        sb.append("\nChildren of DocumentElement (" + this.getDocumentElement() + ") wrapped by the current node:\n");
        Iterator currChildrenItr = this.getDocumentElement().getChildren().iterator();
        while (itr.hasNext()) {
            DocumentElement de = (DocumentElement)itr.next();
            sb.append(de.toString());
            sb.append("\n");
        }
        sb.append("------------");
        ErrorManager.getDefault().log(1, sb.toString());
    }

    private void fireNodeChange() {
        if (!this.firingChange) {
            try {
                this.firingChange = true;
                this.tm.nodeChanged(this);
            }
            finally {
                this.firingChange = false;
            }
        }
    }

    private void markNodeAsError(TreeNodeAdapter tna) {
        tna.containsError = true;
        TreeNodeAdapter parent = tna;
        tna.fireNodeChange();
        while ((parent = (TreeNodeAdapter)parent.getParent()) != null) {
            if (parent.getParent() != null) {
                ++parent.childrenErrorCount;
            }
            parent.fireNodeChange();
        }
    }

    private int getVisibleChildIndex(DocumentElement de) {
        int index = 0;
        for (DocumentElement child : this.getDocumentElement().getChildren()) {
            if (child.equals((Object)de)) {
                return index;
            }
            if (child.getType().equals("content") || child.getType().equals("error") || child.getType().equals("comment")) continue;
            ++index;
        }
        return -1;
    }

    public void elementRemoved(DocumentElementEvent e) {
        DocumentElement rde = e.getChangedChild();
        if (debug) {
            System.out.println(">>> -EVENT on " + this.hashCode() + " - " + this.de + ": element " + rde + " is going to be removed ");
        }
        if (rde.getType().equals("content")) {
            if (debug) {
                System.out.println(">>> removing CONTENT element");
            }
            Iterator i = this.textElements.iterator();
            ArrayList<TextElementWrapper> toRemove = new ArrayList<TextElementWrapper>();
            while (i.hasNext()) {
                TextElementWrapper tew = (TextElementWrapper)i.next();
                if (!rde.equals((Object)tew.getDocumentElement())) continue;
                toRemove.add(tew);
            }
            this.textElements.removeAll(toRemove);
            this.childTextElementChanged();
        } else if (rde.getType().equals("error")) {
            this.unmarkNodeAsError(this);
        } else if (!rde.getType().equals("comment")) {
            if (debug) {
                System.out.println(">>> removing tag element");
            }
            TreeNodeAdapter tn = this.getChildTreeNode(rde);
            int tnIndex = this.getIndex(tn);
            if (tn != null) {
                this.children.remove(tn);
                this.tm.nodesWereRemoved(this, new int[]{tnIndex}, new Object[]{tn});
            } else if (debug) {
                System.out.println("Warning: TreeNode for removed element doesn't exist!!!");
            }
        }
        if (debug) {
            System.out.println("<<<EVENT finished (node removed)");
        }
    }

    private void unmarkNodeAsError(TreeNodeAdapter tna) {
        tna.containsError = false;
        TreeNodeAdapter parent = tna;
        tna.fireNodeChange();
        while ((parent = (TreeNodeAdapter)parent.getParent()) != null) {
            if (parent.getParent() != null) {
                --parent.childrenErrorCount;
            }
            parent.fireNodeChange();
        }
    }

    public void attributesChanged(DocumentElementEvent e) {
        if (debug) {
            System.out.println("Attributes of treenode " + this + " has changed.");
        }
        this.fireNodeChange();
    }

    public void contentChanged(DocumentElementEvent e) {
        if (debug) {
            System.out.println("treenode " + this + " changed.");
        }
        this.fireNodeChange();
    }

    private synchronized void checkChildrenAdapters() {
        if (this.children == null) {
            this.de.addDocumentElementListener((DocumentElementListener)this);
            this.children = new ArrayList();
            Iterator i = this.de.getChildren().iterator();
            boolean textElementAdded = false;
            while (i.hasNext()) {
                DocumentElement chde = (DocumentElement)i.next();
                if (chde.getType().equals("content")) {
                    this.textElements.add(new TextElementWrapper(chde));
                    textElementAdded = true;
                    continue;
                }
                if (chde.getType().equals("error")) {
                    this.markNodeAsError(this);
                    continue;
                }
                if (chde.getType().equals("comment") || this.getChildTreeNode(chde) != null) continue;
                TreeNodeAdapter tna = new TreeNodeAdapter(chde, this.tm, this.tree, this);
                this.children.add(tna);
            }
            if (textElementAdded) {
                this.childTextElementChanged();
            }
        }
    }

    private void childTextElementChanged() {
        this.textContent = null;
        this.fireNodeChange();
    }

    private void checkDocumentContent() {
        if (this.textContent == null) {
            Iterator children = this.getDocumentElement().getChildren().iterator();
            StringBuffer buf = new StringBuffer();
            while (children.hasNext()) {
                DocumentElement del = (DocumentElement)children.next();
                if (!del.getType().equals("content")) continue;
                try {
                    int endOfs = del.getEndOffset() - del.getStartOffset();
                    endOfs = endOfs > del.getDocument().getLength() ? del.getDocument().getLength() : endOfs;
                    buf.append(del.getDocument().getText(del.getStartOffset(), endOfs).trim());
                }
                catch (BadLocationException e) {
                    buf.append("???");
                }
            }
            this.textContent = buf.length() == 0 ? EMPTY_STRING : buf.toString();
            this.fireNodeChange();
        }
    }

    private final class TextElementWrapper
    implements DocumentElementListener {
        private DocumentElement de;

        public TextElementWrapper(DocumentElement de) {
            this.de = de;
            de.addDocumentElementListener((DocumentElementListener)this);
        }

        public DocumentElement getDocumentElement() {
            return this.de;
        }

        public void contentChanged(DocumentElementEvent e) {
            TreeNodeAdapter.this.childTextElementChanged();
        }

        public void elementAdded(DocumentElementEvent e) {
            System.err.println("????? a child node added into a text element!!!!");
        }

        public void elementRemoved(DocumentElementEvent e) {
        }

        public void childrenReordered(DocumentElementEvent e) {
        }

        public void attributesChanged(DocumentElementEvent e) {
        }
    }
}

