/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.util.Objects;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.source.usages.DocumentUtil;

final class BinaryName {
    static final char PKG_SEPARATOR = '.';
    private final String binaryName;
    private final int pkgEnd;
    private final int simpleNameStart;

    private BinaryName(@NonNull String binaryName, int pkgEnd, int simpleNameStart) {
        assert (pkgEnd < binaryName.length() - 1) : binaryName;
        assert (pkgEnd != 0) : binaryName;
        assert (simpleNameStart < binaryName.length() - 1) : binaryName;
        assert (simpleNameStart > pkgEnd) : binaryName;
        this.binaryName = binaryName;
        this.pkgEnd = pkgEnd;
        this.simpleNameStart = simpleNameStart;
    }

    @NonNull
    String getBinaryName() {
        return this.binaryName.substring(0, this.binaryName.length() - 1);
    }

    @NonNull
    char getKind() {
        return this.binaryName.charAt(this.binaryName.length() - 1);
    }

    @NonNull
    String getPackage() {
        return this.pkgEnd > 0 ? this.binaryName.substring(0, this.pkgEnd) : "";
    }

    @NonNull
    String getClassName() {
        return this.pkgEnd > 0 ? this.binaryName.substring(this.pkgEnd + 1, this.binaryName.length() - 1) : this.binaryName.substring(0, this.binaryName.length() - 1);
    }

    @NonNull
    String getClassNameKind() {
        return this.pkgEnd > 0 ? this.binaryName.substring(this.pkgEnd + 1) : this.binaryName;
    }

    @NonNull
    String getSimpleName() {
        return this.binaryName.substring(this.simpleNameStart, this.binaryName.length() - 1);
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + Objects.hashCode(this.binaryName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryName other = (BinaryName)obj;
        if (this.pkgEnd != other.pkgEnd) {
            return false;
        }
        if (this.simpleNameStart != other.simpleNameStart) {
            return false;
        }
        return Objects.equals(this.binaryName, other.binaryName);
    }

    public String toString() {
        return String.format("BinaryName{binaryName=%s, package=%s, className=%s, simpleName=%s}", this.binaryName, this.getPackage(), this.getClassName(), this.getSimpleName());
    }

    @NonNull
    static BinaryName create(@NonNull String binaryName, @NonNull ElementKind kind) {
        int pkgEnd = binaryName.lastIndexOf(46);
        int simpleNameStart = binaryName.lastIndexOf(36);
        if (simpleNameStart < pkgEnd) {
            simpleNameStart = pkgEnd;
        }
        return new BinaryName(binaryName + DocumentUtil.encodeKind(kind), pkgEnd, ++simpleNameStart);
    }

    @NonNull
    static BinaryName create(@NonNull String binaryName, @NonNull ElementKind kind, boolean isLocal, int simpleNameStart) {
        int pkgEnd = binaryName.lastIndexOf(46, simpleNameStart);
        return new BinaryName(binaryName + DocumentUtil.encodeKind(kind, isLocal), pkgEnd, simpleNameStart);
    }
}

