/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ComputePerformanceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="cpuCoreCount")
    private final Integer cpuCoreCount;
    @JsonProperty(value="memoryInGBs")
    private final Double memoryInGBs;
    @JsonProperty(value="networkBandwidthInGbps")
    private final Float networkBandwidthInGbps;
    @JsonProperty(value="networkIops")
    private final Float networkIops;
    @JsonProperty(value="networkThroughputInMbps")
    private final Float networkThroughputInMbps;

    @Deprecated
    @ConstructorProperties(value={"cpuCoreCount", "memoryInGBs", "networkBandwidthInGbps", "networkIops", "networkThroughputInMbps"})
    public ComputePerformanceSummary(Integer cpuCoreCount, Double memoryInGBs, Float networkBandwidthInGbps, Float networkIops, Float networkThroughputInMbps) {
        this.cpuCoreCount = cpuCoreCount;
        this.memoryInGBs = memoryInGBs;
        this.networkBandwidthInGbps = networkBandwidthInGbps;
        this.networkIops = networkIops;
        this.networkThroughputInMbps = networkThroughputInMbps;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public Double getMemoryInGBs() {
        return this.memoryInGBs;
    }

    public Float getNetworkBandwidthInGbps() {
        return this.networkBandwidthInGbps;
    }

    public Float getNetworkIops() {
        return this.networkIops;
    }

    public Float getNetworkThroughputInMbps() {
        return this.networkThroughputInMbps;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ComputePerformanceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("cpuCoreCount=").append(String.valueOf(this.cpuCoreCount));
        sb.append(", memoryInGBs=").append(String.valueOf(this.memoryInGBs));
        sb.append(", networkBandwidthInGbps=").append(String.valueOf(this.networkBandwidthInGbps));
        sb.append(", networkIops=").append(String.valueOf(this.networkIops));
        sb.append(", networkThroughputInMbps=").append(String.valueOf(this.networkThroughputInMbps));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComputePerformanceSummary)) {
            return false;
        }
        ComputePerformanceSummary other = (ComputePerformanceSummary)((Object)o);
        return Objects.equals(this.cpuCoreCount, other.cpuCoreCount) && Objects.equals(this.memoryInGBs, other.memoryInGBs) && Objects.equals(this.networkBandwidthInGbps, other.networkBandwidthInGbps) && Objects.equals(this.networkIops, other.networkIops) && Objects.equals(this.networkThroughputInMbps, other.networkThroughputInMbps) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.cpuCoreCount == null ? 43 : this.cpuCoreCount.hashCode());
        result = result * 59 + (this.memoryInGBs == null ? 43 : this.memoryInGBs.hashCode());
        result = result * 59 + (this.networkBandwidthInGbps == null ? 43 : this.networkBandwidthInGbps.hashCode());
        result = result * 59 + (this.networkIops == null ? 43 : this.networkIops.hashCode());
        result = result * 59 + (this.networkThroughputInMbps == null ? 43 : this.networkThroughputInMbps.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="cpuCoreCount")
        private Integer cpuCoreCount;
        @JsonProperty(value="memoryInGBs")
        private Double memoryInGBs;
        @JsonProperty(value="networkBandwidthInGbps")
        private Float networkBandwidthInGbps;
        @JsonProperty(value="networkIops")
        private Float networkIops;
        @JsonProperty(value="networkThroughputInMbps")
        private Float networkThroughputInMbps;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            this.__explicitlySet__.add("cpuCoreCount");
            return this;
        }

        public Builder memoryInGBs(Double memoryInGBs) {
            this.memoryInGBs = memoryInGBs;
            this.__explicitlySet__.add("memoryInGBs");
            return this;
        }

        public Builder networkBandwidthInGbps(Float networkBandwidthInGbps) {
            this.networkBandwidthInGbps = networkBandwidthInGbps;
            this.__explicitlySet__.add("networkBandwidthInGbps");
            return this;
        }

        public Builder networkIops(Float networkIops) {
            this.networkIops = networkIops;
            this.__explicitlySet__.add("networkIops");
            return this;
        }

        public Builder networkThroughputInMbps(Float networkThroughputInMbps) {
            this.networkThroughputInMbps = networkThroughputInMbps;
            this.__explicitlySet__.add("networkThroughputInMbps");
            return this;
        }

        public ComputePerformanceSummary build() {
            ComputePerformanceSummary model = new ComputePerformanceSummary(this.cpuCoreCount, this.memoryInGBs, this.networkBandwidthInGbps, this.networkIops, this.networkThroughputInMbps);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ComputePerformanceSummary model) {
            if (model.wasPropertyExplicitlySet("cpuCoreCount")) {
                this.cpuCoreCount(model.getCpuCoreCount());
            }
            if (model.wasPropertyExplicitlySet("memoryInGBs")) {
                this.memoryInGBs(model.getMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("networkBandwidthInGbps")) {
                this.networkBandwidthInGbps(model.getNetworkBandwidthInGbps());
            }
            if (model.wasPropertyExplicitlySet("networkIops")) {
                this.networkIops(model.getNetworkIops());
            }
            if (model.wasPropertyExplicitlySet("networkThroughputInMbps")) {
                this.networkThroughputInMbps(model.getNetworkThroughputInMbps());
            }
            return this;
        }
    }
}

