/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ShrinkAutonomousDatabaseRequest
extends BmcRequest<Void> {
    private String autonomousDatabaseId;
    private String ifMatch;

    public String getAutonomousDatabaseId() {
        return this.autonomousDatabaseId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().autonomousDatabaseId(this.autonomousDatabaseId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",autonomousDatabaseId=").append(String.valueOf(this.autonomousDatabaseId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShrinkAutonomousDatabaseRequest)) {
            return false;
        }
        ShrinkAutonomousDatabaseRequest other = (ShrinkAutonomousDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.autonomousDatabaseId, other.autonomousDatabaseId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.autonomousDatabaseId == null ? 43 : this.autonomousDatabaseId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ShrinkAutonomousDatabaseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String autonomousDatabaseId = null;
        private String ifMatch = null;

        public Builder autonomousDatabaseId(String autonomousDatabaseId) {
            this.autonomousDatabaseId = autonomousDatabaseId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ShrinkAutonomousDatabaseRequest o) {
            this.autonomousDatabaseId(o.getAutonomousDatabaseId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ShrinkAutonomousDatabaseRequest build() {
            ShrinkAutonomousDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ShrinkAutonomousDatabaseRequest buildWithoutInvocationCallback() {
            ShrinkAutonomousDatabaseRequest request = new ShrinkAutonomousDatabaseRequest();
            request.autonomousDatabaseId = this.autonomousDatabaseId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

