/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.conversion.swing;

import java.util.ArrayList;
import javax.swing.ListSelectionModel;
import org.netbeans.validation.api.AbstractValidator;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.conversion.Converter;

public class SelectedIndicesToListSelectionModelConverter
extends Converter<Integer[], ListSelectionModel> {
    public SelectedIndicesToListSelectionModelConverter() {
        super(Integer[].class, ListSelectionModel.class);
    }

    public Validator<ListSelectionModel> convert(Validator<Integer[]> from) {
        return new V(from);
    }

    private static final class V
    extends AbstractValidator<ListSelectionModel> {
        private final Validator<Integer[]> wrapped;

        public V(Validator<Integer[]> wrapped) {
            super(ListSelectionModel.class);
            this.wrapped = wrapped;
        }

        public void validate(Problems problems, String compName, ListSelectionModel model) {
            if (model.isSelectionEmpty()) {
                this.wrapped.validate(problems, compName, (Object)new Integer[0]);
            } else {
                ArrayList<Integer> list = new ArrayList<Integer>(model.getMaxSelectionIndex() + 1 - model.getMinSelectionIndex());
                for (int i = model.getMinSelectionIndex(); i <= model.getMaxSelectionIndex(); ++i) {
                    if (!model.isSelectedIndex(i)) continue;
                    list.add(i);
                }
                this.wrapped.validate(problems, compName, (Object)list.toArray(new Integer[list.size()]));
            }
        }
    }
}

