/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp.editor.completion;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.completion.CompletionHandler;
import org.netbeans.modules.groovy.gsp.lexer.GspLexerLanguage;
import org.netbeans.modules.groovy.gsp.lexer.GspTokenId;

public class GspCompleter
extends CompletionHandler {
    public CodeCompletionResult complete(CodeCompletionContext context) {
        ParserResult info = context.getParserResult();
        int caretOffset = context.getCaretOffset();
        Document doc = info.getSnapshot().getSource().getDocument(false);
        if (doc != null && this.isGroovyCompletion(doc, caretOffset)) {
            return super.complete(context);
        }
        return CodeCompletionResult.NONE;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        int caretOffset;
        Document doc = component.getDocument();
        if (this.isGroovyCompletion(doc, caretOffset = component.getCaret().getDot())) {
            return super.getAutoQuery(component, typedText);
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    private boolean isGroovyCompletion(Document doc, int offset) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(GspLexerLanguage.getLanguage());
        tokenSequence.move(offset);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            GspTokenId tokenID = (GspTokenId)tokenSequence.token().id();
            if (tokenID.isGroovyContent()) {
                return true;
            }
            if (this.isGroovyEndTag(tokenID)) {
                tokenSequence.movePrevious();
                if (tokenID.isGroovyContent()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isGroovyEndTag(GspTokenId tokenID) {
        return tokenID == GspTokenId.GSTRING_END || tokenID == GspTokenId.SCRIPTLET_END || tokenID == GspTokenId.SCRIPTLET_OUTPUT_VALUE_END;
    }
}

