/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.netbeans.modules.java.graph.DependencyGraphScene;
import org.netbeans.modules.java.graph.EdgeWidget;
import org.netbeans.modules.java.graph.GraphEdge;
import org.netbeans.modules.java.graph.GraphNode;
import org.netbeans.modules.java.graph.GraphNodeImplementation;
import org.netbeans.modules.java.graph.GraphNodeVisitor;
import org.netbeans.modules.java.graph.NodeWidget;

class HighlightVisitor
implements GraphNodeVisitor {
    private final DependencyGraphScene scene;
    private final Stack<GraphNodeImplementation> path;
    private GraphNodeImplementation root;
    private int max = Integer.MAX_VALUE;
    private final Map<GraphNodeImplementation, Integer> node2Path;

    HighlightVisitor(DependencyGraphScene scene) {
        this.scene = scene;
        this.path = new Stack();
        this.node2Path = new HashMap<GraphNodeImplementation, Integer>();
    }

    public void setMaxDepth(int max) {
        this.max = max;
        this.node2Path.clear();
    }

    public boolean visit(GraphNodeImplementation node) {
        if (this.root == null) {
            this.root = node;
        }
        if (this.scene.isIncluded(node) && this.acceptDepth(node)) {
            this.path.push(node);
            this.node2Path.put(node, this.path.size());
            GraphNode grNode = this.scene.getGraphNodeRepresentant(node);
            if (grNode == null) {
                return false;
            }
            NodeWidget nw = (NodeWidget)this.scene.findWidget(grNode);
            Collection edges = this.scene.findNodeEdges(grNode, true, true);
            nw.setReadable(false);
            if (this.path.size() > this.max) {
                nw.setPaintState(1);
                for (GraphEdge e : edges) {
                    EdgeWidget ew = (EdgeWidget)this.scene.findWidget(e);
                    ew.setState(1);
                }
            } else {
                nw.setPaintState(2);
                for (GraphEdge e : edges) {
                    EdgeWidget ew = (EdgeWidget)this.scene.findWidget(e);
                    ew.setState(2);
                }
            }
            return true;
        }
        return false;
    }

    public boolean endVisit(GraphNodeImplementation node) {
        if (this.path.peek() == node) {
            this.path.pop();
        }
        return true;
    }

    private boolean acceptDepth(GraphNodeImplementation node) {
        Integer d = this.node2Path.get(node);
        if (d == null) {
            return true;
        }
        return this.path.size() < d;
    }
}

