// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package codeguruprofileriface provides an interface to enable mocking the Amazon CodeGuru Profiler service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package codeguruprofileriface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/codeguruprofiler"
)

// CodeGuruProfilerAPI provides an interface to enable mocking the
// codeguruprofiler.CodeGuruProfiler service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon CodeGuru Profiler.
//    func myFunc(svc codeguruprofileriface.CodeGuruProfilerAPI) bool {
//        // Make svc.ConfigureAgent request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := codeguruprofiler.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockCodeGuruProfilerClient struct {
//        codeguruprofileriface.CodeGuruProfilerAPI
//    }
//    func (m *mockCodeGuruProfilerClient) ConfigureAgent(input *codeguruprofiler.ConfigureAgentInput) (*codeguruprofiler.ConfigureAgentOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockCodeGuruProfilerClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type CodeGuruProfilerAPI interface {
	ConfigureAgent(*codeguruprofiler.ConfigureAgentInput) (*codeguruprofiler.ConfigureAgentOutput, error)
	ConfigureAgentWithContext(aws.Context, *codeguruprofiler.ConfigureAgentInput, ...request.Option) (*codeguruprofiler.ConfigureAgentOutput, error)
	ConfigureAgentRequest(*codeguruprofiler.ConfigureAgentInput) (*request.Request, *codeguruprofiler.ConfigureAgentOutput)

	CreateProfilingGroup(*codeguruprofiler.CreateProfilingGroupInput) (*codeguruprofiler.CreateProfilingGroupOutput, error)
	CreateProfilingGroupWithContext(aws.Context, *codeguruprofiler.CreateProfilingGroupInput, ...request.Option) (*codeguruprofiler.CreateProfilingGroupOutput, error)
	CreateProfilingGroupRequest(*codeguruprofiler.CreateProfilingGroupInput) (*request.Request, *codeguruprofiler.CreateProfilingGroupOutput)

	DeleteProfilingGroup(*codeguruprofiler.DeleteProfilingGroupInput) (*codeguruprofiler.DeleteProfilingGroupOutput, error)
	DeleteProfilingGroupWithContext(aws.Context, *codeguruprofiler.DeleteProfilingGroupInput, ...request.Option) (*codeguruprofiler.DeleteProfilingGroupOutput, error)
	DeleteProfilingGroupRequest(*codeguruprofiler.DeleteProfilingGroupInput) (*request.Request, *codeguruprofiler.DeleteProfilingGroupOutput)

	DescribeProfilingGroup(*codeguruprofiler.DescribeProfilingGroupInput) (*codeguruprofiler.DescribeProfilingGroupOutput, error)
	DescribeProfilingGroupWithContext(aws.Context, *codeguruprofiler.DescribeProfilingGroupInput, ...request.Option) (*codeguruprofiler.DescribeProfilingGroupOutput, error)
	DescribeProfilingGroupRequest(*codeguruprofiler.DescribeProfilingGroupInput) (*request.Request, *codeguruprofiler.DescribeProfilingGroupOutput)

	GetPolicy(*codeguruprofiler.GetPolicyInput) (*codeguruprofiler.GetPolicyOutput, error)
	GetPolicyWithContext(aws.Context, *codeguruprofiler.GetPolicyInput, ...request.Option) (*codeguruprofiler.GetPolicyOutput, error)
	GetPolicyRequest(*codeguruprofiler.GetPolicyInput) (*request.Request, *codeguruprofiler.GetPolicyOutput)

	GetProfile(*codeguruprofiler.GetProfileInput) (*codeguruprofiler.GetProfileOutput, error)
	GetProfileWithContext(aws.Context, *codeguruprofiler.GetProfileInput, ...request.Option) (*codeguruprofiler.GetProfileOutput, error)
	GetProfileRequest(*codeguruprofiler.GetProfileInput) (*request.Request, *codeguruprofiler.GetProfileOutput)

	ListProfileTimes(*codeguruprofiler.ListProfileTimesInput) (*codeguruprofiler.ListProfileTimesOutput, error)
	ListProfileTimesWithContext(aws.Context, *codeguruprofiler.ListProfileTimesInput, ...request.Option) (*codeguruprofiler.ListProfileTimesOutput, error)
	ListProfileTimesRequest(*codeguruprofiler.ListProfileTimesInput) (*request.Request, *codeguruprofiler.ListProfileTimesOutput)

	ListProfileTimesPages(*codeguruprofiler.ListProfileTimesInput, func(*codeguruprofiler.ListProfileTimesOutput, bool) bool) error
	ListProfileTimesPagesWithContext(aws.Context, *codeguruprofiler.ListProfileTimesInput, func(*codeguruprofiler.ListProfileTimesOutput, bool) bool, ...request.Option) error

	ListProfilingGroups(*codeguruprofiler.ListProfilingGroupsInput) (*codeguruprofiler.ListProfilingGroupsOutput, error)
	ListProfilingGroupsWithContext(aws.Context, *codeguruprofiler.ListProfilingGroupsInput, ...request.Option) (*codeguruprofiler.ListProfilingGroupsOutput, error)
	ListProfilingGroupsRequest(*codeguruprofiler.ListProfilingGroupsInput) (*request.Request, *codeguruprofiler.ListProfilingGroupsOutput)

	ListProfilingGroupsPages(*codeguruprofiler.ListProfilingGroupsInput, func(*codeguruprofiler.ListProfilingGroupsOutput, bool) bool) error
	ListProfilingGroupsPagesWithContext(aws.Context, *codeguruprofiler.ListProfilingGroupsInput, func(*codeguruprofiler.ListProfilingGroupsOutput, bool) bool, ...request.Option) error

	PostAgentProfile(*codeguruprofiler.PostAgentProfileInput) (*codeguruprofiler.PostAgentProfileOutput, error)
	PostAgentProfileWithContext(aws.Context, *codeguruprofiler.PostAgentProfileInput, ...request.Option) (*codeguruprofiler.PostAgentProfileOutput, error)
	PostAgentProfileRequest(*codeguruprofiler.PostAgentProfileInput) (*request.Request, *codeguruprofiler.PostAgentProfileOutput)

	PutPermission(*codeguruprofiler.PutPermissionInput) (*codeguruprofiler.PutPermissionOutput, error)
	PutPermissionWithContext(aws.Context, *codeguruprofiler.PutPermissionInput, ...request.Option) (*codeguruprofiler.PutPermissionOutput, error)
	PutPermissionRequest(*codeguruprofiler.PutPermissionInput) (*request.Request, *codeguruprofiler.PutPermissionOutput)

	RemovePermission(*codeguruprofiler.RemovePermissionInput) (*codeguruprofiler.RemovePermissionOutput, error)
	RemovePermissionWithContext(aws.Context, *codeguruprofiler.RemovePermissionInput, ...request.Option) (*codeguruprofiler.RemovePermissionOutput, error)
	RemovePermissionRequest(*codeguruprofiler.RemovePermissionInput) (*request.Request, *codeguruprofiler.RemovePermissionOutput)

	UpdateProfilingGroup(*codeguruprofiler.UpdateProfilingGroupInput) (*codeguruprofiler.UpdateProfilingGroupOutput, error)
	UpdateProfilingGroupWithContext(aws.Context, *codeguruprofiler.UpdateProfilingGroupInput, ...request.Option) (*codeguruprofiler.UpdateProfilingGroupOutput, error)
	UpdateProfilingGroupRequest(*codeguruprofiler.UpdateProfilingGroupInput) (*request.Request, *codeguruprofiler.UpdateProfilingGroupOutput)
}

var _ CodeGuruProfilerAPI = (*codeguruprofiler.CodeGuruProfiler)(nil)
