// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestarconnections

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateConnection = "CreateConnection"

// CreateConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnection for more information on using the CreateConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConnectionRequest method.
//	req, resp := client.CreateConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateConnection
func (c *CodeStarConnections) CreateConnectionRequest(input *CreateConnectionInput) (req *request.Request, output *CreateConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectionInput{}
	}

	output = &CreateConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnection API operation for AWS CodeStar connections.
//
// Creates a connection that can then be given to other Amazon Web Services
// services like CodePipeline so that it can access third-party code repositories.
// The connection is in pending status until the third-party connection handshake
// is completed from the console.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation CreateConnection for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     Exceeded the maximum limit for connections.
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ResourceUnavailableException
//     Resource not found. Verify the ARN for the host resource and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateConnection
func (c *CodeStarConnections) CreateConnection(input *CreateConnectionInput) (*CreateConnectionOutput, error) {
	req, out := c.CreateConnectionRequest(input)
	return out, req.Send()
}

// CreateConnectionWithContext is the same as CreateConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) CreateConnectionWithContext(ctx aws.Context, input *CreateConnectionInput, opts ...request.Option) (*CreateConnectionOutput, error) {
	req, out := c.CreateConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHost = "CreateHost"

// CreateHostRequest generates a "aws/request.Request" representing the
// client's request for the CreateHost operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHost for more information on using the CreateHost
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateHostRequest method.
//	req, resp := client.CreateHostRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateHost
func (c *CodeStarConnections) CreateHostRequest(input *CreateHostInput) (req *request.Request, output *CreateHostOutput) {
	op := &request.Operation{
		Name:       opCreateHost,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHostInput{}
	}

	output = &CreateHostOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHost API operation for AWS CodeStar connections.
//
// Creates a resource that represents the infrastructure where a third-party
// provider is installed. The host is used when you create connections to an
// installed third-party provider type, such as GitHub Enterprise Server. You
// create one host for all connections to that provider.
//
// A host created through the CLI or the SDK is in `PENDING` status by default.
// You can make its status `AVAILABLE` by setting up the host in the console.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation CreateHost for usage and error information.
//
// Returned Error Types:
//   - LimitExceededException
//     Exceeded the maximum limit for connections.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateHost
func (c *CodeStarConnections) CreateHost(input *CreateHostInput) (*CreateHostOutput, error) {
	req, out := c.CreateHostRequest(input)
	return out, req.Send()
}

// CreateHostWithContext is the same as CreateHost with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHost for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) CreateHostWithContext(ctx aws.Context, input *CreateHostInput, opts ...request.Option) (*CreateHostOutput, error) {
	req, out := c.CreateHostRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRepositoryLink = "CreateRepositoryLink"

// CreateRepositoryLinkRequest generates a "aws/request.Request" representing the
// client's request for the CreateRepositoryLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRepositoryLink for more information on using the CreateRepositoryLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRepositoryLinkRequest method.
//	req, resp := client.CreateRepositoryLinkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateRepositoryLink
func (c *CodeStarConnections) CreateRepositoryLinkRequest(input *CreateRepositoryLinkInput) (req *request.Request, output *CreateRepositoryLinkOutput) {
	op := &request.Operation{
		Name:       opCreateRepositoryLink,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRepositoryLinkInput{}
	}

	output = &CreateRepositoryLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRepositoryLink API operation for AWS CodeStar connections.
//
// Creates a link to a specified external Git repository. A repository link
// allows Git sync to monitor and sync changes to files in a specified Git repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation CreateRepositoryLink for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConcurrentModificationException
//     Exception thrown as a result of concurrent modification to an application.
//     For example, two individuals attempting to edit the same application at the
//     same time.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - LimitExceededException
//     Exceeded the maximum limit for connections.
//
//   - ResourceAlreadyExistsException
//     Unable to create resource. Resource already exists.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateRepositoryLink
func (c *CodeStarConnections) CreateRepositoryLink(input *CreateRepositoryLinkInput) (*CreateRepositoryLinkOutput, error) {
	req, out := c.CreateRepositoryLinkRequest(input)
	return out, req.Send()
}

// CreateRepositoryLinkWithContext is the same as CreateRepositoryLink with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRepositoryLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) CreateRepositoryLinkWithContext(ctx aws.Context, input *CreateRepositoryLinkInput, opts ...request.Option) (*CreateRepositoryLinkOutput, error) {
	req, out := c.CreateRepositoryLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSyncConfiguration = "CreateSyncConfiguration"

// CreateSyncConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateSyncConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSyncConfiguration for more information on using the CreateSyncConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSyncConfigurationRequest method.
//	req, resp := client.CreateSyncConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateSyncConfiguration
func (c *CodeStarConnections) CreateSyncConfigurationRequest(input *CreateSyncConfigurationInput) (req *request.Request, output *CreateSyncConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateSyncConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSyncConfigurationInput{}
	}

	output = &CreateSyncConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSyncConfiguration API operation for AWS CodeStar connections.
//
// Creates a sync configuration which allows Amazon Web Services to sync content
// from a Git repository to update a specified Amazon Web Services resource.
// Parameters for the sync configuration are determined by the sync type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation CreateSyncConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConcurrentModificationException
//     Exception thrown as a result of concurrent modification to an application.
//     For example, two individuals attempting to edit the same application at the
//     same time.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - LimitExceededException
//     Exceeded the maximum limit for connections.
//
//   - ResourceAlreadyExistsException
//     Unable to create resource. Resource already exists.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateSyncConfiguration
func (c *CodeStarConnections) CreateSyncConfiguration(input *CreateSyncConfigurationInput) (*CreateSyncConfigurationOutput, error) {
	req, out := c.CreateSyncConfigurationRequest(input)
	return out, req.Send()
}

// CreateSyncConfigurationWithContext is the same as CreateSyncConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSyncConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) CreateSyncConfigurationWithContext(ctx aws.Context, input *CreateSyncConfigurationInput, opts ...request.Option) (*CreateSyncConfigurationOutput, error) {
	req, out := c.CreateSyncConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnection = "DeleteConnection"

// DeleteConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnection for more information on using the DeleteConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConnectionRequest method.
//	req, resp := client.DeleteConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteConnection
func (c *CodeStarConnections) DeleteConnectionRequest(input *DeleteConnectionInput) (req *request.Request, output *DeleteConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectionInput{}
	}

	output = &DeleteConnectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConnection API operation for AWS CodeStar connections.
//
// The connection to be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation DeleteConnection for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteConnection
func (c *CodeStarConnections) DeleteConnection(input *DeleteConnectionInput) (*DeleteConnectionOutput, error) {
	req, out := c.DeleteConnectionRequest(input)
	return out, req.Send()
}

// DeleteConnectionWithContext is the same as DeleteConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) DeleteConnectionWithContext(ctx aws.Context, input *DeleteConnectionInput, opts ...request.Option) (*DeleteConnectionOutput, error) {
	req, out := c.DeleteConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteHost = "DeleteHost"

// DeleteHostRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHost operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteHost for more information on using the DeleteHost
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteHostRequest method.
//	req, resp := client.DeleteHostRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteHost
func (c *CodeStarConnections) DeleteHostRequest(input *DeleteHostInput) (req *request.Request, output *DeleteHostOutput) {
	op := &request.Operation{
		Name:       opDeleteHost,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHostInput{}
	}

	output = &DeleteHostOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteHost API operation for AWS CodeStar connections.
//
// The host to be deleted. Before you delete a host, all connections associated
// to the host must be deleted.
//
// A host cannot be deleted if it is in the VPC_CONFIG_INITIALIZING or VPC_CONFIG_DELETING
// state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation DeleteHost for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ResourceUnavailableException
//     Resource not found. Verify the ARN for the host resource and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteHost
func (c *CodeStarConnections) DeleteHost(input *DeleteHostInput) (*DeleteHostOutput, error) {
	req, out := c.DeleteHostRequest(input)
	return out, req.Send()
}

// DeleteHostWithContext is the same as DeleteHost with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteHost for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) DeleteHostWithContext(ctx aws.Context, input *DeleteHostInput, opts ...request.Option) (*DeleteHostOutput, error) {
	req, out := c.DeleteHostRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRepositoryLink = "DeleteRepositoryLink"

// DeleteRepositoryLinkRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRepositoryLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRepositoryLink for more information on using the DeleteRepositoryLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRepositoryLinkRequest method.
//	req, resp := client.DeleteRepositoryLinkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteRepositoryLink
func (c *CodeStarConnections) DeleteRepositoryLinkRequest(input *DeleteRepositoryLinkInput) (req *request.Request, output *DeleteRepositoryLinkOutput) {
	op := &request.Operation{
		Name:       opDeleteRepositoryLink,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRepositoryLinkInput{}
	}

	output = &DeleteRepositoryLinkOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRepositoryLink API operation for AWS CodeStar connections.
//
// Deletes the association between your connection and a specified external
// Git repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation DeleteRepositoryLink for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConcurrentModificationException
//     Exception thrown as a result of concurrent modification to an application.
//     For example, two individuals attempting to edit the same application at the
//     same time.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - SyncConfigurationStillExistsException
//     Unable to continue. The sync blocker still exists.
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UnsupportedProviderTypeException
//     The specified provider type is not supported for connections.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteRepositoryLink
func (c *CodeStarConnections) DeleteRepositoryLink(input *DeleteRepositoryLinkInput) (*DeleteRepositoryLinkOutput, error) {
	req, out := c.DeleteRepositoryLinkRequest(input)
	return out, req.Send()
}

// DeleteRepositoryLinkWithContext is the same as DeleteRepositoryLink with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRepositoryLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) DeleteRepositoryLinkWithContext(ctx aws.Context, input *DeleteRepositoryLinkInput, opts ...request.Option) (*DeleteRepositoryLinkOutput, error) {
	req, out := c.DeleteRepositoryLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSyncConfiguration = "DeleteSyncConfiguration"

// DeleteSyncConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSyncConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSyncConfiguration for more information on using the DeleteSyncConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSyncConfigurationRequest method.
//	req, resp := client.DeleteSyncConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteSyncConfiguration
func (c *CodeStarConnections) DeleteSyncConfigurationRequest(input *DeleteSyncConfigurationInput) (req *request.Request, output *DeleteSyncConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteSyncConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSyncConfigurationInput{}
	}

	output = &DeleteSyncConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSyncConfiguration API operation for AWS CodeStar connections.
//
// Deletes the sync configuration for a specified repository and connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation DeleteSyncConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConcurrentModificationException
//     Exception thrown as a result of concurrent modification to an application.
//     For example, two individuals attempting to edit the same application at the
//     same time.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - LimitExceededException
//     Exceeded the maximum limit for connections.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteSyncConfiguration
func (c *CodeStarConnections) DeleteSyncConfiguration(input *DeleteSyncConfigurationInput) (*DeleteSyncConfigurationOutput, error) {
	req, out := c.DeleteSyncConfigurationRequest(input)
	return out, req.Send()
}

// DeleteSyncConfigurationWithContext is the same as DeleteSyncConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSyncConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) DeleteSyncConfigurationWithContext(ctx aws.Context, input *DeleteSyncConfigurationInput, opts ...request.Option) (*DeleteSyncConfigurationOutput, error) {
	req, out := c.DeleteSyncConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnection = "GetConnection"

// GetConnectionRequest generates a "aws/request.Request" representing the
// client's request for the GetConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnection for more information on using the GetConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConnectionRequest method.
//	req, resp := client.GetConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetConnection
func (c *CodeStarConnections) GetConnectionRequest(input *GetConnectionInput) (req *request.Request, output *GetConnectionOutput) {
	op := &request.Operation{
		Name:       opGetConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConnectionInput{}
	}

	output = &GetConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnection API operation for AWS CodeStar connections.
//
// Returns the connection ARN and details such as status, owner, and provider
// type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation GetConnection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ResourceUnavailableException
//     Resource not found. Verify the ARN for the host resource and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetConnection
func (c *CodeStarConnections) GetConnection(input *GetConnectionInput) (*GetConnectionOutput, error) {
	req, out := c.GetConnectionRequest(input)
	return out, req.Send()
}

// GetConnectionWithContext is the same as GetConnection with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) GetConnectionWithContext(ctx aws.Context, input *GetConnectionInput, opts ...request.Option) (*GetConnectionOutput, error) {
	req, out := c.GetConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetHost = "GetHost"

// GetHostRequest generates a "aws/request.Request" representing the
// client's request for the GetHost operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetHost for more information on using the GetHost
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetHostRequest method.
//	req, resp := client.GetHostRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetHost
func (c *CodeStarConnections) GetHostRequest(input *GetHostInput) (req *request.Request, output *GetHostOutput) {
	op := &request.Operation{
		Name:       opGetHost,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetHostInput{}
	}

	output = &GetHostOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetHost API operation for AWS CodeStar connections.
//
// Returns the host ARN and details such as status, provider type, endpoint,
// and, if applicable, the VPC configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation GetHost for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ResourceUnavailableException
//     Resource not found. Verify the ARN for the host resource and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetHost
func (c *CodeStarConnections) GetHost(input *GetHostInput) (*GetHostOutput, error) {
	req, out := c.GetHostRequest(input)
	return out, req.Send()
}

// GetHostWithContext is the same as GetHost with the addition of
// the ability to pass a context and additional request options.
//
// See GetHost for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) GetHostWithContext(ctx aws.Context, input *GetHostInput, opts ...request.Option) (*GetHostOutput, error) {
	req, out := c.GetHostRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRepositoryLink = "GetRepositoryLink"

// GetRepositoryLinkRequest generates a "aws/request.Request" representing the
// client's request for the GetRepositoryLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRepositoryLink for more information on using the GetRepositoryLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRepositoryLinkRequest method.
//	req, resp := client.GetRepositoryLinkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetRepositoryLink
func (c *CodeStarConnections) GetRepositoryLinkRequest(input *GetRepositoryLinkInput) (req *request.Request, output *GetRepositoryLinkOutput) {
	op := &request.Operation{
		Name:       opGetRepositoryLink,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositoryLinkInput{}
	}

	output = &GetRepositoryLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRepositoryLink API operation for AWS CodeStar connections.
//
// Returns details about a repository link. A repository link allows Git sync
// to monitor and sync changes from files in a specified Git repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation GetRepositoryLink for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConcurrentModificationException
//     Exception thrown as a result of concurrent modification to an application.
//     For example, two individuals attempting to edit the same application at the
//     same time.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetRepositoryLink
func (c *CodeStarConnections) GetRepositoryLink(input *GetRepositoryLinkInput) (*GetRepositoryLinkOutput, error) {
	req, out := c.GetRepositoryLinkRequest(input)
	return out, req.Send()
}

// GetRepositoryLinkWithContext is the same as GetRepositoryLink with the addition of
// the ability to pass a context and additional request options.
//
// See GetRepositoryLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) GetRepositoryLinkWithContext(ctx aws.Context, input *GetRepositoryLinkInput, opts ...request.Option) (*GetRepositoryLinkOutput, error) {
	req, out := c.GetRepositoryLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRepositorySyncStatus = "GetRepositorySyncStatus"

// GetRepositorySyncStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetRepositorySyncStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRepositorySyncStatus for more information on using the GetRepositorySyncStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRepositorySyncStatusRequest method.
//	req, resp := client.GetRepositorySyncStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetRepositorySyncStatus
func (c *CodeStarConnections) GetRepositorySyncStatusRequest(input *GetRepositorySyncStatusInput) (req *request.Request, output *GetRepositorySyncStatusOutput) {
	op := &request.Operation{
		Name:       opGetRepositorySyncStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositorySyncStatusInput{}
	}

	output = &GetRepositorySyncStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRepositorySyncStatus API operation for AWS CodeStar connections.
//
// Returns details about the sync status for a repository. A repository sync
// uses Git sync to push and pull changes from your remote repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation GetRepositorySyncStatus for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetRepositorySyncStatus
func (c *CodeStarConnections) GetRepositorySyncStatus(input *GetRepositorySyncStatusInput) (*GetRepositorySyncStatusOutput, error) {
	req, out := c.GetRepositorySyncStatusRequest(input)
	return out, req.Send()
}

// GetRepositorySyncStatusWithContext is the same as GetRepositorySyncStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetRepositorySyncStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) GetRepositorySyncStatusWithContext(ctx aws.Context, input *GetRepositorySyncStatusInput, opts ...request.Option) (*GetRepositorySyncStatusOutput, error) {
	req, out := c.GetRepositorySyncStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceSyncStatus = "GetResourceSyncStatus"

// GetResourceSyncStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceSyncStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceSyncStatus for more information on using the GetResourceSyncStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourceSyncStatusRequest method.
//	req, resp := client.GetResourceSyncStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetResourceSyncStatus
func (c *CodeStarConnections) GetResourceSyncStatusRequest(input *GetResourceSyncStatusInput) (req *request.Request, output *GetResourceSyncStatusOutput) {
	op := &request.Operation{
		Name:       opGetResourceSyncStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourceSyncStatusInput{}
	}

	output = &GetResourceSyncStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceSyncStatus API operation for AWS CodeStar connections.
//
// Returns the status of the sync with the Git repository for a specific Amazon
// Web Services resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation GetResourceSyncStatus for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetResourceSyncStatus
func (c *CodeStarConnections) GetResourceSyncStatus(input *GetResourceSyncStatusInput) (*GetResourceSyncStatusOutput, error) {
	req, out := c.GetResourceSyncStatusRequest(input)
	return out, req.Send()
}

// GetResourceSyncStatusWithContext is the same as GetResourceSyncStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceSyncStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) GetResourceSyncStatusWithContext(ctx aws.Context, input *GetResourceSyncStatusInput, opts ...request.Option) (*GetResourceSyncStatusOutput, error) {
	req, out := c.GetResourceSyncStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSyncBlockerSummary = "GetSyncBlockerSummary"

// GetSyncBlockerSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetSyncBlockerSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSyncBlockerSummary for more information on using the GetSyncBlockerSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSyncBlockerSummaryRequest method.
//	req, resp := client.GetSyncBlockerSummaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetSyncBlockerSummary
func (c *CodeStarConnections) GetSyncBlockerSummaryRequest(input *GetSyncBlockerSummaryInput) (req *request.Request, output *GetSyncBlockerSummaryOutput) {
	op := &request.Operation{
		Name:       opGetSyncBlockerSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSyncBlockerSummaryInput{}
	}

	output = &GetSyncBlockerSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSyncBlockerSummary API operation for AWS CodeStar connections.
//
// Returns a list of the most recent sync blockers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation GetSyncBlockerSummary for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetSyncBlockerSummary
func (c *CodeStarConnections) GetSyncBlockerSummary(input *GetSyncBlockerSummaryInput) (*GetSyncBlockerSummaryOutput, error) {
	req, out := c.GetSyncBlockerSummaryRequest(input)
	return out, req.Send()
}

// GetSyncBlockerSummaryWithContext is the same as GetSyncBlockerSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetSyncBlockerSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) GetSyncBlockerSummaryWithContext(ctx aws.Context, input *GetSyncBlockerSummaryInput, opts ...request.Option) (*GetSyncBlockerSummaryOutput, error) {
	req, out := c.GetSyncBlockerSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSyncConfiguration = "GetSyncConfiguration"

// GetSyncConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetSyncConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSyncConfiguration for more information on using the GetSyncConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSyncConfigurationRequest method.
//	req, resp := client.GetSyncConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetSyncConfiguration
func (c *CodeStarConnections) GetSyncConfigurationRequest(input *GetSyncConfigurationInput) (req *request.Request, output *GetSyncConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetSyncConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSyncConfigurationInput{}
	}

	output = &GetSyncConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSyncConfiguration API operation for AWS CodeStar connections.
//
// Returns details about a sync configuration, including the sync type and resource
// name. A sync configuration allows the configuration to sync (push and pull)
// changes from the remote repository for a specified branch in a Git repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation GetSyncConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetSyncConfiguration
func (c *CodeStarConnections) GetSyncConfiguration(input *GetSyncConfigurationInput) (*GetSyncConfigurationOutput, error) {
	req, out := c.GetSyncConfigurationRequest(input)
	return out, req.Send()
}

// GetSyncConfigurationWithContext is the same as GetSyncConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetSyncConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) GetSyncConfigurationWithContext(ctx aws.Context, input *GetSyncConfigurationInput, opts ...request.Option) (*GetSyncConfigurationOutput, error) {
	req, out := c.GetSyncConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConnections = "ListConnections"

// ListConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConnections for more information on using the ListConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListConnectionsRequest method.
//	req, resp := client.ListConnectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListConnections
func (c *CodeStarConnections) ListConnectionsRequest(input *ListConnectionsInput) (req *request.Request, output *ListConnectionsOutput) {
	op := &request.Operation{
		Name:       opListConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConnectionsInput{}
	}

	output = &ListConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConnections API operation for AWS CodeStar connections.
//
// Lists the connections associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation ListConnections for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListConnections
func (c *CodeStarConnections) ListConnections(input *ListConnectionsInput) (*ListConnectionsOutput, error) {
	req, out := c.ListConnectionsRequest(input)
	return out, req.Send()
}

// ListConnectionsWithContext is the same as ListConnections with the addition of
// the ability to pass a context and additional request options.
//
// See ListConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) ListConnectionsWithContext(ctx aws.Context, input *ListConnectionsInput, opts ...request.Option) (*ListConnectionsOutput, error) {
	req, out := c.ListConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConnectionsPages iterates over the pages of a ListConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListConnections operation.
//	pageNum := 0
//	err := client.ListConnectionsPages(params,
//	    func(page *codestarconnections.ListConnectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodeStarConnections) ListConnectionsPages(input *ListConnectionsInput, fn func(*ListConnectionsOutput, bool) bool) error {
	return c.ListConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConnectionsPagesWithContext same as ListConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) ListConnectionsPagesWithContext(ctx aws.Context, input *ListConnectionsInput, fn func(*ListConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListHosts = "ListHosts"

// ListHostsRequest generates a "aws/request.Request" representing the
// client's request for the ListHosts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHosts for more information on using the ListHosts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListHostsRequest method.
//	req, resp := client.ListHostsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListHosts
func (c *CodeStarConnections) ListHostsRequest(input *ListHostsInput) (req *request.Request, output *ListHostsOutput) {
	op := &request.Operation{
		Name:       opListHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHostsInput{}
	}

	output = &ListHostsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHosts API operation for AWS CodeStar connections.
//
// Lists the hosts associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation ListHosts for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListHosts
func (c *CodeStarConnections) ListHosts(input *ListHostsInput) (*ListHostsOutput, error) {
	req, out := c.ListHostsRequest(input)
	return out, req.Send()
}

// ListHostsWithContext is the same as ListHosts with the addition of
// the ability to pass a context and additional request options.
//
// See ListHosts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) ListHostsWithContext(ctx aws.Context, input *ListHostsInput, opts ...request.Option) (*ListHostsOutput, error) {
	req, out := c.ListHostsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHostsPages iterates over the pages of a ListHosts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHosts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListHosts operation.
//	pageNum := 0
//	err := client.ListHostsPages(params,
//	    func(page *codestarconnections.ListHostsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodeStarConnections) ListHostsPages(input *ListHostsInput, fn func(*ListHostsOutput, bool) bool) error {
	return c.ListHostsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHostsPagesWithContext same as ListHostsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) ListHostsPagesWithContext(ctx aws.Context, input *ListHostsInput, fn func(*ListHostsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHostsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHostsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHostsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRepositoryLinks = "ListRepositoryLinks"

// ListRepositoryLinksRequest generates a "aws/request.Request" representing the
// client's request for the ListRepositoryLinks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRepositoryLinks for more information on using the ListRepositoryLinks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRepositoryLinksRequest method.
//	req, resp := client.ListRepositoryLinksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListRepositoryLinks
func (c *CodeStarConnections) ListRepositoryLinksRequest(input *ListRepositoryLinksInput) (req *request.Request, output *ListRepositoryLinksOutput) {
	op := &request.Operation{
		Name:       opListRepositoryLinks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositoryLinksInput{}
	}

	output = &ListRepositoryLinksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRepositoryLinks API operation for AWS CodeStar connections.
//
// Lists the repository links created for connections in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation ListRepositoryLinks for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConcurrentModificationException
//     Exception thrown as a result of concurrent modification to an application.
//     For example, two individuals attempting to edit the same application at the
//     same time.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListRepositoryLinks
func (c *CodeStarConnections) ListRepositoryLinks(input *ListRepositoryLinksInput) (*ListRepositoryLinksOutput, error) {
	req, out := c.ListRepositoryLinksRequest(input)
	return out, req.Send()
}

// ListRepositoryLinksWithContext is the same as ListRepositoryLinks with the addition of
// the ability to pass a context and additional request options.
//
// See ListRepositoryLinks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) ListRepositoryLinksWithContext(ctx aws.Context, input *ListRepositoryLinksInput, opts ...request.Option) (*ListRepositoryLinksOutput, error) {
	req, out := c.ListRepositoryLinksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRepositoryLinksPages iterates over the pages of a ListRepositoryLinks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRepositoryLinks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRepositoryLinks operation.
//	pageNum := 0
//	err := client.ListRepositoryLinksPages(params,
//	    func(page *codestarconnections.ListRepositoryLinksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodeStarConnections) ListRepositoryLinksPages(input *ListRepositoryLinksInput, fn func(*ListRepositoryLinksOutput, bool) bool) error {
	return c.ListRepositoryLinksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRepositoryLinksPagesWithContext same as ListRepositoryLinksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) ListRepositoryLinksPagesWithContext(ctx aws.Context, input *ListRepositoryLinksInput, fn func(*ListRepositoryLinksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRepositoryLinksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRepositoryLinksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRepositoryLinksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRepositorySyncDefinitions = "ListRepositorySyncDefinitions"

// ListRepositorySyncDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListRepositorySyncDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRepositorySyncDefinitions for more information on using the ListRepositorySyncDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRepositorySyncDefinitionsRequest method.
//	req, resp := client.ListRepositorySyncDefinitionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListRepositorySyncDefinitions
func (c *CodeStarConnections) ListRepositorySyncDefinitionsRequest(input *ListRepositorySyncDefinitionsInput) (req *request.Request, output *ListRepositorySyncDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListRepositorySyncDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRepositorySyncDefinitionsInput{}
	}

	output = &ListRepositorySyncDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRepositorySyncDefinitions API operation for AWS CodeStar connections.
//
// Lists the repository sync definitions for repository links in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation ListRepositorySyncDefinitions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListRepositorySyncDefinitions
func (c *CodeStarConnections) ListRepositorySyncDefinitions(input *ListRepositorySyncDefinitionsInput) (*ListRepositorySyncDefinitionsOutput, error) {
	req, out := c.ListRepositorySyncDefinitionsRequest(input)
	return out, req.Send()
}

// ListRepositorySyncDefinitionsWithContext is the same as ListRepositorySyncDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListRepositorySyncDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) ListRepositorySyncDefinitionsWithContext(ctx aws.Context, input *ListRepositorySyncDefinitionsInput, opts ...request.Option) (*ListRepositorySyncDefinitionsOutput, error) {
	req, out := c.ListRepositorySyncDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSyncConfigurations = "ListSyncConfigurations"

// ListSyncConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListSyncConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSyncConfigurations for more information on using the ListSyncConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSyncConfigurationsRequest method.
//	req, resp := client.ListSyncConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListSyncConfigurations
func (c *CodeStarConnections) ListSyncConfigurationsRequest(input *ListSyncConfigurationsInput) (req *request.Request, output *ListSyncConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListSyncConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSyncConfigurationsInput{}
	}

	output = &ListSyncConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSyncConfigurations API operation for AWS CodeStar connections.
//
// Returns a list of sync configurations for a specified repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation ListSyncConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListSyncConfigurations
func (c *CodeStarConnections) ListSyncConfigurations(input *ListSyncConfigurationsInput) (*ListSyncConfigurationsOutput, error) {
	req, out := c.ListSyncConfigurationsRequest(input)
	return out, req.Send()
}

// ListSyncConfigurationsWithContext is the same as ListSyncConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListSyncConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) ListSyncConfigurationsWithContext(ctx aws.Context, input *ListSyncConfigurationsInput, opts ...request.Option) (*ListSyncConfigurationsOutput, error) {
	req, out := c.ListSyncConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSyncConfigurationsPages iterates over the pages of a ListSyncConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSyncConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSyncConfigurations operation.
//	pageNum := 0
//	err := client.ListSyncConfigurationsPages(params,
//	    func(page *codestarconnections.ListSyncConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodeStarConnections) ListSyncConfigurationsPages(input *ListSyncConfigurationsInput, fn func(*ListSyncConfigurationsOutput, bool) bool) error {
	return c.ListSyncConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSyncConfigurationsPagesWithContext same as ListSyncConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) ListSyncConfigurationsPagesWithContext(ctx aws.Context, input *ListSyncConfigurationsInput, fn func(*ListSyncConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSyncConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSyncConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSyncConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListTagsForResource
func (c *CodeStarConnections) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS CodeStar connections.
//
// Gets the set of key-value pairs (metadata) that are used to manage the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListTagsForResource
func (c *CodeStarConnections) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/TagResource
func (c *CodeStarConnections) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS CodeStar connections.
//
// Adds to or modifies the tags of the given resource. Tags are metadata that
// can be used to manage a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - LimitExceededException
//     Exceeded the maximum limit for connections.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/TagResource
func (c *CodeStarConnections) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UntagResource
func (c *CodeStarConnections) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS CodeStar connections.
//
// Removes tags from an Amazon Web Services resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UntagResource
func (c *CodeStarConnections) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateHost = "UpdateHost"

// UpdateHostRequest generates a "aws/request.Request" representing the
// client's request for the UpdateHost operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateHost for more information on using the UpdateHost
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateHostRequest method.
//	req, resp := client.UpdateHostRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateHost
func (c *CodeStarConnections) UpdateHostRequest(input *UpdateHostInput) (req *request.Request, output *UpdateHostOutput) {
	op := &request.Operation{
		Name:       opUpdateHost,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateHostInput{}
	}

	output = &UpdateHostOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateHost API operation for AWS CodeStar connections.
//
// Updates a specified host with the provided configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation UpdateHost for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Two conflicting operations have been made on the same resource.
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ResourceUnavailableException
//     Resource not found. Verify the ARN for the host resource and try again.
//
//   - UnsupportedOperationException
//     The operation is not supported. Check the connection status and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateHost
func (c *CodeStarConnections) UpdateHost(input *UpdateHostInput) (*UpdateHostOutput, error) {
	req, out := c.UpdateHostRequest(input)
	return out, req.Send()
}

// UpdateHostWithContext is the same as UpdateHost with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateHost for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) UpdateHostWithContext(ctx aws.Context, input *UpdateHostInput, opts ...request.Option) (*UpdateHostOutput, error) {
	req, out := c.UpdateHostRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRepositoryLink = "UpdateRepositoryLink"

// UpdateRepositoryLinkRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRepositoryLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRepositoryLink for more information on using the UpdateRepositoryLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRepositoryLinkRequest method.
//	req, resp := client.UpdateRepositoryLinkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateRepositoryLink
func (c *CodeStarConnections) UpdateRepositoryLinkRequest(input *UpdateRepositoryLinkInput) (req *request.Request, output *UpdateRepositoryLinkOutput) {
	op := &request.Operation{
		Name:       opUpdateRepositoryLink,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRepositoryLinkInput{}
	}

	output = &UpdateRepositoryLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRepositoryLink API operation for AWS CodeStar connections.
//
// Updates the association between your connection and a specified external
// Git repository. A repository link allows Git sync to monitor and sync changes
// to files in a specified Git repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation UpdateRepositoryLink for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConditionalCheckFailedException
//     The conditional check failed. Try again later.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UpdateOutOfSyncException
//     The update is out of sync. Try syncing again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateRepositoryLink
func (c *CodeStarConnections) UpdateRepositoryLink(input *UpdateRepositoryLinkInput) (*UpdateRepositoryLinkOutput, error) {
	req, out := c.UpdateRepositoryLinkRequest(input)
	return out, req.Send()
}

// UpdateRepositoryLinkWithContext is the same as UpdateRepositoryLink with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRepositoryLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) UpdateRepositoryLinkWithContext(ctx aws.Context, input *UpdateRepositoryLinkInput, opts ...request.Option) (*UpdateRepositoryLinkOutput, error) {
	req, out := c.UpdateRepositoryLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSyncBlocker = "UpdateSyncBlocker"

// UpdateSyncBlockerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSyncBlocker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSyncBlocker for more information on using the UpdateSyncBlocker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSyncBlockerRequest method.
//	req, resp := client.UpdateSyncBlockerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateSyncBlocker
func (c *CodeStarConnections) UpdateSyncBlockerRequest(input *UpdateSyncBlockerInput) (req *request.Request, output *UpdateSyncBlockerOutput) {
	op := &request.Operation{
		Name:       opUpdateSyncBlocker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSyncBlockerInput{}
	}

	output = &UpdateSyncBlockerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSyncBlocker API operation for AWS CodeStar connections.
//
// Allows you to update the status of a sync blocker, resolving the blocker
// and allowing syncing to continue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation UpdateSyncBlocker for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - RetryLatestCommitFailedException
//     Retrying the latest commit failed. Try again later.
//
//   - SyncBlockerDoesNotExistException
//     Unable to continue. The sync blocker does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateSyncBlocker
func (c *CodeStarConnections) UpdateSyncBlocker(input *UpdateSyncBlockerInput) (*UpdateSyncBlockerOutput, error) {
	req, out := c.UpdateSyncBlockerRequest(input)
	return out, req.Send()
}

// UpdateSyncBlockerWithContext is the same as UpdateSyncBlocker with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSyncBlocker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) UpdateSyncBlockerWithContext(ctx aws.Context, input *UpdateSyncBlockerInput, opts ...request.Option) (*UpdateSyncBlockerOutput, error) {
	req, out := c.UpdateSyncBlockerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSyncConfiguration = "UpdateSyncConfiguration"

// UpdateSyncConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSyncConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSyncConfiguration for more information on using the UpdateSyncConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSyncConfigurationRequest method.
//	req, resp := client.UpdateSyncConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateSyncConfiguration
func (c *CodeStarConnections) UpdateSyncConfigurationRequest(input *UpdateSyncConfigurationInput) (req *request.Request, output *UpdateSyncConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateSyncConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSyncConfigurationInput{}
	}

	output = &UpdateSyncConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSyncConfiguration API operation for AWS CodeStar connections.
//
// Updates the sync configuration for your connection and a specified external
// Git repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar connections's
// API operation UpdateSyncConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConcurrentModificationException
//     Exception thrown as a result of concurrent modification to an application.
//     For example, two individuals attempting to edit the same application at the
//     same time.
//
//   - InternalServerException
//     Received an internal server exception. Try again later.
//
//   - InvalidInputException
//     The input is not valid. Verify that the action is typed correctly.
//
//   - ResourceNotFoundException
//     Resource not found. Verify the connection resource ARN and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UpdateOutOfSyncException
//     The update is out of sync. Try syncing again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateSyncConfiguration
func (c *CodeStarConnections) UpdateSyncConfiguration(input *UpdateSyncConfigurationInput) (*UpdateSyncConfigurationOutput, error) {
	req, out := c.UpdateSyncConfigurationRequest(input)
	return out, req.Send()
}

// UpdateSyncConfigurationWithContext is the same as UpdateSyncConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSyncConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarConnections) UpdateSyncConfigurationWithContext(ctx aws.Context, input *UpdateSyncConfigurationInput, opts ...request.Option) (*UpdateSyncConfigurationOutput, error) {
	req, out := c.UpdateSyncConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Exception thrown as a result of concurrent modification to an application.
// For example, two individuals attempting to edit the same application at the
// same time.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The conditional check failed. Try again later.
type ConditionalCheckFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalCheckFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalCheckFailedException) GoString() string {
	return s.String()
}

func newErrorConditionalCheckFailedException(v protocol.ResponseMetadata) error {
	return &ConditionalCheckFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConditionalCheckFailedException) Code() string {
	return "ConditionalCheckFailedException"
}

// Message returns the exception's message.
func (s *ConditionalCheckFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConditionalCheckFailedException) OrigErr() error {
	return nil
}

func (s *ConditionalCheckFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConditionalCheckFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConditionalCheckFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Two conflicting operations have been made on the same resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A resource that is used to connect third-party source providers with services
// like CodePipeline.
//
// Note: A connection created through CloudFormation, the CLI, or the SDK is
// in `PENDING` status by default. You can make its status `AVAILABLE` by updating
// the connection in the console.
type Connection struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connection. The ARN is used as the
	// connection reference when the connection is shared between Amazon Web Services.
	//
	// The ARN is never reused if the connection is deleted.
	ConnectionArn *string `type:"string"`

	// The name of the connection. Connection names must be unique in an Amazon
	// Web Services account.
	ConnectionName *string `min:"1" type:"string"`

	// The current status of the connection.
	ConnectionStatus *string `type:"string" enum:"ConnectionStatus"`

	// The Amazon Resource Name (ARN) of the host associated with the connection.
	HostArn *string `type:"string"`

	// The identifier of the external provider where your third-party code repository
	// is configured. For Bitbucket, this is the account ID of the owner of the
	// Bitbucket repository.
	OwnerAccountId *string `min:"12" type:"string"`

	// The name of the external provider where your third-party code repository
	// is configured.
	ProviderType *string `type:"string" enum:"ProviderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connection) GoString() string {
	return s.String()
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *Connection) SetConnectionArn(v string) *Connection {
	s.ConnectionArn = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *Connection) SetConnectionName(v string) *Connection {
	s.ConnectionName = &v
	return s
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *Connection) SetConnectionStatus(v string) *Connection {
	s.ConnectionStatus = &v
	return s
}

// SetHostArn sets the HostArn field's value.
func (s *Connection) SetHostArn(v string) *Connection {
	s.HostArn = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *Connection) SetOwnerAccountId(v string) *Connection {
	s.OwnerAccountId = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *Connection) SetProviderType(v string) *Connection {
	s.ProviderType = &v
	return s
}

type CreateConnectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the connection to be created.
	//
	// ConnectionName is a required field
	ConnectionName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the host associated with the connection
	// to be created.
	HostArn *string `type:"string"`

	// The name of the external provider where your third-party code repository
	// is configured.
	ProviderType *string `type:"string" enum:"ProviderType"`

	// The key-value pair to use when tagging the resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionInput"}
	if s.ConnectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionName"))
	}
	if s.ConnectionName != nil && len(*s.ConnectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionName sets the ConnectionName field's value.
func (s *CreateConnectionInput) SetConnectionName(v string) *CreateConnectionInput {
	s.ConnectionName = &v
	return s
}

// SetHostArn sets the HostArn field's value.
func (s *CreateConnectionInput) SetHostArn(v string) *CreateConnectionInput {
	s.HostArn = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *CreateConnectionInput) SetProviderType(v string) *CreateConnectionInput {
	s.ProviderType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConnectionInput) SetTags(v []*Tag) *CreateConnectionInput {
	s.Tags = v
	return s
}

type CreateConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connection to be created. The ARN is
	// used as the connection reference when the connection is shared between Amazon
	// Web Services services.
	//
	// The ARN is never reused if the connection is deleted.
	//
	// ConnectionArn is a required field
	ConnectionArn *string `type:"string" required:"true"`

	// Specifies the tags applied to the resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *CreateConnectionOutput) SetConnectionArn(v string) *CreateConnectionOutput {
	s.ConnectionArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConnectionOutput) SetTags(v []*Tag) *CreateConnectionOutput {
	s.Tags = v
	return s
}

type CreateHostInput struct {
	_ struct{} `type:"structure"`

	// The name of the host to be created.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The endpoint of the infrastructure to be represented by the host after it
	// is created.
	//
	// ProviderEndpoint is a required field
	ProviderEndpoint *string `min:"1" type:"string" required:"true"`

	// The name of the installed provider to be associated with your connection.
	// The host resource represents the infrastructure where your provider type
	// is installed. The valid provider type is GitHub Enterprise Server.
	//
	// ProviderType is a required field
	ProviderType *string `type:"string" required:"true" enum:"ProviderType"`

	// Tags for the host to be created.
	Tags []*Tag `type:"list"`

	// The VPC configuration to be provisioned for the host. A VPC must be configured
	// and the infrastructure to be represented by the host must already be connected
	// to the VPC.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHostInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHostInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHostInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ProviderEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderEndpoint"))
	}
	if s.ProviderEndpoint != nil && len(*s.ProviderEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderEndpoint", 1))
	}
	if s.ProviderType == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderType"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateHostInput) SetName(v string) *CreateHostInput {
	s.Name = &v
	return s
}

// SetProviderEndpoint sets the ProviderEndpoint field's value.
func (s *CreateHostInput) SetProviderEndpoint(v string) *CreateHostInput {
	s.ProviderEndpoint = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *CreateHostInput) SetProviderType(v string) *CreateHostInput {
	s.ProviderType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateHostInput) SetTags(v []*Tag) *CreateHostInput {
	s.Tags = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *CreateHostInput) SetVpcConfiguration(v *VpcConfiguration) *CreateHostInput {
	s.VpcConfiguration = v
	return s
}

type CreateHostOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the host to be created.
	HostArn *string `type:"string"`

	// Tags for the created host.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHostOutput) GoString() string {
	return s.String()
}

// SetHostArn sets the HostArn field's value.
func (s *CreateHostOutput) SetHostArn(v string) *CreateHostOutput {
	s.HostArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateHostOutput) SetTags(v []*Tag) *CreateHostOutput {
	s.Tags = v
	return s
}

type CreateRepositoryLinkInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connection to be associated with the
	// repository link.
	//
	// ConnectionArn is a required field
	ConnectionArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) encryption key for the repository to be associated
	// with the repository link.
	EncryptionKeyArn *string `min:"1" type:"string"`

	// The owner ID for the repository associated with a specific sync configuration,
	// such as the owner ID in GitHub.
	//
	// OwnerId is a required field
	OwnerId *string `min:"1" type:"string" required:"true"`

	// The name of the repository to be associated with the repository link.
	//
	// RepositoryName is a required field
	RepositoryName *string `min:"1" type:"string" required:"true"`

	// The tags for the repository to be associated with the repository link.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRepositoryLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRepositoryLinkInput"}
	if s.ConnectionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionArn"))
	}
	if s.EncryptionKeyArn != nil && len(*s.EncryptionKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKeyArn", 1))
	}
	if s.OwnerId == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerId"))
	}
	if s.OwnerId != nil && len(*s.OwnerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OwnerId", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *CreateRepositoryLinkInput) SetConnectionArn(v string) *CreateRepositoryLinkInput {
	s.ConnectionArn = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *CreateRepositoryLinkInput) SetEncryptionKeyArn(v string) *CreateRepositoryLinkInput {
	s.EncryptionKeyArn = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *CreateRepositoryLinkInput) SetOwnerId(v string) *CreateRepositoryLinkInput {
	s.OwnerId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CreateRepositoryLinkInput) SetRepositoryName(v string) *CreateRepositoryLinkInput {
	s.RepositoryName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRepositoryLinkInput) SetTags(v []*Tag) *CreateRepositoryLinkInput {
	s.Tags = v
	return s
}

type CreateRepositoryLinkOutput struct {
	_ struct{} `type:"structure"`

	// The returned information about the created repository link.
	//
	// RepositoryLinkInfo is a required field
	RepositoryLinkInfo *RepositoryLinkInfo `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryLinkOutput) GoString() string {
	return s.String()
}

// SetRepositoryLinkInfo sets the RepositoryLinkInfo field's value.
func (s *CreateRepositoryLinkOutput) SetRepositoryLinkInfo(v *RepositoryLinkInfo) *CreateRepositoryLinkOutput {
	s.RepositoryLinkInfo = v
	return s
}

type CreateSyncConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The branch in the repository from which changes will be synced.
	//
	// Branch is a required field
	Branch *string `min:"1" type:"string" required:"true"`

	// The file name of the configuration file that manages syncing between the
	// connection and the repository. This configuration file is stored in the repository.
	//
	// ConfigFile is a required field
	ConfigFile *string `type:"string" required:"true"`

	// Whether to enable or disable publishing of deployment status to source providers.
	PublishDeploymentStatus *string `type:"string" enum:"PublishDeploymentStatus"`

	// The ID of the repository link created for the connection. A repository link
	// allows Git sync to monitor and sync changes to files in a specified Git repository.
	//
	// RepositoryLinkId is a required field
	RepositoryLinkId *string `type:"string" required:"true"`

	// The name of the Amazon Web Services resource (for example, a CloudFormation
	// stack in the case of CFN_STACK_SYNC) that will be synchronized from the linked
	// repository.
	//
	// ResourceName is a required field
	ResourceName *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that grants permission for Amazon Web Services to
	// use Git sync to update a given Amazon Web Services resource on your behalf.
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// The type of sync configuration.
	//
	// SyncType is a required field
	SyncType *string `type:"string" required:"true" enum:"SyncConfigurationType"`

	// When to trigger Git sync to begin the stack update.
	TriggerResourceUpdateOn *string `type:"string" enum:"TriggerResourceUpdateOn"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSyncConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSyncConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSyncConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSyncConfigurationInput"}
	if s.Branch == nil {
		invalidParams.Add(request.NewErrParamRequired("Branch"))
	}
	if s.Branch != nil && len(*s.Branch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Branch", 1))
	}
	if s.ConfigFile == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigFile"))
	}
	if s.RepositoryLinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryLinkId"))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.ResourceName != nil && len(*s.ResourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.SyncType == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranch sets the Branch field's value.
func (s *CreateSyncConfigurationInput) SetBranch(v string) *CreateSyncConfigurationInput {
	s.Branch = &v
	return s
}

// SetConfigFile sets the ConfigFile field's value.
func (s *CreateSyncConfigurationInput) SetConfigFile(v string) *CreateSyncConfigurationInput {
	s.ConfigFile = &v
	return s
}

// SetPublishDeploymentStatus sets the PublishDeploymentStatus field's value.
func (s *CreateSyncConfigurationInput) SetPublishDeploymentStatus(v string) *CreateSyncConfigurationInput {
	s.PublishDeploymentStatus = &v
	return s
}

// SetRepositoryLinkId sets the RepositoryLinkId field's value.
func (s *CreateSyncConfigurationInput) SetRepositoryLinkId(v string) *CreateSyncConfigurationInput {
	s.RepositoryLinkId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *CreateSyncConfigurationInput) SetResourceName(v string) *CreateSyncConfigurationInput {
	s.ResourceName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateSyncConfigurationInput) SetRoleArn(v string) *CreateSyncConfigurationInput {
	s.RoleArn = &v
	return s
}

// SetSyncType sets the SyncType field's value.
func (s *CreateSyncConfigurationInput) SetSyncType(v string) *CreateSyncConfigurationInput {
	s.SyncType = &v
	return s
}

// SetTriggerResourceUpdateOn sets the TriggerResourceUpdateOn field's value.
func (s *CreateSyncConfigurationInput) SetTriggerResourceUpdateOn(v string) *CreateSyncConfigurationInput {
	s.TriggerResourceUpdateOn = &v
	return s
}

type CreateSyncConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The created sync configuration for the connection. A sync configuration allows
	// Amazon Web Services to sync content from a Git repository to update a specified
	// Amazon Web Services resource.
	//
	// SyncConfiguration is a required field
	SyncConfiguration *SyncConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSyncConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSyncConfigurationOutput) GoString() string {
	return s.String()
}

// SetSyncConfiguration sets the SyncConfiguration field's value.
func (s *CreateSyncConfigurationOutput) SetSyncConfiguration(v *SyncConfiguration) *CreateSyncConfigurationOutput {
	s.SyncConfiguration = v
	return s
}

type DeleteConnectionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connection to be deleted.
	//
	// The ARN is never reused if the connection is deleted.
	//
	// ConnectionArn is a required field
	ConnectionArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectionInput"}
	if s.ConnectionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *DeleteConnectionInput) SetConnectionArn(v string) *DeleteConnectionInput {
	s.ConnectionArn = &v
	return s
}

type DeleteConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionOutput) GoString() string {
	return s.String()
}

type DeleteHostInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the host to be deleted.
	//
	// HostArn is a required field
	HostArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHostInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHostInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHostInput"}
	if s.HostArn == nil {
		invalidParams.Add(request.NewErrParamRequired("HostArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostArn sets the HostArn field's value.
func (s *DeleteHostInput) SetHostArn(v string) *DeleteHostInput {
	s.HostArn = &v
	return s
}

type DeleteHostOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHostOutput) GoString() string {
	return s.String()
}

type DeleteRepositoryLinkInput struct {
	_ struct{} `type:"structure"`

	// The ID of the repository link to be deleted.
	//
	// RepositoryLinkId is a required field
	RepositoryLinkId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRepositoryLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRepositoryLinkInput"}
	if s.RepositoryLinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryLinkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryLinkId sets the RepositoryLinkId field's value.
func (s *DeleteRepositoryLinkInput) SetRepositoryLinkId(v string) *DeleteRepositoryLinkInput {
	s.RepositoryLinkId = &v
	return s
}

type DeleteRepositoryLinkOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryLinkOutput) GoString() string {
	return s.String()
}

type DeleteSyncConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Web Services resource associated with the sync configuration
	// to be deleted.
	//
	// ResourceName is a required field
	ResourceName *string `min:"1" type:"string" required:"true"`

	// The type of sync configuration to be deleted.
	//
	// SyncType is a required field
	SyncType *string `type:"string" required:"true" enum:"SyncConfigurationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSyncConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSyncConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSyncConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSyncConfigurationInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.ResourceName != nil && len(*s.ResourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceName", 1))
	}
	if s.SyncType == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *DeleteSyncConfigurationInput) SetResourceName(v string) *DeleteSyncConfigurationInput {
	s.ResourceName = &v
	return s
}

// SetSyncType sets the SyncType field's value.
func (s *DeleteSyncConfigurationInput) SetSyncType(v string) *DeleteSyncConfigurationInput {
	s.SyncType = &v
	return s
}

type DeleteSyncConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSyncConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSyncConfigurationOutput) GoString() string {
	return s.String()
}

type GetConnectionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a connection.
	//
	// ConnectionArn is a required field
	ConnectionArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConnectionInput"}
	if s.ConnectionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *GetConnectionInput) SetConnectionArn(v string) *GetConnectionInput {
	s.ConnectionArn = &v
	return s
}

type GetConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The connection details, such as status, owner, and provider type.
	Connection *Connection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *GetConnectionOutput) SetConnection(v *Connection) *GetConnectionOutput {
	s.Connection = v
	return s
}

type GetHostInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the requested host.
	//
	// HostArn is a required field
	HostArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetHostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetHostInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHostInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHostInput"}
	if s.HostArn == nil {
		invalidParams.Add(request.NewErrParamRequired("HostArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostArn sets the HostArn field's value.
func (s *GetHostInput) SetHostArn(v string) *GetHostInput {
	s.HostArn = &v
	return s
}

type GetHostOutput struct {
	_ struct{} `type:"structure"`

	// The name of the requested host.
	Name *string `min:"1" type:"string"`

	// The endpoint of the infrastructure represented by the requested host.
	ProviderEndpoint *string `min:"1" type:"string"`

	// The provider type of the requested host, such as GitHub Enterprise Server.
	ProviderType *string `type:"string" enum:"ProviderType"`

	// The status of the requested host.
	Status *string `min:"1" type:"string"`

	// The VPC configuration of the requested host.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetHostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetHostOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *GetHostOutput) SetName(v string) *GetHostOutput {
	s.Name = &v
	return s
}

// SetProviderEndpoint sets the ProviderEndpoint field's value.
func (s *GetHostOutput) SetProviderEndpoint(v string) *GetHostOutput {
	s.ProviderEndpoint = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *GetHostOutput) SetProviderType(v string) *GetHostOutput {
	s.ProviderType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetHostOutput) SetStatus(v string) *GetHostOutput {
	s.Status = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *GetHostOutput) SetVpcConfiguration(v *VpcConfiguration) *GetHostOutput {
	s.VpcConfiguration = v
	return s
}

type GetRepositoryLinkInput struct {
	_ struct{} `type:"structure"`

	// The ID of the repository link to get.
	//
	// RepositoryLinkId is a required field
	RepositoryLinkId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRepositoryLinkInput"}
	if s.RepositoryLinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryLinkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryLinkId sets the RepositoryLinkId field's value.
func (s *GetRepositoryLinkInput) SetRepositoryLinkId(v string) *GetRepositoryLinkInput {
	s.RepositoryLinkId = &v
	return s
}

type GetRepositoryLinkOutput struct {
	_ struct{} `type:"structure"`

	// The information returned for a specified repository link.
	//
	// RepositoryLinkInfo is a required field
	RepositoryLinkInfo *RepositoryLinkInfo `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryLinkOutput) GoString() string {
	return s.String()
}

// SetRepositoryLinkInfo sets the RepositoryLinkInfo field's value.
func (s *GetRepositoryLinkOutput) SetRepositoryLinkInfo(v *RepositoryLinkInfo) *GetRepositoryLinkOutput {
	s.RepositoryLinkInfo = v
	return s
}

type GetRepositorySyncStatusInput struct {
	_ struct{} `type:"structure"`

	// The branch of the repository link for the requested repository sync status.
	//
	// Branch is a required field
	Branch *string `min:"1" type:"string" required:"true"`

	// The repository link ID for the requested repository sync status.
	//
	// RepositoryLinkId is a required field
	RepositoryLinkId *string `type:"string" required:"true"`

	// The sync type of the requested sync status.
	//
	// SyncType is a required field
	SyncType *string `type:"string" required:"true" enum:"SyncConfigurationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositorySyncStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositorySyncStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositorySyncStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRepositorySyncStatusInput"}
	if s.Branch == nil {
		invalidParams.Add(request.NewErrParamRequired("Branch"))
	}
	if s.Branch != nil && len(*s.Branch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Branch", 1))
	}
	if s.RepositoryLinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryLinkId"))
	}
	if s.SyncType == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranch sets the Branch field's value.
func (s *GetRepositorySyncStatusInput) SetBranch(v string) *GetRepositorySyncStatusInput {
	s.Branch = &v
	return s
}

// SetRepositoryLinkId sets the RepositoryLinkId field's value.
func (s *GetRepositorySyncStatusInput) SetRepositoryLinkId(v string) *GetRepositorySyncStatusInput {
	s.RepositoryLinkId = &v
	return s
}

// SetSyncType sets the SyncType field's value.
func (s *GetRepositorySyncStatusInput) SetSyncType(v string) *GetRepositorySyncStatusInput {
	s.SyncType = &v
	return s
}

type GetRepositorySyncStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the latest sync returned for a specified repository and branch.
	//
	// LatestSync is a required field
	LatestSync *RepositorySyncAttempt `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositorySyncStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositorySyncStatusOutput) GoString() string {
	return s.String()
}

// SetLatestSync sets the LatestSync field's value.
func (s *GetRepositorySyncStatusOutput) SetLatestSync(v *RepositorySyncAttempt) *GetRepositorySyncStatusOutput {
	s.LatestSync = v
	return s
}

type GetResourceSyncStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Web Services resource for the sync status with the
	// Git repository.
	//
	// ResourceName is a required field
	ResourceName *string `min:"1" type:"string" required:"true"`

	// The sync type for the sync status with the Git repository.
	//
	// SyncType is a required field
	SyncType *string `type:"string" required:"true" enum:"SyncConfigurationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSyncStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSyncStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceSyncStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceSyncStatusInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.ResourceName != nil && len(*s.ResourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceName", 1))
	}
	if s.SyncType == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *GetResourceSyncStatusInput) SetResourceName(v string) *GetResourceSyncStatusInput {
	s.ResourceName = &v
	return s
}

// SetSyncType sets the SyncType field's value.
func (s *GetResourceSyncStatusInput) SetSyncType(v string) *GetResourceSyncStatusInput {
	s.SyncType = &v
	return s
}

type GetResourceSyncStatusOutput struct {
	_ struct{} `type:"structure"`

	// The desired state of the Amazon Web Services resource for the sync status
	// with the Git repository.
	DesiredState *Revision `type:"structure"`

	// The latest successful sync for the sync status with the Git repository.
	LatestSuccessfulSync *ResourceSyncAttempt `type:"structure"`

	// The latest sync for the sync status with the Git repository, whether successful
	// or not.
	//
	// LatestSync is a required field
	LatestSync *ResourceSyncAttempt `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSyncStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSyncStatusOutput) GoString() string {
	return s.String()
}

// SetDesiredState sets the DesiredState field's value.
func (s *GetResourceSyncStatusOutput) SetDesiredState(v *Revision) *GetResourceSyncStatusOutput {
	s.DesiredState = v
	return s
}

// SetLatestSuccessfulSync sets the LatestSuccessfulSync field's value.
func (s *GetResourceSyncStatusOutput) SetLatestSuccessfulSync(v *ResourceSyncAttempt) *GetResourceSyncStatusOutput {
	s.LatestSuccessfulSync = v
	return s
}

// SetLatestSync sets the LatestSync field's value.
func (s *GetResourceSyncStatusOutput) SetLatestSync(v *ResourceSyncAttempt) *GetResourceSyncStatusOutput {
	s.LatestSync = v
	return s
}

type GetSyncBlockerSummaryInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Web Services resource currently blocked from automatically
	// being synced from a Git repository.
	//
	// ResourceName is a required field
	ResourceName *string `min:"1" type:"string" required:"true"`

	// The sync type for the sync blocker summary.
	//
	// SyncType is a required field
	SyncType *string `type:"string" required:"true" enum:"SyncConfigurationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSyncBlockerSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSyncBlockerSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSyncBlockerSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSyncBlockerSummaryInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.ResourceName != nil && len(*s.ResourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceName", 1))
	}
	if s.SyncType == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *GetSyncBlockerSummaryInput) SetResourceName(v string) *GetSyncBlockerSummaryInput {
	s.ResourceName = &v
	return s
}

// SetSyncType sets the SyncType field's value.
func (s *GetSyncBlockerSummaryInput) SetSyncType(v string) *GetSyncBlockerSummaryInput {
	s.SyncType = &v
	return s
}

type GetSyncBlockerSummaryOutput struct {
	_ struct{} `type:"structure"`

	// The list of sync blockers for a specified resource.
	//
	// SyncBlockerSummary is a required field
	SyncBlockerSummary *SyncBlockerSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSyncBlockerSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSyncBlockerSummaryOutput) GoString() string {
	return s.String()
}

// SetSyncBlockerSummary sets the SyncBlockerSummary field's value.
func (s *GetSyncBlockerSummaryOutput) SetSyncBlockerSummary(v *SyncBlockerSummary) *GetSyncBlockerSummaryOutput {
	s.SyncBlockerSummary = v
	return s
}

type GetSyncConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Web Services resource for the sync configuration for
	// which you want to retrieve information.
	//
	// ResourceName is a required field
	ResourceName *string `min:"1" type:"string" required:"true"`

	// The sync type for the sync configuration for which you want to retrieve information.
	//
	// SyncType is a required field
	SyncType *string `type:"string" required:"true" enum:"SyncConfigurationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSyncConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSyncConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSyncConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSyncConfigurationInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.ResourceName != nil && len(*s.ResourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceName", 1))
	}
	if s.SyncType == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *GetSyncConfigurationInput) SetResourceName(v string) *GetSyncConfigurationInput {
	s.ResourceName = &v
	return s
}

// SetSyncType sets the SyncType field's value.
func (s *GetSyncConfigurationInput) SetSyncType(v string) *GetSyncConfigurationInput {
	s.SyncType = &v
	return s
}

type GetSyncConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The details about the sync configuration for which you want to retrieve information.
	//
	// SyncConfiguration is a required field
	SyncConfiguration *SyncConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSyncConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSyncConfigurationOutput) GoString() string {
	return s.String()
}

// SetSyncConfiguration sets the SyncConfiguration field's value.
func (s *GetSyncConfigurationOutput) SetSyncConfiguration(v *SyncConfiguration) *GetSyncConfigurationOutput {
	s.SyncConfiguration = v
	return s
}

// A resource that represents the infrastructure where a third-party provider
// is installed. The host is used when you create connections to an installed
// third-party provider type, such as GitHub Enterprise Server. You create one
// host for all connections to that provider.
//
// A host created through the CLI or the SDK is in `PENDING` status by default.
// You can make its status `AVAILABLE` by setting up the host in the console.
type Host struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the host.
	HostArn *string `type:"string"`

	// The name of the host.
	Name *string `min:"1" type:"string"`

	// The endpoint of the infrastructure where your provider type is installed.
	ProviderEndpoint *string `min:"1" type:"string"`

	// The name of the installed provider to be associated with your connection.
	// The host resource represents the infrastructure where your provider type
	// is installed. The valid provider type is GitHub Enterprise Server.
	ProviderType *string `type:"string" enum:"ProviderType"`

	// The status of the host, such as PENDING, AVAILABLE, VPC_CONFIG_DELETING,
	// VPC_CONFIG_INITIALIZING, and VPC_CONFIG_FAILED_INITIALIZATION.
	Status *string `min:"1" type:"string"`

	// The status description for the host.
	StatusMessage *string `type:"string"`

	// The VPC configuration provisioned for the host.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Host) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Host) GoString() string {
	return s.String()
}

// SetHostArn sets the HostArn field's value.
func (s *Host) SetHostArn(v string) *Host {
	s.HostArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Host) SetName(v string) *Host {
	s.Name = &v
	return s
}

// SetProviderEndpoint sets the ProviderEndpoint field's value.
func (s *Host) SetProviderEndpoint(v string) *Host {
	s.ProviderEndpoint = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *Host) SetProviderType(v string) *Host {
	s.ProviderType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Host) SetStatus(v string) *Host {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *Host) SetStatusMessage(v string) *Host {
	s.StatusMessage = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *Host) SetVpcConfiguration(v *VpcConfiguration) *Host {
	s.VpcConfiguration = v
	return s
}

// Received an internal server exception. Try again later.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input is not valid. Verify that the action is typed correctly.
type InvalidInputException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputException) GoString() string {
	return s.String()
}

func newErrorInvalidInputException(v protocol.ResponseMetadata) error {
	return &InvalidInputException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInputException) Code() string {
	return "InvalidInputException"
}

// Message returns the exception's message.
func (s *InvalidInputException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInputException) OrigErr() error {
	return nil
}

func (s *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInputException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInputException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Exceeded the maximum limit for connections.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListConnectionsInput struct {
	_ struct{} `type:"structure"`

	// Filters the list of connections to those associated with a specified host.
	HostArnFilter *string `type:"string"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `type:"integer"`

	// The token that was returned from the previous ListConnections call, which
	// can be used to return the next set of connections in the list.
	NextToken *string `min:"1" type:"string"`

	// Filters the list of connections to those associated with a specified provider,
	// such as Bitbucket.
	ProviderTypeFilter *string `type:"string" enum:"ProviderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConnectionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostArnFilter sets the HostArnFilter field's value.
func (s *ListConnectionsInput) SetHostArnFilter(v string) *ListConnectionsInput {
	s.HostArnFilter = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConnectionsInput) SetMaxResults(v int64) *ListConnectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectionsInput) SetNextToken(v string) *ListConnectionsInput {
	s.NextToken = &v
	return s
}

// SetProviderTypeFilter sets the ProviderTypeFilter field's value.
func (s *ListConnectionsInput) SetProviderTypeFilter(v string) *ListConnectionsInput {
	s.ProviderTypeFilter = &v
	return s
}

type ListConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of connections and the details for each connection, such as status,
	// owner, and provider type.
	Connections []*Connection `type:"list"`

	// A token that can be used in the next ListConnections call. To view all items
	// in the list, continue to call this operation with each subsequent token until
	// no more nextToken values are returned.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectionsOutput) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *ListConnectionsOutput) SetConnections(v []*Connection) *ListConnectionsOutput {
	s.Connections = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectionsOutput) SetNextToken(v string) *ListConnectionsOutput {
	s.NextToken = &v
	return s
}

type ListHostsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `type:"integer"`

	// The token that was returned from the previous ListHosts call, which can be
	// used to return the next set of hosts in the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHostsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHostsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHostsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListHostsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListHostsInput) SetMaxResults(v int64) *ListHostsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHostsInput) SetNextToken(v string) *ListHostsInput {
	s.NextToken = &v
	return s
}

type ListHostsOutput struct {
	_ struct{} `type:"structure"`

	// A list of hosts and the details for each host, such as status, endpoint,
	// and provider type.
	Hosts []*Host `type:"list"`

	// A token that can be used in the next ListHosts call. To view all items in
	// the list, continue to call this operation with each subsequent token until
	// no more nextToken values are returned.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHostsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHostsOutput) GoString() string {
	return s.String()
}

// SetHosts sets the Hosts field's value.
func (s *ListHostsOutput) SetHosts(v []*Host) *ListHostsOutput {
	s.Hosts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHostsOutput) SetNextToken(v string) *ListHostsOutput {
	s.NextToken = &v
	return s
}

type ListRepositoryLinksInput struct {
	_ struct{} `type:"structure"`

	// A non-zero, non-negative integer used to limit the number of returned results.
	MaxResults *int64 `type:"integer"`

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoryLinksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoryLinksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRepositoryLinksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRepositoryLinksInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRepositoryLinksInput) SetMaxResults(v int64) *ListRepositoryLinksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoryLinksInput) SetNextToken(v string) *ListRepositoryLinksInput {
	s.NextToken = &v
	return s
}

type ListRepositoryLinksOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the results of the
	// operation.
	NextToken *string `min:"1" type:"string"`

	// Lists the repository links called by the list repository links operation.
	//
	// RepositoryLinks is a required field
	RepositoryLinks []*RepositoryLinkInfo `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoryLinksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoryLinksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoryLinksOutput) SetNextToken(v string) *ListRepositoryLinksOutput {
	s.NextToken = &v
	return s
}

// SetRepositoryLinks sets the RepositoryLinks field's value.
func (s *ListRepositoryLinksOutput) SetRepositoryLinks(v []*RepositoryLinkInfo) *ListRepositoryLinksOutput {
	s.RepositoryLinks = v
	return s
}

type ListRepositorySyncDefinitionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the repository link for the sync definition for which you want
	// to retrieve information.
	//
	// RepositoryLinkId is a required field
	RepositoryLinkId *string `type:"string" required:"true"`

	// The sync type of the repository link for the the sync definition for which
	// you want to retrieve information.
	//
	// SyncType is a required field
	SyncType *string `type:"string" required:"true" enum:"SyncConfigurationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositorySyncDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositorySyncDefinitionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRepositorySyncDefinitionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRepositorySyncDefinitionsInput"}
	if s.RepositoryLinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryLinkId"))
	}
	if s.SyncType == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryLinkId sets the RepositoryLinkId field's value.
func (s *ListRepositorySyncDefinitionsInput) SetRepositoryLinkId(v string) *ListRepositorySyncDefinitionsInput {
	s.RepositoryLinkId = &v
	return s
}

// SetSyncType sets the SyncType field's value.
func (s *ListRepositorySyncDefinitionsInput) SetSyncType(v string) *ListRepositorySyncDefinitionsInput {
	s.SyncType = &v
	return s
}

type ListRepositorySyncDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string `min:"1" type:"string"`

	// The list of repository sync definitions returned by the request. A RepositorySyncDefinition
	// is a mapping from a repository branch to all the Amazon Web Services resources
	// that are being synced from that branch.
	//
	// RepositorySyncDefinitions is a required field
	RepositorySyncDefinitions []*RepositorySyncDefinition `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositorySyncDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositorySyncDefinitionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositorySyncDefinitionsOutput) SetNextToken(v string) *ListRepositorySyncDefinitionsOutput {
	s.NextToken = &v
	return s
}

// SetRepositorySyncDefinitions sets the RepositorySyncDefinitions field's value.
func (s *ListRepositorySyncDefinitionsOutput) SetRepositorySyncDefinitions(v []*RepositorySyncDefinition) *ListRepositorySyncDefinitionsOutput {
	s.RepositorySyncDefinitions = v
	return s
}

type ListSyncConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// A non-zero, non-negative integer used to limit the number of returned results.
	MaxResults *int64 `type:"integer"`

	// An enumeration token that allows the operation to batch the results of the
	// operation.
	NextToken *string `min:"1" type:"string"`

	// The ID of the repository link for the requested list of sync configurations.
	//
	// RepositoryLinkId is a required field
	RepositoryLinkId *string `type:"string" required:"true"`

	// The sync type for the requested list of sync configurations.
	//
	// SyncType is a required field
	SyncType *string `type:"string" required:"true" enum:"SyncConfigurationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSyncConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSyncConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSyncConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSyncConfigurationsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.RepositoryLinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryLinkId"))
	}
	if s.SyncType == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSyncConfigurationsInput) SetMaxResults(v int64) *ListSyncConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSyncConfigurationsInput) SetNextToken(v string) *ListSyncConfigurationsInput {
	s.NextToken = &v
	return s
}

// SetRepositoryLinkId sets the RepositoryLinkId field's value.
func (s *ListSyncConfigurationsInput) SetRepositoryLinkId(v string) *ListSyncConfigurationsInput {
	s.RepositoryLinkId = &v
	return s
}

// SetSyncType sets the SyncType field's value.
func (s *ListSyncConfigurationsInput) SetSyncType(v string) *ListSyncConfigurationsInput {
	s.SyncType = &v
	return s
}

type ListSyncConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the next results
	// of the operation.
	NextToken *string `min:"1" type:"string"`

	// The list of repository sync definitions returned by the request.
	//
	// SyncConfigurations is a required field
	SyncConfigurations []*SyncConfiguration `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSyncConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSyncConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSyncConfigurationsOutput) SetNextToken(v string) *ListSyncConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetSyncConfigurations sets the SyncConfigurations field's value.
func (s *ListSyncConfigurationsOutput) SetSyncConfigurations(v []*SyncConfiguration) *ListSyncConfigurationsOutput {
	s.SyncConfigurations = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource for which you want to get
	// information about tags, if any.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tag key and value pairs associated with the specified resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Information about the repository link resource, such as the repository link
// ARN, the associated connection ARN, encryption key ARN, and owner ID.
type RepositoryLinkInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connection associated with the repository
	// link.
	//
	// ConnectionArn is a required field
	ConnectionArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the encryption key for the repository associated
	// with the repository link.
	EncryptionKeyArn *string `min:"1" type:"string"`

	// The owner ID for the repository associated with the repository link, such
	// as the owner ID in GitHub.
	//
	// OwnerId is a required field
	OwnerId *string `min:"1" type:"string" required:"true"`

	// The provider type for the connection, such as GitHub, associated with the
	// repository link.
	//
	// ProviderType is a required field
	ProviderType *string `type:"string" required:"true" enum:"ProviderType"`

	// The Amazon Resource Name (ARN) of the repository link.
	//
	// RepositoryLinkArn is a required field
	RepositoryLinkArn *string `type:"string" required:"true"`

	// The ID of the repository link.
	//
	// RepositoryLinkId is a required field
	RepositoryLinkId *string `type:"string" required:"true"`

	// The name of the repository associated with the repository link.
	//
	// RepositoryName is a required field
	RepositoryName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryLinkInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryLinkInfo) GoString() string {
	return s.String()
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *RepositoryLinkInfo) SetConnectionArn(v string) *RepositoryLinkInfo {
	s.ConnectionArn = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *RepositoryLinkInfo) SetEncryptionKeyArn(v string) *RepositoryLinkInfo {
	s.EncryptionKeyArn = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *RepositoryLinkInfo) SetOwnerId(v string) *RepositoryLinkInfo {
	s.OwnerId = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *RepositoryLinkInfo) SetProviderType(v string) *RepositoryLinkInfo {
	s.ProviderType = &v
	return s
}

// SetRepositoryLinkArn sets the RepositoryLinkArn field's value.
func (s *RepositoryLinkInfo) SetRepositoryLinkArn(v string) *RepositoryLinkInfo {
	s.RepositoryLinkArn = &v
	return s
}

// SetRepositoryLinkId sets the RepositoryLinkId field's value.
func (s *RepositoryLinkInfo) SetRepositoryLinkId(v string) *RepositoryLinkInfo {
	s.RepositoryLinkId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *RepositoryLinkInfo) SetRepositoryName(v string) *RepositoryLinkInfo {
	s.RepositoryName = &v
	return s
}

// Information about a repository sync attempt for a repository with a sync
// configuration.
type RepositorySyncAttempt struct {
	_ struct{} `type:"structure"`

	// The events associated with a specific sync attempt.
	//
	// Events is a required field
	Events []*RepositorySyncEvent `type:"list" required:"true"`

	// The start time of a specific sync attempt.
	//
	// StartedAt is a required field
	StartedAt *time.Time `type:"timestamp" required:"true"`

	// The status of a specific sync attempt. The following are valid statuses:
	//
	//    * INITIATED - A repository sync attempt has been created and will begin
	//    soon.
	//
	//    * IN_PROGRESS - A repository sync attempt has started and work is being
	//    done to reconcile the branch.
	//
	//    * SUCCEEDED - The repository sync attempt has completed successfully.
	//
	//    * FAILED - The repository sync attempt has failed.
	//
	//    * QUEUED - The repository sync attempt didn't execute and was queued.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"RepositorySyncStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySyncAttempt) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySyncAttempt) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *RepositorySyncAttempt) SetEvents(v []*RepositorySyncEvent) *RepositorySyncAttempt {
	s.Events = v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *RepositorySyncAttempt) SetStartedAt(v time.Time) *RepositorySyncAttempt {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RepositorySyncAttempt) SetStatus(v string) *RepositorySyncAttempt {
	s.Status = &v
	return s
}

// The definition for a repository with a sync configuration.
type RepositorySyncDefinition struct {
	_ struct{} `type:"structure"`

	// The branch specified for a repository sync definition.
	//
	// Branch is a required field
	Branch *string `min:"1" type:"string" required:"true"`

	// The configuration file for a repository sync definition. This value comes
	// from creating or updating the config-file field of a sync-configuration.
	//
	// Directory is a required field
	Directory *string `type:"string" required:"true"`

	// The parent resource specified for a repository sync definition.
	//
	// Parent is a required field
	Parent *string `type:"string" required:"true"`

	// The target resource specified for a repository sync definition. In some cases,
	// such as CFN_STACK_SYNC, the parent and target resource are the same.
	//
	// Target is a required field
	Target *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySyncDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySyncDefinition) GoString() string {
	return s.String()
}

// SetBranch sets the Branch field's value.
func (s *RepositorySyncDefinition) SetBranch(v string) *RepositorySyncDefinition {
	s.Branch = &v
	return s
}

// SetDirectory sets the Directory field's value.
func (s *RepositorySyncDefinition) SetDirectory(v string) *RepositorySyncDefinition {
	s.Directory = &v
	return s
}

// SetParent sets the Parent field's value.
func (s *RepositorySyncDefinition) SetParent(v string) *RepositorySyncDefinition {
	s.Parent = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *RepositorySyncDefinition) SetTarget(v string) *RepositorySyncDefinition {
	s.Target = &v
	return s
}

// Information about a repository sync event.
type RepositorySyncEvent struct {
	_ struct{} `type:"structure"`

	// A description of a repository sync event.
	//
	// Event is a required field
	Event *string `type:"string" required:"true"`

	// The ID for a repository sync event.
	ExternalId *string `type:"string"`

	// The time that a repository sync event occurred.
	//
	// Time is a required field
	Time *time.Time `type:"timestamp" required:"true"`

	// The event type for a repository sync event.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySyncEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySyncEvent) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *RepositorySyncEvent) SetEvent(v string) *RepositorySyncEvent {
	s.Event = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *RepositorySyncEvent) SetExternalId(v string) *RepositorySyncEvent {
	s.ExternalId = &v
	return s
}

// SetTime sets the Time field's value.
func (s *RepositorySyncEvent) SetTime(v time.Time) *RepositorySyncEvent {
	s.Time = &v
	return s
}

// SetType sets the Type field's value.
func (s *RepositorySyncEvent) SetType(v string) *RepositorySyncEvent {
	s.Type = &v
	return s
}

// Unable to create resource. Resource already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Resource not found. Verify the connection resource ARN and try again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a resource sync attempt.
type ResourceSyncAttempt struct {
	_ struct{} `type:"structure"`

	// The events related to a resource sync attempt.
	//
	// Events is a required field
	Events []*ResourceSyncEvent `type:"list" required:"true"`

	// The current state of the resource as defined in the resource's config-file
	// in the linked repository.
	//
	// InitialRevision is a required field
	InitialRevision *Revision `type:"structure" required:"true"`

	// The start time for a resource sync attempt.
	//
	// StartedAt is a required field
	StartedAt *time.Time `type:"timestamp" required:"true"`

	// The status for a resource sync attempt. The follow are valid statuses:
	//
	//    * SYNC-INITIATED - A resource sync attempt has been created and will begin
	//    soon.
	//
	//    * SYNCING - Syncing has started and work is being done to reconcile state.
	//
	//    * SYNCED - Syncing has completed successfully.
	//
	//    * SYNC_FAILED - A resource sync attempt has failed.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ResourceSyncStatus"`

	// The name of the Amazon Web Services resource that is attempted to be synchronized.
	//
	// Target is a required field
	Target *string `type:"string" required:"true"`

	// The desired state of the resource as defined in the resource's config-file
	// in the linked repository. Git sync attempts to update the resource to this
	// state.
	//
	// TargetRevision is a required field
	TargetRevision *Revision `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSyncAttempt) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSyncAttempt) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *ResourceSyncAttempt) SetEvents(v []*ResourceSyncEvent) *ResourceSyncAttempt {
	s.Events = v
	return s
}

// SetInitialRevision sets the InitialRevision field's value.
func (s *ResourceSyncAttempt) SetInitialRevision(v *Revision) *ResourceSyncAttempt {
	s.InitialRevision = v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *ResourceSyncAttempt) SetStartedAt(v time.Time) *ResourceSyncAttempt {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResourceSyncAttempt) SetStatus(v string) *ResourceSyncAttempt {
	s.Status = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *ResourceSyncAttempt) SetTarget(v string) *ResourceSyncAttempt {
	s.Target = &v
	return s
}

// SetTargetRevision sets the TargetRevision field's value.
func (s *ResourceSyncAttempt) SetTargetRevision(v *Revision) *ResourceSyncAttempt {
	s.TargetRevision = v
	return s
}

// Information about a resource sync event for the resource associated with
// a sync configuration.
type ResourceSyncEvent struct {
	_ struct{} `type:"structure"`

	// The event for a resource sync event.
	//
	// Event is a required field
	Event *string `type:"string" required:"true"`

	// The ID for a resource sync event.
	ExternalId *string `type:"string"`

	// The time that a resource sync event occurred.
	//
	// Time is a required field
	Time *time.Time `type:"timestamp" required:"true"`

	// The type of resource sync event.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSyncEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSyncEvent) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *ResourceSyncEvent) SetEvent(v string) *ResourceSyncEvent {
	s.Event = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *ResourceSyncEvent) SetExternalId(v string) *ResourceSyncEvent {
	s.ExternalId = &v
	return s
}

// SetTime sets the Time field's value.
func (s *ResourceSyncEvent) SetTime(v time.Time) *ResourceSyncEvent {
	s.Time = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceSyncEvent) SetType(v string) *ResourceSyncEvent {
	s.Type = &v
	return s
}

// Resource not found. Verify the ARN for the host resource and try again.
type ResourceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) GoString() string {
	return s.String()
}

func newErrorResourceUnavailableException(v protocol.ResponseMetadata) error {
	return &ResourceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceUnavailableException) Code() string {
	return "ResourceUnavailableException"
}

// Message returns the exception's message.
func (s *ResourceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceUnavailableException) OrigErr() error {
	return nil
}

func (s *ResourceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Retrying the latest commit failed. Try again later.
type RetryLatestCommitFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryLatestCommitFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryLatestCommitFailedException) GoString() string {
	return s.String()
}

func newErrorRetryLatestCommitFailedException(v protocol.ResponseMetadata) error {
	return &RetryLatestCommitFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RetryLatestCommitFailedException) Code() string {
	return "RetryLatestCommitFailedException"
}

// Message returns the exception's message.
func (s *RetryLatestCommitFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RetryLatestCommitFailedException) OrigErr() error {
	return nil
}

func (s *RetryLatestCommitFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RetryLatestCommitFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RetryLatestCommitFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the revision for a specific sync event, such as the branch,
// owner ID, and name of the repository.
type Revision struct {
	_ struct{} `type:"structure"`

	// The branch name for a specific revision.
	//
	// Branch is a required field
	Branch *string `min:"1" type:"string" required:"true"`

	// The directory, if any, for a specific revision.
	//
	// Directory is a required field
	Directory *string `type:"string" required:"true"`

	// The owner ID for a specific revision, such as the GitHub owner ID for a GitHub
	// repository.
	//
	// OwnerId is a required field
	OwnerId *string `min:"1" type:"string" required:"true"`

	// The provider type for a revision, such as GitHub.
	//
	// ProviderType is a required field
	ProviderType *string `type:"string" required:"true" enum:"ProviderType"`

	// The repository name for a specific revision.
	//
	// RepositoryName is a required field
	RepositoryName *string `min:"1" type:"string" required:"true"`

	// The SHA, such as the commit ID, for a specific revision.
	//
	// Sha is a required field
	Sha *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Revision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Revision) GoString() string {
	return s.String()
}

// SetBranch sets the Branch field's value.
func (s *Revision) SetBranch(v string) *Revision {
	s.Branch = &v
	return s
}

// SetDirectory sets the Directory field's value.
func (s *Revision) SetDirectory(v string) *Revision {
	s.Directory = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *Revision) SetOwnerId(v string) *Revision {
	s.OwnerId = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *Revision) SetProviderType(v string) *Revision {
	s.ProviderType = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *Revision) SetRepositoryName(v string) *Revision {
	s.RepositoryName = &v
	return s
}

// SetSha sets the Sha field's value.
func (s *Revision) SetSha(v string) *Revision {
	s.Sha = &v
	return s
}

// Information about a blocker for a sync event.
type SyncBlocker struct {
	_ struct{} `type:"structure"`

	// The contexts for a specific sync blocker.
	Contexts []*SyncBlockerContext `type:"list"`

	// The creation time for a specific sync blocker.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The provided reason for a specific sync blocker.
	//
	// CreatedReason is a required field
	CreatedReason *string `type:"string" required:"true"`

	// The ID for a specific sync blocker.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The time that a specific sync blocker was resolved.
	ResolvedAt *time.Time `type:"timestamp"`

	// The resolved reason for a specific sync blocker.
	ResolvedReason *string `min:"1" type:"string"`

	// The status for a specific sync blocker.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"BlockerStatus"`

	// The sync blocker type.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"BlockerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncBlocker) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncBlocker) GoString() string {
	return s.String()
}

// SetContexts sets the Contexts field's value.
func (s *SyncBlocker) SetContexts(v []*SyncBlockerContext) *SyncBlocker {
	s.Contexts = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SyncBlocker) SetCreatedAt(v time.Time) *SyncBlocker {
	s.CreatedAt = &v
	return s
}

// SetCreatedReason sets the CreatedReason field's value.
func (s *SyncBlocker) SetCreatedReason(v string) *SyncBlocker {
	s.CreatedReason = &v
	return s
}

// SetId sets the Id field's value.
func (s *SyncBlocker) SetId(v string) *SyncBlocker {
	s.Id = &v
	return s
}

// SetResolvedAt sets the ResolvedAt field's value.
func (s *SyncBlocker) SetResolvedAt(v time.Time) *SyncBlocker {
	s.ResolvedAt = &v
	return s
}

// SetResolvedReason sets the ResolvedReason field's value.
func (s *SyncBlocker) SetResolvedReason(v string) *SyncBlocker {
	s.ResolvedReason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SyncBlocker) SetStatus(v string) *SyncBlocker {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *SyncBlocker) SetType(v string) *SyncBlocker {
	s.Type = &v
	return s
}

// The context for a specific sync blocker.
type SyncBlockerContext struct {
	_ struct{} `type:"structure"`

	// The key provided for a context key-value pair for a specific sync blocker.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The value provided for a context key-value pair for a specific sync blocker.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncBlockerContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncBlockerContext) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *SyncBlockerContext) SetKey(v string) *SyncBlockerContext {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SyncBlockerContext) SetValue(v string) *SyncBlockerContext {
	s.Value = &v
	return s
}

// Unable to continue. The sync blocker does not exist.
type SyncBlockerDoesNotExistException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncBlockerDoesNotExistException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncBlockerDoesNotExistException) GoString() string {
	return s.String()
}

func newErrorSyncBlockerDoesNotExistException(v protocol.ResponseMetadata) error {
	return &SyncBlockerDoesNotExistException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SyncBlockerDoesNotExistException) Code() string {
	return "SyncBlockerDoesNotExistException"
}

// Message returns the exception's message.
func (s *SyncBlockerDoesNotExistException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SyncBlockerDoesNotExistException) OrigErr() error {
	return nil
}

func (s *SyncBlockerDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SyncBlockerDoesNotExistException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SyncBlockerDoesNotExistException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A summary for sync blockers.
type SyncBlockerSummary struct {
	_ struct{} `type:"structure"`

	// The latest events for a sync blocker summary.
	LatestBlockers []*SyncBlocker `type:"list"`

	// The parent resource name for a sync blocker summary.
	ParentResourceName *string `min:"1" type:"string"`

	// The resource name for sync blocker summary.
	//
	// ResourceName is a required field
	ResourceName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncBlockerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncBlockerSummary) GoString() string {
	return s.String()
}

// SetLatestBlockers sets the LatestBlockers field's value.
func (s *SyncBlockerSummary) SetLatestBlockers(v []*SyncBlocker) *SyncBlockerSummary {
	s.LatestBlockers = v
	return s
}

// SetParentResourceName sets the ParentResourceName field's value.
func (s *SyncBlockerSummary) SetParentResourceName(v string) *SyncBlockerSummary {
	s.ParentResourceName = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *SyncBlockerSummary) SetResourceName(v string) *SyncBlockerSummary {
	s.ResourceName = &v
	return s
}

// Information, such as repository, branch, provider, and resource names for
// a specific sync configuration.
type SyncConfiguration struct {
	_ struct{} `type:"structure"`

	// The branch associated with a specific sync configuration.
	//
	// Branch is a required field
	Branch *string `min:"1" type:"string" required:"true"`

	// The file path to the configuration file associated with a specific sync configuration.
	// The path should point to an actual file in the sync configurations linked
	// repository.
	ConfigFile *string `type:"string"`

	// The owner ID for the repository associated with a specific sync configuration,
	// such as the owner ID in GitHub.
	//
	// OwnerId is a required field
	OwnerId *string `min:"1" type:"string" required:"true"`

	// The connection provider type associated with a specific sync configuration,
	// such as GitHub.
	//
	// ProviderType is a required field
	ProviderType *string `type:"string" required:"true" enum:"ProviderType"`

	// Whether to enable or disable publishing of deployment status to source providers.
	PublishDeploymentStatus *string `type:"string" enum:"PublishDeploymentStatus"`

	// The ID of the repository link associated with a specific sync configuration.
	//
	// RepositoryLinkId is a required field
	RepositoryLinkId *string `type:"string" required:"true"`

	// The name of the repository associated with a specific sync configuration.
	//
	// RepositoryName is a required field
	RepositoryName *string `min:"1" type:"string" required:"true"`

	// The name of the connection resource associated with a specific sync configuration.
	//
	// ResourceName is a required field
	ResourceName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role associated with a specific
	// sync configuration.
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// The type of sync for a specific sync configuration.
	//
	// SyncType is a required field
	SyncType *string `type:"string" required:"true" enum:"SyncConfigurationType"`

	// When to trigger Git sync to begin the stack update.
	TriggerResourceUpdateOn *string `type:"string" enum:"TriggerResourceUpdateOn"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncConfiguration) GoString() string {
	return s.String()
}

// SetBranch sets the Branch field's value.
func (s *SyncConfiguration) SetBranch(v string) *SyncConfiguration {
	s.Branch = &v
	return s
}

// SetConfigFile sets the ConfigFile field's value.
func (s *SyncConfiguration) SetConfigFile(v string) *SyncConfiguration {
	s.ConfigFile = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *SyncConfiguration) SetOwnerId(v string) *SyncConfiguration {
	s.OwnerId = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *SyncConfiguration) SetProviderType(v string) *SyncConfiguration {
	s.ProviderType = &v
	return s
}

// SetPublishDeploymentStatus sets the PublishDeploymentStatus field's value.
func (s *SyncConfiguration) SetPublishDeploymentStatus(v string) *SyncConfiguration {
	s.PublishDeploymentStatus = &v
	return s
}

// SetRepositoryLinkId sets the RepositoryLinkId field's value.
func (s *SyncConfiguration) SetRepositoryLinkId(v string) *SyncConfiguration {
	s.RepositoryLinkId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *SyncConfiguration) SetRepositoryName(v string) *SyncConfiguration {
	s.RepositoryName = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *SyncConfiguration) SetResourceName(v string) *SyncConfiguration {
	s.ResourceName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *SyncConfiguration) SetRoleArn(v string) *SyncConfiguration {
	s.RoleArn = &v
	return s
}

// SetSyncType sets the SyncType field's value.
func (s *SyncConfiguration) SetSyncType(v string) *SyncConfiguration {
	s.SyncType = &v
	return s
}

// SetTriggerResourceUpdateOn sets the TriggerResourceUpdateOn field's value.
func (s *SyncConfiguration) SetTriggerResourceUpdateOn(v string) *SyncConfiguration {
	s.TriggerResourceUpdateOn = &v
	return s
}

// Unable to continue. The sync blocker still exists.
type SyncConfigurationStillExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncConfigurationStillExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncConfigurationStillExistsException) GoString() string {
	return s.String()
}

func newErrorSyncConfigurationStillExistsException(v protocol.ResponseMetadata) error {
	return &SyncConfigurationStillExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SyncConfigurationStillExistsException) Code() string {
	return "SyncConfigurationStillExistsException"
}

// Message returns the exception's message.
func (s *SyncConfigurationStillExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SyncConfigurationStillExistsException) OrigErr() error {
	return nil
}

func (s *SyncConfigurationStillExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SyncConfigurationStillExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SyncConfigurationStillExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A tag is a key-value pair that is used to manage the resource.
//
// This tag is available for use by Amazon Web Services services that support
// tags.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The tag's value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to which you want to add or
	// update tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tags you want to modify or add to the resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation is not supported. Check the connection status and try again.
type UnsupportedOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedOperationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedOperationException(v protocol.ResponseMetadata) error {
	return &UnsupportedOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedOperationException) Code() string {
	return "UnsupportedOperationException"
}

// Message returns the exception's message.
func (s *UnsupportedOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedOperationException) OrigErr() error {
	return nil
}

func (s *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified provider type is not supported for connections.
type UnsupportedProviderTypeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedProviderTypeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedProviderTypeException) GoString() string {
	return s.String()
}

func newErrorUnsupportedProviderTypeException(v protocol.ResponseMetadata) error {
	return &UnsupportedProviderTypeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedProviderTypeException) Code() string {
	return "UnsupportedProviderTypeException"
}

// Message returns the exception's message.
func (s *UnsupportedProviderTypeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedProviderTypeException) OrigErr() error {
	return nil
}

func (s *UnsupportedProviderTypeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedProviderTypeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedProviderTypeException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to remove tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The list of keys for the tags to be removed from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateHostInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the host to be updated.
	//
	// HostArn is a required field
	HostArn *string `type:"string" required:"true"`

	// The URL or endpoint of the host to be updated.
	ProviderEndpoint *string `min:"1" type:"string"`

	// The VPC configuration of the host to be updated. A VPC must be configured
	// and the infrastructure to be represented by the host must already be connected
	// to the VPC.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateHostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateHostInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateHostInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateHostInput"}
	if s.HostArn == nil {
		invalidParams.Add(request.NewErrParamRequired("HostArn"))
	}
	if s.ProviderEndpoint != nil && len(*s.ProviderEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderEndpoint", 1))
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostArn sets the HostArn field's value.
func (s *UpdateHostInput) SetHostArn(v string) *UpdateHostInput {
	s.HostArn = &v
	return s
}

// SetProviderEndpoint sets the ProviderEndpoint field's value.
func (s *UpdateHostInput) SetProviderEndpoint(v string) *UpdateHostInput {
	s.ProviderEndpoint = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *UpdateHostInput) SetVpcConfiguration(v *VpcConfiguration) *UpdateHostInput {
	s.VpcConfiguration = v
	return s
}

type UpdateHostOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateHostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateHostOutput) GoString() string {
	return s.String()
}

// The update is out of sync. Try syncing again.
type UpdateOutOfSyncException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOutOfSyncException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOutOfSyncException) GoString() string {
	return s.String()
}

func newErrorUpdateOutOfSyncException(v protocol.ResponseMetadata) error {
	return &UpdateOutOfSyncException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UpdateOutOfSyncException) Code() string {
	return "UpdateOutOfSyncException"
}

// Message returns the exception's message.
func (s *UpdateOutOfSyncException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UpdateOutOfSyncException) OrigErr() error {
	return nil
}

func (s *UpdateOutOfSyncException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UpdateOutOfSyncException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UpdateOutOfSyncException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateRepositoryLinkInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connection for the repository link
	// to be updated. The updated connection ARN must have the same providerType
	// (such as GitHub) as the original connection ARN for the repo link.
	ConnectionArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the encryption key for the repository link
	// to be updated.
	EncryptionKeyArn *string `min:"1" type:"string"`

	// The ID of the repository link to be updated.
	//
	// RepositoryLinkId is a required field
	RepositoryLinkId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRepositoryLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRepositoryLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRepositoryLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRepositoryLinkInput"}
	if s.EncryptionKeyArn != nil && len(*s.EncryptionKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKeyArn", 1))
	}
	if s.RepositoryLinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryLinkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *UpdateRepositoryLinkInput) SetConnectionArn(v string) *UpdateRepositoryLinkInput {
	s.ConnectionArn = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *UpdateRepositoryLinkInput) SetEncryptionKeyArn(v string) *UpdateRepositoryLinkInput {
	s.EncryptionKeyArn = &v
	return s
}

// SetRepositoryLinkId sets the RepositoryLinkId field's value.
func (s *UpdateRepositoryLinkInput) SetRepositoryLinkId(v string) *UpdateRepositoryLinkInput {
	s.RepositoryLinkId = &v
	return s
}

type UpdateRepositoryLinkOutput struct {
	_ struct{} `type:"structure"`

	// Information about the repository link to be updated.
	//
	// RepositoryLinkInfo is a required field
	RepositoryLinkInfo *RepositoryLinkInfo `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRepositoryLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRepositoryLinkOutput) GoString() string {
	return s.String()
}

// SetRepositoryLinkInfo sets the RepositoryLinkInfo field's value.
func (s *UpdateRepositoryLinkOutput) SetRepositoryLinkInfo(v *RepositoryLinkInfo) *UpdateRepositoryLinkOutput {
	s.RepositoryLinkInfo = v
	return s
}

type UpdateSyncBlockerInput struct {
	_ struct{} `type:"structure"`

	// The ID of the sync blocker to be updated.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The reason for resolving the sync blocker.
	//
	// ResolvedReason is a required field
	ResolvedReason *string `min:"1" type:"string" required:"true"`

	// The name of the resource for the sync blocker to be updated.
	//
	// ResourceName is a required field
	ResourceName *string `min:"1" type:"string" required:"true"`

	// The sync type of the sync blocker to be updated.
	//
	// SyncType is a required field
	SyncType *string `type:"string" required:"true" enum:"SyncConfigurationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSyncBlockerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSyncBlockerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSyncBlockerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSyncBlockerInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.ResolvedReason == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolvedReason"))
	}
	if s.ResolvedReason != nil && len(*s.ResolvedReason) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolvedReason", 1))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.ResourceName != nil && len(*s.ResourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceName", 1))
	}
	if s.SyncType == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateSyncBlockerInput) SetId(v string) *UpdateSyncBlockerInput {
	s.Id = &v
	return s
}

// SetResolvedReason sets the ResolvedReason field's value.
func (s *UpdateSyncBlockerInput) SetResolvedReason(v string) *UpdateSyncBlockerInput {
	s.ResolvedReason = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *UpdateSyncBlockerInput) SetResourceName(v string) *UpdateSyncBlockerInput {
	s.ResourceName = &v
	return s
}

// SetSyncType sets the SyncType field's value.
func (s *UpdateSyncBlockerInput) SetSyncType(v string) *UpdateSyncBlockerInput {
	s.SyncType = &v
	return s
}

type UpdateSyncBlockerOutput struct {
	_ struct{} `type:"structure"`

	// The parent resource name for the sync blocker.
	ParentResourceName *string `min:"1" type:"string"`

	// The resource name for the sync blocker.
	//
	// ResourceName is a required field
	ResourceName *string `min:"1" type:"string" required:"true"`

	// Information about the sync blocker to be updated.
	//
	// SyncBlocker is a required field
	SyncBlocker *SyncBlocker `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSyncBlockerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSyncBlockerOutput) GoString() string {
	return s.String()
}

// SetParentResourceName sets the ParentResourceName field's value.
func (s *UpdateSyncBlockerOutput) SetParentResourceName(v string) *UpdateSyncBlockerOutput {
	s.ParentResourceName = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *UpdateSyncBlockerOutput) SetResourceName(v string) *UpdateSyncBlockerOutput {
	s.ResourceName = &v
	return s
}

// SetSyncBlocker sets the SyncBlocker field's value.
func (s *UpdateSyncBlockerOutput) SetSyncBlocker(v *SyncBlocker) *UpdateSyncBlockerOutput {
	s.SyncBlocker = v
	return s
}

type UpdateSyncConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The branch for the sync configuration to be updated.
	Branch *string `min:"1" type:"string"`

	// The configuration file for the sync configuration to be updated.
	ConfigFile *string `type:"string"`

	// Whether to enable or disable publishing of deployment status to source providers.
	PublishDeploymentStatus *string `type:"string" enum:"PublishDeploymentStatus"`

	// The ID of the repository link for the sync configuration to be updated.
	RepositoryLinkId *string `type:"string"`

	// The name of the Amazon Web Services resource for the sync configuration to
	// be updated.
	//
	// ResourceName is a required field
	ResourceName *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role for the sync configuration to be updated.
	RoleArn *string `min:"1" type:"string"`

	// The sync type for the sync configuration to be updated.
	//
	// SyncType is a required field
	SyncType *string `type:"string" required:"true" enum:"SyncConfigurationType"`

	// When to trigger Git sync to begin the stack update.
	TriggerResourceUpdateOn *string `type:"string" enum:"TriggerResourceUpdateOn"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSyncConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSyncConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSyncConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSyncConfigurationInput"}
	if s.Branch != nil && len(*s.Branch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Branch", 1))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.ResourceName != nil && len(*s.ResourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceName", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.SyncType == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranch sets the Branch field's value.
func (s *UpdateSyncConfigurationInput) SetBranch(v string) *UpdateSyncConfigurationInput {
	s.Branch = &v
	return s
}

// SetConfigFile sets the ConfigFile field's value.
func (s *UpdateSyncConfigurationInput) SetConfigFile(v string) *UpdateSyncConfigurationInput {
	s.ConfigFile = &v
	return s
}

// SetPublishDeploymentStatus sets the PublishDeploymentStatus field's value.
func (s *UpdateSyncConfigurationInput) SetPublishDeploymentStatus(v string) *UpdateSyncConfigurationInput {
	s.PublishDeploymentStatus = &v
	return s
}

// SetRepositoryLinkId sets the RepositoryLinkId field's value.
func (s *UpdateSyncConfigurationInput) SetRepositoryLinkId(v string) *UpdateSyncConfigurationInput {
	s.RepositoryLinkId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *UpdateSyncConfigurationInput) SetResourceName(v string) *UpdateSyncConfigurationInput {
	s.ResourceName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateSyncConfigurationInput) SetRoleArn(v string) *UpdateSyncConfigurationInput {
	s.RoleArn = &v
	return s
}

// SetSyncType sets the SyncType field's value.
func (s *UpdateSyncConfigurationInput) SetSyncType(v string) *UpdateSyncConfigurationInput {
	s.SyncType = &v
	return s
}

// SetTriggerResourceUpdateOn sets the TriggerResourceUpdateOn field's value.
func (s *UpdateSyncConfigurationInput) SetTriggerResourceUpdateOn(v string) *UpdateSyncConfigurationInput {
	s.TriggerResourceUpdateOn = &v
	return s
}

type UpdateSyncConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The information returned for the sync configuration to be updated.
	//
	// SyncConfiguration is a required field
	SyncConfiguration *SyncConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSyncConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSyncConfigurationOutput) GoString() string {
	return s.String()
}

// SetSyncConfiguration sets the SyncConfiguration field's value.
func (s *UpdateSyncConfigurationOutput) SetSyncConfiguration(v *SyncConfiguration) *UpdateSyncConfigurationOutput {
	s.SyncConfiguration = v
	return s
}

// The VPC configuration provisioned for the host.
type VpcConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID of the security group or security groups associated with the Amazon
	// VPC connected to the infrastructure where your provider type is installed.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `min:"1" type:"list" required:"true"`

	// The ID of the subnet or subnets associated with the Amazon VPC connected
	// to the infrastructure where your provider type is installed.
	//
	// SubnetIds is a required field
	SubnetIds []*string `min:"1" type:"list" required:"true"`

	// The value of the Transport Layer Security (TLS) certificate associated with
	// the infrastructure where your provider type is installed.
	TlsCertificate *string `min:"1" type:"string"`

	// The ID of the Amazon VPC connected to the infrastructure where your provider
	// type is installed.
	//
	// VpcId is a required field
	VpcId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfiguration"}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 1))
	}
	if s.TlsCertificate != nil && len(*s.TlsCertificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TlsCertificate", 1))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.VpcId != nil && len(*s.VpcId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfiguration) SetSecurityGroupIds(v []*string) *VpcConfiguration {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfiguration) SetSubnetIds(v []*string) *VpcConfiguration {
	s.SubnetIds = v
	return s
}

// SetTlsCertificate sets the TlsCertificate field's value.
func (s *VpcConfiguration) SetTlsCertificate(v string) *VpcConfiguration {
	s.TlsCertificate = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfiguration) SetVpcId(v string) *VpcConfiguration {
	s.VpcId = &v
	return s
}

const (
	// BlockerStatusActive is a BlockerStatus enum value
	BlockerStatusActive = "ACTIVE"

	// BlockerStatusResolved is a BlockerStatus enum value
	BlockerStatusResolved = "RESOLVED"
)

// BlockerStatus_Values returns all elements of the BlockerStatus enum
func BlockerStatus_Values() []string {
	return []string{
		BlockerStatusActive,
		BlockerStatusResolved,
	}
}

const (
	// BlockerTypeAutomated is a BlockerType enum value
	BlockerTypeAutomated = "AUTOMATED"
)

// BlockerType_Values returns all elements of the BlockerType enum
func BlockerType_Values() []string {
	return []string{
		BlockerTypeAutomated,
	}
}

const (
	// ConnectionStatusPending is a ConnectionStatus enum value
	ConnectionStatusPending = "PENDING"

	// ConnectionStatusAvailable is a ConnectionStatus enum value
	ConnectionStatusAvailable = "AVAILABLE"

	// ConnectionStatusError is a ConnectionStatus enum value
	ConnectionStatusError = "ERROR"
)

// ConnectionStatus_Values returns all elements of the ConnectionStatus enum
func ConnectionStatus_Values() []string {
	return []string{
		ConnectionStatusPending,
		ConnectionStatusAvailable,
		ConnectionStatusError,
	}
}

const (
	// ProviderTypeBitbucket is a ProviderType enum value
	ProviderTypeBitbucket = "Bitbucket"

	// ProviderTypeGitHub is a ProviderType enum value
	ProviderTypeGitHub = "GitHub"

	// ProviderTypeGitHubEnterpriseServer is a ProviderType enum value
	ProviderTypeGitHubEnterpriseServer = "GitHubEnterpriseServer"

	// ProviderTypeGitLab is a ProviderType enum value
	ProviderTypeGitLab = "GitLab"

	// ProviderTypeGitLabSelfManaged is a ProviderType enum value
	ProviderTypeGitLabSelfManaged = "GitLabSelfManaged"
)

// ProviderType_Values returns all elements of the ProviderType enum
func ProviderType_Values() []string {
	return []string{
		ProviderTypeBitbucket,
		ProviderTypeGitHub,
		ProviderTypeGitHubEnterpriseServer,
		ProviderTypeGitLab,
		ProviderTypeGitLabSelfManaged,
	}
}

const (
	// PublishDeploymentStatusEnabled is a PublishDeploymentStatus enum value
	PublishDeploymentStatusEnabled = "ENABLED"

	// PublishDeploymentStatusDisabled is a PublishDeploymentStatus enum value
	PublishDeploymentStatusDisabled = "DISABLED"
)

// PublishDeploymentStatus_Values returns all elements of the PublishDeploymentStatus enum
func PublishDeploymentStatus_Values() []string {
	return []string{
		PublishDeploymentStatusEnabled,
		PublishDeploymentStatusDisabled,
	}
}

const (
	// RepositorySyncStatusFailed is a RepositorySyncStatus enum value
	RepositorySyncStatusFailed = "FAILED"

	// RepositorySyncStatusInitiated is a RepositorySyncStatus enum value
	RepositorySyncStatusInitiated = "INITIATED"

	// RepositorySyncStatusInProgress is a RepositorySyncStatus enum value
	RepositorySyncStatusInProgress = "IN_PROGRESS"

	// RepositorySyncStatusSucceeded is a RepositorySyncStatus enum value
	RepositorySyncStatusSucceeded = "SUCCEEDED"

	// RepositorySyncStatusQueued is a RepositorySyncStatus enum value
	RepositorySyncStatusQueued = "QUEUED"
)

// RepositorySyncStatus_Values returns all elements of the RepositorySyncStatus enum
func RepositorySyncStatus_Values() []string {
	return []string{
		RepositorySyncStatusFailed,
		RepositorySyncStatusInitiated,
		RepositorySyncStatusInProgress,
		RepositorySyncStatusSucceeded,
		RepositorySyncStatusQueued,
	}
}

const (
	// ResourceSyncStatusFailed is a ResourceSyncStatus enum value
	ResourceSyncStatusFailed = "FAILED"

	// ResourceSyncStatusInitiated is a ResourceSyncStatus enum value
	ResourceSyncStatusInitiated = "INITIATED"

	// ResourceSyncStatusInProgress is a ResourceSyncStatus enum value
	ResourceSyncStatusInProgress = "IN_PROGRESS"

	// ResourceSyncStatusSucceeded is a ResourceSyncStatus enum value
	ResourceSyncStatusSucceeded = "SUCCEEDED"
)

// ResourceSyncStatus_Values returns all elements of the ResourceSyncStatus enum
func ResourceSyncStatus_Values() []string {
	return []string{
		ResourceSyncStatusFailed,
		ResourceSyncStatusInitiated,
		ResourceSyncStatusInProgress,
		ResourceSyncStatusSucceeded,
	}
}

const (
	// SyncConfigurationTypeCfnStackSync is a SyncConfigurationType enum value
	SyncConfigurationTypeCfnStackSync = "CFN_STACK_SYNC"
)

// SyncConfigurationType_Values returns all elements of the SyncConfigurationType enum
func SyncConfigurationType_Values() []string {
	return []string{
		SyncConfigurationTypeCfnStackSync,
	}
}

const (
	// TriggerResourceUpdateOnAnyChange is a TriggerResourceUpdateOn enum value
	TriggerResourceUpdateOnAnyChange = "ANY_CHANGE"

	// TriggerResourceUpdateOnFileChange is a TriggerResourceUpdateOn enum value
	TriggerResourceUpdateOnFileChange = "FILE_CHANGE"
)

// TriggerResourceUpdateOn_Values returns all elements of the TriggerResourceUpdateOn enum
func TriggerResourceUpdateOn_Values() []string {
	return []string{
		TriggerResourceUpdateOnAnyChange,
		TriggerResourceUpdateOnFileChange,
	}
}
