// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/gkemulticloud/v1/common_resources.proto

package gkemulticloudpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The taint effect.
type NodeTaint_Effect int32

const (
	// Not set.
	NodeTaint_EFFECT_UNSPECIFIED NodeTaint_Effect = 0
	// Do not allow new pods to schedule onto the node unless they tolerate the
	// taint, but allow all pods submitted to Kubelet without going through the
	// scheduler to start, and allow all already-running pods to continue
	// running. Enforced by the scheduler.
	NodeTaint_NO_SCHEDULE NodeTaint_Effect = 1
	// Like TaintEffectNoSchedule, but the scheduler tries not to schedule
	// new pods onto the node, rather than prohibiting new pods from scheduling
	// onto the node entirely. Enforced by the scheduler.
	NodeTaint_PREFER_NO_SCHEDULE NodeTaint_Effect = 2
	// Evict any already-running pods that do not tolerate the taint.
	// Currently enforced by NodeController.
	NodeTaint_NO_EXECUTE NodeTaint_Effect = 3
)

// Enum value maps for NodeTaint_Effect.
var (
	NodeTaint_Effect_name = map[int32]string{
		0: "EFFECT_UNSPECIFIED",
		1: "NO_SCHEDULE",
		2: "PREFER_NO_SCHEDULE",
		3: "NO_EXECUTE",
	}
	NodeTaint_Effect_value = map[string]int32{
		"EFFECT_UNSPECIFIED": 0,
		"NO_SCHEDULE":        1,
		"PREFER_NO_SCHEDULE": 2,
		"NO_EXECUTE":         3,
	}
)

func (x NodeTaint_Effect) Enum() *NodeTaint_Effect {
	p := new(NodeTaint_Effect)
	*p = x
	return p
}

func (x NodeTaint_Effect) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeTaint_Effect) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes[0].Descriptor()
}

func (NodeTaint_Effect) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes[0]
}

func (x NodeTaint_Effect) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeTaint_Effect.Descriptor instead.
func (NodeTaint_Effect) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{4, 0}
}

// The components of the logging configuration;
type LoggingComponentConfig_Component int32

const (
	// No component is specified
	LoggingComponentConfig_COMPONENT_UNSPECIFIED LoggingComponentConfig_Component = 0
	// This indicates that system logging components is enabled.
	LoggingComponentConfig_SYSTEM_COMPONENTS LoggingComponentConfig_Component = 1
	// This indicates that user workload logging component is enabled.
	LoggingComponentConfig_WORKLOADS LoggingComponentConfig_Component = 2
)

// Enum value maps for LoggingComponentConfig_Component.
var (
	LoggingComponentConfig_Component_name = map[int32]string{
		0: "COMPONENT_UNSPECIFIED",
		1: "SYSTEM_COMPONENTS",
		2: "WORKLOADS",
	}
	LoggingComponentConfig_Component_value = map[string]int32{
		"COMPONENT_UNSPECIFIED": 0,
		"SYSTEM_COMPONENTS":     1,
		"WORKLOADS":             2,
	}
)

func (x LoggingComponentConfig_Component) Enum() *LoggingComponentConfig_Component {
	p := new(LoggingComponentConfig_Component)
	*p = x
	return p
}

func (x LoggingComponentConfig_Component) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoggingComponentConfig_Component) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes[1].Descriptor()
}

func (LoggingComponentConfig_Component) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes[1]
}

func (x LoggingComponentConfig_Component) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoggingComponentConfig_Component.Descriptor instead.
func (LoggingComponentConfig_Component) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{8, 0}
}

// Binary Authorization mode of operation.
type BinaryAuthorization_EvaluationMode int32

const (
	// Default value
	BinaryAuthorization_EVALUATION_MODE_UNSPECIFIED BinaryAuthorization_EvaluationMode = 0
	// Disable BinaryAuthorization
	BinaryAuthorization_DISABLED BinaryAuthorization_EvaluationMode = 1
	// Enforce Kubernetes admission requests with BinaryAuthorization using the
	// project's singleton policy.
	BinaryAuthorization_PROJECT_SINGLETON_POLICY_ENFORCE BinaryAuthorization_EvaluationMode = 2
)

// Enum value maps for BinaryAuthorization_EvaluationMode.
var (
	BinaryAuthorization_EvaluationMode_name = map[int32]string{
		0: "EVALUATION_MODE_UNSPECIFIED",
		1: "DISABLED",
		2: "PROJECT_SINGLETON_POLICY_ENFORCE",
	}
	BinaryAuthorization_EvaluationMode_value = map[string]int32{
		"EVALUATION_MODE_UNSPECIFIED":      0,
		"DISABLED":                         1,
		"PROJECT_SINGLETON_POLICY_ENFORCE": 2,
	}
)

func (x BinaryAuthorization_EvaluationMode) Enum() *BinaryAuthorization_EvaluationMode {
	p := new(BinaryAuthorization_EvaluationMode)
	*p = x
	return p
}

func (x BinaryAuthorization_EvaluationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BinaryAuthorization_EvaluationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes[2].Descriptor()
}

func (BinaryAuthorization_EvaluationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes[2]
}

func (x BinaryAuthorization_EvaluationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BinaryAuthorization_EvaluationMode.Descriptor instead.
func (BinaryAuthorization_EvaluationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{12, 0}
}

// VulnerabilityMode defines enablement mode for vulnerability scanning.
type SecurityPostureConfig_VulnerabilityMode int32

const (
	// Default value not specified.
	SecurityPostureConfig_VULNERABILITY_MODE_UNSPECIFIED SecurityPostureConfig_VulnerabilityMode = 0
	// Disables vulnerability scanning on the cluster.
	SecurityPostureConfig_VULNERABILITY_DISABLED SecurityPostureConfig_VulnerabilityMode = 1
	// Applies the Security Posture's vulnerability on cluster Enterprise level
	// features.
	SecurityPostureConfig_VULNERABILITY_ENTERPRISE SecurityPostureConfig_VulnerabilityMode = 2
)

// Enum value maps for SecurityPostureConfig_VulnerabilityMode.
var (
	SecurityPostureConfig_VulnerabilityMode_name = map[int32]string{
		0: "VULNERABILITY_MODE_UNSPECIFIED",
		1: "VULNERABILITY_DISABLED",
		2: "VULNERABILITY_ENTERPRISE",
	}
	SecurityPostureConfig_VulnerabilityMode_value = map[string]int32{
		"VULNERABILITY_MODE_UNSPECIFIED": 0,
		"VULNERABILITY_DISABLED":         1,
		"VULNERABILITY_ENTERPRISE":       2,
	}
)

func (x SecurityPostureConfig_VulnerabilityMode) Enum() *SecurityPostureConfig_VulnerabilityMode {
	p := new(SecurityPostureConfig_VulnerabilityMode)
	*p = x
	return p
}

func (x SecurityPostureConfig_VulnerabilityMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityPostureConfig_VulnerabilityMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes[3].Descriptor()
}

func (SecurityPostureConfig_VulnerabilityMode) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes[3]
}

func (x SecurityPostureConfig_VulnerabilityMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityPostureConfig_VulnerabilityMode.Descriptor instead.
func (SecurityPostureConfig_VulnerabilityMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{13, 0}
}

// Jwk is a JSON Web Key as specified in RFC 7517.
type Jwk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key Type.
	Kty string `protobuf:"bytes,1,opt,name=kty,proto3" json:"kty,omitempty"`
	// Algorithm.
	Alg string `protobuf:"bytes,2,opt,name=alg,proto3" json:"alg,omitempty"`
	// Permitted uses for the public keys.
	Use string `protobuf:"bytes,3,opt,name=use,proto3" json:"use,omitempty"`
	// Key ID.
	Kid string `protobuf:"bytes,4,opt,name=kid,proto3" json:"kid,omitempty"`
	// Used for RSA keys.
	N string `protobuf:"bytes,5,opt,name=n,proto3" json:"n,omitempty"`
	// Used for RSA keys.
	E string `protobuf:"bytes,6,opt,name=e,proto3" json:"e,omitempty"`
	// Used for ECDSA keys.
	X string `protobuf:"bytes,7,opt,name=x,proto3" json:"x,omitempty"`
	// Used for ECDSA keys.
	Y string `protobuf:"bytes,8,opt,name=y,proto3" json:"y,omitempty"`
	// Used for ECDSA keys.
	Crv string `protobuf:"bytes,9,opt,name=crv,proto3" json:"crv,omitempty"`
}

func (x *Jwk) Reset() {
	*x = Jwk{}
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Jwk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Jwk) ProtoMessage() {}

func (x *Jwk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Jwk.ProtoReflect.Descriptor instead.
func (*Jwk) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Jwk) GetKty() string {
	if x != nil {
		return x.Kty
	}
	return ""
}

func (x *Jwk) GetAlg() string {
	if x != nil {
		return x.Alg
	}
	return ""
}

func (x *Jwk) GetUse() string {
	if x != nil {
		return x.Use
	}
	return ""
}

func (x *Jwk) GetKid() string {
	if x != nil {
		return x.Kid
	}
	return ""
}

func (x *Jwk) GetN() string {
	if x != nil {
		return x.N
	}
	return ""
}

func (x *Jwk) GetE() string {
	if x != nil {
		return x.E
	}
	return ""
}

func (x *Jwk) GetX() string {
	if x != nil {
		return x.X
	}
	return ""
}

func (x *Jwk) GetY() string {
	if x != nil {
		return x.Y
	}
	return ""
}

func (x *Jwk) GetCrv() string {
	if x != nil {
		return x.Crv
	}
	return ""
}

// Workload Identity settings.
type WorkloadIdentityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The OIDC issuer URL for this cluster.
	IssuerUri string `protobuf:"bytes,1,opt,name=issuer_uri,json=issuerUri,proto3" json:"issuer_uri,omitempty"`
	// The Workload Identity Pool associated to the cluster.
	WorkloadPool string `protobuf:"bytes,2,opt,name=workload_pool,json=workloadPool,proto3" json:"workload_pool,omitempty"`
	// The ID of the OIDC Identity Provider (IdP) associated to the Workload
	// Identity Pool.
	IdentityProvider string `protobuf:"bytes,3,opt,name=identity_provider,json=identityProvider,proto3" json:"identity_provider,omitempty"`
}

func (x *WorkloadIdentityConfig) Reset() {
	*x = WorkloadIdentityConfig{}
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkloadIdentityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadIdentityConfig) ProtoMessage() {}

func (x *WorkloadIdentityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadIdentityConfig.ProtoReflect.Descriptor instead.
func (*WorkloadIdentityConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{1}
}

func (x *WorkloadIdentityConfig) GetIssuerUri() string {
	if x != nil {
		return x.IssuerUri
	}
	return ""
}

func (x *WorkloadIdentityConfig) GetWorkloadPool() string {
	if x != nil {
		return x.WorkloadPool
	}
	return ""
}

func (x *WorkloadIdentityConfig) GetIdentityProvider() string {
	if x != nil {
		return x.IdentityProvider
	}
	return ""
}

// Constraints applied to pods.
type MaxPodsConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The maximum number of pods to schedule on a single node.
	MaxPodsPerNode int64 `protobuf:"varint,1,opt,name=max_pods_per_node,json=maxPodsPerNode,proto3" json:"max_pods_per_node,omitempty"`
}

func (x *MaxPodsConstraint) Reset() {
	*x = MaxPodsConstraint{}
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MaxPodsConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaxPodsConstraint) ProtoMessage() {}

func (x *MaxPodsConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaxPodsConstraint.ProtoReflect.Descriptor instead.
func (*MaxPodsConstraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{2}
}

func (x *MaxPodsConstraint) GetMaxPodsPerNode() int64 {
	if x != nil {
		return x.MaxPodsPerNode
	}
	return 0
}

// Metadata about a long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time at which this operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this operation was completed.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The name of the resource associated to this operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusDetail string `protobuf:"bytes,4,opt,name=status_detail,json=statusDetail,proto3" json:"status_detail,omitempty"`
	// Output only. Human-readable status of any error that occurred during the
	// operation.
	ErrorDetail string `protobuf:"bytes,5,opt,name=error_detail,json=errorDetail,proto3" json:"error_detail,omitempty"`
	// Output only. The verb associated with the API method which triggered this
	// operation. Possible values are "create", "delete", "update" and "import".
	Verb string `protobuf:"bytes,7,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Identifies whether cancellation has been requested for the
	// operation. Operations that have successfully been cancelled have
	// [google.longrunning.Operation.error][google.longrunning.Operation.error]
	// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{3}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetStatusDetail() string {
	if x != nil {
		return x.StatusDetail
	}
	return ""
}

func (x *OperationMetadata) GetErrorDetail() string {
	if x != nil {
		return x.ErrorDetail
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

// The taint content for the node taint.
type NodeTaint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Key for the taint.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Required. Value for the taint.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Required. The taint effect.
	Effect NodeTaint_Effect `protobuf:"varint,3,opt,name=effect,proto3,enum=google.cloud.gkemulticloud.v1.NodeTaint_Effect" json:"effect,omitempty"`
}

func (x *NodeTaint) Reset() {
	*x = NodeTaint{}
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeTaint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeTaint) ProtoMessage() {}

func (x *NodeTaint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeTaint.ProtoReflect.Descriptor instead.
func (*NodeTaint) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{4}
}

func (x *NodeTaint) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *NodeTaint) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *NodeTaint) GetEffect() NodeTaint_Effect {
	if x != nil {
		return x.Effect
	}
	return NodeTaint_EFFECT_UNSPECIFIED
}

// Configuration for node pool kubelet options.
type NodeKubeletConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Enable the insecure kubelet read only port.
	InsecureKubeletReadonlyPortEnabled bool `protobuf:"varint,1,opt,name=insecure_kubelet_readonly_port_enabled,json=insecureKubeletReadonlyPortEnabled,proto3" json:"insecure_kubelet_readonly_port_enabled,omitempty"`
	// Optional. Control the CPU management policy on the node.
	// See
	// https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/
	//
	// The following values are allowed.
	// * "none": the default, which represents the existing scheduling behavior.
	// * "static": allows pods with certain resource characteristics to be granted
	// increased CPU affinity and exclusivity on the node.
	// The default value is 'none' if unspecified.
	CpuManagerPolicy *string `protobuf:"bytes,2,opt,name=cpu_manager_policy,json=cpuManagerPolicy,proto3,oneof" json:"cpu_manager_policy,omitempty"`
	// Optional. Enable CPU CFS quota enforcement for containers that specify CPU
	// limits.
	//
	// This option is enabled by default which makes kubelet use CFS quota
	// (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
	// enforce container CPU limits. Otherwise, CPU limits will not be enforced at
	// all.
	//
	// Disable this option to mitigate CPU throttling problems while still having
	// your pods to be in Guaranteed QoS class by specifying the CPU limits.
	//
	// The default value is 'true' if unspecified.
	CpuCfsQuota *bool `protobuf:"varint,3,opt,name=cpu_cfs_quota,json=cpuCfsQuota,proto3,oneof" json:"cpu_cfs_quota,omitempty"`
	// Optional. Set the CPU CFS quota period value 'cpu.cfs_period_us'.
	//
	// The string must be a sequence of decimal numbers, each with optional
	// fraction and a unit suffix, such as "300ms".
	// Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
	// The value must be a positive duration.
	//
	// The default value is '100ms' if unspecified.
	CpuCfsQuotaPeriod *string `protobuf:"bytes,4,opt,name=cpu_cfs_quota_period,json=cpuCfsQuotaPeriod,proto3,oneof" json:"cpu_cfs_quota_period,omitempty"`
	// Optional. Set the Pod PID limits. See
	// https://kubernetes.io/docs/concepts/policy/pid-limiting/#pod-pid-limits
	//
	// Controls the maximum number of processes allowed to run in a pod. The value
	// must be greater than or equal to 1024 and less than 4194304.
	PodPidsLimit *int64 `protobuf:"varint,5,opt,name=pod_pids_limit,json=podPidsLimit,proto3,oneof" json:"pod_pids_limit,omitempty"`
}

func (x *NodeKubeletConfig) Reset() {
	*x = NodeKubeletConfig{}
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeKubeletConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeKubeletConfig) ProtoMessage() {}

func (x *NodeKubeletConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeKubeletConfig.ProtoReflect.Descriptor instead.
func (*NodeKubeletConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{5}
}

func (x *NodeKubeletConfig) GetInsecureKubeletReadonlyPortEnabled() bool {
	if x != nil {
		return x.InsecureKubeletReadonlyPortEnabled
	}
	return false
}

func (x *NodeKubeletConfig) GetCpuManagerPolicy() string {
	if x != nil && x.CpuManagerPolicy != nil {
		return *x.CpuManagerPolicy
	}
	return ""
}

func (x *NodeKubeletConfig) GetCpuCfsQuota() bool {
	if x != nil && x.CpuCfsQuota != nil {
		return *x.CpuCfsQuota
	}
	return false
}

func (x *NodeKubeletConfig) GetCpuCfsQuotaPeriod() string {
	if x != nil && x.CpuCfsQuotaPeriod != nil {
		return *x.CpuCfsQuotaPeriod
	}
	return ""
}

func (x *NodeKubeletConfig) GetPodPidsLimit() int64 {
	if x != nil && x.PodPidsLimit != nil {
		return *x.PodPidsLimit
	}
	return 0
}

// Fleet related configuration.
//
// Fleets are a Google Cloud concept for logically organizing clusters,
// letting you use and manage multi-cluster capabilities and apply
// consistent policies across your systems.
//
// See [Anthos
// Fleets](https://cloud.google.com/anthos/multicluster-management/fleets) for
// more details on Anthos multi-cluster capabilities using Fleets.
type Fleet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Fleet host project where this cluster will be
	// registered.
	//
	// Project names are formatted as
	// `projects/<project-number>`.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Output only. The name of the managed Hub Membership resource associated to
	// this cluster.
	//
	// Membership names are formatted as
	// `projects/<project-number>/locations/global/membership/<cluster-id>`.
	Membership string `protobuf:"bytes,2,opt,name=membership,proto3" json:"membership,omitempty"`
}

func (x *Fleet) Reset() {
	*x = Fleet{}
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Fleet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Fleet) ProtoMessage() {}

func (x *Fleet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Fleet.ProtoReflect.Descriptor instead.
func (*Fleet) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{6}
}

func (x *Fleet) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *Fleet) GetMembership() string {
	if x != nil {
		return x.Membership
	}
	return ""
}

// Parameters that describe the Logging configuration in a cluster.
type LoggingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration of the logging components;
	ComponentConfig *LoggingComponentConfig `protobuf:"bytes,1,opt,name=component_config,json=componentConfig,proto3" json:"component_config,omitempty"`
}

func (x *LoggingConfig) Reset() {
	*x = LoggingConfig{}
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingConfig) ProtoMessage() {}

func (x *LoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingConfig.ProtoReflect.Descriptor instead.
func (*LoggingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{7}
}

func (x *LoggingConfig) GetComponentConfig() *LoggingComponentConfig {
	if x != nil {
		return x.ComponentConfig
	}
	return nil
}

// Parameters that describe the Logging component configuration in a cluster.
type LoggingComponentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The components to be enabled.
	EnableComponents []LoggingComponentConfig_Component `protobuf:"varint,1,rep,packed,name=enable_components,json=enableComponents,proto3,enum=google.cloud.gkemulticloud.v1.LoggingComponentConfig_Component" json:"enable_components,omitempty"`
}

func (x *LoggingComponentConfig) Reset() {
	*x = LoggingComponentConfig{}
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoggingComponentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingComponentConfig) ProtoMessage() {}

func (x *LoggingComponentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingComponentConfig.ProtoReflect.Descriptor instead.
func (*LoggingComponentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{8}
}

func (x *LoggingComponentConfig) GetEnableComponents() []LoggingComponentConfig_Component {
	if x != nil {
		return x.EnableComponents
	}
	return nil
}

// Parameters that describe the Monitoring configuration in a cluster.
type MonitoringConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable Google Cloud Managed Service for Prometheus in the cluster.
	ManagedPrometheusConfig *ManagedPrometheusConfig `protobuf:"bytes,2,opt,name=managed_prometheus_config,json=managedPrometheusConfig,proto3" json:"managed_prometheus_config,omitempty"`
	// Optionally enable GKE metrics.
	// Only for Attached Clusters.
	CloudMonitoringConfig *CloudMonitoringConfig `protobuf:"bytes,4,opt,name=cloud_monitoring_config,json=cloudMonitoringConfig,proto3" json:"cloud_monitoring_config,omitempty"`
}

func (x *MonitoringConfig) Reset() {
	*x = MonitoringConfig{}
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MonitoringConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitoringConfig) ProtoMessage() {}

func (x *MonitoringConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitoringConfig.ProtoReflect.Descriptor instead.
func (*MonitoringConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{9}
}

func (x *MonitoringConfig) GetManagedPrometheusConfig() *ManagedPrometheusConfig {
	if x != nil {
		return x.ManagedPrometheusConfig
	}
	return nil
}

func (x *MonitoringConfig) GetCloudMonitoringConfig() *CloudMonitoringConfig {
	if x != nil {
		return x.CloudMonitoringConfig
	}
	return nil
}

// ManagedPrometheusConfig defines the configuration for
// Google Cloud Managed Service for Prometheus.
type ManagedPrometheusConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable Managed Collection.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *ManagedPrometheusConfig) Reset() {
	*x = ManagedPrometheusConfig{}
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ManagedPrometheusConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedPrometheusConfig) ProtoMessage() {}

func (x *ManagedPrometheusConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedPrometheusConfig.ProtoReflect.Descriptor instead.
func (*ManagedPrometheusConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{10}
}

func (x *ManagedPrometheusConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// CloudMonitoringConfig defines the configuration for
// built-in Cloud Logging and Monitoring.
// Only for Attached Clusters.
type CloudMonitoringConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable GKE-native logging and metrics.
	// Only for Attached Clusters.
	Enabled *bool `protobuf:"varint,1,opt,name=enabled,proto3,oneof" json:"enabled,omitempty"`
}

func (x *CloudMonitoringConfig) Reset() {
	*x = CloudMonitoringConfig{}
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudMonitoringConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudMonitoringConfig) ProtoMessage() {}

func (x *CloudMonitoringConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudMonitoringConfig.ProtoReflect.Descriptor instead.
func (*CloudMonitoringConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{11}
}

func (x *CloudMonitoringConfig) GetEnabled() bool {
	if x != nil && x.Enabled != nil {
		return *x.Enabled
	}
	return false
}

// Configuration for Binary Authorization.
type BinaryAuthorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mode of operation for binauthz policy evaluation. If unspecified, defaults
	// to DISABLED.
	EvaluationMode BinaryAuthorization_EvaluationMode `protobuf:"varint,1,opt,name=evaluation_mode,json=evaluationMode,proto3,enum=google.cloud.gkemulticloud.v1.BinaryAuthorization_EvaluationMode" json:"evaluation_mode,omitempty"`
}

func (x *BinaryAuthorization) Reset() {
	*x = BinaryAuthorization{}
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BinaryAuthorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BinaryAuthorization) ProtoMessage() {}

func (x *BinaryAuthorization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BinaryAuthorization.ProtoReflect.Descriptor instead.
func (*BinaryAuthorization) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{12}
}

func (x *BinaryAuthorization) GetEvaluationMode() BinaryAuthorization_EvaluationMode {
	if x != nil {
		return x.EvaluationMode
	}
	return BinaryAuthorization_EVALUATION_MODE_UNSPECIFIED
}

// SecurityPostureConfig defines the flags needed to enable/disable features for
// the Security Posture API.
type SecurityPostureConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sets which mode to use for vulnerability scanning.
	VulnerabilityMode SecurityPostureConfig_VulnerabilityMode `protobuf:"varint,1,opt,name=vulnerability_mode,json=vulnerabilityMode,proto3,enum=google.cloud.gkemulticloud.v1.SecurityPostureConfig_VulnerabilityMode" json:"vulnerability_mode,omitempty"`
}

func (x *SecurityPostureConfig) Reset() {
	*x = SecurityPostureConfig{}
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecurityPostureConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityPostureConfig) ProtoMessage() {}

func (x *SecurityPostureConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityPostureConfig.ProtoReflect.Descriptor instead.
func (*SecurityPostureConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{13}
}

func (x *SecurityPostureConfig) GetVulnerabilityMode() SecurityPostureConfig_VulnerabilityMode {
	if x != nil {
		return x.VulnerabilityMode
	}
	return SecurityPostureConfig_VULNERABILITY_MODE_UNSPECIFIED
}

var File_google_cloud_gkemulticloud_v1_common_resources_proto protoreflect.FileDescriptor

var file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x97, 0x01, 0x0a, 0x03, 0x4a, 0x77, 0x6b, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x74,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x6c, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x61, 0x6c, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x75, 0x73, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x69, 0x64, 0x12, 0x0c, 0x0a, 0x01, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x01, 0x6e, 0x12, 0x0c, 0x0a, 0x01, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x01, 0x65, 0x12, 0x0c, 0x0a, 0x01, 0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x01,
	0x78, 0x12, 0x0c, 0x0a, 0x01, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x01, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x63, 0x72, 0x76, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x63, 0x72,
	0x76, 0x22, 0x89, 0x01, 0x0a, 0x16, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x55, 0x72, 0x69, 0x12, 0x23, 0x0a, 0x0d, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6f, 0x6f, 0x6c,
	0x12, 0x2b, 0x0a, 0x11, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x22, 0x43, 0x0a,
	0x11, 0x4d, 0x61, 0x78, 0x50, 0x6f, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x6f, 0x64, 0x73, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x50, 0x6f, 0x64, 0x73, 0x50, 0x65, 0x72, 0x4e, 0x6f,
	0x64, 0x65, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0c, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x26, 0x0a,
	0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x3a,
	0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe6, 0x01, 0x0a, 0x09, 0x4e,
	0x6f, 0x64, 0x65, 0x54, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4c, 0x0a, 0x06, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54,
	0x61, 0x69, 0x6e, 0x74, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x22, 0x59, 0x0a, 0x06, 0x45, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x45, 0x46, 0x46, 0x45, 0x43, 0x54, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f,
	0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x50,
	0x52, 0x45, 0x46, 0x45, 0x52, 0x5f, 0x4e, 0x4f, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c,
	0x45, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x4f, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54,
	0x45, 0x10, 0x03, 0x22, 0x92, 0x03, 0x0a, 0x11, 0x4e, 0x6f, 0x64, 0x65, 0x4b, 0x75, 0x62, 0x65,
	0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x26, 0x69, 0x6e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x5f, 0x72, 0x65,
	0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x22,
	0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x4b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x52,
	0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x50, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x36, 0x0a, 0x12, 0x63, 0x70, 0x75, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x63, 0x70, 0x75, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x88, 0x01, 0x01, 0x12, 0x2c, 0x0a, 0x0d, 0x63, 0x70,
	0x75, 0x5f, 0x63, 0x66, 0x73, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0b, 0x63, 0x70, 0x75, 0x43, 0x66, 0x73,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x39, 0x0a, 0x14, 0x63, 0x70, 0x75, 0x5f,
	0x63, 0x66, 0x73, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x11, 0x63,
	0x70, 0x75, 0x43, 0x66, 0x73, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64,
	0x88, 0x01, 0x01, 0x12, 0x2e, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x70, 0x69, 0x64, 0x73, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x03, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x50, 0x69, 0x64, 0x73, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x88, 0x01, 0x01, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x63,
	0x70, 0x75, 0x5f, 0x63, 0x66, 0x73, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x42, 0x17, 0x0a, 0x15,
	0x5f, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x66, 0x73, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x70, 0x69,
	0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x22, 0x4b, 0x0a, 0x05, 0x46, 0x6c, 0x65, 0x65,
	0x74, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x12, 0x23, 0x0a, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x22, 0x71, 0x0a, 0x0d, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xd4, 0x01, 0x0a, 0x16, 0x4c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x6c, 0x0a, 0x11, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x52,
	0x10, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x73, 0x22, 0x4c, 0x0a, 0x09, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x19,
	0x0a, 0x15, 0x43, 0x4f, 0x4d, 0x50, 0x4f, 0x4e, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x59, 0x53,
	0x54, 0x45, 0x4d, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4f, 0x4e, 0x45, 0x4e, 0x54, 0x53, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x57, 0x4f, 0x52, 0x4b, 0x4c, 0x4f, 0x41, 0x44, 0x53, 0x10, 0x02, 0x22,
	0xf4, 0x01, 0x0a, 0x10, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x72, 0x0a, 0x19, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f,
	0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x50,
	0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x17, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65,
	0x75, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6c, 0x0a, 0x17, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x15, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x33, 0x0a, 0x17, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x50, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x42, 0x0a, 0x15, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x88, 0x01, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22,
	0xe8, 0x01, 0x0a, 0x13, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a, 0x0f, 0x65, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x52, 0x0e, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x22, 0x65, 0x0a, 0x0e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x56, 0x41, 0x4c, 0x55, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x24, 0x0a, 0x20, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f,
	0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x54, 0x4f, 0x4e, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59,
	0x5f, 0x45, 0x4e, 0x46, 0x4f, 0x52, 0x43, 0x45, 0x10, 0x02, 0x22, 0x81, 0x02, 0x0a, 0x15, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x75, 0x0a, 0x12, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x11, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0x71, 0x0a, 0x11, 0x56,
	0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x22, 0x0a, 0x1e, 0x56, 0x55, 0x4c, 0x4e, 0x45, 0x52, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54,
	0x59, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x56, 0x55, 0x4c, 0x4e, 0x45, 0x52, 0x41, 0x42,
	0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x1c, 0x0a, 0x18, 0x56, 0x55, 0x4c, 0x4e, 0x45, 0x52, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54,
	0x59, 0x5f, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x49, 0x53, 0x45, 0x10, 0x02, 0x42, 0xe7,
	0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x42, 0x14, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x70, 0x62, 0x3b, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x70, 0x62, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescOnce sync.Once
	file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescData = file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDesc
)

func file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescData)
	})
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescData
}

var file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_gkemulticloud_v1_common_resources_proto_goTypes = []any{
	(NodeTaint_Effect)(0),                        // 0: google.cloud.gkemulticloud.v1.NodeTaint.Effect
	(LoggingComponentConfig_Component)(0),        // 1: google.cloud.gkemulticloud.v1.LoggingComponentConfig.Component
	(BinaryAuthorization_EvaluationMode)(0),      // 2: google.cloud.gkemulticloud.v1.BinaryAuthorization.EvaluationMode
	(SecurityPostureConfig_VulnerabilityMode)(0), // 3: google.cloud.gkemulticloud.v1.SecurityPostureConfig.VulnerabilityMode
	(*Jwk)(nil),                     // 4: google.cloud.gkemulticloud.v1.Jwk
	(*WorkloadIdentityConfig)(nil),  // 5: google.cloud.gkemulticloud.v1.WorkloadIdentityConfig
	(*MaxPodsConstraint)(nil),       // 6: google.cloud.gkemulticloud.v1.MaxPodsConstraint
	(*OperationMetadata)(nil),       // 7: google.cloud.gkemulticloud.v1.OperationMetadata
	(*NodeTaint)(nil),               // 8: google.cloud.gkemulticloud.v1.NodeTaint
	(*NodeKubeletConfig)(nil),       // 9: google.cloud.gkemulticloud.v1.NodeKubeletConfig
	(*Fleet)(nil),                   // 10: google.cloud.gkemulticloud.v1.Fleet
	(*LoggingConfig)(nil),           // 11: google.cloud.gkemulticloud.v1.LoggingConfig
	(*LoggingComponentConfig)(nil),  // 12: google.cloud.gkemulticloud.v1.LoggingComponentConfig
	(*MonitoringConfig)(nil),        // 13: google.cloud.gkemulticloud.v1.MonitoringConfig
	(*ManagedPrometheusConfig)(nil), // 14: google.cloud.gkemulticloud.v1.ManagedPrometheusConfig
	(*CloudMonitoringConfig)(nil),   // 15: google.cloud.gkemulticloud.v1.CloudMonitoringConfig
	(*BinaryAuthorization)(nil),     // 16: google.cloud.gkemulticloud.v1.BinaryAuthorization
	(*SecurityPostureConfig)(nil),   // 17: google.cloud.gkemulticloud.v1.SecurityPostureConfig
	(*timestamppb.Timestamp)(nil),   // 18: google.protobuf.Timestamp
}
var file_google_cloud_gkemulticloud_v1_common_resources_proto_depIdxs = []int32{
	18, // 0: google.cloud.gkemulticloud.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	18, // 1: google.cloud.gkemulticloud.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	0,  // 2: google.cloud.gkemulticloud.v1.NodeTaint.effect:type_name -> google.cloud.gkemulticloud.v1.NodeTaint.Effect
	12, // 3: google.cloud.gkemulticloud.v1.LoggingConfig.component_config:type_name -> google.cloud.gkemulticloud.v1.LoggingComponentConfig
	1,  // 4: google.cloud.gkemulticloud.v1.LoggingComponentConfig.enable_components:type_name -> google.cloud.gkemulticloud.v1.LoggingComponentConfig.Component
	14, // 5: google.cloud.gkemulticloud.v1.MonitoringConfig.managed_prometheus_config:type_name -> google.cloud.gkemulticloud.v1.ManagedPrometheusConfig
	15, // 6: google.cloud.gkemulticloud.v1.MonitoringConfig.cloud_monitoring_config:type_name -> google.cloud.gkemulticloud.v1.CloudMonitoringConfig
	2,  // 7: google.cloud.gkemulticloud.v1.BinaryAuthorization.evaluation_mode:type_name -> google.cloud.gkemulticloud.v1.BinaryAuthorization.EvaluationMode
	3,  // 8: google.cloud.gkemulticloud.v1.SecurityPostureConfig.vulnerability_mode:type_name -> google.cloud.gkemulticloud.v1.SecurityPostureConfig.VulnerabilityMode
	9,  // [9:9] is the sub-list for method output_type
	9,  // [9:9] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_gkemulticloud_v1_common_resources_proto_init() }
func file_google_cloud_gkemulticloud_v1_common_resources_proto_init() {
	if File_google_cloud_gkemulticloud_v1_common_resources_proto != nil {
		return
	}
	file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[5].OneofWrappers = []any{}
	file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[11].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkemulticloud_v1_common_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkemulticloud_v1_common_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_gkemulticloud_v1_common_resources_proto = out.File
	file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDesc = nil
	file_google_cloud_gkemulticloud_v1_common_resources_proto_goTypes = nil
	file_google_cloud_gkemulticloud_v1_common_resources_proto_depIdxs = nil
}
