# Gorilla WebSocket

[![GoDoc](https://godoc.org/github.com/minio/websocket?status.svg)](https://godoc.org/github.com/minio/websocket)

Gorilla WebSocket is a [Go](http://golang.org/) implementation of the [WebSocket](http://www.rfc-editor.org/rfc/rfc6455.txt) protocol.

### Documentation

* [API Reference](https://pkg.go.dev/github.com/minio/websocket?tab=doc)
* [Chat example](https://github.com/minio/websocket/tree/master/examples/chat)
* [Command example](https://github.com/minio/websocket/tree/master/examples/command)
* [Client and server example](https://github.com/minio/websocket/tree/master/examples/echo)
* [File watch example](https://github.com/minio/websocket/tree/master/examples/filewatch)

### Status

The Gorilla WebSocket package provides a complete and tested implementation of
the [WebSocket](http://www.rfc-editor.org/rfc/rfc6455.txt) protocol. The
package API is stable.

### Installation

	go get github.com/minio/websocket

### Protocol Compliance

The Gorilla WebSocket package passes the server tests in the [Autobahn Test Suite](https://github.com/crossbario/autobahn-testsuite) using the application in the [examples/autobahn subdirectory](https://github.com/minio/websocket/tree/master/examples/autobahn).

