// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package atproto

// schema: com.atproto.sync.subscribeRepos

import (
	"github.com/bluesky-social/indigo/lex/util"
)

// SyncSubscribeRepos_Account is a "account" in the com.atproto.sync.subscribeRepos schema.
//
// Represents a change to an account's status on a host (eg, PDS or Relay). The semantics of this event are that the status is at the host which emitted the event, not necessarily that at the currently active PDS. Eg, a Relay takedown would emit a takedown with active=false, even if the PDS is still active.
type SyncSubscribeRepos_Account struct {
	// active: Indicates that the account has a repository which can be fetched from the host that emitted this event.
	Active bool   `json:"active" cborgen:"active"`
	Did    string `json:"did" cborgen:"did"`
	Seq    int64  `json:"seq" cborgen:"seq"`
	// status: If active=false, this optional field indicates a reason for why the account is not active.
	Status *string `json:"status,omitempty" cborgen:"status,omitempty"`
	Time   string  `json:"time" cborgen:"time"`
}

// SyncSubscribeRepos_Commit is a "commit" in the com.atproto.sync.subscribeRepos schema.
//
// Represents an update of repository state. Note that empty commits are allowed, which include no repo data changes, but an update to rev and signature.
type SyncSubscribeRepos_Commit struct {
	Blobs []util.LexLink `json:"blobs" cborgen:"blobs"`
	// blocks: CAR file containing relevant blocks, as a diff since the previous repo state. The commit must be included as a block, and the commit block CID must be the first entry in the CAR header 'roots' list.
	Blocks util.LexBytes `json:"blocks,omitempty" cborgen:"blocks,omitempty"`
	// commit: Repo commit object CID.
	Commit util.LexLink                 `json:"commit" cborgen:"commit"`
	Ops    []*SyncSubscribeRepos_RepoOp `json:"ops" cborgen:"ops"`
	// prevData: The root CID of the MST tree for the previous commit from this repo (indicated by the 'since' revision field in this message). Corresponds to the 'data' field in the repo commit object. NOTE: this field is effectively required for the 'inductive' version of firehose.
	PrevData *util.LexLink `json:"prevData,omitempty" cborgen:"prevData,omitempty"`
	// rebase: DEPRECATED -- unused
	Rebase bool `json:"rebase" cborgen:"rebase"`
	// repo: The repo this event comes from. Note that all other message types name this field 'did'.
	Repo string `json:"repo" cborgen:"repo"`
	// rev: The rev of the emitted commit. Note that this information is also in the commit object included in blocks, unless this is a tooBig event.
	Rev string `json:"rev" cborgen:"rev"`
	// seq: The stream sequence number of this message.
	Seq int64 `json:"seq" cborgen:"seq"`
	// since: The rev of the last emitted commit from this repo (if any).
	Since *string `json:"since" cborgen:"since"`
	// time: Timestamp of when this message was originally broadcast.
	Time string `json:"time" cborgen:"time"`
	// tooBig: DEPRECATED -- replaced by #sync event and data limits. Indicates that this commit contained too many ops, or data size was too large. Consumers will need to make a separate request to get missing data.
	TooBig bool `json:"tooBig" cborgen:"tooBig"`
}

// SyncSubscribeRepos_Identity is a "identity" in the com.atproto.sync.subscribeRepos schema.
//
// Represents a change to an account's identity. Could be an updated handle, signing key, or pds hosting endpoint. Serves as a prod to all downstream services to refresh their identity cache.
type SyncSubscribeRepos_Identity struct {
	Did string `json:"did" cborgen:"did"`
	// handle: The current handle for the account, or 'handle.invalid' if validation fails. This field is optional, might have been validated or passed-through from an upstream source. Semantics and behaviors for PDS vs Relay may evolve in the future; see atproto specs for more details.
	Handle *string `json:"handle,omitempty" cborgen:"handle,omitempty"`
	Seq    int64   `json:"seq" cborgen:"seq"`
	Time   string  `json:"time" cborgen:"time"`
}

// SyncSubscribeRepos_Info is a "info" in the com.atproto.sync.subscribeRepos schema.
type SyncSubscribeRepos_Info struct {
	Message *string `json:"message,omitempty" cborgen:"message,omitempty"`
	Name    string  `json:"name" cborgen:"name"`
}

// SyncSubscribeRepos_RepoOp is a "repoOp" in the com.atproto.sync.subscribeRepos schema.
//
// A repo operation, ie a mutation of a single record.
type SyncSubscribeRepos_RepoOp struct {
	Action string `json:"action" cborgen:"action"`
	// cid: For creates and updates, the new record CID. For deletions, null.
	Cid  *util.LexLink `json:"cid" cborgen:"cid"`
	Path string        `json:"path" cborgen:"path"`
	// prev: For updates and deletes, the previous record CID (required for inductive firehose). For creations, field should not be defined.
	Prev *util.LexLink `json:"prev,omitempty" cborgen:"prev,omitempty"`
}

// SyncSubscribeRepos_Sync is a "sync" in the com.atproto.sync.subscribeRepos schema.
//
// Updates the repo to a new state, without necessarily including that state on the firehose. Used to recover from broken commit streams, data loss incidents, or in situations where upstream host does not know recent state of the repository.
type SyncSubscribeRepos_Sync struct {
	// blocks: CAR file containing the commit, as a block. The CAR header must include the commit block CID as the first 'root'.
	Blocks util.LexBytes `json:"blocks,omitempty" cborgen:"blocks,omitempty"`
	// did: The account this repo event corresponds to. Must match that in the commit object.
	Did string `json:"did" cborgen:"did"`
	// rev: The rev of the commit. This value must match that in the commit object.
	Rev string `json:"rev" cborgen:"rev"`
	// seq: The stream sequence number of this message.
	Seq int64 `json:"seq" cborgen:"seq"`
	// time: Timestamp of when this message was originally broadcast.
	Time string `json:"time" cborgen:"time"`
}
