// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package bsky

// schema: app.bsky.actor.status

import (
	"bytes"
	"encoding/json"
	"fmt"
	"io"

	"github.com/bluesky-social/indigo/lex/util"
	cbg "github.com/whyrusleeping/cbor-gen"
)

func init() {
	util.RegisterType("app.bsky.actor.status", &ActorStatus{})
} //
// RECORDTYPE: ActorStatus
type ActorStatus struct {
	LexiconTypeID string `json:"$type,const=app.bsky.actor.status" cborgen:"$type,const=app.bsky.actor.status"`
	CreatedAt     string `json:"createdAt" cborgen:"createdAt"`
	// durationMinutes: The duration of the status in minutes. Applications can choose to impose minimum and maximum limits.
	DurationMinutes *int64 `json:"durationMinutes,omitempty" cborgen:"durationMinutes,omitempty"`
	// embed: An optional embed associated with the status.
	Embed *ActorStatus_Embed `json:"embed,omitempty" cborgen:"embed,omitempty"`
	// status: The status for the account.
	Status string `json:"status" cborgen:"status"`
}

// An optional embed associated with the status.
type ActorStatus_Embed struct {
	EmbedExternal *EmbedExternal
}

func (t *ActorStatus_Embed) MarshalJSON() ([]byte, error) {
	if t.EmbedExternal != nil {
		t.EmbedExternal.LexiconTypeID = "app.bsky.embed.external"
		return json.Marshal(t.EmbedExternal)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *ActorStatus_Embed) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "app.bsky.embed.external":
		t.EmbedExternal = new(EmbedExternal)
		return json.Unmarshal(b, t.EmbedExternal)

	default:
		return nil
	}
}

func (t *ActorStatus_Embed) MarshalCBOR(w io.Writer) error {

	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}
	if t.EmbedExternal != nil {
		return t.EmbedExternal.MarshalCBOR(w)
	}
	return fmt.Errorf("cannot cbor marshal empty enum")
}
func (t *ActorStatus_Embed) UnmarshalCBOR(r io.Reader) error {
	typ, b, err := util.CborTypeExtractReader(r)
	if err != nil {
		return err
	}

	switch typ {
	case "app.bsky.embed.external":
		t.EmbedExternal = new(EmbedExternal)
		return t.EmbedExternal.UnmarshalCBOR(bytes.NewReader(b))

	default:
		return nil
	}
}
