# OS/2 2.0 C Set/2 1.0 (CS0014 or greater patch level required) Makefile for 
# Icon v8.8 rtt module

CC      = icc
CFLAGS  = /C /Q /O /DRttx /DRTT /DTokDotH /Sm

RTT_OBJ = rttparse.obj rttmain.obj rttlex.obj rttsym.obj rttnode.obj \
	  rttout.obj rttmisc.obj rttdb.obj rttinlin.obj rttilc.obj

PP_DIR = ../preproc/

P_DOT_H = $(PP_DIR)preproc.h $(PP_DIR)pproto.h ltoken.h ..\h\mproto.h \
	..\h\define.h ..\h\config.h ..\h\typedefs.h ..\h\proto.h\
	..\h\cstructs.h ..\h\cpuconf.h

P_OBJ = pout.obj pchars.obj perr.obj pmem.obj  bldtok.obj macro.obj \
	preproc.obj evaluate.obj files.obj gettok.obj pinit.obj

COMMON = ..\common\getopt.obj ..\common\time.obj ..\common\filepart.obj\
	  ..\common\memory.obj ..\common\identify.obj ..\common\strtbl.obj\
	  ..\common\rtdb.obj ..\common\mlocal.obj ..\common\alloc.obj \
	  ..\common\literals.obj ..\common\alloc.obj

OBJ = $(RTT_OBJ) $(P_OBJ) $(COMMON)

rtt.exe: $(OBJ)
	link386 @rtt.lnk
	copy rtt.exe ..\..\bin

$(RTT_OBJ): rtt.h rtt1.h rttproto.h $(P_DOT_H)

rttdb.obj: ..\h\version.h

pout.obj: $(PP_DIR)pout.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)pout.c

pchars.obj: $(PP_DIR)pchars.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)pchars.c

perr.obj: $(PP_DIR)perr.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)perr.c

pmem.obj: $(PP_DIR)pmem.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)pmem.c

bldtok.obj: $(PP_DIR)bldtok.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)bldtok.c

macro.obj: $(PP_DIR)macro.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)macro.c

preproc.obj: $(PP_DIR)preproc.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)preproc.c

evaluate.obj: $(PP_DIR)evaluate.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)evaluate.c

files.obj: $(PP_DIR)files.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)files.c

gettok.obj: $(PP_DIR)gettok.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)gettok.c

pinit.obj: $(PP_DIR)pinit.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)pinit.c
