# OS/2 2.0 C Set/2 1.0 (CS0014 patch level or greater required) Makefile for 
# Icon v8.10 icont module (Presentation Manager)

CFLAGS  = /Q /C /Sm /Gm /DICONT /O
CC      = icc

HDRS=	..\h\rt.h ..\h\config.h ..\h\define.h ..\h\cpuconf.h \
	..\h\monitor.h

HDRS=	..\h\define.h ..\h\config.h ..\h\typedefs.h ..\h\cstructs.h \
	..\h\proto.h ..\h\gsupport.h ..\h\mproto.h ..\h\dproto.h \
	..\h\cpuconf.h tproto.h

THDRS=	trans.h tree.h tsym.h token.h

LHDRS=	..\h\sys.h ..\h\rmacros.h ..\h\rstructs.h ..\h\rexterns.h \
	..\h\rproto.h link.h

TRANS=	trans.obj tcode.obj tlex.obj lnklist.obj tparse.obj tsym.obj \
	tmem.obj tree.obj

LINKR=	link.obj lglob.obj lcode.obj llex.obj lmem.obj lsym.obj opcode.obj

OBJS=	tmain.obj util.obj tlocal.obj $(TRANS) $(LINKR)

COMMON= ..\common\getopt.obj ..\common\long.obj  ..\common\alloc.obj \
	..\common\filepart.obj ..\common\strtbl.obj ..\common\ipp.obj

# main program

xicont.exe:	$(OBJS)
		link386 @icont.lnk
		copy xicont.exe ..\..\bin

$(OBJS):	$(HDRS)

# translator files
trans.obj:	tglobals.h tsym.h ttoken.h tree.h ..\h\version.h ..\h\kdefs.h
lnklist.obj:	lfile.h
tparse.obj:	..\h\lexdef.h tglobals.h tsym.h tree.h keyword.h
tcode.obj:	tglobals.h tsym.h ttoken.h tree.h
tlex.obj:	..\h\lexdef.h ..\h\parserr.h ttoken.h tree.h ..\h\esctab.h \
		..\common\lextab.h ..\common\yylex.h ..\common\error.h
tmem.obj:	tglobals.h tsym.h tree.h
tree.obj:	tree.h
tsym.obj:	tglobals.h tsym.h ttoken.h lfile.h keyword.h ..\h\kdefs.h

# linker files
$(LINKR):	link.h lfile.h ..\h\rt.h ..\h\sys.h ..\h\monitor.h \
		..\h\rstructs.h ..\h\rmacros.h ..\h\rexterns.h

link.obj:	tglobals.h ..\h\header.h hdr.h
lcode.obj:	tglobals.h opcode.h keyword.h ..\h\header.h \
		..\h\opdefs.h ..\h\version.h
lglob.obj:	opcode.h ..\h\opdefs.h ..\h\version.h
llex.obj:	tglobals.h opcode.h ..\h\opdefs.h
lmem.obj:	tglobals.h
lsym.obj:	tglobals.h
opcode.obj:	opcode.h ..\h\opdefs.h
# will not build the header.exe at this point (need TASM)
hdr.h:		header.exe os2nwhdr.exe
		os2nwhdr
os2nwhdr.exe:	os2nwhdr.c
		$(CC) /O /Q os2nwhdr.c
