# OS/2 2.x C Set/2 1.0 (CS0014 or greater patch level required) Makefile for
# Icon v8.10 runtime module (PresentationManager)

CFLAGS  = /C /Q /Sm /Gm /O
CC      = icc

HDRS =	..\h\config.h ..\h\cpuconf.h ..\h\cstructs.h ..\h\define.h \
        ..\h\proto.h ..\h\fdefs.h ..\h\features.h ..\h\grttin.h \
        ..\h\monitor.h ..\h\mproto.h ..\h\proto.h ..\h\rexterns.h \
        ..\h\rmacros.h ..\h\rproto.h ..\h\rstructs.h ..\h\sys.h \
        ..\h\typedefs.h ..\h\version.h

RSRC =  iconx.rc iconx.dlg arrow.ptr barwdwn.ptr barwup.ptr blcorner.ptr \
        boat.ptr bogosity.ptr botside.ptr bottee.ptr brcorner.ptr \
        bxspiral.ptr centptr.ptr circle.ptr clock.ptr cross.ptr crosshair.ptr \
        crsrev.ptr darrow.ptr dblar.ptr dblarrow.ptr dcross.ptr dot.ptr  \
        dotbox.ptr draftl.ptr drafts.ptr drapbx.ptr exchange.ptr fleur.ptr \
        gobbler.ptr gumby.ptr hand1.ptr hand2.ptr heart.ptr icon.ptr \
        ironcrs.ptr larrow.ptr leftbut.ptr leftptr.ptr leftside.ptr \
        lefttee.ptr llangle.ptr lrangle.ptr man.ptr midbut.ptr mouse.ptr \
        mug.ptr pencil.ptr pirate.ptr plus.ptr qarrow.ptr rarrow.ptr \
        rightbut.ptr rightptr.ptr rside.ptr rtee.ptr rtllogo.ptr sailboat.ptr \
        shuttle.ptr sizing.ptr spider.ptr spraycan.ptr star.ptr target.ptr \
        tcross.ptr tlarrow.ptr tlcorner.ptr toptee.ptr trcorner.ptr trek.ptr \
        tside.ptr uarrow.ptr ulangle.ptr umbrella.ptr urangle.ptr vdblar.ptr \
        watch.ptr Xcursor.ptr xterm.ptr

XHDRS = ..\h\pmres.h ..\h\pmwin.h ..\h\xicon.h

####################################################################
#
# Make entries for iconx
#

OBJ =	xcnv.obj xdata.obj xdef.obj xerrmsg.obj xextcall.obj xfconv.obj  \
        xfmath.obj xfmisc.obj xfmonitr.obj xfscan.obj xfstr.obj xfstranl.obj \
        xfstruct.obj xfsys.obj xfwindow.obj xfxtra.obj ximain.obj ximisc.obj \
        xinit.obj xinterp.obj xinvoke.obj xistart.obj xkeyword.obj xlmisc.obj \
        xoarith.obj xoasgn.obj xocat.obj xocomp.obj xomisc.obj xoref.obj xoset.obj \
        xovalue.obj xralc.obj xrcoexpr.obj xrcomp.obj xrdebug.obj xrgfxsys.obj \
        xrlocal.obj xrlrgint.obj xrmemmgt.obj xrmisc.obj xrstruct.obj xrsys.obj \
        xrwindow.obj xrwinrsc.obj xrwinsys.obj

COMMON= ..\common\long.obj ..\common\memory.obj ..\common\time.obj \
        ..\common\redirerr.obj ..\common\rswitch.obj

xiconx.exe: $(OBJ) $(COMMON) iconx.res
	link386 @iconx.lnk
	rc iconx.res xiconx.exe
	copy xiconx.exe ..\..\bin

iconx.res: $(RSRC) ..\h\pmres.h
	rc -r iconx.rc

xcnv.obj: cnv.r $(HDRS)
	..\..\bin\rtt -x cnv.r
	$(CC) $(CFLAGS) xcnv.c
	del xcnv.c

xdata.obj: data.r $(HDRS)
	..\..\bin\rtt -x data.r
	$(CC) $(CFLAGS) xdata.c
	del xdata.c

xdef.obj: def.r $(HDRS)
	..\..\bin\rtt -x def.r
	$(CC) $(CFLAGS) xdef.c
	del xdef.c

xerrmsg.obj: errmsg.r $(HDRS) $(XHDRS)
	..\..\bin\rtt -x errmsg.r
	$(CC) $(CFLAGS) xerrmsg.c
	del xerrmsg.c

xextcall.obj: extcall.r $(HDRS)
	..\..\bin\rtt -x extcall.r
	$(CC) $(CFLAGS) xextcall.c
	del xextcall.c

xfconv.obj: fconv.r $(HDRS)
	..\..\bin\rtt -x fconv.r
	$(CC) $(CFLAGS) xfconv.c
	del xfconv.c

xfmath.obj: fmath.r $(HDRS)
	..\..\bin\rtt -x fmath.r
	$(CC) $(CFLAGS) xfmath.c
	del xfmath.c

xfmisc.obj: fmisc.r $(HDRS)
	..\..\bin\rtt -x fmisc.r
	$(CC) $(CFLAGS) xfmisc.c
	del xfmisc.c

xfmonitr.obj: fmonitr.r $(HDRS)
	..\..\bin\rtt -x fmonitr.r
	$(CC) $(CFLAGS) xfmonitr.c
	del xfmonitr.c

xfscan.obj: fscan.r $(HDRS)
	..\..\bin\rtt -x fscan.r
	$(CC) $(CFLAGS) xfscan.c
	del xfscan.c

xfstr.obj: fstr.r $(HDRS)
	..\..\bin\rtt -x fstr.r
	$(CC) $(CFLAGS) xfstr.c
	del xfstr.c

xfstranl.obj: fstranl.r $(HDRS)
	..\..\bin\rtt -x fstranl.r
	$(CC) $(CFLAGS) xfstranl.c
	del xfstranl.c

xfstruct.obj: fstruct.r $(HDRS)
	..\..\bin\rtt -x fstruct.r
	$(CC) $(CFLAGS) xfstruct.c
	del xfstruct.c

xfsys.obj: fsys.r $(HDRS) $(XHDRS)
	..\..\bin\rtt -x fsys.r
	$(CC) $(CFLAGS) xfsys.c
	del xfsys.c

xfwindow.obj: fwindow.r $(HDRS) $(XHDRS)
	..\..\bin\rtt -x fwindow.r
	$(CC) $(CFLAGS) xfwindow.c
	del xfwindow.c

xfxtra.obj: fxtra.r $(HDRS)
	..\..\bin\rtt -x fxtra.r
	$(CC) $(CFLAGS) xfxtra.c
	del xfxtra.c

ximain.obj: imain.r $(HDRS) $(XHDRS)
	..\..\bin\rtt -x imain.r
	$(CC) $(CFLAGS) ximain.c
	del ximain.c

ximisc.obj: imisc.r $(HDRS)
	..\..\bin\rtt -x imisc.r
	$(CC) $(CFLAGS) ximisc.c
	del ximisc.c

xinit.obj: init.r $(HDRS) $(XHDRS)
	..\..\bin\rtt -x init.r
	$(CC) $(CFLAGS) xinit.c
	del xinit.c

xinterp.obj: interp.r $(HDRS)
	..\..\bin\rtt -x interp.r
	$(CC) $(CFLAGS) xinterp.c
	del xinterp.c

xinvoke.obj: invoke.r $(HDRS)
	..\..\bin\rtt -x invoke.r
	$(CC) $(CFLAGS) xinvoke.c
	del xinvoke.c

xistart.obj: istart.r $(HDRS) $(XHDRS)
	..\..\bin\rtt -x istart.r
	$(CC) $(CFLAGS) xistart.c
	del xistart.c

xkeyword.obj: keyword.r $(HDRS) $(XHDRS)
	..\..\bin\rtt -x keyword.r
	$(CC) $(CFLAGS) xkeyword.c
	del xkeyword.c

xlmisc.obj: lmisc.r $(HDRS)
	..\..\bin\rtt -x lmisc.r
	$(CC) $(CFLAGS) xlmisc.c
	del xlmisc.c

xoarith.obj: oarith.r $(HDRS)
	..\..\bin\rtt -x oarith.r
	$(CC) $(CFLAGS) xoarith.c
	del xoarith.c

xoasgn.obj: oasgn.r $(HDRS)
	..\..\bin\rtt -x oasgn.r
	$(CC) $(CFLAGS) xoasgn.c
	del xoasgn.c

xocat.obj: ocat.r $(HDRS)
	..\..\bin\rtt -x ocat.r
	$(CC) $(CFLAGS) xocat.c
	del xocat.c

xocomp.obj: ocomp.r $(HDRS)
	..\..\bin\rtt -x ocomp.r
	$(CC) $(CFLAGS) xocomp.c
	del xocomp.c

xomisc.obj: omisc.r $(HDRS)
	..\..\bin\rtt -x omisc.r
	$(CC) $(CFLAGS) xomisc.c
	del xomisc.c

xoref.obj: oref.r $(HDRS)
	..\..\bin\rtt -x oref.r
	$(CC) $(CFLAGS) xoref.c
	del xoref.c

xoset.obj: oset.r $(HDRS)
	..\..\bin\rtt -x oset.r
	$(CC) $(CFLAGS) xoset.c
	del xoset.c

xovalue.obj: ovalue.r $(HDRS)
	..\..\bin\rtt -x ovalue.r
	$(CC) $(CFLAGS) xovalue.c
	del xovalue.c

xralc.obj: ralc.r $(HDRS)
	..\..\bin\rtt -x ralc.r
	$(CC) $(CFLAGS) xralc.c
	del xralc.c

xrcoexpr.obj: rcoexpr.r $(HDRS)
	..\..\bin\rtt -x rcoexpr.r
	$(CC) $(CFLAGS) xrcoexpr.c
	del xrcoexpr.c

xrcomp.obj: rcomp.r $(HDRS)
	..\..\bin\rtt -x rcomp.r
	$(CC) $(CFLAGS) xrcomp.c
	del xrcomp.c

xrdebug.obj: rdebug.r $(HDRS) $(XHDRS)
	..\..\bin\rtt -x rdebug.r
	$(CC) $(CFLAGS) xrdebug.c
	del xrdebug.c

xrgfxsys.obj: rgfxsys.r $(HDRS) $(XHDRS) rpmgraph.ri
	..\..\bin\rtt -x rgfxsys.r
	$(CC) $(CFLAGS) xrgfxsys.c
	del xrgfxsys.c

xrlocal.obj: rlocal.r $(HDRS)
	..\..\bin\rtt -x rlocal.r
	$(CC) $(CFLAGS) xrlocal.c
	del xrlocal.c

xrlrgint.obj: rlrgint.r $(HDRS)
	..\..\bin\rtt -x rlrgint.r
	$(CC) $(CFLAGS) xrlrgint.c
	del xrlrgint.c

xrmemmgt.obj: rmemmgt.r $(HDRS) $(XHDRS) rmemfix.ri
	..\..\bin\rtt -x rmemmgt.r
	$(CC) $(CFLAGS) xrmemmgt.c
	del xrmemmgt.c

xrmisc.obj: rmisc.r $(HDRS)
	..\..\bin\rtt -x rmisc.r
	$(CC) $(CFLAGS) xrmisc.c
	del xrmisc.c

xrstruct.obj: rstruct.r $(HDRS)
	..\..\bin\rtt -x rstruct.r
	$(CC) $(CFLAGS) xrstruct.c
	del xrstruct.c

xrsys.obj: rsys.r $(HDRS) $(XHDRS)
	..\..\bin\rtt -x rsys.r
	$(CC) $(CFLAGS) xrsys.c
	del xrsys.c

xrwindow.obj: rwindow.r $(HDRS) $(XHDRS)
	..\..\bin\rtt -x rwindow.r
	$(CC) $(CFLAGS) xrwindow.c
	del xrwindow.c

xrwinrsc.obj: rwinrsc.r $(HDRS) $(XHDRS) rpmrsc.ri
	..\..\bin\rtt -x rwinrsc.r
	$(CC) $(CFLAGS) xrwinrsc.c
	del xrwinrsc.c

xrwinsys.obj: rwinsys.r $(HDRS) $(XHDRS) rpmwin.ri
	..\..\bin\rtt -x rwinsys.r
	$(CC) $(CFLAGS) xrwinsys.c
	del xrwinsys.c
