/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionWithSmartcast;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirTypeAttributeExtension;
import org.jetbrains.kotlin.fir.extensions.FirTypeAttributeExtensionKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeAttribute;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttribute;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRefWithNullability;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010/\u001a\u000200*\b\u0012\u0004\u0012\u00020\u0019012\u0006\u00102\u001a\u000203\u001a-\u00104\u001a\u0004\u0018\u0001H5\"\n\b\u0000\u00105\u0018\u0001*\u00020\u0006*\u00020\tH\u0086\b\u0082\u0002\n\n\b\b\u0002\u001a\u0004\u0010\u0000(\u0000\u00a2\u0006\u0002\u0010\r\u001a\u001e\u00106\u001a\u0002H5\"\n\b\u0000\u00105\u0018\u0001*\u00020\u0006*\u00020\tH\u0086\b\u00a2\u0006\u0002\u0010\r\u001a\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u001901*\b\u0012\u0004\u0012\u00020\u001901\u001a\f\u00108\u001a\u00020\u0005*\u000209H\u0002\u001a\u001c\u0010:\u001a\u00020\u0005*\u00020\t2\u0006\u0010;\u001a\u00020\u00012\u0006\u0010<\u001a\u00020\u0005H\u0002\u001a\u001b\u0010=\u001a\u00020\u0005*\u00020 \u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0001\u001a\n\u0010?\u001a\u00020@*\u00020A\u001a\u0010\u0010B\u001a\b\u0012\u0002\b\u0003\u0018\u00010C*\u00020D\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\"\u0015\u0010\u000b\u001a\u00020\u0006*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0013\"\u0015\u0010\u0014\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\n\"\u0015\u0010\u0015\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\n\"\u0015\u0010\u0016\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\n\"\u0015\u0010\u0017\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\n\"\u0015\u0010\u0018\u001a\u00020\u0005*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\"\u0015\u0010\u001b\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\n\"\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\"\u0015\u0010\u001e\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\n\"\u0015\u0010\u001f\u001a\u00020\u0005*\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!\"\u0015\u0010\"\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\n\"\u0015\u0010#\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\n\"\u0015\u0010$\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\n\"\u0015\u0010%\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\n\"\u001a\u0010&\u001a\u0004\u0018\u00010'*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\"\u0015\u0010*\u001a\u00020+*\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00f2\u0001\b\n\u00020\u0012\n\u00020>\u00a8\u0006E"}, d2={"EXTENSION_FUNCTION_ANNOTATION", "Lorg/jetbrains/kotlin/name/ClassId;", "getEXTENSION_FUNCTION_ANNOTATION", "()Lorg/jetbrains/kotlin/name/ClassId;", "canBeNull", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getCanBeNull", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Z", "coneType", "getConeType", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "functionTypeKind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassKind;", "getFunctionTypeKind", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/builtins/functions/FunctionClassKind;", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "(Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;)Lorg/jetbrains/kotlin/builtins/functions/FunctionClassKind;", "isAny", "isArrayType", "isBoolean", "isEnum", "isExtensionFunctionAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)Z", "isInt", "isMarkedNullable", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Ljava/lang/Boolean;", "isNothing", "isNullLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "isNullableAny", "isNullableNothing", "isString", "isUnit", "lookupTagBasedOrNull", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "getLookupTagBasedOrNull", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "parametersCount", "", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "getParametersCount", "(Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;)I", "computeTypeAttributes", "Lorg/jetbrains/kotlin/fir/types/ConeAttributes;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "coneTypeSafe", "T", "coneTypeUnsafe", "dropExtensionFunctionAnnotation", "hasNotNullUpperBound", "Lorg/jetbrains/kotlin/fir/types/ConeTypeParameterType;", "isBuiltinType", "classId", "isNullable", "isStableSmartcast", "Lorg/jetbrains/kotlin/fir/expressions/FirExpressionWithSmartcast;", "toConeTypeProjection", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "toConstKind", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "tree"})
public final class FirTypeUtilsKt {
    @NotNull
    private static final ClassId EXTENSION_FUNCTION_ANNOTATION;

    public static final /* synthetic */ <T extends ConeKotlinType> T coneTypeUnsafe(FirTypeRef $this$coneTypeUnsafe) {
        Intrinsics.checkNotNullParameter($this$coneTypeUnsafe, "<this>");
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe).getType();
        Intrinsics.reifiedOperationMarker(1, "T");
        return (T)coneKotlinType;
    }

    public static final /* synthetic */ <T extends ConeKotlinType> T coneTypeSafe(FirTypeRef $this$coneTypeSafe) {
        Intrinsics.checkNotNullParameter($this$coneTypeSafe, "<this>");
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        Intrinsics.reifiedOperationMarker(2, "T");
        return (T)coneKotlinType;
    }

    @NotNull
    public static final ConeKotlinType getConeType(@NotNull FirTypeRef $this$coneType) {
        Intrinsics.checkNotNullParameter($this$coneType, "<this>");
        FirTypeRef $this$coneTypeSafe$iv = $this$coneType;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        if (coneKotlinType == null) {
            throw new IllegalStateException(("Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType, null, 1, null)).toString());
        }
        return coneKotlinType;
    }

    public static final boolean isAny(@NotNull FirTypeRef $this$isAny) {
        Intrinsics.checkNotNullParameter($this$isAny, "<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isAny, StandardClassIds.INSTANCE.getAny(), false);
    }

    public static final boolean isNullableAny(@NotNull FirTypeRef $this$isNullableAny) {
        Intrinsics.checkNotNullParameter($this$isNullableAny, "<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isNullableAny, StandardClassIds.INSTANCE.getAny(), true);
    }

    public static final boolean isNothing(@NotNull FirTypeRef $this$isNothing) {
        Intrinsics.checkNotNullParameter($this$isNothing, "<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isNothing, StandardClassIds.INSTANCE.getNothing(), false);
    }

    public static final boolean isNullableNothing(@NotNull FirTypeRef $this$isNullableNothing) {
        Intrinsics.checkNotNullParameter($this$isNullableNothing, "<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isNullableNothing, StandardClassIds.INSTANCE.getNothing(), true);
    }

    public static final boolean isUnit(@NotNull FirTypeRef $this$isUnit) {
        Intrinsics.checkNotNullParameter($this$isUnit, "<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isUnit, StandardClassIds.INSTANCE.getUnit(), false);
    }

    public static final boolean isBoolean(@NotNull FirTypeRef $this$isBoolean) {
        Intrinsics.checkNotNullParameter($this$isBoolean, "<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isBoolean, StandardClassIds.INSTANCE.getBoolean(), false);
    }

    public static final boolean isInt(@NotNull FirTypeRef $this$isInt) {
        Intrinsics.checkNotNullParameter($this$isInt, "<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isInt, StandardClassIds.INSTANCE.getInt(), false);
    }

    public static final boolean isString(@NotNull FirTypeRef $this$isString) {
        Intrinsics.checkNotNullParameter($this$isString, "<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isString, StandardClassIds.INSTANCE.getString(), false);
    }

    public static final boolean isEnum(@NotNull FirTypeRef $this$isEnum) {
        Intrinsics.checkNotNullParameter($this$isEnum, "<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isEnum, StandardClassIds.INSTANCE.getEnum(), false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isArrayType(@NotNull FirTypeRef $this$isArrayType) {
        ClassId it;
        Intrinsics.checkNotNullParameter($this$isArrayType, "<this>");
        if (FirTypeUtilsKt.isBuiltinType($this$isArrayType, StandardClassIds.INSTANCE.getArray(), false)) return true;
        Iterable $this$any$iv = StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (ClassId)element$iv;
            boolean bl = false;
        } while (!FirTypeUtilsKt.isBuiltinType($this$isArrayType, it, false));
        return true;
    }

    public static final boolean isNullLiteral(@NotNull FirExpression $this$isNullLiteral) {
        Intrinsics.checkNotNullParameter($this$isNullLiteral, "<this>");
        return $this$isNullLiteral instanceof FirConstExpression && Intrinsics.areEqual(((FirConstExpression)$this$isNullLiteral).getKind(), ConstantValueKind.Null.INSTANCE) && ((FirConstExpression)$this$isNullLiteral).getValue() == null && $this$isNullLiteral.getSource() != null;
    }

    public static final boolean isStableSmartcast(@NotNull FirExpression $this$isStableSmartcast) {
        Intrinsics.checkNotNullParameter($this$isStableSmartcast, "<this>");
        return $this$isStableSmartcast instanceof FirExpressionWithSmartcast && ((FirExpressionWithSmartcast)$this$isStableSmartcast).isStable();
    }

    private static final ConeLookupTagBasedType getLookupTagBasedOrNull(FirTypeRef $this$lookupTagBasedOrNull) {
        ConeKotlinType coneKotlinType;
        FirTypeRef firTypeRef = $this$lookupTagBasedOrNull;
        ConeLookupTagBasedType coneLookupTagBasedType = firTypeRef instanceof FirImplicitBuiltinTypeRef ? (ConeLookupTagBasedType)((FirImplicitBuiltinTypeRef)$this$lookupTagBasedOrNull).getType() : (firTypeRef instanceof FirResolvedTypeRef ? ((coneKotlinType = ((FirResolvedTypeRef)$this$lookupTagBasedOrNull).getType()) instanceof ConeLookupTagBasedType ? (ConeLookupTagBasedType)coneKotlinType : null) : null);
        return coneLookupTagBasedType;
    }

    private static final boolean isBuiltinType(FirTypeRef $this$isBuiltinType, ClassId classId, boolean isNullable) {
        ConeLookupTagBasedType coneLookupTagBasedType = FirTypeUtilsKt.getLookupTagBasedOrNull($this$isBuiltinType);
        if (coneLookupTagBasedType == null) {
            return false;
        }
        ConeLookupTagBasedType type2 = coneLookupTagBasedType;
        Object object = type2 instanceof ConeClassLikeType ? (ConeClassLikeType)type2 : null;
        return Intrinsics.areEqual(object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null, classId) && ConeTypeUtilsKt.isNullable(type2) == isNullable;
    }

    @Nullable
    public static final Boolean isMarkedNullable(@NotNull FirTypeRef $this$isMarkedNullable) {
        Boolean bl;
        Intrinsics.checkNotNullParameter($this$isMarkedNullable, "<this>");
        if ($this$isMarkedNullable instanceof FirTypeRefWithNullability) {
            bl = ((FirTypeRefWithNullability)$this$isMarkedNullable).isMarkedNullable();
        } else {
            ConeLookupTagBasedType coneLookupTagBasedType = FirTypeUtilsKt.getLookupTagBasedOrNull($this$isMarkedNullable);
            bl = coneLookupTagBasedType != null ? Boolean.valueOf(ConeTypeUtilsKt.isMarkedNullable(coneLookupTagBasedType)) : null;
        }
        return bl;
    }

    public static final int getParametersCount(@NotNull FirFunctionTypeRef $this$parametersCount) {
        Intrinsics.checkNotNullParameter($this$parametersCount, "<this>");
        return $this$parametersCount.getReceiverTypeRef() != null ? $this$parametersCount.getValueParameters().size() + 1 : $this$parametersCount.getValueParameters().size();
    }

    @NotNull
    public static final ClassId getEXTENSION_FUNCTION_ANNOTATION() {
        return EXTENSION_FUNCTION_ANNOTATION;
    }

    public static final boolean isExtensionFunctionAnnotationCall(@NotNull FirAnnotation $this$isExtensionFunctionAnnotationCall) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isExtensionFunctionAnnotationCall, "<this>");
        FirAnnotation firAnnotation = $this$isExtensionFunctionAnnotationCall;
        if (firAnnotation != null) {
            Boolean bl2;
            FirAnnotation annotationCall = firAnnotation;
            boolean bl3 = false;
            FirTypeRef firTypeRef = annotationCall.getAnnotationTypeRef();
            FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
            if (firResolvedTypeRef != null) {
                FirResolvedTypeRef typeRef = firResolvedTypeRef;
                boolean bl4 = false;
                ConeKotlinType coneKotlinType = typeRef.getType();
                ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
                if (coneClassLikeType != null) {
                    ConeClassLikeType it = coneClassLikeType;
                    boolean bl5 = false;
                    bl2 = Intrinsics.areEqual(it.getLookupTag().getClassId(), EXTENSION_FUNCTION_ANNOTATION);
                } else {
                    bl2 = null;
                }
            } else {
                bl2 = null;
            }
            bl = Intrinsics.areEqual(bl2, true);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnnotation> dropExtensionFunctionAnnotation(@NotNull List<? extends FirAnnotation> $this$dropExtensionFunctionAnnotation) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$dropExtensionFunctionAnnotation, "<this>");
        Iterable $this$filterNot$iv = $this$dropExtensionFunctionAnnotation;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FirAnnotation it = (FirAnnotation)element$iv$iv;
            boolean bl = false;
            if (FirTypeUtilsKt.isExtensionFunctionAnnotationCall(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ConstantValueKind<?> toConstKind(@NotNull ConeClassLikeType $this$toConstKind) {
        Intrinsics.checkNotNullParameter($this$toConstKind, "<this>");
        ClassId classId = $this$toConstKind.getLookupTag().getClassId();
        return Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getByte()) ? (ConstantValueKind)ConstantValueKind.Byte.INSTANCE : (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getShort()) ? (ConstantValueKind)ConstantValueKind.Short.INSTANCE : (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getInt()) ? (ConstantValueKind)ConstantValueKind.Int.INSTANCE : (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getLong()) ? (ConstantValueKind)ConstantValueKind.Long.INSTANCE : (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getUInt()) ? (ConstantValueKind)ConstantValueKind.UnsignedInt.INSTANCE : (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getULong()) ? (ConstantValueKind)ConstantValueKind.UnsignedLong.INSTANCE : (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getUShort()) ? (ConstantValueKind)ConstantValueKind.UnsignedShort.INSTANCE : (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getUByte()) ? (ConstantValueKind)ConstantValueKind.UnsignedByte.INSTANCE : null)))))));
    }

    @NotNull
    public static final ConeAttributes computeTypeAttributes(@NotNull List<? extends FirAnnotation> $this$computeTypeAttributes, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$computeTypeAttributes, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if ($this$computeTypeAttributes.isEmpty()) {
            return ConeAttributes.Companion.getEmpty();
        }
        List attributes2 = new ArrayList();
        List customAnnotations = new ArrayList();
        for (FirAnnotation firAnnotation : $this$computeTypeAttributes) {
            ConeAttribute<?> attributeFromPlugin;
            block10: {
                ConeAttribute<?> coneAttribute;
                ConeClassLikeType type2;
                FirTypeRef $this$coneTypeSafe$iv = firAnnotation.getAnnotationTypeRef();
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null) continue;
                ClassId classId = type2.getLookupTag().getClassId();
                if (Intrinsics.areEqual(classId, CompilerConeAttributes.Exact.INSTANCE.getANNOTATION_CLASS_ID())) {
                    ((Collection)attributes2).add(CompilerConeAttributes.Exact.INSTANCE);
                    continue;
                }
                if (Intrinsics.areEqual(classId, CompilerConeAttributes.NoInfer.INSTANCE.getANNOTATION_CLASS_ID())) {
                    ((Collection)attributes2).add(CompilerConeAttributes.NoInfer.INSTANCE);
                    continue;
                }
                if (Intrinsics.areEqual(classId, CompilerConeAttributes.ExtensionFunctionType.INSTANCE.getANNOTATION_CLASS_ID())) {
                    ((Collection)attributes2).add(CompilerConeAttributes.ExtensionFunctionType.INSTANCE);
                    continue;
                }
                if (Intrinsics.areEqual(classId, CompilerConeAttributes.UnsafeVariance.INSTANCE.getANNOTATION_CLASS_ID())) {
                    ((Collection)attributes2).add(CompilerConeAttributes.UnsafeVariance.INSTANCE);
                    continue;
                }
                for (FirTypeAttributeExtension it : (Iterable)FirTypeAttributeExtensionKt.getTypeAttributeExtensions(FirExtensionServiceKt.getExtensionService(session2))) {
                    boolean bl = false;
                    ConeAttribute<?> coneAttribute2 = it.extractAttributeFromAnnotation(firAnnotation);
                    if (coneAttribute2 == null) continue;
                    coneAttribute = coneAttribute2;
                    break block10;
                }
                coneAttribute = attributeFromPlugin = null;
            }
            if (attributeFromPlugin != null) {
                ((Collection)attributes2).add(attributeFromPlugin);
                continue;
            }
            ((Collection)customAnnotations).add(firAnnotation);
        }
        if (!((Collection)customAnnotations).isEmpty()) {
            ((Collection)attributes2).add(new CustomAnnotationTypeAttribute(customAnnotations));
        }
        return ConeAttributes.Companion.create(attributes2);
    }

    @NotNull
    public static final ConeTypeProjection toConeTypeProjection(@NotNull FirTypeProjection $this$toConeTypeProjection) {
        ConeTypeProjection coneTypeProjection;
        Intrinsics.checkNotNullParameter($this$toConeTypeProjection, "<this>");
        FirTypeProjection firTypeProjection = $this$toConeTypeProjection;
        if (firTypeProjection instanceof FirStarProjection) {
            coneTypeProjection = ConeStarProjection.INSTANCE;
        } else if (firTypeProjection instanceof FirTypeProjectionWithVariance) {
            ConeKotlinType type2 = FirTypeUtilsKt.getConeType(((FirTypeProjectionWithVariance)$this$toConeTypeProjection).getTypeRef());
            coneTypeProjection = ConeTypeUtilsKt.toTypeProjection(type2, ((FirTypeProjectionWithVariance)$this$toConeTypeProjection).getVariance());
        } else {
            throw new IllegalStateException("!".toString());
        }
        return coneTypeProjection;
    }

    public static final boolean getCanBeNull(@NotNull FirTypeRef $this$canBeNull) {
        Intrinsics.checkNotNullParameter($this$canBeNull, "<this>");
        FirTypeRef $this$coneTypeSafe$iv = $this$canBeNull;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        return coneKotlinType != null ? FirTypeUtilsKt.getCanBeNull(coneKotlinType) : false;
    }

    public static final boolean getCanBeNull(@NotNull ConeKotlinType $this$canBeNull) {
        boolean bl;
        block15: {
            Intrinsics.checkNotNullParameter($this$canBeNull, "<this>");
            if (ConeTypeUtilsKt.isMarkedNullable($this$canBeNull)) {
                return true;
            }
            ConeKotlinType coneKotlinType = $this$canBeNull;
            if (coneKotlinType instanceof ConeFlexibleType) {
                bl = FirTypeUtilsKt.getCanBeNull(((ConeFlexibleType)$this$canBeNull).getUpperBound());
            } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                bl = false;
            } else if (coneKotlinType instanceof ConeTypeParameterType) {
                Iterable $this$all$iv = ((FirTypeParameter)((ConeTypeParameterType)$this$canBeNull).getLookupTag().getTypeParameterSymbol().getFir()).getBounds();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        FirTypeRef it = (FirTypeRef)element$iv;
                        boolean bl2 = false;
                        if (FirTypeUtilsKt.getCanBeNull(FirTypeUtilsKt.getConeType(it))) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            } else if (coneKotlinType instanceof ConeIntersectionType) {
                Iterable $this$all$iv = ((ConeIntersectionType)$this$canBeNull).getIntersectedTypes();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl3 = false;
                        if (FirTypeUtilsKt.getCanBeNull(it)) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            } else {
                bl = ConeTypeUtilsKt.isNullable($this$canBeNull);
            }
        }
        return bl;
    }

    @Nullable
    public static final FunctionClassKind getFunctionTypeKind(@Nullable ConeKotlinType $this$functionTypeKind) {
        Object object = $this$functionTypeKind instanceof ConeClassLikeType ? (ConeClassLikeType)$this$functionTypeKind : null;
        if (object == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null || (object = ((ConeClassLikeLookupTag)object).getClassId()) == null) {
            return null;
        }
        Object classId = object;
        String string2 = ((ClassId)classId).getShortClassName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "classId.shortClassName.asString()");
        FqName fqName2 = ((ClassId)classId).getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "classId.packageFqName");
        return FunctionClassKind.Companion.getFunctionalClassKind(string2, fqName2);
    }

    @Nullable
    public static final FunctionClassKind getFunctionTypeKind(@NotNull FirResolvedTypeRef $this$functionTypeKind) {
        Intrinsics.checkNotNullParameter($this$functionTypeKind, "<this>");
        return FirTypeUtilsKt.getFunctionTypeKind($this$functionTypeKind.getType());
    }

    static {
        ClassId classId = ClassId.fromString("kotlin/ExtensionFunctionType");
        Intrinsics.checkNotNullExpressionValue(classId, "fromString(\"kotlin/ExtensionFunctionType\")");
        EXTENSION_FUNCTION_ANNOTATION = classId;
    }
}

